/**
 * The Pentaho proprietary code is licensed under the terms and conditions
 * of the software license agreement entered into between the entity licensing
 * such code and Pentaho Corporation. 
 */

pen.require(['common-ui/instrumented/prompting/pentaho-prompting', 'common-ui/instrumented/prompting/pentaho-prompting-builders', 'common-ui/instrumented/prompting/pentaho-prompting-components'], function() {
  // Determine the size of an object (# of properties)
  var sizeOf = function(obj) {
    var size = 0, key;
    for (key in obj) {
      if (obj.hasOwnProperty(key)) size++;
    }
    return size;
  };

  doh.register("Prompting Tests", [
    {
      name: "Test Package",
      runTest: function() {
        doh.assertTrue( pentaho.common.prompting );    
      }
    },
    {  
      name: "Test ParameterXmlParser",
      runTest: function() {
      	var parameterXml = '<?xml version="1.0" encoding="UTF-8"?><parameters accepted-page="-1" autoSubmitUI="true" ignore-biserver-5538="true" is-prompt-needed="false" layout="vertical" page-count="1" paginate="true" subscribe="false"><parameter is-list="true" is-mandatory="false" is-multi-select="false" is-strict="true" name="line" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="user"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><attribute name="re-evaluate-on-failed-values" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="autofill-selection" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Choose a Line:"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><values><value label="Classic Cars" null="false" selected="false" type="java.lang.String" value="Classic Cars"/><value label="Motorcycles" null="false" selected="false" type="java.lang.String" value="Motorcycles"/><value label="Planes" null="false" selected="false" type="java.lang.String" value="Planes"/><value label="Ships" null="false" selected="false" type="java.lang.String" value="Ships"/><value label="Trains" null="false" selected="true" type="java.lang.String" value="Trains"/><value label="Trucks and Buses" null="false" selected="false" type="java.lang.String" value="Trucks and Buses"/><value label="Vintage Cars" null="false" selected="false" type="java.lang.String" value="Vintage Cars"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="subscription-name" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="schedule"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscription"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Scheduling Options"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Name"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="destination" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="schedule"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscription"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Scheduling Options"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="E-Mail To"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="true" is-mandatory="false" is-multi-select="false" is-strict="true" name="schedule-id" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="schedule"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscription"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Scheduling Options"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Subscription"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><values/></parameter><parameter is-list="true" is-mandatory="true" is-multi-select="false" is-strict="true" name="output-target" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="parameters"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Output Type"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><values><value label="HTML (Paginated)" null="false" selected="true" type="java.lang.String" value="table/html;page-mode=page"/><value label="HTML (Single Page)" null="false" selected="false" type="java.lang.String" value="table/html;page-mode=stream"/><value label="PDF" null="false" selected="false" type="java.lang.String" value="pageable/pdf"/><value label="Excel" null="false" selected="false" type="java.lang.String" value="table/excel;page-mode=flow"/><value label="Excel 2007" null="false" selected="false" type="java.lang.String" value="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;page-mode=flow"/><value label="Comma Separated Value" null="false" selected="false" type="java.lang.String" value="table/csv;page-mode=stream"/><value label="Rich-Text-Format" null="false" selected="false" type="java.lang.String" value="table/rtf;page-mode=flow"/><value label="Text" null="false" selected="false" type="java.lang.String" value="pageable/text"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="subscribe" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscribe"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="true" is-mandatory="false" is-multi-select="true" is-strict="false" name="::cl" type="[Ljava.lang.String;"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Content-Linking"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="list"/><values/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="::TabName" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="::TabName"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="::TabActive" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="::TabActive"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="yield-rate" type="java.lang.Integer"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="yield-rate"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="accepted-page" type="java.lang.Integer"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="accepted-page"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="::session" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="::session"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><values><value label="53919d5a-1077-11e1-af53-1d63ac2acec9" null="false" selected="true" type="java.lang.String" value="53919d5a-1077-11e1-af53-1d63ac2acec9"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="output-type" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="output-type"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="layout" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="layout"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="content-handler-pattern" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="content-handler-pattern"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="autoSubmit" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="autoSubmit"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="autoSubmitUI" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="autoSubmitUI"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="dashboard-mode" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dashboard-mode"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="showParameters" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="showParameters"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><values><value label="true" null="false" selected="true" type="java.lang.Boolean" value="true"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="paginate" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="paginate"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="ignoreDefaultDates" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="ignoreDefaultDates"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="print" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="print"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="printer-name" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="printer-name"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="true" is-mandatory="false" is-multi-select="false" is-strict="true" name="renderMode" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="renderMode"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><values><value label="XML" null="false" selected="true" type="java.lang.String" value="XML"/><value label="REPORT" null="false" selected="false" type="java.lang.String" value="REPORT"/><value label="SUBSCRIBE" null="false" selected="false" type="java.lang.String" value="SUBSCRIBE"/><value label="DOWNLOAD" null="false" selected="false" type="java.lang.String" value="DOWNLOAD"/><value label="PARAMETER" null="false" selected="false" type="java.lang.String" value="PARAMETER"/></values></parameter></parameters>';
        var parser = new pentaho.common.prompting.ParameterXmlParser();

        var paramDefn = parser.parseParameterXml(parameterXml);

        doh.assertTrue(paramDefn);

        doh.assertTrue(paramDefn.allowAutoSubmit());
        doh.assertEqual(undefined, paramDefn.autoSubmit);
        doh.assertTrue(paramDefn.autoSubmitUI);
        doh.assertTrue(paramDefn.ignoreBiServer5538);
        doh.assertEqual(-1, paramDefn.page);
        doh.assertTrue(paramDefn.paginate);
        doh.assertFalse(paramDefn.promptNeeded);
        doh.assertFalse(paramDefn.subscribe);
        doh.assertEqual(1, paramDefn.totalPages);

        doh.assertTrue(paramDefn.showParameterUI());

        doh.assertEqual(0, sizeOf(paramDefn.errors));
        doh.assertEqual(3, paramDefn.parameterGroups.length);  
        // default parameter group
        var paramGroup = paramDefn.parameterGroups[0];
        doh.assertEqual(undefined, paramGroup.label);
        doh.assertEqual('parameters', paramGroup.name);
        doh.assertEqual(2, paramGroup.parameters.length);
        // line parameter
        var param = paramGroup.parameters[0];
        doh.assertEqual('line', param.name);
        doh.assertTrue(param.list);
        doh.assertFalse(param.mandatory);
        doh.assertFalse(param.multiSelect);
        doh.assertTrue(param.strict);
        doh.assertEqual(undefined, param.timezoneHint);
        doh.assertEqual('java.lang.String', param.type);
        doh.assertEqual(6, sizeOf(param.attributes));
        doh.assertEqual('false', param.attributes['autofill-selection']);
        doh.assertEqual('false', param.attributes['hidden']);
        doh.assertEqual('Choose a Line:', param.attributes['label']);
        doh.assertEqual('dropdown', param.attributes['parameter-render-type']);
        doh.assertEqual('false', param.attributes['re-evaluate-on-failed-values']);
        doh.assertEqual('user', param.attributes['role']);
        doh.assertEqual(7, param.values.length);
        doh.assertEqual('Classic Cars', param.values[0].label);
        doh.assertFalse(param.values[0].selected);
        doh.assertEqual('java.lang.String', param.values[0].type);
        doh.assertEqual('Classic Cars', param.values[0].value);
        doh.assertEqual('Motorcycles', param.values[1].label);
        doh.assertFalse(param.values[1].selected);
        doh.assertEqual('java.lang.String', param.values[1].type);
        doh.assertEqual('Motorcycles', param.values[1].value);
        doh.assertEqual('Planes', param.values[2].label);
        doh.assertFalse(param.values[2].selected);
        doh.assertEqual('java.lang.String', param.values[2].type);
        doh.assertEqual('Planes', param.values[2].value);
        doh.assertEqual('Ships', param.values[3].label);
        doh.assertFalse(param.values[3].selected);
        doh.assertEqual('java.lang.String', param.values[3].type);
        doh.assertEqual('Ships', param.values[3].value);
        doh.assertEqual('Trains', param.values[4].label);
        doh.assertTrue(param.values[4].selected);
        doh.assertEqual('java.lang.String', param.values[4].type);
        doh.assertEqual('Trains', param.values[4].value);
        doh.assertEqual('Trucks and Buses', param.values[5].label);
        doh.assertFalse(param.values[5].selected);
        doh.assertEqual('java.lang.String', param.values[5].type);
        doh.assertEqual('Trucks and Buses', param.values[5].value);
        doh.assertEqual('Vintage Cars', param.values[6].label);
        doh.assertFalse(param.values[6].selected);
        doh.assertEqual('java.lang.String', param.values[6].type);
        doh.assertEqual('Vintage Cars', param.values[6].value);

        // output-target parameter
        param = paramGroup.parameters[1];
        doh.assertEqual('output-target', param.name);
        doh.assertTrue(param.list);
        doh.assertTrue(param.mandatory);
        doh.assertFalse(param.multiSelect);
        doh.assertTrue(param.strict);
        doh.assertEqual(undefined, param.timezoneHint);
        doh.assertEqual('java.lang.String', param.type);
        doh.assertEqual(7, sizeOf(param.attributes));
        doh.assertEqual('false', param.attributes['hidden']);
        doh.assertEqual('Output Type', param.attributes['label']);
        doh.assertEqual('parameters', param.attributes['parameter-group']);
        doh.assertEqual('Report Parameters', param.attributes['parameter-group-label']);
        doh.assertEqual('dropdown', param.attributes['parameter-render-type']);
        doh.assertEqual('true', param.attributes['preferred']);
        doh.assertEqual('system', param.attributes['role']);
        doh.assertEqual(8, param.values.length);
        doh.assertEqual('HTML (Paginated)', param.values[0].label);
        doh.assertTrue(param.values[0].selected);
        doh.assertEqual('java.lang.String', param.values[0].type);
        doh.assertEqual('table/html;page-mode=page', param.values[0].value);
        doh.assertEqual('HTML (Single Page)', param.values[1].label);
        doh.assertFalse(param.values[1].selected);
        doh.assertEqual('java.lang.String', param.values[1].type);
        doh.assertEqual('table/html;page-mode=stream', param.values[1].value);
        doh.assertEqual('PDF', param.values[2].label);
        doh.assertFalse(param.values[2].selected);
        doh.assertEqual('java.lang.String', param.values[2].type);
        doh.assertEqual('pageable/pdf', param.values[2].value);
        doh.assertEqual('Excel', param.values[3].label);
        doh.assertFalse(param.values[3].selected);
        doh.assertEqual('java.lang.String', param.values[3].type);
        doh.assertEqual('table/excel;page-mode=flow', param.values[3].value);
        doh.assertEqual('Excel 2007', param.values[4].label);
        doh.assertFalse(param.values[4].selected);
        doh.assertEqual('java.lang.String', param.values[4].type);
        doh.assertEqual('application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;page-mode=flow', param.values[4].value);
        doh.assertEqual('Comma Separated Value', param.values[5].label);
        doh.assertFalse(param.values[5].selected);
        doh.assertEqual('java.lang.String', param.values[5].type);
        doh.assertEqual('table/csv;page-mode=stream', param.values[5].value);
        doh.assertEqual('Rich-Text-Format', param.values[6].label);
        doh.assertFalse(param.values[6].selected);
        doh.assertEqual('java.lang.String', param.values[6].type);
        doh.assertEqual('table/rtf;page-mode=flow', param.values[6].value);
        doh.assertEqual('Text', param.values[7].label);
        doh.assertFalse(param.values[7].selected);
        doh.assertEqual('java.lang.String', param.values[7].type);
        doh.assertEqual('pageable/text', param.values[7].value);

        // schedule parameter group
        paramGroup = paramDefn.parameterGroups[1];
        doh.assertEqual('Report Scheduling Options', paramGroup.label);
        doh.assertEqual('subscription', paramGroup.name);
        doh.assertEqual(3, paramGroup.parameters.length);
        doh.assertEqual('subscription-name', paramGroup.parameters[0].name);
        doh.assertEqual('destination', paramGroup.parameters[1].name);
        doh.assertEqual('schedule-id', paramGroup.parameters[2].name);

        // system parameters
        paramGroup = paramDefn.parameterGroups[2];
        doh.assertEqual('System Parameters', paramGroup.label);
        doh.assertEqual('system', paramGroup.name);
        doh.assertEqual(19, paramGroup.parameters.length);
        doh.assertEqual('subscribe', paramGroup.parameters[0].name);
        doh.assertEqual('::cl', paramGroup.parameters[1].name);
        doh.assertEqual('::TabName', paramGroup.parameters[2].name);
        doh.assertEqual('::TabActive', paramGroup.parameters[3].name);
        doh.assertEqual('yield-rate', paramGroup.parameters[4].name);
        doh.assertEqual('accepted-page', paramGroup.parameters[5].name);
        doh.assertEqual('::session', paramGroup.parameters[6].name);
        doh.assertEqual('output-type', paramGroup.parameters[7].name);
        doh.assertEqual('layout', paramGroup.parameters[8].name);
        doh.assertEqual('content-handler-pattern', paramGroup.parameters[9].name);
        doh.assertEqual('autoSubmit', paramGroup.parameters[10].name);
        doh.assertEqual('autoSubmitUI', paramGroup.parameters[11].name);
        doh.assertEqual('dashboard-mode', paramGroup.parameters[12].name);
        doh.assertEqual('showParameters', paramGroup.parameters[13].name);
        doh.assertEqual('paginate', paramGroup.parameters[14].name);
        doh.assertEqual('ignoreDefaultDates', paramGroup.parameters[15].name);
        doh.assertEqual('print', paramGroup.parameters[16].name);
        doh.assertEqual('printer-name', paramGroup.parameters[17].name);
        doh.assertEqual('renderMode', paramGroup.parameters[18].name);
      }
    },
    {
      name: "Create Prompt Panel",
      timeout: 2000,
      runTest: function() {
        var parameterXml = '<?xml version="1.0" encoding="UTF-8"?><parameters accepted-page="-1" autoSubmitUI="true" ignore-biserver-5538="true" is-prompt-needed="false" layout="vertical" page-count="1" paginate="true" subscribe="false"><parameter is-list="true" is-mandatory="false" is-multi-select="false" is-strict="true" name="line" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="user"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><attribute name="re-evaluate-on-failed-values" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="autofill-selection" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Choose a Line:"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><values><value label="Classic Cars" null="false" selected="false" type="java.lang.String" value="Classic Cars"/><value label="Motorcycles" null="false" selected="false" type="java.lang.String" value="Motorcycles"/><value label="Planes" null="false" selected="false" type="java.lang.String" value="Planes"/><value label="Ships" null="false" selected="false" type="java.lang.String" value="Ships"/><value label="Trains" null="false" selected="true" type="java.lang.String" value="Trains"/><value label="Trucks and Buses" null="false" selected="false" type="java.lang.String" value="Trucks and Buses"/><value label="Vintage Cars" null="false" selected="false" type="java.lang.String" value="Vintage Cars"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="subscription-name" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="schedule"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscription"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Scheduling Options"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Name"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="destination" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="schedule"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscription"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Scheduling Options"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="E-Mail To"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="true" is-mandatory="false" is-multi-select="false" is-strict="true" name="schedule-id" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="schedule"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscription"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Scheduling Options"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Subscription"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><values/></parameter><parameter is-list="true" is-mandatory="true" is-multi-select="false" is-strict="true" name="output-target" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="parameters"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Output Type"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><values><value label="HTML (Paginated)" null="false" selected="true" type="java.lang.String" value="table/html;page-mode=page"/><value label="HTML (Single Page)" null="false" selected="false" type="java.lang.String" value="table/html;page-mode=stream"/><value label="PDF" null="false" selected="false" type="java.lang.String" value="pageable/pdf"/><value label="Excel" null="false" selected="false" type="java.lang.String" value="table/excel;page-mode=flow"/><value label="Excel 2007" null="false" selected="false" type="java.lang.String" value="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;page-mode=flow"/><value label="Comma Separated Value" null="false" selected="false" type="java.lang.String" value="table/csv;page-mode=stream"/><value label="Rich-Text-Format" null="false" selected="false" type="java.lang.String" value="table/rtf;page-mode=flow"/><value label="Text" null="false" selected="false" type="java.lang.String" value="pageable/text"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="subscribe" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscribe"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="true" is-mandatory="false" is-multi-select="true" is-strict="false" name="::cl" type="[Ljava.lang.String;"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Content-Linking"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="list"/><values/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="::TabName" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="::TabName"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="::TabActive" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="::TabActive"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="yield-rate" type="java.lang.Integer"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="yield-rate"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="accepted-page" type="java.lang.Integer"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="accepted-page"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="::session" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="::session"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><values><value label="53919d5a-1077-11e1-af53-1d63ac2acec9" null="false" selected="true" type="java.lang.String" value="53919d5a-1077-11e1-af53-1d63ac2acec9"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="output-type" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="output-type"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="layout" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="layout"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="content-handler-pattern" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="content-handler-pattern"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="autoSubmit" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="autoSubmit"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="autoSubmitUI" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="autoSubmitUI"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="dashboard-mode" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dashboard-mode"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="showParameters" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="showParameters"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><values><value label="true" null="false" selected="true" type="java.lang.Boolean" value="true"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="paginate" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="paginate"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="ignoreDefaultDates" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="ignoreDefaultDates"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="print" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="print"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="printer-name" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="printer-name"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="true" is-mandatory="false" is-multi-select="false" is-strict="true" name="renderMode" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="renderMode"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><values><value label="XML" null="false" selected="true" type="java.lang.String" value="XML"/><value label="REPORT" null="false" selected="false" type="java.lang.String" value="REPORT"/><value label="SUBSCRIBE" null="false" selected="false" type="java.lang.String" value="SUBSCRIBE"/><value label="DOWNLOAD" null="false" selected="false" type="java.lang.String" value="DOWNLOAD"/><value label="PARAMETER" null="false" selected="false" type="java.lang.String" value="PARAMETER"/></values></parameter></parameters>';
        var paramDefn = new pentaho.common.prompting.ParameterXmlParser().parseParameterXml(parameterXml);
        doh.assertTrue(paramDefn);

        var destinationId = 'panel';

        // Create panel element to inject into
        jQuery('<div/>', {
          id: destinationId
        }).appendTo('body');

        var panel = new pentaho.common.prompting.PromptPanel(destinationId, paramDefn);
        doh.assertTrue(panel);
        doh.assertEqual(destinationId, panel.destinationId);

        var submitCalled = false;

        panel.submit = function() {
          submitCalled = true;
        }

        panel.init();

        doh.assertEqual(10, panel.components.length);

        var parameterValues = panel.getParameterValues();
        doh.assertEqual(5, sizeOf(parameterValues));
        doh.assertTrue(typeof parameterValues['::session'] === 'string' && parameterValues['::session'].length > 12);
        doh.assertEqual('Trains', parameterValues['line']);
        doh.assertEqual('table/html;page-mode=page', parameterValues['output-target']);
        doh.assertEqual('XML', parameterValues['renderMode']);
        doh.assertEqual('true', parameterValues['showParameters']);

        // 1 second timeout to allow submit callback to be called after panel is initialized
        var deferred = new doh.Deferred();
        setTimeout(function() {
          doh.assertTrue(submitCalled);

          var panelDiv = $('#' + destinationId);
          doh.assertTrue(panelDiv.html().length > 0);

          // Make sure all components have elements in the dom
          $.each(panel.components, function(i, c) {
            doh.assertTrue($('#' + c.htmlObject));
          });

          deferred.callback(true);
        }, 1000);
        return deferred;
      }
    },
    {
      name: "Hide Prompt Panel on showParameters = false",
      // timeout: 2000,
      runTest: function() {
        var parameterXml = '<?xml version="1.0" encoding="UTF-8"?><parameters accepted-page="-1" autoSubmitUI="true" ignore-biserver-5538="true" is-prompt-needed="false" layout="vertical" page-count="1" paginate="true" subscribe="false"><parameter is-list="true" is-mandatory="false" is-multi-select="false" is-strict="true" name="line" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="user"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><attribute name="re-evaluate-on-failed-values" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="autofill-selection" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Choose a Line:"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><values><value label="Classic Cars" null="false" selected="false" type="java.lang.String" value="Classic Cars"/><value label="Motorcycles" null="false" selected="false" type="java.lang.String" value="Motorcycles"/><value label="Planes" null="false" selected="false" type="java.lang.String" value="Planes"/><value label="Ships" null="false" selected="false" type="java.lang.String" value="Ships"/><value label="Trains" null="false" selected="true" type="java.lang.String" value="Trains"/><value label="Trucks and Buses" null="false" selected="false" type="java.lang.String" value="Trucks and Buses"/><value label="Vintage Cars" null="false" selected="false" type="java.lang.String" value="Vintage Cars"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="subscription-name" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="schedule"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscription"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Scheduling Options"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Name"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="destination" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="schedule"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscription"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Scheduling Options"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="E-Mail To"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="true" is-mandatory="false" is-multi-select="false" is-strict="true" name="schedule-id" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="schedule"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscription"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Scheduling Options"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Subscription"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><values/></parameter><parameter is-list="true" is-mandatory="true" is-multi-select="false" is-strict="true" name="output-target" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="parameters"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Output Type"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><values><value label="HTML (Paginated)" null="false" selected="true" type="java.lang.String" value="table/html;page-mode=page"/><value label="HTML (Single Page)" null="false" selected="false" type="java.lang.String" value="table/html;page-mode=stream"/><value label="PDF" null="false" selected="false" type="java.lang.String" value="pageable/pdf"/><value label="Excel" null="false" selected="false" type="java.lang.String" value="table/excel;page-mode=flow"/><value label="Excel 2007" null="false" selected="false" type="java.lang.String" value="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;page-mode=flow"/><value label="Comma Separated Value" null="false" selected="false" type="java.lang.String" value="table/csv;page-mode=stream"/><value label="Rich-Text-Format" null="false" selected="false" type="java.lang.String" value="table/rtf;page-mode=flow"/><value label="Text" null="false" selected="false" type="java.lang.String" value="pageable/text"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="subscribe" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscribe"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="true" is-mandatory="false" is-multi-select="true" is-strict="false" name="::cl" type="[Ljava.lang.String;"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Content-Linking"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="list"/><values/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="::TabName" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="::TabName"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="::TabActive" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="::TabActive"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="yield-rate" type="java.lang.Integer"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="yield-rate"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="accepted-page" type="java.lang.Integer"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="accepted-page"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="::session" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="::session"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><values><value label="53919d5a-1077-11e1-af53-1d63ac2acec9" null="false" selected="true" type="java.lang.String" value="53919d5a-1077-11e1-af53-1d63ac2acec9"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="output-type" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="output-type"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="layout" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="layout"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="content-handler-pattern" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="content-handler-pattern"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="autoSubmit" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="autoSubmit"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="autoSubmitUI" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="autoSubmitUI"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="dashboard-mode" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dashboard-mode"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="showParameters" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="showParameters"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><values><value label="false" null="false" selected="true" type="java.lang.Boolean" value="false"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="paginate" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="paginate"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="ignoreDefaultDates" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="ignoreDefaultDates"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="print" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="print"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="printer-name" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="printer-name"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="true" is-mandatory="false" is-multi-select="false" is-strict="true" name="renderMode" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="renderMode"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><values><value label="XML" null="false" selected="true" type="java.lang.String" value="XML"/><value label="REPORT" null="false" selected="false" type="java.lang.String" value="REPORT"/><value label="SUBSCRIBE" null="false" selected="false" type="java.lang.String" value="SUBSCRIBE"/><value label="DOWNLOAD" null="false" selected="false" type="java.lang.String" value="DOWNLOAD"/><value label="PARAMETER" null="false" selected="false" type="java.lang.String" value="PARAMETER"/></values></parameter></parameters>';
        var paramDefn = new pentaho.common.prompting.ParameterXmlParser().parseParameterXml(parameterXml);
        doh.assertTrue(paramDefn);

        doh.assertFalse(paramDefn.showParameterUI());

        var destinationId = 'panel';

        // Create panel element to inject into
        jQuery('<div/>', {
          id: destinationId
        }).appendTo('body');

        var panel = new pentaho.common.prompting.PromptPanel(destinationId, paramDefn);
        doh.assertTrue(panel);
        doh.assertEqual(destinationId, panel.destinationId);

        var submitCalled = false;

        panel.submit = function() {
          submitCalled = true;
        }

        panel.init();

        // Don't create any components for hidden panels
        doh.assertEqual(undefined, panel.components);

        // Submit is called immediately when we don't create any components
        doh.assertTrue(submitCalled);
      }
    },
    {
      name: "Submit Called when no submit panel",
      runTest: function() {
        var parameterXml = '<?xml version="1.0" encoding="UTF-8"?><parameters accepted-page="-1" autoSubmitUI="true" ignore-biserver-5538="true" is-prompt-needed="false" layout="vertical" page-count="1" paginate="true" subscribe="false"><parameter is-list="true" is-mandatory="false" is-multi-select="false" is-strict="true" name="line" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="user"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><attribute name="re-evaluate-on-failed-values" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="autofill-selection" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Choose a Line:"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><values><value label="Classic Cars" null="false" selected="false" type="java.lang.String" value="Classic Cars"/><value label="Motorcycles" null="false" selected="false" type="java.lang.String" value="Motorcycles"/><value label="Planes" null="false" selected="false" type="java.lang.String" value="Planes"/><value label="Ships" null="false" selected="false" type="java.lang.String" value="Ships"/><value label="Trains" null="false" selected="true" type="java.lang.String" value="Trains"/><value label="Trucks and Buses" null="false" selected="false" type="java.lang.String" value="Trucks and Buses"/><value label="Vintage Cars" null="false" selected="false" type="java.lang.String" value="Vintage Cars"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="subscription-name" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="schedule"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscription"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Scheduling Options"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Name"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="destination" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="schedule"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscription"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Scheduling Options"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="E-Mail To"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="true" is-mandatory="false" is-multi-select="false" is-strict="true" name="schedule-id" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="schedule"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscription"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Scheduling Options"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Subscription"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><values/></parameter><parameter is-list="true" is-mandatory="true" is-multi-select="false" is-strict="true" name="output-target" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="parameters"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Output Type"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><values><value label="HTML (Paginated)" null="false" selected="true" type="java.lang.String" value="table/html;page-mode=page"/><value label="HTML (Single Page)" null="false" selected="false" type="java.lang.String" value="table/html;page-mode=stream"/><value label="PDF" null="false" selected="false" type="java.lang.String" value="pageable/pdf"/><value label="Excel" null="false" selected="false" type="java.lang.String" value="table/excel;page-mode=flow"/><value label="Excel 2007" null="false" selected="false" type="java.lang.String" value="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;page-mode=flow"/><value label="Comma Separated Value" null="false" selected="false" type="java.lang.String" value="table/csv;page-mode=stream"/><value label="Rich-Text-Format" null="false" selected="false" type="java.lang.String" value="table/rtf;page-mode=flow"/><value label="Text" null="false" selected="false" type="java.lang.String" value="pageable/text"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="subscribe" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscribe"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="true" is-mandatory="false" is-multi-select="true" is-strict="false" name="::cl" type="[Ljava.lang.String;"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Content-Linking"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="list"/><values/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="::TabName" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="::TabName"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="::TabActive" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="::TabActive"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="yield-rate" type="java.lang.Integer"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="yield-rate"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="accepted-page" type="java.lang.Integer"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="accepted-page"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="::session" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="::session"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><values><value label="53919d5a-1077-11e1-af53-1d63ac2acec9" null="false" selected="true" type="java.lang.String" value="53919d5a-1077-11e1-af53-1d63ac2acec9"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="output-type" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="output-type"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="layout" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="layout"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="content-handler-pattern" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="content-handler-pattern"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="autoSubmit" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="autoSubmit"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="autoSubmitUI" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="autoSubmitUI"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="dashboard-mode" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dashboard-mode"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="showParameters" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="showParameters"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><values><value label="true" null="false" selected="true" type="java.lang.Boolean" value="true"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="paginate" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="paginate"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="ignoreDefaultDates" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="ignoreDefaultDates"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="print" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="print"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="printer-name" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="printer-name"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="true" is-mandatory="false" is-multi-select="false" is-strict="true" name="renderMode" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="renderMode"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><values><value label="XML" null="false" selected="true" type="java.lang.String" value="XML"/><value label="REPORT" null="false" selected="false" type="java.lang.String" value="REPORT"/><value label="SUBSCRIBE" null="false" selected="false" type="java.lang.String" value="SUBSCRIBE"/><value label="DOWNLOAD" null="false" selected="false" type="java.lang.String" value="DOWNLOAD"/><value label="PARAMETER" null="false" selected="false" type="java.lang.String" value="PARAMETER"/></values></parameter></parameters>';
        var paramDefn = new pentaho.common.prompting.ParameterXmlParser().parseParameterXml(parameterXml);
        doh.assertTrue(paramDefn);

        var destinationId = 'panel';

        // Create panel element to inject into
        jQuery('<div/>', {
          id: destinationId
        }).appendTo('body');

        var panel = new pentaho.common.prompting.PromptPanel(destinationId, paramDefn);
        doh.assertTrue(panel);
        doh.assertEqual(destinationId, panel.destinationId);

        var submitCalled = false;

        panel.submit = function() {
          submitCalled = true;
        }

        panel.shouldBuildSubmitPanel = function () { return false; };

        panel.init();

        doh.assertEqual(8, panel.components.length);

        doh.assertTrue(submitCalled);
      }
    },
    {
      name: "No elements if no visible parameters or submit panel",
      timeout: 2000,
      runTest: function() {
        var parameterXml = '<?xml version="1.0" encoding="UTF-8"?><parameters autoSubmitUI="true" ignore-biserver-5538="true" is-prompt-needed="false" layout="vertical" subscribe="false"><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="subscription-name" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="schedule"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscription"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Scheduling Options"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Name"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="destination" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="schedule"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscription"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Scheduling Options"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="E-Mail To"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="true" is-mandatory="false" is-multi-select="false" is-strict="true" name="schedule-id" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="schedule"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscription"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Scheduling Options"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Subscription"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><values/></parameter><parameter is-list="true" is-mandatory="false" is-multi-select="false" is-strict="true" name="output-target" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="parameters"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Report Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Output Type"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><values><value label="HTML (Paginated)" null="false" selected="true" type="java.lang.String" value="table/html;page-mode=page"/><value label="HTML (Single Page)" null="false" selected="false" type="java.lang.String" value="table/html;page-mode=stream"/><value label="PDF" null="false" selected="false" type="java.lang.String" value="pageable/pdf"/><value label="Excel" null="false" selected="false" type="java.lang.String" value="table/excel;page-mode=flow"/><value label="Excel 2007" null="false" selected="false" type="java.lang.String" value="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;page-mode=flow"/><value label="Comma Separated Value" null="false" selected="false" type="java.lang.String" value="table/csv;page-mode=stream"/><value label="Rich-Text-Format" null="false" selected="false" type="java.lang.String" value="table/rtf;page-mode=flow"/><value label="Text" null="false" selected="false" type="java.lang.String" value="pageable/text"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="subscribe" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="subscribe"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="true" is-mandatory="false" is-multi-select="true" is-strict="false" name="::cl" type="[Ljava.lang.String;"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="Content-Linking"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="list"/><values/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="::TabName" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="::TabName"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="::TabActive" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="::TabActive"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="yield-rate" type="java.lang.Integer"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="yield-rate"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="accepted-page" type="java.lang.Integer"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="accepted-page"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="::session" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="::session"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><values><value label="fdf6154e-1095-11e1-af53-1d63ac2acec9" null="false" selected="true" type="java.lang.String" value="fdf6154e-1095-11e1-af53-1d63ac2acec9"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="output-type" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="output-type"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="layout" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="layout"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="content-handler-pattern" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="content-handler-pattern"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="autoSubmit" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="autoSubmit"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="autoSubmitUI" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="autoSubmitUI"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="dashboard-mode" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dashboard-mode"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="showParameters" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="showParameters"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><values><value label="true" null="false" selected="true" type="java.lang.Boolean" value="true"/></values></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="paginate" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="paginate"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="ignoreDefaultDates" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="ignoreDefaultDates"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="print" type="java.lang.Boolean"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="print"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="false" is-mandatory="false" is-multi-select="false" is-strict="false" name="printer-name" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="printer-name"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="textbox"/><attribute name="deprecated" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/></parameter><parameter is-list="true" is-mandatory="false" is-multi-select="false" is-strict="true" name="renderMode" type="java.lang.String"><attribute name="role" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="preferred" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="parameter-group" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="system"/><attribute name="parameter-group-label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="System Parameters"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="renderMode"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><values><value label="XML" null="false" selected="false" type="java.lang.String" value="XML"/><value label="REPORT" null="false" selected="false" type="java.lang.String" value="REPORT"/><value label="SUBSCRIBE" null="false" selected="false" type="java.lang.String" value="SUBSCRIBE"/><value label="DOWNLOAD" null="false" selected="false" type="java.lang.String" value="DOWNLOAD"/><value label="PARAMETER" null="false" selected="true" type="java.lang.String" value="PARAMETER"/></values></parameter></parameters>';
        var paramDefn = new pentaho.common.prompting.ParameterXmlParser().parseParameterXml(parameterXml);
        doh.assertTrue(paramDefn);

        var destinationId = 'panel';

        // Create panel element to inject into
        jQuery('<div/>', {
          id: destinationId
        }).appendTo('body');

        var panel = new pentaho.common.prompting.PromptPanel(destinationId, paramDefn);
        doh.assertTrue(panel);
        doh.assertEqual(destinationId, panel.destinationId);

        var submitCalled = false;

        panel.submit = function() {
          submitCalled = true;
        }

        panel.shouldBuildSubmitPanel = function () { return false; };

        panel.init();

        doh.assertEqual(1, panel.components.length);

        doh.assertTrue(submitCalled);

        // 1 second timeout to allow submit callback to be called after panel is initialized
        var deferred = new doh.Deferred();
        setTimeout(function() {
          doh.assertTrue(submitCalled);

          var panelDiv = $('#' + destinationId);
          doh.assertEqual(0, panelDiv.html().length);

          deferred.callback(true);
        }, 1000);
        return deferred;
      }
    },
    {
      name: "Null value converted to empty string",
      runTest: function() {
        var parameterXml = '<?xml version="1.0" encoding="UTF-8"?><parameters autoSubmitUI="true" ignore-biserver-5538="true" is-prompt-needed="false" layout="vertical" subscribe="false"><parameter is-list="true" is-mandatory="true" is-multi-select="false" is-strict="true" name="State" type="java.lang.String"><attribute name="autofill-selection" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="true"/><attribute name="hidden" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="false"/><attribute name="label" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="State"/><attribute name="parameter-render-type" namespace="http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core" value="dropdown"/><values><value label="null" null="true" selected="true" type="java.lang.String"/></values></parameter></parameters>';
        var paramDefn = new pentaho.common.prompting.ParameterXmlParser().parseParameterXml(parameterXml);
        doh.assertTrue(paramDefn);

        var destinationId = 'panel';

        // Create panel element to inject into
        jQuery('<div/>', {
          id: destinationId
        }).appendTo('body');

        var panel = new pentaho.common.prompting.PromptPanel(destinationId, paramDefn);
        panel.init();

        // Check for invalid value
        var param = paramDefn.parameterGroups[0].parameters[0];
        var currentValue = panel.getParameterValue(param);

        // nulls should be converted into empty strings so Dashboards doesn't break
        doh.assertEqual('', currentValue);
      }
    }
  ]);
});
