/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes;

import java.util.Locale;
import net.sourceforge.barbecue.Barcode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.types.ContentType;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes.BarcodeDrawable;
import org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes.BarcodeWrapper;
import org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes.SimpleBarcodesUtility;

public class SimpleBarcodesType
extends ContentType {
    private static final Log logger = LogFactory.getLog(SimpleBarcodesType.class);

    public SimpleBarcodesType() {
        super("simple-barcodes");
    }

    public Object getDesignValue(ExpressionRuntime runtime, ReportElement element) {
        Object value = ElementTypeUtils.queryStaticValue((ReportElement)element);
        if (value == null) {
            String type = (String)element.getAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", "type");
            value = SimpleBarcodesUtility.getBarcodeSampleData(type);
        }
        return this.createBarcode(runtime, element, value);
    }

    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        Object value = ElementTypeUtils.queryFieldOrValue((ExpressionRuntime)runtime, (ReportElement)element);
        if (value == null) {
            Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
            return this.filter(runtime, element, nullValue);
        }
        return this.createBarcode(runtime, element, value);
    }

    private Object createBarcode(ExpressionRuntime runtime, ReportElement element, Object value) {
        String type = (String)element.getAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", "type");
        if (type == null) {
            Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
            return this.filter(runtime, element, nullValue);
        }
        Number barHeight = ElementTypeUtils.getNumberAttribute((ReportElement)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", (String)"bar-height", null);
        Number barWidth = ElementTypeUtils.getNumberAttribute((ReportElement)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", (String)"bar-width", null);
        boolean showText = ElementTypeUtils.getBooleanAttribute((ReportElement)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", (String)"show-text", (boolean)true);
        boolean checksum = ElementTypeUtils.getBooleanAttribute((ReportElement)element, (String)"http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", (String)"checksum", (boolean)true);
        try {
            BarcodeGenerator generator = SimpleBarcodesUtility.createBarcode4J(type, showText, checksum, barHeight);
            if (generator != null) {
                return new BarcodeDrawable(generator, value.toString());
            }
            Barcode barcode = SimpleBarcodesUtility.createBarcode(value.toString(), type, checksum);
            if (barcode == null) {
                Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
                return this.filter(runtime, element, nullValue);
            }
            barcode.setDrawingText(showText);
            if (barWidth != null) {
                barcode.setBarWidth(barWidth.intValue());
            } else {
                barcode.setBarWidth(1);
            }
            if (barHeight != null) {
                barcode.setBarHeight(barHeight.intValue());
            } else {
                barcode.setBarHeight(18);
            }
            barcode.setDrawingText(showText);
            return new BarcodeWrapper(barcode);
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Error creating barcode, falling back to null value", (Throwable)e);
            }
            Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
            return this.filter(runtime, element, nullValue);
        }
    }

    public void configureDesignTimeDefaults(ReportElement element, Locale locale) {
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/extensions/sbarcodes/1.0", "type", (Object)"code128");
    }
}

