/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.connection;

import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.pentaho.commons.connection.DataUtilities;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.Messages;
import org.pentaho.commons.connection.memory.MemoryMetaData;
import org.pentaho.commons.connection.memory.MemoryResultSet;

public class PentahoDataTransmuter
extends DataUtilities {
    protected final IPentahoResultSet sourceResultSet;

    public PentahoDataTransmuter(IPentahoResultSet resultSet) {
        this.sourceResultSet = resultSet;
    }

    public IPentahoResultSet getSourceResultSet() {
        return this.sourceResultSet;
    }

    public static IPentahoResultSet transmute(IPentahoResultSet source, boolean pivot) {
        return PentahoDataTransmuter.transmute(source, (Integer)null, null, null, null, pivot);
    }

    public static IPentahoResultSet transmute(IPentahoResultSet source, Integer columnForRowHeaders, Integer rowForColumnHeaders, boolean pivot) {
        return PentahoDataTransmuter.transmute(source, columnForRowHeaders, rowForColumnHeaders, null, null, pivot);
    }

    public IPentahoResultSet transmute(Integer columnForRowHeaders, Integer rowForColumnHeaders, boolean pivot) {
        return PentahoDataTransmuter.transmute(this.sourceResultSet, columnForRowHeaders, rowForColumnHeaders, null, null, pivot);
    }

    public static IPentahoResultSet transmute(IPentahoResultSet source, String[] columnForRowHeaders, String[] rowForColumnHeaders, boolean pivot) {
        return PentahoDataTransmuter.transmute(source, columnForRowHeaders, rowForColumnHeaders, (String[][])null, (String[][])null, pivot);
    }

    public IPentahoResultSet transmute(String[] columnForRowHeaders, String[] rowForColumnHeaders, boolean pivot) {
        return PentahoDataTransmuter.transmute(this.sourceResultSet, columnForRowHeaders, rowForColumnHeaders, (String[][])null, (String[][])null, pivot);
    }

    public static IPentahoResultSet transmute(IPentahoResultSet source, Integer[] rowsToInclude, Integer[] columnsToInclude, boolean pivot) {
        return PentahoDataTransmuter.transmute(source, null, null, rowsToInclude, columnsToInclude, pivot);
    }

    public IPentahoResultSet transmute(Integer[] rowsToInclude, Integer[] columnsToInclude, boolean pivot) {
        return PentahoDataTransmuter.transmute(this.sourceResultSet, null, null, rowsToInclude, columnsToInclude, pivot);
    }

    public static IPentahoResultSet transmute(IPentahoResultSet source, String[][] rowsToInclude, String[][] columnsToInclude, boolean pivot) {
        return PentahoDataTransmuter.transmute(source, null, null, rowsToInclude, columnsToInclude, pivot);
    }

    public IPentahoResultSet transmute(String[][] rowsToInclude, String[][] columnsToInclude, boolean pivot) {
        return PentahoDataTransmuter.transmute(this.sourceResultSet, null, null, rowsToInclude, columnsToInclude, pivot);
    }

    public IPentahoResultSet transmute(String[] columnForRowHeaders, String[] rowForColumnHeaders, String[][] rowsToInclude, String[][] columnsToInclude, boolean pivot) {
        return PentahoDataTransmuter.transmute(this.sourceResultSet, columnForRowHeaders, rowForColumnHeaders, rowsToInclude, columnsToInclude, pivot);
    }

    public static IPentahoResultSet transmute(IPentahoResultSet source, String[] columnForRowHeaders, String[] rowForColumnHeaders, String[][] rowsToInclude, String[][] columnsToInclude, boolean pivot) {
        Integer cfrh = null;
        if (columnForRowHeaders != null) {
            String[][] searchStrings = new String[][]{columnForRowHeaders};
            Integer[] indexes = PentahoDataTransmuter.columnNamesToIndexes(source, searchStrings);
            if (indexes.length > 0) {
                cfrh = indexes[0];
            }
        }
        Integer rfch = null;
        if (rowForColumnHeaders != null) {
            String[][] searchStrings = new String[][]{rowForColumnHeaders};
            Integer[] indexes = PentahoDataTransmuter.rowNamesToIndexes(source, searchStrings);
            if (indexes.length > 0) {
                rfch = indexes[0];
            }
        }
        Integer[] rti = null;
        if (rowsToInclude != null) {
            rti = PentahoDataTransmuter.rowNamesToIndexes(source, rowsToInclude);
        }
        Integer[] cti = null;
        if (columnsToInclude != null) {
            cti = PentahoDataTransmuter.columnNamesToIndexes(source, columnsToInclude);
        }
        return PentahoDataTransmuter.transmute(source, cfrh, rfch, rti, cti, pivot);
    }

    public IPentahoResultSet transmute(Integer columnForRowHeaders, Integer rowForColumnHeaders, Integer[] rowsToInclude, Integer[] columnsToInclude, boolean pivot) {
        return PentahoDataTransmuter.transmute(this.sourceResultSet, columnForRowHeaders, rowForColumnHeaders, rowsToInclude, columnsToInclude, pivot);
    }

    public static IPentahoResultSet transmute(IPentahoResultSet source, Integer columnForRowHeaders, Integer rowForColumnHeaders, Integer[] rowsToInclude, Integer[] columnsToInclude, boolean pivot) {
        Object[][] rowHeaders = null;
        Object[][] columnHeaders = null;
        rowHeaders = PentahoDataTransmuter.constructRowHeaders(source, columnForRowHeaders);
        columnHeaders = PentahoDataTransmuter.constructColumnHeaders(source, rowForColumnHeaders);
        rowHeaders = DataUtilities.filterDataByRows(rowHeaders, rowsToInclude);
        columnHeaders = DataUtilities.filterDataByColumns(columnHeaders, columnsToInclude);
        source.beforeFirst();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        Object[] rowData = source.next();
        while (rowData != null) {
            dataList.add(rowData);
            rowData = source.next();
        }
        Object[][] data = null;
        if (columnHeaders != null) {
            data = new Object[dataList.size()][columnHeaders[0].length];
            for (int row = 0; row < data.length; ++row) {
                data[row] = (Object[])dataList.get(row);
            }
        }
        data = DataUtilities.filterData(data, rowsToInclude, columnsToInclude);
        IPentahoResultSet result = new MemoryResultSet(new MemoryMetaData(columnHeaders, rowHeaders));
        if (data != null) {
            for (int row = 0; row < data.length; ++row) {
                ((MemoryResultSet)result).addRow(data[row]);
            }
        }
        if (pivot) {
            result = PentahoDataTransmuter.pivot(result);
        }
        return result;
    }

    public IPentahoResultSet pivot() {
        return PentahoDataTransmuter.pivot(this.sourceResultSet);
    }

    public static IPentahoResultSet pivot(IPentahoResultSet resultSet) {
        int row;
        MemoryResultSet result = new MemoryResultSet(PentahoDataTransmuter.swapAndPivotRowAndColumnHeaders(resultSet.getMetaData()));
        Object[][] dataValues = new Object[resultSet.getRowCount()][resultSet.getColumnCount()];
        for (row = 0; row < resultSet.getRowCount(); ++row) {
            Object[] dataRow = resultSet.next();
            for (int column = 0; column < resultSet.getColumnCount(); ++column) {
                dataValues[row][column] = dataRow[column];
            }
        }
        dataValues = DataUtilities.pivotDimensions(dataValues);
        for (row = 0; row < dataValues.length; ++row) {
            result.addRow(dataValues[row]);
        }
        return result;
    }

    public Integer[] rowNamesToIndexes(String[][] names) {
        return PentahoDataTransmuter.rowNamesToIndexes(this.sourceResultSet, names);
    }

    public static Integer[] rowNamesToIndexes(IPentahoResultSet source, String[][] names) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int row = 0; row < names.length; ++row) {
            int found = source.getMetaData().getRowIndex(names[row]);
            if (found == -1) continue;
            result.add(new Integer(found));
        }
        Integer[] resultArray = new Integer[result.size()];
        for (int i = 0; i < resultArray.length; ++i) {
            resultArray[i] = (Integer)result.get(i);
        }
        return resultArray;
    }

    public Integer[] columnNamesToIndexes(String[][] names) {
        return PentahoDataTransmuter.columnNamesToIndexes(this.sourceResultSet, names);
    }

    public static Integer[] columnNamesToIndexes(IPentahoResultSet source, String[][] names) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int row = 0; row < names.length; ++row) {
            int found = source.getMetaData().getColumnIndex(names[row]);
            if (found == -1) continue;
            result.add(new Integer(found));
        }
        Integer[] resultArray = new Integer[result.size()];
        for (int i = 0; i < resultArray.length; ++i) {
            resultArray[i] = (Integer)result.get(i);
        }
        return resultArray;
    }

    protected static Object[][] constructColumnHeaders(IPentahoResultSet source, Integer rowForColumnHeaders) {
        Object[][] result = null;
        if (rowForColumnHeaders == null) {
            if (source.getMetaData().getColumnHeaders() == null) {
                Object[] dataRow = source.getDataRow(0);
                if (dataRow != null) {
                    result = new Object[][]{dataRow};
                }
            } else {
                result = source.getMetaData().getColumnHeaders();
            }
        } else {
            Object[] dataRow = source.getDataRow(rowForColumnHeaders);
            if (dataRow != null) {
                result = new Object[][]{dataRow};
            }
        }
        return result;
    }

    protected static Object[][] constructRowHeaders(IPentahoResultSet source, Integer columnForRowHeaders) {
        Object[][] result = null;
        if (columnForRowHeaders == null) {
            if (source.getMetaData().getRowHeaders() == null) {
                Object[] dataColumn = source.getDataColumn(0);
                result = new Object[dataColumn.length][1];
                for (int row = 0; row < result.length; ++row) {
                    result[row][0] = dataColumn[row];
                }
            } else {
                result = source.getMetaData().getRowHeaders();
            }
        } else {
            Object[] dataColumn = source.getDataColumn(columnForRowHeaders);
            result = new Object[dataColumn.length][1];
            for (int row = 0; row < result.length; ++row) {
                result[row][0] = dataColumn[row];
            }
        }
        return result;
    }

    protected static IPentahoMetaData swapAndPivotRowAndColumnHeaders(IPentahoMetaData metaData) {
        Object[][] sourceColumnHeaders = metaData.getColumnHeaders();
        Object[][] sourceRowHeaders = metaData.getRowHeaders();
        boolean hasColumnHeaders = sourceColumnHeaders != null;
        boolean hasRowHeaders = sourceRowHeaders != null;
        Object[][] columnHeaders = null;
        Object[][] rowHeaders = null;
        if (hasColumnHeaders) {
            rowHeaders = DataUtilities.pivotDimensions(sourceColumnHeaders);
        }
        if (hasRowHeaders) {
            columnHeaders = DataUtilities.pivotDimensions(sourceRowHeaders);
        }
        MemoryMetaData result = new MemoryMetaData(columnHeaders, rowHeaders);
        return result;
    }

    private static String[] getCollapsedRowHeaders(IPentahoResultSet resultSet, char seperator) {
        Object[][] rowHeaders = resultSet.getMetaData().getRowHeaders();
        if (rowHeaders != null) {
            StringBuffer[] resultBuffer = new StringBuffer[rowHeaders.length];
            for (int i = 0; i < resultBuffer.length; ++i) {
                resultBuffer[i] = new StringBuffer();
            }
            for (int row = 0; row < rowHeaders.length; ++row) {
                for (int col = 0; col < rowHeaders[row].length; ++col) {
                    if (col == 0) {
                        resultBuffer[row].append(rowHeaders[row][col].toString());
                        continue;
                    }
                    resultBuffer[row].append(seperator + rowHeaders[row][col].toString());
                }
            }
            String[] result = new String[resultBuffer.length];
            for (int i = 0; i < resultBuffer.length; ++i) {
                result[i] = resultBuffer[i].toString();
            }
            return result;
        }
        return null;
    }

    private static String[] getCollapsedColumnHeaders(IPentahoResultSet resultSet, char seperator) {
        Object[][] columnHeaders = resultSet.getMetaData().getColumnHeaders();
        if (columnHeaders != null) {
            StringBuffer[] resultBuffer = new StringBuffer[columnHeaders[0].length];
            for (int i = 0; i < resultBuffer.length; ++i) {
                resultBuffer[i] = new StringBuffer();
            }
            for (int col = 0; col < columnHeaders[0].length; ++col) {
                for (int row = 0; row < columnHeaders.length; ++row) {
                    if (row == 0) {
                        resultBuffer[col].append(columnHeaders[row][col].toString());
                        continue;
                    }
                    resultBuffer[col].append(seperator + columnHeaders[row][col].toString());
                }
            }
            String[] result = new String[resultBuffer.length];
            for (int i = 0; i < resultBuffer.length; ++i) {
                result[i] = resultBuffer[i].toString();
            }
            return result;
        }
        return null;
    }

    public String[] getCollapsedHeaders(int axis, char seperator) throws Exception {
        return PentahoDataTransmuter.getCollapsedHeaders(axis, this.sourceResultSet, seperator);
    }

    public static String[] getCollapsedHeaders(int axis, IPentahoResultSet resultSet, char seperator) throws Exception {
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException(Messages.getString("PentahoDataTransmuter.ERROR_0001_INVALID_AXIS"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(Messages.getString("PentahoDataTransmuter.ERROR_0002_NULL_DATASET"));
        }
        switch (axis) {
            case 0: {
                return PentahoDataTransmuter.getCollapsedColumnHeaders(resultSet, seperator);
            }
            case 1: {
                return PentahoDataTransmuter.getCollapsedRowHeaders(resultSet, seperator);
            }
        }
        return null;
    }

    public static IPentahoResultSet flattenResultSet(IPentahoResultSet resultSet, int squashColumn) {
        IPentahoResultSet flattenedResultSet = resultSet.memoryCopy();
        if (flattenedResultSet instanceof MemoryResultSet) {
            MemoryResultSet memoryResultSet = (MemoryResultSet)flattenedResultSet;
            Object[][] colHeads = memoryResultSet.getMetaData().getColumnHeaders();
            int rowCount = memoryResultSet.getRowCount();
            int colCount = memoryResultSet.getColumnCount();
            Object squashColumnValue = memoryResultSet.getValueAt(0, squashColumn);
            Object[] squashedRow = new Object[colCount];
            LinkedList<Object[]> rowsList = new LinkedList<Object[]>();
            rowsList.add(squashedRow);
            for (int row = 0; row < rowCount; ++row) {
                Object newSquashColumnValue = memoryResultSet.getValueAt(row, squashColumn);
                if (!newSquashColumnValue.equals(squashColumnValue)) {
                    squashedRow = new Object[colCount];
                    rowsList.add(squashedRow);
                }
                squashColumnValue = newSquashColumnValue;
                for (int col = 0; col < colCount; ++col) {
                    Object potentialValue = memoryResultSet.getValueAt(row, col);
                    if (potentialValue == null || potentialValue.toString().equals("")) continue;
                    squashedRow[col] = potentialValue;
                }
            }
            Object[][] rows = new Object[rowsList.size()][colCount];
            for (int i = 0; i < rowsList.size(); ++i) {
                rows[i] = (Object[])rowsList.get(i);
            }
            return MemoryResultSet.createFromArrays(colHeads, rows);
        }
        return flattenedResultSet;
    }

    public static String dump(IPentahoResultSet source) {
        return PentahoDataTransmuter.dump(source, true);
    }

    public static String dump(IPentahoResultSet source, boolean useOrBar) {
        int column;
        int row;
        StringBuffer sb = new StringBuffer();
        String orBar = "";
        if (useOrBar) {
            orBar = "|";
        }
        source.beforeFirst();
        Object[][] columnHeaders = source.getMetaData().getColumnHeaders();
        Object[][] rowHeaders = source.getMetaData().getRowHeaders();
        String formatString = "";
        if (rowHeaders != null) {
            for (int columns = 0; columns < rowHeaders[0].length; ++columns) {
                formatString = formatString + "\t\t";
            }
        }
        if (columnHeaders != null) {
            for (row = columnHeaders.length - 1; row >= 0; --row) {
                sb.append(formatString);
                for (column = 0; column < columnHeaders[row].length; ++column) {
                    sb.append(columnHeaders[row][column] + orBar + "\t");
                }
                sb.append('\n');
            }
        }
        if (rowHeaders != null) {
            for (row = 0; row < rowHeaders.length; ++row) {
                for (int column2 = rowHeaders[row].length - 1; column2 >= 0; --column2) {
                    sb.append(rowHeaders[row][column2] + orBar + "\t");
                }
                Object[] dataRow = source.next();
                for (int column3 = 0; column3 < dataRow.length; ++column3) {
                    sb.append(dataRow[column3] + orBar + "\t");
                }
                sb.append('\n');
            }
        } else {
            Object[] dataRow = source.next();
            while (dataRow != null) {
                for (column = 0; column < dataRow.length; ++column) {
                    sb.append(dataRow[column] + orBar + "\t");
                }
                sb.append('\n');
                dataRow = source.next();
            }
        }
        sb.append('\n');
        source.beforeFirst();
        return sb.toString();
    }

    public static IPentahoResultSet crossTab(IPentahoResultSet source, int columnToPivot, int measureColumn, Format pivotDataFormatter) {
        return PentahoDataTransmuter.crossTab(source, columnToPivot, measureColumn, pivotDataFormatter, true);
    }

    public static IPentahoResultSet crossTab(IPentahoResultSet source, int columnToPivot, int measureColumn, Format pivotDataFormatter, boolean orderedMaps) {
        return PentahoDataTransmuter.crossTab(source, columnToPivot, measureColumn, -1, pivotDataFormatter, null, orderedMaps);
    }

    public static IPentahoResultSet crossTab(IPentahoResultSet source, int columnToPivot, int measureColumn, int columnToSortColumnsBy, Format pivotDataFormatter, Format sortDataFormatter, boolean orderedMaps) {
        if (source == null) {
            throw new IllegalArgumentException(Messages.getString("PentahoDataTransmuter.ERROR_0002_NULL_DATASET"));
        }
        int sourceColumnCount = source.getColumnCount();
        if (columnToPivot > sourceColumnCount) {
            throw new IllegalArgumentException(Messages.getString("PentahoDataTransmuter.ERROR_0003_INVALID_PIVOT_COLUMN"));
        }
        if (measureColumn > sourceColumnCount) {
            throw new IllegalArgumentException(Messages.getString("PentahoDataTransmuter.ERROR_0004_INVALID_MEASURE_COLUMN"));
        }
        if (columnToSortColumnsBy > sourceColumnCount) {
            throw new IllegalArgumentException(Messages.getString("PentahoDataTransmuter.ERROR_0005_INVALID_SORT_COLUMN"));
        }
        String sortPrefixSeparator = "\t";
        OrderedMap rowMap = null;
        OrderedMap newHeadersMap = null;
        if (columnToSortColumnsBy >= 0) {
            orderedMaps = true;
        }
        if (orderedMaps) {
            rowMap = new TreeMap();
            newHeadersMap = new TreeMap();
        } else {
            rowMap = ListOrderedMap.decorate(new HashMap());
            newHeadersMap = ListOrderedMap.decorate(new HashMap());
        }
        ArrayList<String> columnHeaders = new ArrayList<String>();
        IPentahoMetaData origMetaData = source.getMetaData();
        Object[][] origColHeaders = origMetaData.getColumnHeaders();
        for (int i = 0; i < origColHeaders[0].length; ++i) {
            if (i == columnToPivot || i == measureColumn) continue;
            columnHeaders.add(origColHeaders[0][i].toString());
        }
        Object[] rowData = source.next();
        String columnPrefix = null;
        Object currentMap = null;
        while (rowData != null) {
            Object header;
            Object colPivotData = rowData[columnToPivot];
            if (colPivotData == null) {
                throw new IllegalArgumentException(Messages.getString("PentahoDataTransmuter.ERROR_0006_CANNOT_PIVOT_NULL_DATA"));
            }
            Object colMeasureData = rowData[measureColumn];
            if (columnToSortColumnsBy >= 0) {
                Object colToSortByRaw = rowData[columnToSortColumnsBy];
                if (colToSortByRaw == null) {
                    throw new IllegalArgumentException(Messages.getString("PentahoDataTransmuter.ERROR_0007_CANNOT_SORT_NULL_DATA"));
                }
                columnPrefix = sortDataFormatter != null ? sortDataFormatter.format(colToSortByRaw) : colToSortByRaw.toString();
            }
            currentMap = rowMap;
            for (int i = 0; i < rowData.length; ++i) {
                if (i == columnToPivot || i == measureColumn || i == columnToSortColumnsBy) continue;
                Object cellData = currentMap.get(rowData[i]);
                if (cellData == null) {
                    OrderedMap newColumnMap = null;
                    newColumnMap = orderedMaps ? new TreeMap() : ListOrderedMap.decorate(new HashMap());
                    currentMap.put(rowData[i], newColumnMap);
                    currentMap = newColumnMap;
                    continue;
                }
                currentMap = (Map)cellData;
            }
            String formattedPivotData = null;
            formattedPivotData = pivotDataFormatter != null ? (pivotDataFormatter instanceof MessageFormat ? pivotDataFormatter.format(new Object[]{colPivotData}) : pivotDataFormatter.format(colPivotData)) : colPivotData.toString();
            if (columnToSortColumnsBy >= 0) {
                formattedPivotData = columnPrefix + "\t" + formattedPivotData;
            }
            if ((header = newHeadersMap.get(formattedPivotData)) == null) {
                newHeadersMap.put(formattedPivotData, "");
            }
            currentMap.put(formattedPivotData, colMeasureData);
            rowData = source.next();
        }
        Iterator hIt = newHeadersMap.keySet().iterator();
        while (hIt.hasNext()) {
            columnHeaders.add(hIt.next().toString());
        }
        ArrayList rows = new ArrayList();
        Set uniqueItems = rowMap.keySet();
        Iterator it = uniqueItems.iterator();
        ArrayList newCurRow = new ArrayList();
        while (it.hasNext()) {
            PentahoDataTransmuter.recurseCreateRow(it.next(), (Map)rowMap, rows, newCurRow, (Map)newHeadersMap);
            newCurRow.clear();
        }
        if (columnToSortColumnsBy >= 0) {
            for (int i = 0; i < columnHeaders.size(); ++i) {
                String aHeader = (String)columnHeaders.get(i);
                int tabIdx = aHeader.indexOf("\t");
                if (tabIdx < 0) continue;
                columnHeaders.set(i, aHeader.substring(tabIdx + 1));
            }
        }
        MemoryResultSet result = MemoryResultSet.createFromLists(columnHeaders, rows);
        return result;
    }

    private static List recurseCreateRow(Object lookup, Map mapToLookupIn, List rows, List curRow, Map newColumnsMap) {
        Object value;
        if (curRow == null) {
            curRow = new ArrayList<Object>();
        }
        if ((value = mapToLookupIn.get(lookup)) == null) {
            curRow.add(null);
            return null;
        }
        if (value instanceof Map) {
            curRow.add(lookup);
            Map newLkupMap = (Map)value;
            Set uniqueItems = newLkupMap.keySet();
            Iterator<Object> it = uniqueItems.iterator();
            Object obj = it.next();
            it = newColumnsMap.get(obj.toString()) != null ? newColumnsMap.keySet().iterator() : uniqueItems.iterator();
            ArrayList beforeValues = new ArrayList(curRow);
            beforeValues.remove(beforeValues.size() - 1);
            List addedValues = null;
            while (it.hasNext()) {
                addedValues = PentahoDataTransmuter.recurseCreateRow(it.next(), newLkupMap, rows, curRow, newColumnsMap);
                if (addedValues == null) continue;
                curRow.clear();
                curRow.addAll(addedValues);
            }
            if (addedValues == null) {
                if (curRow.size() > newColumnsMap.size()) {
                    rows.add(new ArrayList(curRow));
                }
                return beforeValues;
            }
            curRow.clear();
            curRow.addAll(beforeValues);
            return null;
        }
        curRow.add(value);
        return null;
    }

    private static boolean isEqual(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    private static boolean isNewRow(Object[] thisRow, Object[] lastRow) {
        for (int i = 0; i < thisRow.length; ++i) {
            if (PentahoDataTransmuter.isEqual(thisRow[i], lastRow[i])) continue;
            return true;
        }
        return false;
    }

    private static String formatPivotData(Object colPivotData, Format pivotDataFormatter) {
        String formattedPivotData = null;
        formattedPivotData = pivotDataFormatter != null ? (pivotDataFormatter instanceof MessageFormat ? pivotDataFormatter.format(new Object[]{colPivotData}) : pivotDataFormatter.format(colPivotData)) : colPivotData.toString();
        return formattedPivotData;
    }

    public static IPentahoResultSet crossTabOrdered(IPentahoResultSet source, int columnToPivot, int measureColumn, Format pivotDataFormatter) {
        return PentahoDataTransmuter.crossTabOrdered(source, columnToPivot, measureColumn, pivotDataFormatter, true);
    }

    public static IPentahoResultSet crossTabOrdered(IPentahoResultSet source, int columnToPivot, int measureColumn, Format pivotDataFormatter, boolean orderedMaps) {
        return PentahoDataTransmuter.crossTabOrdered(source, columnToPivot, measureColumn, -1, pivotDataFormatter, null, orderedMaps, -1);
    }

    public static IPentahoResultSet crossTabOrdered(IPentahoResultSet source, int columnToPivot, int measureColumn, int columnToSortColumnsBy, Format pivotDataFormatter, Format sortDataFormatter, boolean orderedMaps, int uniqueRowIdentifierColumn) {
        Object colPivotData;
        if (source == null) {
            throw new IllegalArgumentException(Messages.getString("PentahoDataTransmuter.ERROR_0002_NULL_DATASET"));
        }
        int sourceColumnCount = source.getColumnCount();
        if (columnToPivot > sourceColumnCount) {
            throw new IllegalArgumentException(Messages.getString("PentahoDataTransmuter.ERROR_0003_INVALID_PIVOT_COLUMN"));
        }
        if (measureColumn > sourceColumnCount) {
            throw new IllegalArgumentException(Messages.getString("PentahoDataTransmuter.ERROR_0004_INVALID_MEASURE_COLUMN"));
        }
        if (columnToSortColumnsBy > sourceColumnCount) {
            throw new IllegalArgumentException(Messages.getString("PentahoDataTransmuter.ERROR_0005_INVALID_SORT_COLUMN"));
        }
        if (uniqueRowIdentifierColumn > sourceColumnCount) {
            throw new IllegalArgumentException(Messages.getString("PentahoDataTransmuter.ERROR_0008_INVALID_UNIQUE_COLUMN"));
        }
        String sortPrefixSeparator = "\t";
        OrderedMap newHeadersMap = null;
        HashMap uniqueColumnIdentifierMap = null;
        if (uniqueRowIdentifierColumn >= 0) {
            uniqueColumnIdentifierMap = new HashMap();
        }
        int uniqueRowIdentifierColumnPostShift = -1;
        if (columnToSortColumnsBy >= 0) {
            orderedMaps = true;
        }
        newHeadersMap = orderedMaps ? new TreeMap() : ListOrderedMap.decorate(new HashMap());
        ArrayList<String> columnHeaders = new ArrayList<String>();
        IPentahoMetaData origMetaData = source.getMetaData();
        Object[][] origColHeaders = origMetaData.getColumnHeaders();
        for (int i = 0; i < origColHeaders[0].length; ++i) {
            if (i == columnToPivot || i == measureColumn || i == columnToSortColumnsBy) continue;
            columnHeaders.add(origColHeaders[0][i].toString());
            if (i != uniqueRowIdentifierColumn) continue;
            uniqueRowIdentifierColumnPostShift = columnHeaders.size() - 1;
        }
        int baseColumnsCount = columnHeaders.size();
        Object[] rowData = source.next();
        String columnPrefix = null;
        HashMap<Object, Integer> newColumnHeadersRaw = new HashMap<Object, Integer>();
        Integer placeHolder = new Integer(0);
        while (rowData != null) {
            colPivotData = rowData[columnToPivot];
            if (colPivotData == null) {
                throw new IllegalArgumentException(Messages.getString("PentahoDataTransmuter.ERROR_0006_CANNOT_PIVOT_NULL_DATA"));
            }
            if (columnToSortColumnsBy >= 0) {
                Object colToSortByRaw = rowData[columnToSortColumnsBy];
                if (colToSortByRaw == null) {
                    throw new IllegalArgumentException(Messages.getString("PentahoDataTransmuter.ERROR_0007_CANNOT_SORT_NULL_DATA"));
                }
                columnPrefix = sortDataFormatter != null ? sortDataFormatter.format(colToSortByRaw) : colToSortByRaw.toString();
            }
            if (!newColumnHeadersRaw.containsKey(colPivotData)) {
                newColumnHeadersRaw.put(colPivotData, placeHolder);
                String formattedPivotData = PentahoDataTransmuter.formatPivotData(colPivotData, pivotDataFormatter);
                if (columnToSortColumnsBy >= 0) {
                    formattedPivotData = columnPrefix + "\t" + formattedPivotData;
                }
                newHeadersMap.put(formattedPivotData, colPivotData);
            }
            rowData = source.next();
        }
        source.beforeFirst();
        Iterator it = newHeadersMap.entrySet().iterator();
        int columnIndex = columnHeaders.size();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            newColumnHeadersRaw.put(me.getValue(), new Integer(columnIndex));
            columnHeaders.add(PentahoDataTransmuter.formatPivotData(me.getValue(), pivotDataFormatter));
            ++columnIndex;
        }
        int columnCount = columnHeaders.size();
        MemoryResultSet mrs = new MemoryResultSet();
        MemoryMetaData md = new MemoryMetaData(columnHeaders);
        mrs.setMetaData(md);
        Object[] thisRow = new Object[baseColumnsCount];
        Object[] currentRow = new Object[columnCount];
        rowData = source.next();
        boolean isFirstRow = true;
        while (rowData != null) {
            Object colMeasureData = rowData[measureColumn];
            int rowPos = 0;
            for (int i = 0; i < rowData.length; ++i) {
                if (i == columnToPivot || i == measureColumn || i == columnToSortColumnsBy) continue;
                thisRow[rowPos] = rowData[i];
                ++rowPos;
            }
            boolean newRow = true;
            String uniqueRowIdentifierValue = null;
            Integer previousRowNumber = null;
            if (uniqueRowIdentifierColumn >= 0 && (previousRowNumber = (Integer)uniqueColumnIdentifierMap.get(uniqueRowIdentifierValue = rowData[uniqueRowIdentifierColumn] != null ? rowData[uniqueRowIdentifierColumn] : "_NULL_VALUE_")) != null) {
                PentahoDataTransmuter.addIfNeeded(currentRow, mrs, uniqueColumnIdentifierMap, uniqueRowIdentifierColumnPostShift);
                currentRow = mrs.getDataRow(previousRowNumber);
                newRow = false;
            }
            boolean bl = newRow = newRow && !isFirstRow && PentahoDataTransmuter.isNewRow(thisRow, currentRow);
            if (newRow) {
                PentahoDataTransmuter.addIfNeeded(currentRow, mrs, uniqueColumnIdentifierMap, uniqueRowIdentifierColumnPostShift);
                currentRow = new Object[columnCount];
                System.arraycopy(thisRow, 0, currentRow, 0, thisRow.length);
            } else if (isFirstRow) {
                System.arraycopy(thisRow, 0, currentRow, 0, thisRow.length);
            }
            isFirstRow = false;
            colPivotData = rowData[columnToPivot];
            Integer targetColumn = (Integer)newColumnHeadersRaw.get(colPivotData);
            currentRow[targetColumn.intValue()] = colMeasureData;
            rowData = source.next();
        }
        PentahoDataTransmuter.addIfNeeded(currentRow, mrs, uniqueColumnIdentifierMap, uniqueRowIdentifierColumnPostShift);
        return mrs;
    }

    private static void addIfNeeded(Object[] currentRow, MemoryResultSet mrs, Map uniqueColumnIdentifierMap, int uniqueRowIdentifierColumnPostShift) {
        if (uniqueRowIdentifierColumnPostShift >= 0) {
            String tmpValue;
            String string = tmpValue = currentRow[uniqueRowIdentifierColumnPostShift] != null ? currentRow[uniqueRowIdentifierColumnPostShift] : "_NULL_VALUE_";
            if (!uniqueColumnIdentifierMap.containsKey(tmpValue)) {
                int addedRow = mrs.addRow(currentRow);
                uniqueColumnIdentifierMap.put(tmpValue, new Integer(addedRow));
            }
        } else {
            mrs.addRow(currentRow);
        }
    }
}

