/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.IOException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hive.service.auth.KerberosSaslHelper;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class HiveAuthFactory {
    private HadoopThriftAuthBridge.Server saslServer = null;
    private String authTypeStr;
    HiveConf conf = new HiveConf();

    public HiveAuthFactory() throws TTransportException {
        this.authTypeStr = this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION);
        if (this.authTypeStr == null) {
            this.authTypeStr = AuthTypes.NONE.getAuthName();
        }
        if (this.authTypeStr.equalsIgnoreCase(AuthTypes.KERBEROS.getAuthName()) && ShimLoader.getHadoopShims().isSecureShimImpl()) {
            this.saslServer = ShimLoader.getHadoopThriftAuthBridge().createServer(this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB), this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL));
        }
    }

    public TTransportFactory getAuthTransFactory() throws LoginException {
        TTransportFactory transportFactory;
        if (this.authTypeStr.equalsIgnoreCase(AuthTypes.KERBEROS.getAuthName())) {
            try {
                transportFactory = this.saslServer.createTransportFactory();
            }
            catch (TTransportException e) {
                throw new LoginException(e.getMessage());
            }
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.NONE.getAuthName())) {
            transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.LDAP.getAuthName())) {
            transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.NOSASL.getAuthName())) {
            transportFactory = new TTransportFactory();
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.CUSTOM.getAuthName())) {
            transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
        } else {
            throw new LoginException("Unsupported authentication type " + this.authTypeStr);
        }
        return transportFactory;
    }

    public TProcessorFactory getAuthProcFactory(ThriftCLIService service) throws LoginException {
        if (this.authTypeStr.equalsIgnoreCase(AuthTypes.KERBEROS.getAuthName())) {
            return KerberosSaslHelper.getKerberosProcessorFactory(this.saslServer, service);
        }
        return PlainSaslHelper.getPlainProcessorFactory(service);
    }

    public String getRemoteUser() {
        if (this.saslServer != null) {
            return this.saslServer.getRemoteUser();
        }
        return null;
    }

    public String getIpAddress() {
        return this.saslServer != null ? this.saslServer.getRemoteAddress().toString() : null;
    }

    public static void loginFromKeytab(HiveConf hiveConf) throws IOException {
        String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL);
        String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB);
        if (principal.isEmpty() && keyTabFile.isEmpty()) {
            return;
        }
        if (principal.isEmpty() || keyTabFile.isEmpty()) {
            throw new IOException("HiveServer2 kerberos principal or keytab is not correctly configured");
        }
        ShimLoader.getHadoopShims().loginUserFromKeytab(principal, keyTabFile);
    }

    public static enum AuthTypes {
        NOSASL("NOSASL"),
        NONE("NONE"),
        LDAP("LDAP"),
        KERBEROS("KERBEROS"),
        CUSTOM("CUSTOM");

        private String authType;

        private AuthTypes(String authType) {
            this.authType = authType;
        }

        public String getAuthName() {
            return this.authType;
        }
    }
}

