/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.operation.GetCatalogsOperation;
import org.apache.hive.service.cli.operation.GetColumnsOperation;
import org.apache.hive.service.cli.operation.GetFunctionsOperation;
import org.apache.hive.service.cli.operation.GetSchemasOperation;
import org.apache.hive.service.cli.operation.GetTableTypesOperation;
import org.apache.hive.service.cli.operation.GetTypeInfoOperation;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.SessionManager;

public class HiveSessionImpl
implements HiveSession {
    private final SessionHandle sessionHandle = new SessionHandle();
    private String username;
    private final String password;
    private final Map<String, String> sessionConf = new HashMap<String, String>();
    private final HiveConf hiveConf = new HiveConf();
    private final SessionState sessionState;
    private static final String FETCH_WORK_SERDE_CLASS = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
    private SessionManager sessionManager;
    private OperationManager operationManager;
    private IMetaStoreClient metastoreClient = null;
    private String ipAddress;

    public HiveSessionImpl(String username, String password, Map<String, String> sessionConf, String ipAddress) {
        this.username = username;
        this.password = password;
        this.ipAddress = ipAddress;
        if (sessionConf != null) {
            for (Map.Entry<String, String> entry : sessionConf.entrySet()) {
                this.hiveConf.set(entry.getKey(), entry.getValue());
            }
        }
        this.sessionState = new SessionState(this.hiveConf);
    }

    private SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    private OperationManager getOperationManager() {
        return this.operationManager;
    }

    @Override
    public void setOperationManager(OperationManager operationManager) {
        this.operationManager = operationManager;
    }

    protected synchronized void acquire() throws HiveSQLException {
        SessionState.start((SessionState)this.sessionState);
    }

    protected synchronized void release() {
        assert (this.sessionState != null);
    }

    @Override
    public SessionHandle getSessionHandle() {
        return this.sessionHandle;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public HiveConf getHiveConf() {
        this.hiveConf.setVar(HiveConf.ConfVars.HIVEFETCHOUTPUTSERDE, FETCH_WORK_SERDE_CLASS);
        return this.hiveConf;
    }

    @Override
    public IMetaStoreClient getMetaStoreClient() throws HiveSQLException {
        if (this.metastoreClient == null) {
            try {
                this.metastoreClient = new HiveMetaStoreClient(this.getHiveConf());
            }
            catch (MetaException e) {
                throw new HiveSQLException(e);
            }
        }
        return this.metastoreClient;
    }

    @Override
    public GetInfoValue getInfo(GetInfoType getInfoType) throws HiveSQLException {
        this.acquire();
        try {
            switch (getInfoType) {
                case CLI_SERVER_NAME: {
                    GetInfoValue getInfoValue = new GetInfoValue("Hive");
                    return getInfoValue;
                }
                case CLI_DBMS_NAME: {
                    GetInfoValue getInfoValue = new GetInfoValue("Apache Hive");
                    return getInfoValue;
                }
                case CLI_DBMS_VER: {
                    GetInfoValue getInfoValue = new GetInfoValue("0.10.0");
                    return getInfoValue;
                }
                case CLI_MAX_COLUMN_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
                case CLI_MAX_SCHEMA_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
                case CLI_MAX_TABLE_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
            }
            throw new HiveSQLException("Unrecognized GetInfoType value: " + getInfoType.toString());
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationHandle executeStatement(String statement, Map<String, String> confOverlay) throws HiveSQLException {
        this.acquire();
        try {
            ExecuteStatementOperation operation = this.getOperationManager().newExecuteStatementOperation(this.getSession(), statement, confOverlay);
            operation.run();
            OperationHandle operationHandle = operation.getHandle();
            return operationHandle;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationHandle getTypeInfo() throws HiveSQLException {
        this.acquire();
        try {
            GetTypeInfoOperation operation = this.getOperationManager().newGetTypeInfoOperation(this.getSession());
            operation.run();
            OperationHandle operationHandle = operation.getHandle();
            return operationHandle;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationHandle getCatalogs() throws HiveSQLException {
        this.acquire();
        try {
            GetCatalogsOperation operation = this.getOperationManager().newGetCatalogsOperation(this.getSession());
            operation.run();
            OperationHandle operationHandle = operation.getHandle();
            return operationHandle;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationHandle getSchemas(String catalogName, String schemaName) throws HiveSQLException {
        this.acquire();
        try {
            GetSchemasOperation operation = this.getOperationManager().newGetSchemasOperation(this.getSession(), catalogName, schemaName);
            operation.run();
            OperationHandle operationHandle = operation.getHandle();
            return operationHandle;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationHandle getTables(String catalogName, String schemaName, String tableName, List<String> tableTypes) throws HiveSQLException {
        this.acquire();
        try {
            MetadataOperation operation = this.getOperationManager().newGetTablesOperation(this.getSession(), catalogName, schemaName, tableName, tableTypes);
            operation.run();
            OperationHandle operationHandle = operation.getHandle();
            return operationHandle;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationHandle getTableTypes() throws HiveSQLException {
        this.acquire();
        try {
            GetTableTypesOperation operation = this.getOperationManager().newGetTableTypesOperation(this.getSession());
            operation.run();
            OperationHandle operationHandle = operation.getHandle();
            return operationHandle;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationHandle getColumns(String catalogName, String schemaName, String tableName, String columnName) throws HiveSQLException {
        this.acquire();
        try {
            GetColumnsOperation operation = this.getOperationManager().newGetColumnsOperation(this.getSession(), catalogName, schemaName, tableName, columnName);
            operation.run();
            OperationHandle operationHandle = operation.getHandle();
            return operationHandle;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationHandle getFunctions(String catalogName, String schemaName, String functionName) throws HiveSQLException {
        this.acquire();
        try {
            GetFunctionsOperation operation = this.getOperationManager().newGetFunctionsOperation(this.getSession(), catalogName, schemaName, functionName);
            operation.run();
            OperationHandle operationHandle = operation.getHandle();
            return operationHandle;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HiveSQLException {
        try {
            this.acquire();
            if (this.metastoreClient != null) {
                this.metastoreClient.close();
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    public SessionState getSessionState() {
        return this.sessionState;
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public String setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this.ipAddress;
    }

    @Override
    public String getUserName() {
        return this.username;
    }

    @Override
    public void setUserName(String userName) {
        this.username = userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelOperation(OperationHandle opHandle) throws HiveSQLException {
        this.acquire();
        try {
            this.sessionManager.getOperationManager().cancelOperation(opHandle);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeOperation(OperationHandle opHandle) throws HiveSQLException {
        this.acquire();
        try {
            this.sessionManager.getOperationManager().closeOperation(opHandle);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableSchema getResultSetMetadata(OperationHandle opHandle) throws HiveSQLException {
        this.acquire();
        try {
            TableSchema tableSchema = this.sessionManager.getOperationManager().getOperationResultSetSchema(opHandle);
            return tableSchema;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowSet fetchResults(OperationHandle opHandle, FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.acquire();
        try {
            RowSet rowSet = this.sessionManager.getOperationManager().getOperationNextRowSet(opHandle, orientation, maxRows);
            return rowSet;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowSet fetchResults(OperationHandle opHandle) throws HiveSQLException {
        this.acquire();
        try {
            RowSet rowSet = this.sessionManager.getOperationManager().getOperationNextRowSet(opHandle);
            return rowSet;
        }
        finally {
            this.release();
        }
    }

    protected HiveSession getSession() {
        return this;
    }
}

