/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.HiveSessionImpl;
import org.apache.hive.service.cli.session.HiveSessionImplwithUGI;
import org.apache.hive.service.cli.session.HiveSessionProxy;

public class SessionManager
extends CompositeService {
    private HiveConf hiveConf;
    private final Map<SessionHandle, HiveSession> handleToSession = new HashMap<SessionHandle, HiveSession>();
    private OperationManager operationManager = new OperationManager();
    private static final Object sessionMapLock = new Object();
    private static ThreadLocal<String> threadLocalIpAddress = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };
    private static ThreadLocal<String> threadLocalUserName = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };

    public SessionManager() {
        super("SessionManager");
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        this.operationManager = new OperationManager();
        this.addService(this.operationManager);
        super.init(hiveConf);
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionHandle openSession(String username, String password, Map<String, String> sessionConf, boolean withImpersonation, String delegationToken) throws HiveSQLException {
        HiveSession session;
        if (username == null) {
            username = threadLocalUserName.get();
        }
        if (withImpersonation) {
            HiveSessionImplwithUGI hiveSessionUgi = new HiveSessionImplwithUGI(username, password, sessionConf, threadLocalIpAddress.get(), delegationToken);
            session = HiveSessionProxy.getProxy(hiveSessionUgi, hiveSessionUgi.getSessionUgi());
            hiveSessionUgi.setProxySession(session);
        } else {
            session = new HiveSessionImpl(username, password, sessionConf, threadLocalIpAddress.get());
        }
        session.setSessionManager(this);
        session.setOperationManager(this.operationManager);
        Object object = sessionMapLock;
        synchronized (object) {
            this.handleToSession.put(session.getSessionHandle(), session);
        }
        return session.getSessionHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(SessionHandle sessionHandle) throws HiveSQLException {
        HiveSession session;
        Object object = sessionMapLock;
        synchronized (object) {
            session = this.handleToSession.remove(sessionHandle);
        }
        if (session == null) {
            throw new HiveSQLException("Session does not exist!");
        }
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiveSession getSession(SessionHandle sessionHandle) throws HiveSQLException {
        HiveSession session;
        Object object = sessionMapLock;
        synchronized (object) {
            session = this.handleToSession.get(sessionHandle);
        }
        if (session == null) {
            throw new HiveSQLException("Invalid SessionHandle: " + sessionHandle);
        }
        return session;
    }

    public OperationManager getOperationManager() {
        return this.operationManager;
    }

    public static void setIpAddress(String ipAddress) {
        threadLocalIpAddress.set(ipAddress);
    }

    private void clearIpAddress() {
        threadLocalIpAddress.remove();
    }

    public static void setUserName(String userName) {
        threadLocalUserName.set(userName);
    }

    private void clearUserName() {
        threadLocalUserName.remove();
    }

    public void clearThreadLocals() {
        this.clearIpAddress();
        this.clearUserName();
    }
}

