/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;

public class HiveServer2
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(HiveServer2.class);
    private static CompositeService.CompositeServiceShutdownHook serverShutdownHook;
    public static final int SHUTDOWN_HOOK_PRIORITY = 100;
    private CLIService cliService;
    private ThriftCLIService thriftCLIService;

    public HiveServer2() {
        super("HiveServer2");
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.cliService = new CLIService();
        this.addService(this.cliService);
        this.thriftCLIService = new ThriftCLIService(this.cliService);
        this.addService(this.thriftCLIService);
        super.init(hiveConf);
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
    }

    public static void main(String[] args) {
        try {
            LogUtils.initHiveLog4j();
        }
        catch (LogUtils.LogInitializationException e) {
            LOG.warn((Object)e.getMessage());
        }
        HiveStringUtils.startupShutdownMessage(HiveServer2.class, (String[])args, (Log)LOG);
        try {
            HiveConf hiveConf = new HiveConf();
            HiveServer2 server = new HiveServer2();
            server.init(hiveConf);
            server.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting HiveServer2", t);
            System.exit(-1);
        }
    }
}

