/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.ActiveStatusEvent;
import com.ibm.as400.resource.ActiveStatusListener;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceLevel;
import com.ibm.as400.resource.ResourceListEnumeration;
import com.ibm.as400.resource.ResourceListEvent;
import com.ibm.as400.resource.ResourceListListener;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ResourceList
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private ResourceMetaDataTable attributes_;
    private String currentLevel_ = null;
    private int defaultBidiStringType_ = -1;
    private Presentation presentation_;
    private ResourceMetaDataTable selections_;
    private Hashtable selectionValues_ = new Hashtable();
    private ResourceMetaDataTable sorts_;
    private Hashtable sortOrders_ = new Hashtable();
    private Object[] sortValue_ = new Object[0];
    private AS400 system_ = null;
    private transient boolean complete_ = false;
    private transient boolean connectionEstablished_ = false;
    private transient boolean inError_ = false;
    private transient long length_ = -1L;
    private transient boolean open_ = false;
    private transient boolean propertiesFrozen_ = false;
    private transient Vector activeStatusListeners_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient Vector resourceListListeners_;
    private transient VetoableChangeSupport vetoableChangeSupport_;

    public ResourceList() {
        this.presentation_ = new Presentation();
        this.attributes_ = new ResourceMetaDataTable();
        this.selections_ = new ResourceMetaDataTable();
        this.sorts_ = new ResourceMetaDataTable();
        this.initializeTransient();
    }

    public ResourceList(Presentation presentation, ResourceMetaData[] resourceMetaDataArray, ResourceMetaData[] resourceMetaDataArray2, ResourceMetaData[] resourceMetaDataArray3) {
        if (presentation == null) {
            throw new NullPointerException("presentation");
        }
        this.presentation_ = presentation;
        this.attributes_ = new ResourceMetaDataTable(resourceMetaDataArray);
        this.selections_ = new ResourceMetaDataTable(resourceMetaDataArray2);
        this.sorts_ = new ResourceMetaDataTable(resourceMetaDataArray3);
        this.initializeTransient();
    }

    ResourceList(Presentation presentation, ResourceMetaDataTable resourceMetaDataTable, ResourceMetaDataTable resourceMetaDataTable2, ResourceMetaDataTable resourceMetaDataTable3) {
        if (presentation == null) {
            throw new NullPointerException("presentation");
        }
        this.presentation_ = presentation;
        this.attributes_ = resourceMetaDataTable == null ? new ResourceMetaDataTable() : resourceMetaDataTable;
        this.selections_ = resourceMetaDataTable2 == null ? new ResourceMetaDataTable() : resourceMetaDataTable2;
        this.sorts_ = resourceMetaDataTable3 == null ? new ResourceMetaDataTable() : resourceMetaDataTable3;
        this.initializeTransient();
    }

    public void addActiveStatusListener(ActiveStatusListener activeStatusListener) {
        if (activeStatusListener == null) {
            throw new NullPointerException("listener");
        }
        this.activeStatusListeners_.addElement(activeStatusListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addResourceListListener(ResourceListListener resourceListListener) {
        if (resourceListListener == null) {
            throw new NullPointerException("listener");
        }
        this.resourceListListeners_.addElement(resourceListListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    protected boolean arePropertiesFrozen() {
        return this.propertiesFrozen_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws ResourceException {
        if (this.open_) {
            ResourceList resourceList = this;
            synchronized (resourceList) {
                this.complete_ = false;
                this.length_ = -1L;
                this.open_ = false;
                this.inError_ = false;
            }
            this.fireListClosed();
        }
    }

    protected void establishConnection() throws ResourceException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Establishing a connection for " + this + ".");
        }
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (!this.propertiesFrozen_) {
            this.freezeProperties();
        }
        this.connectionEstablished_ = true;
    }

    protected void fireBusy() {
        ActiveStatusEvent activeStatusEvent = new ActiveStatusEvent(this, 1);
        Vector vector = (Vector)this.activeStatusListeners_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ActiveStatusListener)enumeration.nextElement()).busy(activeStatusEvent);
        }
    }

    protected void fireIdle() {
        ActiveStatusEvent activeStatusEvent = new ActiveStatusEvent(this, 2);
        Vector vector = (Vector)this.activeStatusListeners_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ActiveStatusListener)enumeration.nextElement()).idle(activeStatusEvent);
        }
    }

    protected void fireLengthChanged(long l) {
        this.length_ = l;
        ResourceListEvent resourceListEvent = new ResourceListEvent(this, 1, l);
        Vector vector = (Vector)this.resourceListListeners_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ResourceListListener)enumeration.nextElement()).lengthChanged(resourceListEvent);
        }
    }

    protected void fireListClosed() {
        ResourceListEvent resourceListEvent = new ResourceListEvent(this, 2);
        Vector vector = (Vector)this.resourceListListeners_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ResourceListListener)enumeration.nextElement()).listClosed(resourceListEvent);
        }
    }

    protected void fireListCompleted() {
        this.complete_ = true;
        ResourceListEvent resourceListEvent = new ResourceListEvent(this, 3);
        Vector vector = (Vector)this.resourceListListeners_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ResourceListListener)enumeration.nextElement()).listCompleted(resourceListEvent);
        }
    }

    protected void fireListInError() {
        this.inError_ = true;
        ResourceListEvent resourceListEvent = new ResourceListEvent(this, 4);
        Vector vector = (Vector)this.resourceListListeners_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ResourceListListener)enumeration.nextElement()).listInError(resourceListEvent);
        }
    }

    protected void fireListOpened() {
        ResourceListEvent resourceListEvent = new ResourceListEvent(this, 5);
        Vector vector = (Vector)this.resourceListListeners_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ResourceListListener)enumeration.nextElement()).listOpened(resourceListEvent);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport_.firePropertyChange(string, object, object2);
    }

    protected void fireResourceAdded(Resource resource, long l) {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Resource " + resource + " (index=" + l + ") loaded by list " + this + ".");
        }
        ResourceListEvent resourceListEvent = new ResourceListEvent(this, 6, resource, l);
        Vector vector = (Vector)this.resourceListListeners_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ResourceListListener)enumeration.nextElement()).resourceAdded(resourceListEvent);
        }
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        this.vetoableChangeSupport_.fireVetoableChange(string, object, object2);
    }

    protected void freezeProperties() throws ResourceException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Freezing properties for " + this + ".");
        }
        this.propertiesFrozen_ = true;
    }

    public ResourceMetaData getAttributeMetaData(Object object) {
        return this.attributes_.getMetaData(object);
    }

    public ResourceMetaData[] getAttributeMetaData() {
        return this.attributes_.getMetaData(this.getCurrentLevel());
    }

    String getCurrentLevel() {
        if (this.system_ == null) {
            return "";
        }
        if (this.currentLevel_ != null) {
            return this.currentLevel_;
        }
        try {
            this.currentLevel_ = ResourceLevel.vrmToLevel(this.system_.getVRM());
        }
        catch (Exception exception) {
            return "";
        }
        return this.currentLevel_;
    }

    int getDefaultBidiStringType() {
        if (this.system_ == null) {
            return 0;
        }
        if (this.defaultBidiStringType_ == -1) {
            this.defaultBidiStringType_ = AS400BidiTransform.getStringType((char)this.system_.getCcsid());
        }
        return this.defaultBidiStringType_;
    }

    public long getListLength() throws ResourceException {
        if (!this.open_) {
            this.open();
        }
        return this.length_;
    }

    public Presentation getPresentation() {
        return this.presentation_;
    }

    public ResourceMetaData getSelectionMetaData(Object object) {
        return this.selections_.getMetaData(object);
    }

    public ResourceMetaData[] getSelectionMetaData() {
        return this.selections_.getMetaData(this.getCurrentLevel());
    }

    public Object getSelectionValue(Object object) throws ResourceException {
        if (this.isBidiEnabled()) {
            return this.getSelectionValue(object, this.getDefaultBidiStringType());
        }
        return this.getSelectionValueImplementation(object);
    }

    public Object getSelectionValue(Object object, int n) throws ResourceException {
        if (!this.isBidiEnabled()) {
            return this.getSelectionValue(object);
        }
        return this.getSelectionValueImplementation(object);
    }

    private Object getSelectionValueImplementation(Object object) throws ResourceException {
        this.selections_.validateID(object);
        Object object2 = this.selectionValues_.get(object);
        if (object2 == null) {
            object2 = this.selections_.getMetaData(object).getDefaultValue();
        }
        return object2;
    }

    public ResourceMetaData getSortMetaData(Object object) {
        return this.sorts_.getMetaData(object);
    }

    public ResourceMetaData[] getSortMetaData() {
        return this.sorts_.getMetaData(this.getCurrentLevel());
    }

    public boolean getSortOrder(Object object) throws ResourceException {
        this.sorts_.validateID(object);
        if (this.sortOrders_.containsKey(object)) {
            return (Boolean)this.sortOrders_.get(object);
        }
        return true;
    }

    public Object[] getSortValue() throws ResourceException {
        return this.sortValue_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    private void initializeTransient() {
        this.activeStatusListeners_ = new Vector();
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.resourceListListeners_ = new Vector();
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
    }

    protected boolean isBidiEnabled() {
        return false;
    }

    public boolean isComplete() {
        return this.complete_;
    }

    protected boolean isConnectionEstablished() {
        return this.connectionEstablished_;
    }

    public boolean isInError() {
        return this.inError_;
    }

    public boolean isOpen() {
        return this.open_;
    }

    public boolean isResourceAvailable(long l) throws ResourceException {
        if (l < 0L) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        return l < this.length_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws ResourceException {
        if (this.open_) {
            return;
        }
        ResourceList resourceList = this;
        synchronized (resourceList) {
            this.complete_ = false;
            this.inError_ = false;
            this.open_ = true;
            this.length_ = 0L;
            if (Trace.isTraceOn()) {
                Trace.log(3, "Opening list " + this + ".");
            }
            this.fireListOpened();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshContents() throws ResourceException {
        ResourceList resourceList = this;
        synchronized (resourceList) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "Refreshing list contents for " + this + ".");
            }
            if (!this.open_) {
                this.open();
            }
        }
    }

    public void refreshStatus() throws ResourceException {
        if (!this.open_) {
            this.open();
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "Refreshing status for list " + this + ".");
        }
    }

    public void removeActiveStatusListener(ActiveStatusListener activeStatusListener) {
        if (activeStatusListener == null) {
            throw new NullPointerException("listener");
        }
        this.activeStatusListeners_.removeElement(activeStatusListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeResourceListListener(ResourceListListener resourceListListener) {
        if (resourceListListener == null) {
            throw new NullPointerException("listener");
        }
        this.resourceListListeners_.removeElement(resourceListListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public Resource resourceAt(long l) throws ResourceException {
        if (!this.open_) {
            this.open();
        }
        if (l < 0L || this.complete_ && l >= this.length_) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        return null;
    }

    public Enumeration resources() throws ResourceException {
        return new ResourceListEnumeration(this);
    }

    protected void setAttributeMetaData(ResourceMetaData[] resourceMetaDataArray) {
        if (resourceMetaDataArray == null) {
            throw new NullPointerException("attributeMetaData");
        }
        this.attributes_ = new ResourceMetaDataTable(resourceMetaDataArray);
    }

    public void setSelectionValue(Object object, Object object2) throws ResourceException {
        if (this.isBidiEnabled()) {
            this.setSelectionValue(object, object2, this.getDefaultBidiStringType());
        } else {
            this.setSelectionValueImplementation(object, object2);
        }
    }

    public void setSelectionValue(Object object, Object object2, int n) throws ResourceException {
        if (!this.isBidiEnabled()) {
            this.setSelectionValue(object, object2);
        } else {
            this.setSelectionValueImplementation(object, object2);
        }
    }

    private void setSelectionValueImplementation(Object object, Object object2) throws ResourceException {
        ResourceMetaData resourceMetaData = this.selections_.validateID(object);
        if (object2 == null) {
            this.selectionValues_.remove(object);
        } else {
            this.selectionValues_.put(object, resourceMetaData.validateValue(object2));
        }
    }

    protected void setPresentation(Presentation presentation) {
        if (presentation == null) {
            throw new NullPointerException("presentation");
        }
        this.presentation_ = presentation;
    }

    public void setSortOrder(Object object, boolean bl) throws ResourceException {
        this.sorts_.validateID(object);
        this.sortOrders_.put(object, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setSortValue(Object[] objectArray) throws ResourceException {
        if (objectArray == null) {
            throw new NullPointerException("sortValue");
        }
        this.sorts_.validateIDs(objectArray);
        this.sortValue_ = objectArray;
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        AS400 aS4002 = this.system_;
        this.fireVetoableChange("system", aS4002, aS400);
        this.system_ = aS400;
        this.firePropertyChange("system", aS4002, aS400);
    }

    public String toString() {
        if (this.presentation_ == null) {
            return super.toString();
        }
        String string = this.presentation_.getFullName();
        if (string.length() > 0) {
            return string;
        }
        return super.toString();
    }

    public void waitForComplete() throws ResourceException {
        if (!this.open_) {
            this.open();
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "Waiting for the list to complete.");
        }
    }

    public void waitForResource(long l) throws ResourceException {
        if (l < 0L) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        if (!this.open_) {
            this.open();
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "Waiting for resource " + l + " to become available.");
        }
    }
}

