/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete;

import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.delete.index.IndexDeleteRequest;
import org.elasticsearch.action.delete.index.IndexDeleteResponse;
import org.elasticsearch.action.delete.index.ShardDeleteResponse;
import org.elasticsearch.action.delete.index.TransportIndexDeleteAction;
import org.elasticsearch.action.support.replication.TransportShardReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteAction
extends TransportShardReplicationOperationAction<DeleteRequest, DeleteResponse> {
    private final boolean autoCreateIndex;
    private final TransportCreateIndexAction createIndexAction;
    private final TransportIndexDeleteAction indexDeleteAction;

    @Inject
    public TransportDeleteAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, TransportCreateIndexAction createIndexAction, TransportIndexDeleteAction indexDeleteAction) {
        super(settings, transportService, clusterService, indicesService, threadPool, shardStateAction);
        this.createIndexAction = createIndexAction;
        this.indexDeleteAction = indexDeleteAction;
        this.autoCreateIndex = settings.getAsBoolean("action.auto_create_index", true);
    }

    @Override
    protected String executor() {
        return "index";
    }

    @Override
    protected void doExecute(final DeleteRequest deleteRequest, final ActionListener<DeleteResponse> listener) {
        if (this.autoCreateIndex && !this.clusterService.state().metaData().hasConcreteIndex(deleteRequest.index())) {
            this.createIndexAction.execute(new CreateIndexRequest(deleteRequest.index()), new ActionListener<CreateIndexResponse>(){

                @Override
                public void onResponse(CreateIndexResponse result) {
                    TransportDeleteAction.this.innerExecute(deleteRequest, listener);
                }

                @Override
                public void onFailure(Throwable e) {
                    if (ExceptionsHelper.unwrapCause(e) instanceof IndexAlreadyExistsException) {
                        TransportDeleteAction.this.innerExecute(deleteRequest, listener);
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            this.innerExecute(deleteRequest, listener);
        }
    }

    private void innerExecute(final DeleteRequest request, final ActionListener<DeleteResponse> listener) {
        MappingMetaData mappingMd;
        ClusterState clusterState = this.clusterService.state();
        request.index(clusterState.metaData().concreteIndex(request.index()));
        if (clusterState.metaData().hasIndex(request.index()) && (mappingMd = clusterState.metaData().index(request.index()).mapping(request.type())) != null && mappingMd.routing().required() && request.routing() == null) {
            this.indexDeleteAction.execute(new IndexDeleteRequest(request), new ActionListener<IndexDeleteResponse>(){

                @Override
                public void onResponse(IndexDeleteResponse indexDeleteResponse) {
                    long version = 0L;
                    boolean found = false;
                    for (ShardDeleteResponse deleteResponse : indexDeleteResponse.responses()) {
                        if (deleteResponse.notFound()) continue;
                        found = true;
                        version = deleteResponse.version();
                        break;
                    }
                    listener.onResponse(new DeleteResponse(request.index(), request.type(), request.id(), version, !found));
                }

                @Override
                public void onFailure(Throwable e) {
                    listener.onFailure(e);
                }
            });
            return;
        }
        super.doExecute(request, listener);
    }

    @Override
    protected boolean checkWriteConsistency() {
        return true;
    }

    @Override
    protected DeleteRequest newRequestInstance() {
        return new DeleteRequest();
    }

    @Override
    protected DeleteResponse newResponseInstance() {
        return new DeleteResponse();
    }

    @Override
    protected String transportAction() {
        return "indices/index/shard/delete";
    }

    @Override
    protected void checkBlock(DeleteRequest request, ClusterState state) {
        state.blocks().indexBlockedRaiseException(ClusterBlockLevel.WRITE, request.index());
    }

    @Override
    protected TransportShardReplicationOperationAction.PrimaryResponse<DeleteResponse> shardOperationOnPrimary(ClusterState clusterState, TransportShardReplicationOperationAction.ShardOperationRequest shardRequest) {
        DeleteRequest request = (DeleteRequest)shardRequest.request;
        IndexShard indexShard = this.indexShard(shardRequest);
        Engine.Delete delete = indexShard.prepareDelete(request.type(), request.id(), request.version()).versionType(request.versionType()).origin(Engine.Operation.Origin.PRIMARY);
        indexShard.delete(delete);
        request.version(delete.version());
        if (request.refresh()) {
            try {
                indexShard.refresh(new Engine.Refresh(false));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        DeleteResponse response = new DeleteResponse(request.index(), request.type(), request.id(), delete.version(), delete.notFound());
        return new TransportShardReplicationOperationAction.PrimaryResponse<DeleteResponse>(response, null);
    }

    @Override
    protected void shardOperationOnReplica(TransportShardReplicationOperationAction.ShardOperationRequest shardRequest) {
        DeleteRequest request = (DeleteRequest)shardRequest.request;
        IndexShard indexShard = this.indexShard(shardRequest);
        Engine.Delete delete = indexShard.prepareDelete(request.type(), request.id(), request.version()).origin(Engine.Operation.Origin.REPLICA);
        indexShard.delete(delete);
        if (request.refresh()) {
            try {
                indexShard.refresh(new Engine.Refresh(false));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, DeleteRequest request) {
        return this.clusterService.operationRouting().deleteShards(this.clusterService.state(), request.index(), request.type(), request.id(), request.routing());
    }
}

