/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.trove.impl.hash;

import java.util.Arrays;
import org.elasticsearch.common.trove.impl.Constants;
import org.elasticsearch.common.trove.impl.HashFunctions;
import org.elasticsearch.common.trove.impl.hash.TPrimitiveHash;
import org.elasticsearch.common.trove.procedure.TDoubleProcedure;

public abstract class TDoubleHash
extends TPrimitiveHash {
    static final long serialVersionUID = 1L;
    public transient double[] _set;
    protected double no_entry_value;

    public TDoubleHash() {
        this.no_entry_value = Constants.DEFAULT_DOUBLE_NO_ENTRY_VALUE;
        if (this.no_entry_value != 0.0) {
            Arrays.fill(this._set, this.no_entry_value);
        }
    }

    public TDoubleHash(int initialCapacity) {
        super(initialCapacity);
        this.no_entry_value = Constants.DEFAULT_DOUBLE_NO_ENTRY_VALUE;
        if (this.no_entry_value != 0.0) {
            Arrays.fill(this._set, this.no_entry_value);
        }
    }

    public TDoubleHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.no_entry_value = Constants.DEFAULT_DOUBLE_NO_ENTRY_VALUE;
        if (this.no_entry_value != 0.0) {
            Arrays.fill(this._set, this.no_entry_value);
        }
    }

    public TDoubleHash(int initialCapacity, float loadFactor, double no_entry_value) {
        super(initialCapacity, loadFactor);
        this.no_entry_value = no_entry_value;
        if (no_entry_value != 0.0) {
            Arrays.fill(this._set, no_entry_value);
        }
    }

    public double getNoEntryValue() {
        return this.no_entry_value;
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new double[capacity];
        return capacity;
    }

    public boolean contains(double val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TDoubleProcedure procedure) {
        byte[] states = this._states;
        double[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    protected void removeAt(int index) {
        this._set[index] = this.no_entry_value;
        super.removeAt(index);
    }

    protected int index(double val) {
        byte[] states = this._states;
        double[] set = this._set;
        int length = states.length;
        int hash = HashFunctions.hash(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] != 0 && (states[index] == 2 || set[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] != 0 && (states[index] == 2 || set[index] != val));
        }
        return states[index] == 0 ? -1 : index;
    }

    protected int insertionIndex(double val) {
        byte[] states = this._states;
        double[] set = this._set;
        int length = states.length;
        int hash = HashFunctions.hash(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1 && set[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (states[index] != 2) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] == 1 && set[index] != val);
        }
        if (states[index] == 2) {
            int firstRemoved = index;
            while (states[index] != 0 && (states[index] == 2 || set[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
            return states[index] == 1 ? -index - 1 : firstRemoved;
        }
        return states[index] == 1 ? -index - 1 : index;
    }
}

