/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.floats;

import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.support.NumericFieldDataComparator;

public class FloatFieldDataComparator
extends NumericFieldDataComparator {
    private final float[] values;
    private float bottom;

    public FloatFieldDataComparator(int numHits, String fieldName, FieldDataCache fieldDataCache) {
        super(fieldName, fieldDataCache);
        this.values = new float[numHits];
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.FLOAT;
    }

    public int compare(int slot1, int slot2) {
        float v1 = this.values[slot1];
        float v2 = this.values[slot2];
        if (v1 > v2) {
            return 1;
        }
        if (v1 < v2) {
            return -1;
        }
        return 0;
    }

    public int compareBottom(int doc) {
        float v2 = this.currentFieldData.floatValue(doc);
        if (this.bottom > v2) {
            return 1;
        }
        if (this.bottom < v2) {
            return -1;
        }
        return 0;
    }

    public void copy(int slot, int doc) {
        this.values[slot] = this.currentFieldData.floatValue(doc);
    }

    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public Comparable value(int slot) {
        return Float.valueOf(this.values[slot]);
    }
}

