/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.policy;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.merge.policy.EnableMergePolicy;
import org.elasticsearch.index.merge.policy.MergePolicyProvider;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.store.Store;

public class LogByteSizeMergePolicyProvider
extends AbstractIndexShardComponent
implements MergePolicyProvider<LogByteSizeMergePolicy> {
    private final IndexSettingsService indexSettingsService;
    private volatile boolean compoundFormat;
    private volatile ByteSizeValue minMergeSize;
    private volatile ByteSizeValue maxMergeSize;
    private volatile int mergeFactor;
    private volatile int maxMergeDocs;
    private final boolean calibrateSizeByDeletes;
    private boolean asyncMerge;
    private final Set<CustomLogByteSizeMergePolicy> policies = new CopyOnWriteArraySet<CustomLogByteSizeMergePolicy>();
    private final ApplySettings applySettings = new ApplySettings();

    @Inject
    public LogByteSizeMergePolicyProvider(Store store, IndexSettingsService indexSettingsService) {
        super(store.shardId(), store.indexSettings());
        Preconditions.checkNotNull(store, "Store must be provided to merge policy");
        this.indexSettingsService = indexSettingsService;
        this.compoundFormat = this.indexSettings.getAsBoolean("index.compound_format", store.suggestUseCompoundFile());
        this.minMergeSize = this.componentSettings.getAsBytesSize("min_merge_size", new ByteSizeValue(0x199999L, ByteSizeUnit.BYTES));
        this.maxMergeSize = this.componentSettings.getAsBytesSize("max_merge_size", new ByteSizeValue(2048L, ByteSizeUnit.MB));
        this.mergeFactor = this.componentSettings.getAsInt("merge_factor", 10);
        this.maxMergeDocs = this.componentSettings.getAsInt("max_merge_docs", Integer.MAX_VALUE);
        this.calibrateSizeByDeletes = this.componentSettings.getAsBoolean("calibrate_size_by_deletes", true);
        this.asyncMerge = this.indexSettings.getAsBoolean("index.merge.async", true);
        this.logger.debug("using [log_bytes_size] merge policy with merge_factor[{}], min_merge_size[{}], max_merge_size[{}], max_merge_docs[{}], calibrate_size_by_deletes[{}], async_merge[{}]", this.mergeFactor, this.minMergeSize, this.maxMergeSize, this.maxMergeDocs, this.calibrateSizeByDeletes, this.asyncMerge);
        indexSettingsService.addListener(this.applySettings);
    }

    @Override
    public LogByteSizeMergePolicy newMergePolicy() {
        CustomLogByteSizeMergePolicy mergePolicy = this.asyncMerge ? new CustomLogByteSizeMergePolicy(this) : new CustomLogByteSizeMergePolicy(this);
        mergePolicy.setMinMergeMB(this.minMergeSize.mbFrac());
        mergePolicy.setMaxMergeMB(this.maxMergeSize.mbFrac());
        mergePolicy.setMergeFactor(this.mergeFactor);
        mergePolicy.setMaxMergeDocs(this.maxMergeDocs);
        mergePolicy.setCalibrateSizeByDeletes(this.calibrateSizeByDeletes);
        mergePolicy.setUseCompoundFile(this.compoundFormat);
        this.policies.add(mergePolicy);
        return mergePolicy;
    }

    @Override
    public void close(boolean delete) throws ElasticSearchException {
        this.indexSettingsService.removeListener(this.applySettings);
    }

    public static class EnableMergeLogByteSizeMergePolicy
    extends CustomLogByteSizeMergePolicy
    implements EnableMergePolicy {
        private final ThreadLocal<Boolean> enableMerge = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };

        public EnableMergeLogByteSizeMergePolicy(LogByteSizeMergePolicyProvider provider) {
            super(provider);
        }

        @Override
        public void enableMerge() {
            this.enableMerge.set(Boolean.TRUE);
        }

        @Override
        public void disableMerge() {
            this.enableMerge.set(Boolean.FALSE);
        }

        @Override
        public boolean isMergeEnabled() {
            return this.enableMerge.get() == Boolean.TRUE;
        }

        @Override
        public void close() {
            this.enableMerge.remove();
            super.close();
        }

        public MergePolicy.MergeSpecification findMerges(SegmentInfos infos) throws IOException {
            if (this.enableMerge.get() == Boolean.FALSE) {
                return null;
            }
            return super.findMerges(infos);
        }

        public MergePolicy.MergeSpecification findMergesToExpungeDeletes(SegmentInfos segmentInfos) throws CorruptIndexException, IOException {
            if (this.enableMerge.get() == Boolean.FALSE) {
                return null;
            }
            return super.findMergesToExpungeDeletes(segmentInfos);
        }

        public MergePolicy.MergeSpecification findMergesForOptimize(SegmentInfos infos, int maxNumSegments, Set<SegmentInfo> segmentsToOptimize) throws IOException {
            if (this.enableMerge.get() == Boolean.FALSE) {
                return null;
            }
            return super.findMergesForOptimize(infos, maxNumSegments, segmentsToOptimize);
        }
    }

    public static class CustomLogByteSizeMergePolicy
    extends LogByteSizeMergePolicy {
        private final LogByteSizeMergePolicyProvider provider;

        public CustomLogByteSizeMergePolicy(LogByteSizeMergePolicyProvider provider) {
            this.provider = provider;
        }

        public void close() {
            super.close();
            this.provider.policies.remove((Object)this);
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            boolean compoundFormat;
            int mergeFactor;
            int maxMergeDocs;
            ByteSizeValue maxMergeSize;
            ByteSizeValue minMergeSize = settings.getAsBytesSize("index.merge.policy.min_merge_size", LogByteSizeMergePolicyProvider.this.minMergeSize);
            if (!minMergeSize.equals(LogByteSizeMergePolicyProvider.this.minMergeSize)) {
                LogByteSizeMergePolicyProvider.this.logger.info("updating min_merge_size from [{}] to [{}]", LogByteSizeMergePolicyProvider.this.minMergeSize, minMergeSize);
                LogByteSizeMergePolicyProvider.this.minMergeSize = minMergeSize;
                for (CustomLogByteSizeMergePolicy policy : LogByteSizeMergePolicyProvider.this.policies) {
                    policy.setMinMergeMB(minMergeSize.mbFrac());
                }
            }
            if (!(maxMergeSize = settings.getAsBytesSize("index.merge.policy.max_merge_size", LogByteSizeMergePolicyProvider.this.maxMergeSize)).equals(LogByteSizeMergePolicyProvider.this.maxMergeSize)) {
                LogByteSizeMergePolicyProvider.this.logger.info("updating max_merge_size from [{}] to [{}]", LogByteSizeMergePolicyProvider.this.maxMergeSize, maxMergeSize);
                LogByteSizeMergePolicyProvider.this.maxMergeSize = maxMergeSize;
                for (CustomLogByteSizeMergePolicy policy : LogByteSizeMergePolicyProvider.this.policies) {
                    policy.setMaxMergeMB(maxMergeSize.mbFrac());
                }
            }
            if ((maxMergeDocs = settings.getAsInt("index.merge.policy.max_merge_docs", LogByteSizeMergePolicyProvider.this.maxMergeDocs).intValue()) != LogByteSizeMergePolicyProvider.this.maxMergeDocs) {
                LogByteSizeMergePolicyProvider.this.logger.info("updating max_merge_docs from [{}] to [{}]", LogByteSizeMergePolicyProvider.this.maxMergeDocs, maxMergeDocs);
                LogByteSizeMergePolicyProvider.this.maxMergeDocs = maxMergeDocs;
                for (CustomLogByteSizeMergePolicy policy : LogByteSizeMergePolicyProvider.this.policies) {
                    policy.setMaxMergeDocs(maxMergeDocs);
                }
            }
            if ((mergeFactor = settings.getAsInt("index.merge.policy.merge_factor", LogByteSizeMergePolicyProvider.this.mergeFactor).intValue()) != LogByteSizeMergePolicyProvider.this.mergeFactor) {
                LogByteSizeMergePolicyProvider.this.logger.info("updating merge_factor from [{}] to [{}]", LogByteSizeMergePolicyProvider.this.mergeFactor, mergeFactor);
                LogByteSizeMergePolicyProvider.this.mergeFactor = mergeFactor;
                for (CustomLogByteSizeMergePolicy policy : LogByteSizeMergePolicyProvider.this.policies) {
                    policy.setMergeFactor(mergeFactor);
                }
            }
            if ((compoundFormat = settings.getAsBoolean("index.compound_format", LogByteSizeMergePolicyProvider.this.compoundFormat).booleanValue()) != LogByteSizeMergePolicyProvider.this.compoundFormat) {
                LogByteSizeMergePolicyProvider.this.logger.info("updating index.compound_format from [{}] to [{}]", LogByteSizeMergePolicyProvider.this.compoundFormat, compoundFormat);
                LogByteSizeMergePolicyProvider.this.compoundFormat = compoundFormat;
                for (CustomLogByteSizeMergePolicy policy : LogByteSizeMergePolicyProvider.this.policies) {
                    policy.setUseCompoundFile(compoundFormat);
                }
            }
        }
    }
}

