/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.BaseQueryBuilder;
import org.elasticsearch.index.query.xcontent.XContentSpanQueryBuilder;

public class FieldMaskingSpanQueryBuilder
extends BaseQueryBuilder
implements XContentSpanQueryBuilder {
    private final XContentSpanQueryBuilder queryBuilder;
    private final String field;
    private float boost = -1.0f;

    public FieldMaskingSpanQueryBuilder(XContentSpanQueryBuilder queryBuilder, String field) {
        this.queryBuilder = queryBuilder;
        this.field = field;
    }

    public FieldMaskingSpanQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("field_masking_span");
        builder.field("query");
        this.queryBuilder.toXContent(builder, params);
        builder.field("field", this.field);
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

