/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard.recovery;

import java.io.IOException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.index.shard.ShardId;

class RecoveryFileChunkRequest
implements Streamable {
    private ShardId shardId;
    private String name;
    private long position;
    private long length;
    private String checksum;
    private byte[] content;
    private int contentLength;

    RecoveryFileChunkRequest() {
    }

    RecoveryFileChunkRequest(ShardId shardId, String name, long position, long length, String checksum, byte[] content, int contentLength) {
        this.shardId = shardId;
        this.name = name;
        this.position = position;
        this.length = length;
        this.checksum = checksum;
        this.content = content;
        this.contentLength = contentLength;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public String name() {
        return this.name;
    }

    public long position() {
        return this.position;
    }

    @Nullable
    public String checksum() {
        return this.checksum;
    }

    public long length() {
        return this.length;
    }

    public byte[] content() {
        return this.content;
    }

    public int contentLength() {
        return this.contentLength;
    }

    public RecoveryFileChunkRequest readFileChunk(StreamInput in) throws IOException {
        RecoveryFileChunkRequest request = new RecoveryFileChunkRequest();
        request.readFrom(in);
        return request;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.shardId = ShardId.readShardId(in);
        this.name = in.readUTF();
        this.position = in.readVLong();
        this.length = in.readVLong();
        if (in.readBoolean()) {
            this.checksum = in.readUTF();
        }
        this.contentLength = in.readVInt();
        this.content = new byte[this.contentLength];
        in.readFully(this.content);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeUTF(this.name);
        out.writeVLong(this.position);
        out.writeVLong(this.length);
        if (this.checksum == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.checksum);
        }
        out.writeVInt(this.contentLength);
        out.writeBytes(this.content, 0, this.contentLength);
    }

    public String toString() {
        return this.shardId + ": name='" + this.name + '\'' + ", position=" + this.position + ", length=" + this.length;
    }
}

