/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import java.util.Map;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Scopes;
import org.elasticsearch.common.inject.assistedinject.FactoryProvider;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.similarity.SimilarityProviderFactory;
import org.elasticsearch.index.similarity.SimilarityService;

public class SimilarityModule
extends AbstractModule {
    private final Settings settings;

    public SimilarityModule(Settings settings) {
        this.settings = settings;
    }

    @Override
    protected void configure() {
        MapBinder<String, SimilarityProviderFactory> similarityBinder = MapBinder.newMapBinder(this.binder(), String.class, SimilarityProviderFactory.class);
        Map<String, Settings> similarityProvidersSettings = this.settings.getGroups("index.similarity");
        for (Map.Entry<String, Settings> entry : similarityProvidersSettings.entrySet()) {
            String name = entry.getKey();
            Settings settings = entry.getValue();
            Class type = settings.getAsClass("type", null, "org.elasticsearch.index.similarity.", "SimilarityProvider");
            if (type == null) {
                throw new IllegalArgumentException("Similarity [" + name + "] must have a type associated with it");
            }
            similarityBinder.addBinding(name).toProvider(FactoryProvider.newFactory(SimilarityProviderFactory.class, type)).in(Scopes.SINGLETON);
        }
        this.bind(SimilarityService.class).in(Scopes.SINGLETON);
    }
}

