/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CFPropDefs;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;

public class AlterTableStatement
extends SchemaAlteringStatement {
    public final Type oType;
    public final CQL3Type validator;
    public final ColumnIdentifier columnName;
    private final CFPropDefs cfProps;
    private final Map<ColumnIdentifier, ColumnIdentifier> renames;

    public AlterTableStatement(CFName name, Type type, ColumnIdentifier columnName, CQL3Type validator, CFPropDefs cfProps, Map<ColumnIdentifier, ColumnIdentifier> renames) {
        super(name);
        this.oType = type;
        this.columnName = columnName;
        this.validator = validator;
        this.cfProps = cfProps;
        this.renames = renames;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.ALTER);
    }

    @Override
    public void announceMigration() throws RequestValidationException {
        CFMetaData meta = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        CFMetaData cfm = meta.clone();
        CFDefinition cfDef = meta.getCfDef();
        CFDefinition.Name name = this.columnName == null ? null : cfDef.get(this.columnName);
        switch (this.oType) {
            case ADD: {
                AbstractType<?> type;
                if (cfDef.isCompact) {
                    throw new InvalidRequestException("Cannot add new column to a compact CF");
                }
                if (name != null) {
                    switch (name.kind) {
                        case KEY_ALIAS: 
                        case COLUMN_ALIAS: {
                            throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with a PRIMARY KEY part", this.columnName));
                        }
                        case COLUMN_METADATA: {
                            throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with an existing column", this.columnName));
                        }
                    }
                }
                if ((type = this.validator.getType()) instanceof CollectionType) {
                    if (!cfDef.isComposite) {
                        throw new InvalidRequestException("Cannot use collection types with non-composite PRIMARY KEY");
                    }
                    HashMap<ByteBuffer, CollectionType> collections = cfDef.hasCollections ? new HashMap<ByteBuffer, CollectionType>(cfDef.getCollectionType().defined) : new HashMap();
                    collections.put(this.columnName.key, (CollectionType)type);
                    ColumnToCollectionType newColType = ColumnToCollectionType.getInstance(collections);
                    ArrayList ctypes = new ArrayList(((CompositeType)cfm.comparator).types);
                    if (cfDef.hasCollections) {
                        ctypes.set(ctypes.size() - 1, newColType);
                    } else {
                        ctypes.add(newColType);
                    }
                    cfm.comparator = CompositeType.getInstance(ctypes);
                }
                Integer componentIndex = cfDef.isComposite ? Integer.valueOf(((CompositeType)meta.comparator).types.size() - (cfDef.hasCollections ? 2 : 1)) : null;
                cfm.addColumnDefinition(new ColumnDefinition(this.columnName.key, type, null, null, null, componentIndex));
                break;
            }
            case ALTER: {
                if (name == null) {
                    throw new InvalidRequestException(String.format("Column %s was not found in table %s", this.columnName, this.columnFamily()));
                }
                switch (name.kind) {
                    case KEY_ALIAS: {
                        AbstractType<?> newType = this.validator.getType();
                        if (newType instanceof CounterColumnType) {
                            throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", this.columnName));
                        }
                        if (cfDef.hasCompositeKey) {
                            ArrayList newTypes = new ArrayList(((CompositeType)cfm.getKeyValidator()).types);
                            newTypes.set(name.position, newType);
                            cfm.keyValidator(CompositeType.getInstance(newTypes));
                            break;
                        }
                        cfm.keyValidator(newType);
                        break;
                    }
                    case COLUMN_ALIAS: {
                        assert (cfDef.isComposite);
                        ArrayList newTypes = new ArrayList(((CompositeType)cfm.comparator).types);
                        newTypes.set(name.position, this.validator.getType());
                        cfm.comparator = CompositeType.getInstance(newTypes);
                        break;
                    }
                    case VALUE_ALIAS: {
                        cfm.defaultValidator(this.validator.getType());
                        break;
                    }
                    case COLUMN_METADATA: {
                        ColumnDefinition column = cfm.getColumnDefinition(this.columnName.key);
                        column.setValidator(this.validator.getType());
                        cfm.addColumnDefinition(column);
                    }
                }
                break;
            }
            case DROP: {
                if (cfDef.isCompact) {
                    throw new InvalidRequestException("Cannot drop columns from a compact CF");
                }
                if (name == null) {
                    throw new InvalidRequestException(String.format("Column %s was not found in table %s", this.columnName, this.columnFamily()));
                }
                switch (name.kind) {
                    case KEY_ALIAS: 
                    case COLUMN_ALIAS: {
                        throw new InvalidRequestException(String.format("Cannot drop PRIMARY KEY part %s", this.columnName));
                    }
                    case COLUMN_METADATA: {
                        ColumnDefinition toDelete = null;
                        for (ColumnDefinition columnDef : cfm.getColumn_metadata().values()) {
                            if (!columnDef.name.equals(this.columnName.key)) continue;
                            toDelete = columnDef;
                        }
                        assert (toDelete != null);
                        cfm.removeColumnDefinition(toDelete);
                    }
                }
                break;
            }
            case OPTS: {
                if (this.cfProps == null) {
                    throw new InvalidRequestException(String.format("ALTER COLUMNFAMILY WITH invoked, but no parameters found", new Object[0]));
                }
                this.cfProps.validate();
                this.cfProps.applyToCFMetadata(cfm);
                break;
            }
            case RENAME: {
                for (Map.Entry<ColumnIdentifier, ColumnIdentifier> entry : this.renames.entrySet()) {
                    CFDefinition.Name from = cfDef.get(entry.getKey());
                    ColumnIdentifier to = entry.getValue();
                    if (from == null) {
                        throw new InvalidRequestException(String.format("Column %s was not found in table %s", entry.getKey(), this.columnFamily()));
                    }
                    CFDefinition.Name exists = cfDef.get(to);
                    if (exists != null) {
                        throw new InvalidRequestException(String.format("Cannot rename column %s in table %s to %s; another column of that name already exist", from, this.columnFamily(), to));
                    }
                    switch (from.kind) {
                        case KEY_ALIAS: {
                            cfm.keyAliases(AlterTableStatement.rename(from.position, to, cfm.getKeyAliases()));
                            break;
                        }
                        case COLUMN_ALIAS: {
                            cfm.columnAliases(AlterTableStatement.rename(from.position, to, cfm.getColumnAliases()));
                            break;
                        }
                        case VALUE_ALIAS: {
                            cfm.valueAlias(to.key);
                            break;
                        }
                        case COLUMN_METADATA: {
                            throw new InvalidRequestException(String.format("Cannot rename non PRIMARY KEY part %s", from));
                        }
                    }
                }
                break;
            }
        }
        MigrationManager.announceColumnFamilyUpdate(cfm);
    }

    private static List<ByteBuffer> rename(int pos, ColumnIdentifier newName, List<ByteBuffer> aliases) {
        if (pos < aliases.size()) {
            ArrayList<ByteBuffer> newList = new ArrayList<ByteBuffer>(aliases);
            newList.set(pos, newName.key);
            return newList;
        }
        ArrayList<ByteBuffer> newList = new ArrayList<ByteBuffer>(pos + 1);
        for (int i = 0; i < pos; ++i) {
            newList.add(i < aliases.size() ? aliases.get(i) : null);
        }
        newList.add(newName.key);
        return newList;
    }

    public String toString() {
        return String.format("AlterTableStatement(name=%s, type=%s, column=%s, validator=%s)", new Object[]{this.cfName, this.oType, this.columnName, this.validator});
    }

    @Override
    public ResultMessage.SchemaChange.Change changeType() {
        return ResultMessage.SchemaChange.Change.UPDATED;
    }

    public static enum Type {
        ADD,
        ALTER,
        DROP,
        OPTS,
        RENAME;

    }
}

