/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnCounter {
    protected int live;
    protected int ignored;

    public void count(IColumn column, IColumnContainer container) {
        if (!ColumnCounter.isLive(column, container)) {
            ++this.ignored;
        } else {
            ++this.live;
        }
    }

    protected static boolean isLive(IColumn column, IColumnContainer container) {
        return column.isLive() && !container.deletionInfo().isDeleted(column);
    }

    public int live() {
        return this.live;
    }

    public int ignored() {
        return this.ignored;
    }

    public static class GroupByPrefix
    extends ColumnCounter {
        private final CompositeType type;
        private final int toGroup;
        private ByteBuffer[] last;

        public GroupByPrefix(CompositeType type, int toGroup) {
            this.type = type;
            this.toGroup = toGroup;
            assert (toGroup == 0 || type != null);
        }

        @Override
        public void count(IColumn column, IColumnContainer container) {
            if (!GroupByPrefix.isLive(column, container)) {
                ++this.ignored;
                return;
            }
            if (this.toGroup == 0) {
                this.live = 1;
                return;
            }
            ByteBuffer[] current = this.type.split(column.name());
            assert (current.length >= this.toGroup);
            if (this.last != null) {
                boolean isSameGroup = true;
                for (int i = 0; i < this.toGroup; ++i) {
                    if (ByteBufferUtil.compareUnsigned(this.last[i], current[i]) == 0) continue;
                    isSameGroup = false;
                    break;
                }
                if (isSameGroup) {
                    return;
                }
            }
            ++this.live;
            this.last = current;
        }
    }
}

