/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(HiveConf conf, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(tree.getToken().getType()));
        switch (tree.getToken().getType()) {
            case 333: {
                return new ExplainSemanticAnalyzer(conf);
            }
            case 374: {
                return new LoadSemanticAnalyzer(conf);
            }
            case 335: {
                return new ExportSemanticAnalyzer(conf);
            }
            case 358: {
                return new ImportSemanticAnalyzer(conf);
            }
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 271: 
            case 273: 
            case 274: 
            case 278: 
            case 279: 
            case 280: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 301: 
            case 303: 
            case 305: 
            case 318: 
            case 319: 
            case 320: 
            case 326: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 344: 
            case 345: 
            case 376: 
            case 379: 
            case 426: 
            case 427: 
            case 437: 
            case 438: 
            case 439: 
            case 440: 
            case 441: 
            case 442: 
            case 443: 
            case 444: 
            case 445: 
            case 446: 
            case 447: 
            case 448: 
            case 461: 
            case 506: {
                return new DDLSemanticAnalyzer(conf);
            }
            case 277: {
                HiveOperation commandType = null;
                Integer type = ((ASTNode)tree.getChild(1)).getToken().getType();
                commandType = tree.getChild(0).getChildCount() > 1 ? tablePartitionCommandType.get(type)[1] : tablePartitionCommandType.get(type)[0];
                SemanticAnalyzerFactory.setSessionCommandType(commandType);
                return new DDLSemanticAnalyzer(conf);
            }
            case 302: 
            case 327: {
                return new FunctionSemanticAnalyzer(conf);
            }
            case 293: {
                return new ColumnStatsSemanticAnalyzer(conf, tree);
            }
        }
        return new SemanticAnalyzer(conf);
    }

    private static void setSessionCommandType(HiveOperation commandType) {
        if (SessionState.get() != null) {
            SessionState.get().setCommandType(commandType);
        }
    }

    private SemanticAnalyzerFactory() {
    }

    static {
        commandType.put(333, HiveOperation.EXPLAIN);
        commandType.put(374, HiveOperation.LOAD);
        commandType.put(335, HiveOperation.EXPORT);
        commandType.put(358, HiveOperation.IMPORT);
        commandType.put(301, HiveOperation.CREATEDATABASE);
        commandType.put(326, HiveOperation.DROPDATABASE);
        commandType.put(461, HiveOperation.SWITCHDATABASE);
        commandType.put(306, HiveOperation.CREATETABLE);
        commandType.put(330, HiveOperation.DROPTABLE);
        commandType.put(320, HiveOperation.DESCTABLE);
        commandType.put(319, HiveOperation.DESCFUNCTION);
        commandType.put(379, HiveOperation.MSCK);
        commandType.put(267, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(282, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(280, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(279, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(274, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(268, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(286, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(271, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(287, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(278, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(273, HiveOperation.ALTERTABLE_CLUSTER_SORT);
        commandType.put(438, HiveOperation.SHOWDATABASES);
        commandType.put(443, HiveOperation.SHOWTABLES);
        commandType.put(437, HiveOperation.SHOWCOLUMNS);
        commandType.put(447, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(448, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(444, HiveOperation.SHOW_CREATETABLE);
        commandType.put(439, HiveOperation.SHOWFUNCTIONS);
        commandType.put(440, HiveOperation.SHOWINDEXES);
        commandType.put(442, HiveOperation.SHOWPARTITIONS);
        commandType.put(441, HiveOperation.SHOWLOCKS);
        commandType.put(302, HiveOperation.CREATEFUNCTION);
        commandType.put(327, HiveOperation.DROPFUNCTION);
        commandType.put(307, HiveOperation.CREATEVIEW);
        commandType.put(331, HiveOperation.DROPVIEW);
        commandType.put(303, HiveOperation.CREATEINDEX);
        commandType.put(328, HiveOperation.DROPINDEX);
        commandType.put(266, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(265, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(291, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(289, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(290, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(421, HiveOperation.QUERY);
        commandType.put(376, HiveOperation.LOCKTABLE);
        commandType.put(506, HiveOperation.UNLOCKTABLE);
        commandType.put(305, HiveOperation.CREATEROLE);
        commandType.put(329, HiveOperation.DROPROLE);
        commandType.put(344, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(426, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(445, HiveOperation.SHOW_GRANT);
        commandType.put(345, HiveOperation.GRANT_ROLE);
        commandType.put(427, HiveOperation.REVOKE_ROLE);
        commandType.put(446, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(264, HiveOperation.ALTERDATABASE);
        commandType.put(318, HiveOperation.DESCDATABASE);
        commandType.put(285, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(293, HiveOperation.ANALYZE_TABLE);
        tablePartitionCommandType.put(270, new HiveOperation[]{HiveOperation.ALTERTABLE_PROTECTMODE, HiveOperation.ALTERPARTITION_PROTECTMODE});
        tablePartitionCommandType.put(275, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(276, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(269, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(284, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(283, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(281, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(288, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
    }
}

