/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.impl.ietl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.memory.MemoryResultSet;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.filterrows.FilterRowsMeta;
import org.pentaho.di.trans.steps.formula.FormulaMeta;
import org.pentaho.di.trans.steps.formula.FormulaMetaFunction;
import org.pentaho.di.trans.steps.groupby.GroupByMeta;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesMeta;
import org.pentaho.di.trans.steps.sort.SortRowsMeta;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.InlineEtlPhysicalColumn;
import org.pentaho.metadata.model.InlineEtlPhysicalModel;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.query.BaseMetadataQueryExec;
import org.pentaho.metadata.query.model.CombinationType;
import org.pentaho.metadata.query.model.Constraint;
import org.pentaho.metadata.query.model.Order;
import org.pentaho.metadata.query.model.Parameter;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.query.model.Selection;
import org.pentaho.metadata.query.model.util.QueryModelMetaData;

public class InlineEtlQueryExecutor
extends BaseMetadataQueryExec {
    private static final String __FORMULA_ = "__FORMULA_";
    private static final Log logger = LogFactory.getLog(InlineEtlQueryExecutor.class);
    String transformLocation = "res:org/pentaho/metadata/query/impl/ietl/";
    private String csvFileLoc = null;

    @Override
    public void setParameter(Parameter param, Object value) {
        super.setParameter(param, this.convertParameterValue(param, value));
    }

    @Override
    public IPentahoResultSet executeQuery(Query queryObject) {
        try {
            return this.executeQuery(queryObject, this.parameters);
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            return null;
        }
    }

    protected void init() {
    }

    @Override
    public boolean isLive() {
        return false;
    }

    protected String getTransformLocation() {
        return this.transformLocation;
    }

    public void setTransformLocation(String transformLocation) {
        this.transformLocation = transformLocation;
    }

    private List<Selection> getAllSelections(Query query, List<QueryConstraint> queryConstraints) {
        ArrayList<Selection> allSelections = new ArrayList<Selection>();
        allSelections.addAll(query.getSelections());
        for (Order order : query.getOrders()) {
            if (allSelections.contains(order.getSelection())) continue;
            allSelections.add(order.getSelection());
        }
        for (QueryConstraint constraint : queryConstraints) {
            for (Selection selection : constraint.selections) {
                if (allSelections.contains(selection)) continue;
                allSelections.add(selection);
            }
        }
        return allSelections;
    }

    public List<QueryConstraint> parseConstraints(Query query, Map<String, Object> parameters) {
        ArrayList<QueryConstraint> constraints = new ArrayList<QueryConstraint>();
        for (Constraint constraint : query.getConstraints()) {
            QueryConstraint qc = new QueryConstraint();
            qc.orig = constraint;
            Pattern p = Pattern.compile("\\[([^\\]]*)\\]");
            Matcher m = p.matcher(constraint.getFormula());
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String match = m.group(1);
                if (match.startsWith("param:")) {
                    String paramName = match.substring(6);
                    Object paramValue = parameters.get(paramName);
                    String openFormulaValue = "";
                    openFormulaValue = paramValue instanceof Boolean ? (((Boolean)paramValue).booleanValue() ? "TRUE()" : "FALSE()") : (paramValue instanceof Double ? paramValue.toString() : "\"" + paramValue + "\"");
                    m.appendReplacement(sb, openFormulaValue);
                    continue;
                }
                String[] seg = match.split("\\.");
                if (seg != null && seg.length > 1) {
                    Selection sel;
                    Category cat = query.getLogicalModel().findCategory(seg[0]);
                    LogicalColumn col = cat.findLogicalColumn(seg[1]);
                    if (col == null) {
                        logger.error((Object)Messages.getErrorString("InlineEtlQueryExecutor.ERROR_0001_FAILED_TO_LOCATE_COLUMN", seg[0], seg[1]));
                    }
                    String fieldName = (String)col.getProperty("field_name");
                    AggregationType agg = null;
                    if (seg.length > 2) {
                        agg = AggregationType.valueOf(seg[2].toUpperCase());
                    }
                    if (!qc.selections.contains(sel = new Selection(cat, col, agg))) {
                        qc.selections.add(sel);
                        if (sel.getActiveAggregationType() != null && sel.getActiveAggregationType() != AggregationType.NONE) {
                            qc.groupby = true;
                        }
                    }
                    m.appendReplacement(sb, "[" + fieldName + "]");
                    continue;
                }
                logger.error((Object)Messages.getErrorString("InlineEtlQueryExecutor.ERROR_0002_FAILED_TO_PARSE_FORMULA", match));
            }
            m.appendTail(sb);
            qc.formula = sb.toString();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("PARSED FORMULA: " + qc.formula));
            }
            constraints.add(qc);
        }
        return constraints;
    }

    protected void doInputWiring(Query query, TransMeta transMeta) {
        InlineEtlPhysicalModel physicalModel = (InlineEtlPhysicalModel)query.getLogicalModel().getPhysicalModel();
        CsvInputMeta csvinput = (CsvInputMeta)this.getStepMeta(transMeta, "CSV file input").getStepMetaInterface();
        if (this.csvFileLoc != null) {
            csvinput.setFilename(this.csvFileLoc + physicalModel.getFileLocation());
        } else {
            csvinput.setFilename(physicalModel.getFileLocation());
        }
        csvinput.setDelimiter(physicalModel.getDelimiter());
        csvinput.setEnclosure(physicalModel.getEnclosure());
        csvinput.setHeaderPresent(physicalModel.getHeaderPresent().booleanValue());
        LogicalTable table = query.getLogicalModel().getLogicalTables().get(0);
        csvinput.allocate(table.getLogicalColumns().size());
        for (int i = 0; i < csvinput.getInputFields().length; ++i) {
            LogicalColumn col = table.getLogicalColumns().get(i);
            csvinput.getInputFields()[i] = new TextFileInputField();
            String fieldName = (String)col.getProperty("field_name");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("FROM CSV: " + fieldName));
            }
            csvinput.getInputFields()[i].setName(fieldName);
            csvinput.getInputFields()[i].setType(this.convertType(col.getDataType()));
        }
    }

    protected void doInjector(Query query, Trans trans) throws Exception {
    }

    public IPentahoResultSet executeQuery(Query query, String fileLoc, Map<String, Object> parameters) throws Exception {
        this.setCsvFileLoc(fileLoc);
        return this.executeQuery(query, parameters);
    }

    public IPentahoResultSet executeQuery(Query query, Map<String, Object> parameters) throws Exception {
        if (query.getLimit() >= 0) {
            throw new UnsupportedOperationException(Messages.getErrorString("InlineEtlQueryExecutor.ERROR_0003_LIMIT_NOT_SUPPORTED", new Object[0]));
        }
        if (parameters == null && query.getParameters().size() > 0) {
            parameters = new HashMap<String, Object>();
        }
        for (Parameter param : query.getParameters()) {
            if (parameters.containsKey(param.getName())) continue;
            parameters.put(param.getName(), param.getDefaultValue());
        }
        int groupBys = 0;
        List<QueryConstraint> queryConstraints = this.parseConstraints(query, parameters);
        TreeSet<String> repeatedSelections = new TreeSet<String>();
        List<Selection> allSelections = this.getAllSelections(query, queryConstraints);
        HashMap<Selection, String> selectionFieldNames = new HashMap<Selection, String>();
        for (Selection selection : allSelections) {
            String fieldName;
            String useFieldName = fieldName = ((InlineEtlPhysicalColumn)selection.getLogicalColumn().getPhysicalColumn()).getFieldName();
            int count = 1;
            while (repeatedSelections.contains(useFieldName)) {
                useFieldName = fieldName + "_" + count++;
            }
            repeatedSelections.add(useFieldName);
            selectionFieldNames.put(selection, useFieldName);
            if (selection.getActiveAggregationType() == null || selection.getActiveAggregationType() == AggregationType.NONE) continue;
            ++groupBys;
        }
        String fileAddress = this.getTransformLocation() + "inlinecsv.ktr";
        if (groupBys > 0) {
            fileAddress = this.getTransformLocation() + "inlinecsv_groupby.ktr";
        }
        TransMeta transMeta = new TransMeta(fileAddress, null, true);
        transMeta.setFilename(fileAddress);
        this.doInputWiring(query, transMeta);
        StepMeta selections = this.getStepMeta(transMeta, "Select values");
        SelectValuesMeta selectVals = (SelectValuesMeta)selections.getStepMetaInterface();
        selectVals.allocate(allSelections.size(), 0, 0);
        for (int i = 0; i < allSelections.size(); ++i) {
            Selection selection = allSelections.get(i);
            String fieldName = ((InlineEtlPhysicalColumn)selection.getLogicalColumn().getPhysicalColumn()).getFieldName();
            String renameFieldName = (String)selectionFieldNames.get(selection);
            selectVals.getSelectName()[i] = fieldName;
            if (!fieldName.equals(renameFieldName)) {
                selectVals.getSelectRename()[i] = renameFieldName;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("SELECT " + fieldName + " RENAME TO " + renameFieldName));
        }
        StepMeta finalSelections = this.getStepMeta(transMeta, "Select values 2");
        HashMap<String, String> fieldNameMap = new HashMap<String, String>();
        SelectValuesMeta finalSelectVals = (SelectValuesMeta)finalSelections.getStepMetaInterface();
        finalSelectVals.allocate(query.getSelections().size(), 0, 0);
        for (int i = 0; i < query.getSelections().size(); ++i) {
            Selection selection = query.getSelections().get(i);
            String fieldName = (String)selectionFieldNames.get(selection);
            fieldNameMap.put(fieldName.toUpperCase(), selection.getLogicalColumn().getId());
            finalSelectVals.getSelectName()[i] = fieldName;
        }
        if (query.getConstraints().size() > 0) {
            StepMeta formula = this.getStepMeta(transMeta, "Formula");
            FormulaMeta formulaMeta = (FormulaMeta)formula.getStepMetaInterface();
            int alloc = 0;
            for (QueryConstraint constraint : queryConstraints) {
                if (constraint.groupby) continue;
                ++alloc;
            }
            if (alloc > 0) {
                formulaMeta.allocate(alloc);
            }
            StepMeta filter = this.getStepMeta(transMeta, "Filter rows");
            FilterRowsMeta filterRows = (FilterRowsMeta)filter.getStepMetaInterface();
            Condition rootCondition = new Condition();
            int c = 0;
            for (QueryConstraint constraint : queryConstraints) {
                if (constraint.groupby) continue;
                String formulaVal = constraint.formula;
                formulaMeta.getFormula()[c] = new FormulaMetaFunction(__FORMULA_ + c, formulaVal, 4, -1, -1, null);
                Condition condition = new Condition();
                condition.setLeftValuename(__FORMULA_ + c);
                condition.setOperator(this.convertOperator(constraint.orig.getCombinationType()));
                condition.setFunction(0);
                condition.setRightExact(new ValueMetaAndData("dummy", (Object)true));
                rootCondition.addCondition(condition);
                ++c;
            }
            if (c > 0) {
                filterRows.setCondition(rootCondition);
                StepMeta dummy = this.getStepMeta(transMeta, "Dummy 1");
                ((StreamInterface)filterRows.getStepIOMeta().getTargetStreams().get(1)).setStepMeta(dummy);
                transMeta.addTransHop(new TransHopMeta(filter, dummy));
            }
            if (groupBys > 0) {
                StepMeta formula2 = this.getStepMeta(transMeta, "Formula 2");
                FormulaMeta formulaMeta2 = (FormulaMeta)formula2.getStepMetaInterface();
                alloc = 0;
                for (QueryConstraint constraint : queryConstraints) {
                    if (!constraint.groupby) continue;
                    ++alloc;
                }
                if (alloc > 0) {
                    formulaMeta2.allocate(alloc);
                }
                StepMeta filter2 = this.getStepMeta(transMeta, "Filter rows 2");
                FilterRowsMeta filterRows2 = (FilterRowsMeta)filter2.getStepMetaInterface();
                Condition rootCondition2 = new Condition();
                c = 0;
                for (QueryConstraint constraint : queryConstraints) {
                    if (!constraint.groupby) continue;
                    String formulaVal = constraint.formula;
                    formulaMeta2.getFormula()[c] = new FormulaMetaFunction("__FORMULA2_" + c, formulaVal, 4, -1, -1, null);
                    Condition condition = new Condition();
                    condition.setLeftValuename("__FORMULA2_" + c);
                    condition.setOperator(this.convertOperator(constraint.orig.getCombinationType()));
                    condition.setFunction(0);
                    condition.setRightExact(new ValueMetaAndData("dummy", (Object)true));
                    rootCondition2.addCondition(condition);
                    ++c;
                }
                if (c > 0) {
                    filterRows2.setCondition(rootCondition2);
                    StepMeta dummy2 = this.getStepMeta(transMeta, "Dummy 2");
                    ((StreamInterface)filterRows2.getStepIOMeta().getTargetStreams().get(1)).setStepMeta(dummy2);
                    transMeta.addTransHop(new TransHopMeta(filter2, dummy2));
                }
            }
        }
        StepMeta sort = this.getStepMeta(transMeta, "Sort rows");
        SortRowsMeta sortRows = (SortRowsMeta)sort.getStepMetaInterface();
        sortRows.allocate(query.getOrders().size());
        int c = 0;
        for (Order order : query.getOrders()) {
            String fieldName;
            sortRows.getFieldName()[c] = fieldName = (String)selectionFieldNames.get(order.getSelection());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ORDER: " + fieldName));
            }
            sortRows.getAscending()[c] = order.getType() == Order.Type.ASC;
            sortRows.getCaseSensitive()[c] = false;
            ++c;
        }
        if (groupBys > 0) {
            String fieldName;
            StepMeta groupsort = this.getStepMeta(transMeta, "Group Sort rows");
            SortRowsMeta groupSortRows = (SortRowsMeta)groupsort.getStepMetaInterface();
            int groups = 0;
            for (Selection selection : query.getSelections()) {
                if (selection.getActiveAggregationType() != null && selection.getActiveAggregationType() != AggregationType.NONE) continue;
                ++groups;
            }
            groupSortRows.allocate(groups);
            c = 0;
            for (Selection selection : query.getSelections()) {
                String fieldName2;
                if (selection.getActiveAggregationType() != null && selection.getActiveAggregationType() != AggregationType.NONE) continue;
                groupSortRows.getFieldName()[c] = fieldName2 = (String)selectionFieldNames.get(selection);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("GROUP ORDER: " + fieldName2));
                }
                groupSortRows.getAscending()[c] = true;
                groupSortRows.getCaseSensitive()[c] = false;
                ++c;
            }
            StepMeta group = this.getStepMeta(transMeta, "Group by");
            GroupByMeta groupStep = (GroupByMeta)group.getStepMetaInterface();
            groupStep.allocate(groups, groupBys);
            c = 0;
            for (Selection selection : query.getSelections()) {
                if (selection.getActiveAggregationType() != null && selection.getActiveAggregationType() != AggregationType.NONE) continue;
                groupStep.getGroupField()[c] = fieldName = (String)selectionFieldNames.get(selection);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("GROUP BY: " + fieldName));
                }
                ++c;
            }
            c = 0;
            for (Selection selection : allSelections) {
                if (selection.getActiveAggregationType() == null || selection.getActiveAggregationType() == AggregationType.NONE) continue;
                groupStep.getAggregateField()[c] = fieldName = (String)selectionFieldNames.get(selection);
                groupStep.getSubjectField()[c] = fieldName;
                groupStep.getAggregateType()[c] = this.convertAggType(selection.getActiveAggregationType());
                groupStep.getValueField()[c] = null;
                ++c;
            }
        }
        InlineEtlRowListener listener = new InlineEtlRowListener();
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(transMeta.getArguments());
        this.doInjector(query, trans);
        listener.registerAsStepListener(trans, query, fieldNameMap);
        trans.startThreads();
        trans.waitUntilFinished();
        trans.cleanup();
        return listener.results;
    }

    private int convertAggType(AggregationType type) {
        switch (type) {
            case NONE: {
                return 0;
            }
            case AVERAGE: {
                return 2;
            }
            case SUM: {
                return 1;
            }
            case COUNT: {
                return 7;
            }
            case COUNT_DISTINCT: {
                return 17;
            }
            case MINIMUM: {
                return 5;
            }
            case MAXIMUM: {
                return 6;
            }
        }
        return 0;
    }

    private int convertOperator(CombinationType combo) {
        switch (combo) {
            case OR: {
                return 1;
            }
            case AND_NOT: {
                return 5;
            }
            case OR_NOT: {
                return 4;
            }
        }
        return 2;
    }

    protected StepMeta getStepMeta(TransMeta meta, String name) {
        for (StepMeta step : meta.getSteps()) {
            if (!name.equals(step.getName())) continue;
            return step;
        }
        return null;
    }

    private int convertType(DataType type) {
        switch (type) {
            case DATE: {
                return 3;
            }
            case BOOLEAN: {
                return 4;
            }
            case NUMERIC: {
                return 1;
            }
            case BINARY: 
            case IMAGE: {
                return 8;
            }
        }
        return 2;
    }

    public String getCsvFileLoc() {
        return this.csvFileLoc;
    }

    public void setCsvFileLoc(String csvFileLoc) {
        this.csvFileLoc = csvFileLoc;
    }

    private static class InlineEtlRowListener
    implements RowListener {
        private MemoryResultSet results;
        private MemoryResultSet errorResults;

        private InlineEtlRowListener() {
        }

        private boolean registerAsStepListener(Trans trans, Query query, Map fieldMap) throws Exception {
            boolean success = false;
            if (trans != null) {
                List stepList = trans.getSteps();
                for (StepMetaDataCombi step : stepList) {
                    if (!"Unique rows".equals(step.stepname)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("STEP NAME: " + step.stepname));
                    }
                    RowMetaInterface row = trans.getTransMeta().getStepFields(step.stepMeta);
                    String[] fieldNames = row.getFieldNames();
                    Object[][] columns = new String[1][fieldNames.length];
                    for (int column = 0; column < fieldNames.length; ++column) {
                        columns[0][column] = fieldNames[column];
                    }
                    QueryModelMetaData metadata = new QueryModelMetaData(fieldMap, columns, null, query.getSelections());
                    this.results = new MemoryResultSet((IPentahoMetaData)metadata);
                    this.errorResults = new MemoryResultSet((IPentahoMetaData)metadata);
                    step.step.addRowListener((RowListener)this);
                    success = true;
                }
            }
            return success;
        }

        public void rowReadEvent(RowMetaInterface row, Object[] values) {
        }

        public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            this.processRow(this.results, rowMeta, row);
        }

        public void errorRowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            this.processRow(this.errorResults, rowMeta, row);
        }

        public void processRow(MemoryResultSet memResults, RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            if (memResults == null) {
                return;
            }
            try {
                Object[] pentahoRow = new Object[memResults.getColumnCount()];
                block11: for (int columnNo = 0; columnNo < memResults.getColumnCount(); ++columnNo) {
                    ValueMetaInterface valueMeta = rowMeta.getValueMeta(columnNo);
                    switch (valueMeta.getType()) {
                        case 6: {
                            pentahoRow[columnNo] = rowMeta.getBigNumber(row, columnNo);
                            continue block11;
                        }
                        case 4: {
                            pentahoRow[columnNo] = rowMeta.getBoolean(row, columnNo);
                            continue block11;
                        }
                        case 3: {
                            pentahoRow[columnNo] = rowMeta.getDate(row, columnNo);
                            continue block11;
                        }
                        case 5: {
                            pentahoRow[columnNo] = rowMeta.getInteger(row, columnNo);
                            continue block11;
                        }
                        case 0: {
                            pentahoRow[columnNo] = rowMeta.getString(row, columnNo);
                            continue block11;
                        }
                        case 1: {
                            pentahoRow[columnNo] = rowMeta.getNumber(row, columnNo);
                            continue block11;
                        }
                        case 2: {
                            pentahoRow[columnNo] = rowMeta.getString(row, columnNo);
                            continue block11;
                        }
                        default: {
                            pentahoRow[columnNo] = rowMeta.getString(row, columnNo);
                        }
                    }
                }
                if (logger.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < pentahoRow.length; ++i) {
                        sb.append(pentahoRow[i]).append("; ");
                    }
                    logger.debug((Object)sb.toString());
                }
                memResults.addRow(pentahoRow);
            }
            catch (KettleValueException e) {
                throw new KettleStepException((Throwable)e);
            }
        }
    }

    private static class QueryConstraint {
        boolean groupby = false;
        List<Selection> selections = new ArrayList<Selection>();
        String formula;
        Constraint orig;

        private QueryConstraint() {
        }
    }
}

