/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.util;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalRelationship;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.model.concept.types.TargetTableType;
import org.pentaho.metadata.model.olap.OlapAnnotation;
import org.pentaho.metadata.model.olap.OlapCube;
import org.pentaho.metadata.model.olap.OlapDimension;
import org.pentaho.metadata.model.olap.OlapDimensionUsage;
import org.pentaho.metadata.model.olap.OlapHierarchy;
import org.pentaho.metadata.model.olap.OlapHierarchyLevel;
import org.pentaho.metadata.model.olap.OlapMeasure;
import org.pentaho.metadata.util.Util;

public class MondrianModelExporter {
    private LogicalModel businessModel;
    private String locale;

    public MondrianModelExporter(LogicalModel businessModel, String locale) {
        this.businessModel = businessModel;
        this.locale = locale;
    }

    public String createMondrianModelXML() throws Exception {
        List olapCubes;
        StringBuffer xml = new StringBuffer(10000);
        xml.append("<Schema ");
        xml.append("name=\"");
        String name = this.businessModel.getName(this.locale);
        if (this.businessModel.getProperty("AGILE_BI_GENERATED_SCHEMA") != null) {
            name = name.replace("_OLAP", "");
        }
        XMLHandler.appendReplacedChars((StringBuffer)xml, (String)name);
        xml.append("\">");
        xml.append(Util.CR);
        List olapDimensions = (List)this.businessModel.getProperty("olap_dimensions");
        if (olapDimensions != null) {
            for (int d = 0; d < olapDimensions.size(); ++d) {
                OlapDimension olapDimension = (OlapDimension)olapDimensions.get(d);
                xml.append("  <Dimension");
                xml.append(" name=\"");
                XMLHandler.appendReplacedChars((StringBuffer)xml, (String)olapDimension.getName());
                xml.append("\"");
                if (olapDimension.isTimeDimension()) {
                    xml.append(" type=\"");
                    XMLHandler.appendReplacedChars((StringBuffer)xml, (String)"TimeDimension");
                    xml.append("\"");
                }
                xml.append(">");
                xml.append(Util.CR);
                List<OlapHierarchy> olapHierarchies = olapDimension.getHierarchies();
                for (int h = 0; h < olapHierarchies.size(); ++h) {
                    OlapHierarchy olapHierarchy = olapHierarchies.get(h);
                    xml.append("    <Hierarchy");
                    if (StringUtils.isNotEmpty((String)olapHierarchy.getName()) && !StringUtils.equals((String)olapHierarchy.getName(), (String)olapDimension.getName())) {
                        xml.append(" name=\"");
                        xml.append(olapHierarchy.getName());
                        xml.append("\"");
                    }
                    xml.append(" hasAll=\"");
                    xml.append(olapHierarchy.isHavingAll() ? "true" : "false");
                    xml.append("\"");
                    if (olapHierarchy.getPrimaryKey() != null) {
                        xml.append(" primaryKey=\"");
                        xml.append(olapHierarchy.getPrimaryKey().getProperty("target_column"));
                        xml.append("\"");
                    }
                    xml.append(">");
                    xml.append(Util.CR);
                    if (olapHierarchy.getLogicalTable().getProperty("target_table_type") == TargetTableType.INLINE_SQL) {
                        xml.append("    <View alias=\"FACT\">").append(Util.CR);
                        xml.append("        <SQL dialect=\"generic\">").append(Util.CR);
                        xml.append("         <![CDATA[" + olapHierarchy.getLogicalTable().getProperty("target_table") + "]]>").append(Util.CR);
                        xml.append("        </SQL>").append(Util.CR);
                        xml.append("    </View>").append(Util.CR);
                    } else {
                        xml.append("      <Table");
                        xml.append(" name=\"");
                        XMLHandler.appendReplacedChars((StringBuffer)xml, (String)this.cleanseDbName((String)olapHierarchy.getLogicalTable().getProperty("target_table")));
                        xml.append("\"");
                        if (!StringUtils.isBlank((String)((String)olapHierarchy.getLogicalTable().getProperty("target_schema")))) {
                            xml.append(" schema=\"");
                            XMLHandler.appendReplacedChars((StringBuffer)xml, (String)this.cleanseDbName((String)olapHierarchy.getLogicalTable().getProperty("target_schema")));
                            xml.append("\"");
                        }
                        xml.append("/>");
                        xml.append(Util.CR);
                    }
                    List<OlapHierarchyLevel> hierarchyLevels = olapHierarchy.getHierarchyLevels();
                    for (int hl = 0; hl < hierarchyLevels.size(); ++hl) {
                        String levelType;
                        OlapHierarchyLevel olapHierarchyLevel = hierarchyLevels.get(hl);
                        xml.append("      <Level");
                        xml.append(" name=\"");
                        XMLHandler.appendReplacedChars((StringBuffer)xml, (String)olapHierarchyLevel.getName());
                        xml.append("\"");
                        xml.append(" uniqueMembers=\"");
                        XMLHandler.appendReplacedChars((StringBuffer)xml, (String)(olapHierarchyLevel.isHavingUniqueMembers() ? "true" : "false"));
                        xml.append("\"");
                        LogicalColumn column = olapHierarchyLevel.getReferenceColumn();
                        xml.append(" column=\"");
                        XMLHandler.appendReplacedChars((StringBuffer)xml, (String)((String)column.getProperty("target_column")));
                        xml.append("\"");
                        column = olapHierarchyLevel.getReferenceOrdinalColumn();
                        if (column != null) {
                            xml.append(" ordinalColumn=\"");
                            XMLHandler.appendReplacedChars((StringBuffer)xml, (String)((String)column.getProperty("target_column")));
                            xml.append("\"");
                        }
                        if ((column = olapHierarchyLevel.getReferenceCaptionColumn()) != null) {
                            xml.append(" captionColumn=\"");
                            XMLHandler.appendReplacedChars((StringBuffer)xml, (String)((String)column.getProperty("target_column")));
                            xml.append("\"");
                        }
                        if ((levelType = olapHierarchyLevel.getLevelType()) != null && !levelType.equals("")) {
                            xml.append(" levelType=\"");
                            XMLHandler.appendReplacedChars((StringBuffer)xml, (String)levelType);
                            xml.append("\"");
                        }
                        DataType dataTypeLevel = olapHierarchyLevel.getReferenceColumn().getDataType();
                        String typeDescLevel = null;
                        switch (dataTypeLevel) {
                            case STRING: {
                                typeDescLevel = "String";
                                break;
                            }
                            case NUMERIC: {
                                typeDescLevel = "Numeric";
                                break;
                            }
                            case BOOLEAN: {
                                typeDescLevel = "Boolean";
                            }
                        }
                        if (typeDescLevel != null) {
                            xml.append(" type=\"");
                            XMLHandler.appendReplacedChars((StringBuffer)xml, (String)typeDescLevel);
                            xml.append("\"");
                        }
                        xml.append(">");
                        xml.append(Util.CR);
                        if (olapHierarchyLevel.getAnnotations().size() > 0) {
                            xml.append("        <Annotations>");
                            for (OlapAnnotation annotation : olapHierarchyLevel.getAnnotations()) {
                                xml.append(Util.CR);
                                xml.append(annotation.asXml());
                            }
                            xml.append(Util.CR);
                            xml.append("        </Annotations>");
                            xml.append(Util.CR);
                        }
                        List<LogicalColumn> businessColumns = olapHierarchyLevel.getLogicalColumns();
                        for (int i = 0; i < businessColumns.size(); ++i) {
                            LogicalColumn businessColumn = businessColumns.get(i);
                            xml.append("        <Property");
                            xml.append(" name=\"");
                            XMLHandler.appendReplacedChars((StringBuffer)xml, (String)businessColumn.getName(this.locale));
                            xml.append("\"");
                            xml.append(" column=\"");
                            XMLHandler.appendReplacedChars((StringBuffer)xml, (String)((String)businessColumn.getProperty("target_column")));
                            xml.append("\"");
                            DataType dataType = businessColumn.getDataType();
                            String typeDesc = null;
                            switch (dataType) {
                                case STRING: {
                                    typeDesc = "String";
                                    break;
                                }
                                case NUMERIC: {
                                    typeDesc = "Numeric";
                                    break;
                                }
                                case BOOLEAN: {
                                    typeDesc = "Boolean";
                                    break;
                                }
                                case DATE: {
                                    typeDesc = "Date";
                                }
                            }
                            if (typeDesc != null) {
                                xml.append(" type=\"");
                                XMLHandler.appendReplacedChars((StringBuffer)xml, (String)typeDesc);
                                xml.append("\"");
                            }
                            if (businessColumn.getDescription() != null) {
                                xml.append(" description=\"");
                                XMLHandler.appendReplacedChars((StringBuffer)xml, (String)businessColumn.getDescription(this.locale));
                                xml.append("\"");
                            }
                            xml.append("/>");
                            xml.append(Util.CR);
                        }
                        xml.append("      </Level>").append(Util.CR);
                    }
                    xml.append("    </Hierarchy>").append(Util.CR);
                }
                xml.append("  </Dimension>").append(Util.CR);
            }
        }
        if ((olapCubes = (List)this.businessModel.getProperty("olap_cubes")) != null) {
            for (int c = 0; c < olapCubes.size(); ++c) {
                OlapCube olapCube = (OlapCube)olapCubes.get(c);
                xml.append("  <Cube");
                xml.append(" name=\"");
                XMLHandler.appendReplacedChars((StringBuffer)xml, (String)olapCube.getName());
                xml.append("\"");
                xml.append(">").append(Util.CR);
                if (olapCube.getLogicalTable().getProperty("target_table_type") == TargetTableType.INLINE_SQL) {
                    xml.append("    <View alias=\"FACT\">").append(Util.CR);
                    xml.append("        <SQL dialect=\"generic\">").append(Util.CR);
                    xml.append("         <![CDATA[" + olapCube.getLogicalTable().getProperty("target_table") + "]]>").append(Util.CR);
                    xml.append("        </SQL>").append(Util.CR);
                    xml.append("    </View>").append(Util.CR);
                } else {
                    xml.append("    <Table");
                    xml.append(" name=\"");
                    XMLHandler.appendReplacedChars((StringBuffer)xml, (String)this.cleanseDbName((String)olapCube.getLogicalTable().getProperty("target_table")));
                    xml.append("\"");
                    if (!StringUtils.isBlank((String)((String)olapCube.getLogicalTable().getProperty("target_schema")))) {
                        xml.append(" schema=\"");
                        XMLHandler.appendReplacedChars((StringBuffer)xml, (String)this.cleanseDbName((String)olapCube.getLogicalTable().getProperty("target_schema")));
                        xml.append("\"");
                    }
                    xml.append("/>").append(Util.CR);
                }
                List<OlapDimensionUsage> usages = olapCube.getOlapDimensionUsages();
                for (int u = 0; u < usages.size(); ++u) {
                    OlapDimensionUsage usage = usages.get(u);
                    xml.append("    <DimensionUsage");
                    xml.append(" name=\"");
                    XMLHandler.appendReplacedChars((StringBuffer)xml, (String)usage.getName());
                    xml.append("\"");
                    xml.append(" source=\"");
                    XMLHandler.appendReplacedChars((StringBuffer)xml, (String)usage.getOlapDimension().getName());
                    xml.append("\"");
                    LogicalTable dimTable = usage.getOlapDimension().findLogicalTable();
                    LogicalTable cubeTable = olapCube.getLogicalTable();
                    LogicalRelationship relationshipMeta = this.businessModel.findRelationshipUsing(dimTable, cubeTable);
                    if (!dimTable.equals(cubeTable) || relationshipMeta != null) {
                        if (relationshipMeta != null) {
                            LogicalColumn keyColumn = relationshipMeta.getFromTable().equals(dimTable) ? relationshipMeta.getToColumn() : relationshipMeta.getFromColumn();
                            xml.append(" foreignKey=\"");
                            XMLHandler.appendReplacedChars((StringBuffer)xml, (String)((String)keyColumn.getProperty("target_column")));
                            xml.append("\"");
                        } else {
                            throw new Exception(Messages.getString("MondrianModelExporter.ERROR_0001_ERROR_NO_RELATIONSHIP", dimTable.getName(this.locale), cubeTable.toString()));
                        }
                    }
                    xml.append("/>").append(Util.CR);
                }
                List<OlapMeasure> measures = olapCube.getOlapMeasures();
                for (int m = 0; m < measures.size(); ++m) {
                    String formatString;
                    OlapMeasure measure = measures.get(m);
                    LogicalColumn businessColumn = measure.getLogicalColumn();
                    xml.append("    <Measure");
                    xml.append(" name=\"");
                    XMLHandler.appendReplacedChars((StringBuffer)xml, (String)businessColumn.getName(this.locale));
                    xml.append("\"");
                    xml.append(" column=\"");
                    XMLHandler.appendReplacedChars((StringBuffer)xml, (String)((String)businessColumn.getProperty("target_column")));
                    xml.append("\"");
                    AggregationType aggregationType = businessColumn.getAggregationType();
                    String typeDesc = null;
                    switch (aggregationType) {
                        case NONE: {
                            typeDesc = "none";
                            break;
                        }
                        case SUM: {
                            typeDesc = "sum";
                            break;
                        }
                        case AVERAGE: {
                            typeDesc = "avg";
                            break;
                        }
                        case COUNT: {
                            typeDesc = "count";
                            break;
                        }
                        case COUNT_DISTINCT: {
                            typeDesc = "distinct count";
                            break;
                        }
                        case MINIMUM: {
                            typeDesc = "min";
                            break;
                        }
                        case MAXIMUM: {
                            typeDesc = "max";
                        }
                    }
                    if (typeDesc != null) {
                        xml.append(" aggregator=\"");
                        XMLHandler.appendReplacedChars((StringBuffer)xml, (String)typeDesc);
                        xml.append("\"");
                    }
                    if (StringUtils.isEmpty((String)(formatString = (String)businessColumn.getProperty("mask")))) {
                        formatString = "Standard";
                    }
                    xml.append(" formatString=\"");
                    XMLHandler.appendReplacedChars((StringBuffer)xml, (String)formatString);
                    xml.append("\"");
                    xml.append("/>").append(Util.CR);
                }
                xml.append("  </Cube>").append(Util.CR);
            }
        }
        xml.append("</Schema>");
        return xml.toString();
    }

    private String cleanseDbName(String name) {
        return name.replaceAll("^[`'\"]|[`'\"]$", "");
    }

    public LogicalModel getLogicalModel() {
        return this.businessModel;
    }

    public void setLogicalModel(LogicalModel businessModel) {
        this.businessModel = businessModel;
    }
}

