/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.mql.MappedQuery;
import org.pentaho.pms.mql.OrderBy;
import org.pentaho.pms.mql.PMSFormula;
import org.pentaho.pms.mql.Path;
import org.pentaho.pms.mql.SQLAndTables;
import org.pentaho.pms.mql.Selection;
import org.pentaho.pms.mql.WhereCondition;
import org.pentaho.pms.mql.dialect.JoinType;
import org.pentaho.pms.mql.dialect.SQLDialectFactory;
import org.pentaho.pms.mql.dialect.SQLDialectInterface;
import org.pentaho.pms.mql.dialect.SQLQueryModel;
import org.pentaho.pms.mql.graph.MqlGraph;
import org.pentaho.pms.mql.graph.PathType;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.BusinessModel;
import org.pentaho.pms.schema.BusinessTable;
import org.pentaho.pms.schema.RelationshipMeta;
import org.pentaho.pms.schema.concept.ConceptInterface;
import org.pentaho.pms.schema.concept.ConceptPropertyInterface;
import org.pentaho.pms.schema.concept.types.ConceptPropertyType;

public class SQLGenerator {
    private static final Log logger = LogFactory.getLog(SQLGenerator.class);
    public boolean preferClassicShortestPath = false;

    public void generateSelect(SQLQueryModel query, BusinessModel model, DatabaseMeta databaseMeta, List<Selection> selections, boolean disableDistinct, int limit, boolean group, String locale, Map<BusinessTable, String> tableAliases, Map<String, String> columnsMap) {
        query.setDistinct(!disableDistinct && !group);
        query.setLimit(limit);
        for (int i = 0; i < selections.size(); ++i) {
            String alias = null;
            if (columnsMap != null) {
                alias = databaseMeta.generateColumnAlias(i, selections.get(i).getBusinessColumn().getId());
                columnsMap.put(alias, selections.get(i).getBusinessColumn().getId());
                alias = databaseMeta.quoteField(alias);
            } else {
                alias = databaseMeta.quoteField(selections.get(i).getBusinessColumn().getId());
            }
            SQLAndTables sqlAndTables = SQLGenerator.getBusinessColumnSQL(model, selections.get(i), tableAliases, databaseMeta, locale);
            query.addSelection(sqlAndTables.getSql(), alias);
        }
    }

    public void generateFromAndWhere(SQLQueryModel query, List<BusinessTable> usedBusinessTables, BusinessModel model, Path path, List<WhereCondition> conditions, Map<BusinessTable, String> tableAliases, DatabaseMeta databaseMeta, String locale) throws PentahoMetadataException {
        int i;
        for (i = 0; i < usedBusinessTables.size(); ++i) {
            String tableName;
            BusinessTable businessTable = usedBusinessTables.get(i);
            String schemaName = null;
            if (businessTable.getTargetSchema() != null) {
                schemaName = databaseMeta.quoteField(businessTable.getTargetSchema());
            }
            tableName = (tableName = businessTable.getTargetTable()).toLowerCase().startsWith("select ") ? "(" + tableName + ")" : databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
            query.addTable(tableName, databaseMeta.quoteField(tableAliases.get(businessTable)));
        }
        if (path != null) {
            for (i = 0; i < path.size(); ++i) {
                JoinType joinType;
                RelationshipMeta relation = path.getRelationship(i);
                String joinFormula = this.getJoin(model, relation, tableAliases, databaseMeta, locale);
                String joinOrderKey = relation.getJoinOrderKey();
                switch (relation.getJoinType()) {
                    case 1: {
                        joinType = JoinType.LEFT_OUTER_JOIN;
                        break;
                    }
                    case 2: {
                        joinType = JoinType.RIGHT_OUTER_JOIN;
                        break;
                    }
                    case 3: {
                        joinType = JoinType.FULL_OUTER_JOIN;
                        break;
                    }
                    default: {
                        joinType = JoinType.INNER_JOIN;
                    }
                }
                String leftTableName = databaseMeta.getQuotedSchemaTableCombination(relation.getTableFrom().getTargetSchema(), relation.getTableFrom().getTargetTable());
                String leftTableAlias = relation.getTableFrom().getId();
                String rightTableName = databaseMeta.getQuotedSchemaTableCombination(relation.getTableTo().getTargetSchema(), relation.getTableTo().getTargetTable());
                String rightTableAlias = relation.getTableTo().getId();
                query.addJoin(leftTableName, leftTableAlias, rightTableName, rightTableAlias, joinType, joinFormula, joinOrderKey);
            }
        }
        if (conditions != null) {
            boolean first = true;
            for (WhereCondition condition : conditions) {
                condition.getPMSFormula().setTableAliases(tableAliases);
                if (!condition.hasAggregate()) {
                    String sqlFormula = condition.getPMSFormula().generateSQL(locale);
                    String[] usedTables = condition.getPMSFormula().getBusinessTableIDs();
                    query.addWhereFormula(sqlFormula, first ? "AND" : condition.getOperator(), usedTables);
                    first = false;
                    continue;
                }
                query.addHavingFormula(condition.getPMSFormula().generateSQL(locale), condition.getOperator());
            }
        }
    }

    public void generateGroupBy(SQLQueryModel query, BusinessModel model, List<Selection> selections, Map<BusinessTable, String> tableAliases, DatabaseMeta databaseMeta, String locale) {
        for (Selection selection : selections) {
            if (this.hasFactsInIt(model, selection, databaseMeta, locale)) continue;
            SQLAndTables sqlAndTables = SQLGenerator.getBusinessColumnSQL(model, selection, tableAliases, databaseMeta, locale);
            query.addGroupBy(sqlAndTables.getSql(), null);
        }
    }

    public void generateOrderBy(SQLQueryModel query, BusinessModel model, List<OrderBy> orderBy, DatabaseMeta databaseMeta, String locale, Map<BusinessTable, String> tableAliases, Map<String, String> columnsMap) {
        if (orderBy != null) {
            for (OrderBy orderItem : orderBy) {
                BusinessColumn businessColumn = orderItem.getSelection().getBusinessColumn();
                String alias = null;
                if (columnsMap != null) {
                    for (String key : columnsMap.keySet()) {
                        String value = columnsMap.get(key);
                        if (!value.equals(businessColumn.getId())) continue;
                        alias = key;
                        break;
                    }
                }
                SQLAndTables sqlAndTables = SQLGenerator.getBusinessColumnSQL(model, orderItem.getSelection(), tableAliases, databaseMeta, locale);
                query.addOrderBy(sqlAndTables.getSql(), databaseMeta.quoteField(alias), !orderItem.isAscending() ? SQLQueryModel.OrderType.DESCENDING : null);
            }
        }
    }

    private static String genString(String base, int val) {
        if (val < 10) {
            return base + "0" + val;
        }
        return base + val;
    }

    public static String generateUniqueAlias(String alias, int maxLength, Collection<String> existingAliases) {
        if (alias.length() <= maxLength) {
            if (!existingAliases.contains(alias)) {
                return alias;
            }
            if (alias.length() > maxLength - 2) {
                alias = alias.substring(0, maxLength - 2);
            }
        } else {
            alias = alias.substring(0, maxLength - 2);
        }
        int id = 1;
        String aliasWithId = SQLGenerator.genString(alias, id);
        while (existingAliases.contains(aliasWithId)) {
            aliasWithId = SQLGenerator.genString(alias, ++id);
        }
        return aliasWithId;
    }

    public MappedQuery getSQL(BusinessModel model, List<Selection> selections, List<WhereCondition> conditions, List<OrderBy> orderBy, DatabaseMeta databaseMeta, String locale, boolean disableDistinct, int limit, WhereCondition securityConstraint) throws PentahoMetadataException {
        SQLQueryModel query = new SQLQueryModel();
        ConceptInterface concept = model.getConcept();
        ConceptPropertyInterface delayOuterJoin = concept.getProperty("delay_outer_join_conditions");
        if (delayOuterJoin != null && delayOuterJoin.getType().equals(ConceptPropertyType.BOOLEAN)) {
            Boolean value = (Boolean)delayOuterJoin.getValue();
            query.setDelayOuterJoinConditions(value);
        }
        HashMap<String, String> columnsMap = new HashMap<String, String>();
        List<BusinessTable> tabs = this.getTablesInvolved(model, selections, conditions, orderBy, databaseMeta, locale, securityConstraint);
        Path path = this.getShortestPathBetween(model, tabs);
        if (path == null) {
            throw new PentahoMetadataException(Messages.getErrorString("BusinessModel.ERROR_0001_FAILED_TO_FIND_PATH"));
        }
        List<BusinessTable> usedBusinessTables = path.getUsedTables();
        if (path.size() == 0 && selections.size() > 0) {
            usedBusinessTables.add(selections.get(0).getBusinessColumn().getBusinessTable());
        }
        if (usedBusinessTables.size() > 0) {
            int maxAliasNameWidth = SQLDialectFactory.getSQLDialect(databaseMeta).getMaxTableNameLength();
            HashMap<BusinessTable, String> tableAliases = new HashMap<BusinessTable, String>();
            for (BusinessTable table : usedBusinessTables) {
                String uniqueAlias = SQLGenerator.generateUniqueAlias(table.getId(), maxAliasNameWidth, tableAliases.values());
                tableAliases.put(table, uniqueAlias);
            }
            boolean group = this.hasFactsInIt(model, selections, conditions, databaseMeta, locale);
            this.generateSelect(query, model, databaseMeta, selections, disableDistinct, limit, group, locale, tableAliases, columnsMap);
            this.generateFromAndWhere(query, usedBusinessTables, model, path, conditions, tableAliases, databaseMeta, locale);
            if (group) {
                this.generateGroupBy(query, model, selections, tableAliases, databaseMeta, locale);
            }
            this.generateOrderBy(query, model, orderBy, databaseMeta, locale, tableAliases, columnsMap);
            if (securityConstraint != null) {
                securityConstraint.getPMSFormula().setTableAliases(tableAliases);
                String sqlFormula = securityConstraint.getPMSFormula().generateSQL(locale);
                query.setSecurityConstraint(sqlFormula, securityConstraint.hasAggregate());
            }
        }
        SQLDialectInterface dialect = SQLDialectFactory.getSQLDialect(databaseMeta);
        String sqlStr = dialect.generateSelectStatement(query);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)sqlStr);
        }
        return new MappedQuery(sqlStr, columnsMap, selections);
    }

    protected List<BusinessTable> getTablesInvolved(BusinessModel model, List<Selection> selections, List<WhereCondition> conditions, List<OrderBy> orderBy, DatabaseMeta databaseMeta, String locale, WhereCondition securityConstraint) {
        SQLAndTables sqlAndTables;
        TreeSet<BusinessTable> treeSet = new TreeSet<BusinessTable>();
        for (Selection selection : selections) {
            sqlAndTables = SQLGenerator.getBusinessColumnSQL(model, selection, null, databaseMeta, locale);
            for (BusinessTable businessTable : sqlAndTables.getUsedTables()) {
                treeSet.add(businessTable);
            }
        }
        for (WhereCondition condition : conditions) {
            List<Selection> cols = condition.getBusinessColumns();
            for (Selection selection : cols) {
                BusinessTable businessTable = selection.getBusinessColumn().getBusinessTable();
                treeSet.add(businessTable);
            }
        }
        for (OrderBy order : orderBy) {
            sqlAndTables = SQLGenerator.getBusinessColumnSQL(model, order.getSelection(), null, databaseMeta, locale);
            for (BusinessTable businessTable : sqlAndTables.getUsedTables()) {
                treeSet.add(businessTable);
            }
        }
        if (securityConstraint != null) {
            List<Selection> cols = securityConstraint.getBusinessColumns();
            for (Selection col : cols) {
                BusinessTable businessTable = col.getBusinessColumn().getBusinessTable();
                treeSet.add(businessTable);
            }
        }
        return new ArrayList<BusinessTable>(treeSet);
    }

    public boolean hasFactsInIt(BusinessModel model, List<Selection> selections, List<WhereCondition> conditions, DatabaseMeta databaseMeta, String locale) {
        for (Selection selection : selections) {
            if (!this.hasFactsInIt(model, selection, databaseMeta, locale)) continue;
            return true;
        }
        if (conditions != null) {
            for (WhereCondition condition : conditions) {
                for (Selection conditionColumn : condition.getBusinessColumns()) {
                    if (!this.hasFactsInIt(model, conditionColumn, databaseMeta, locale)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasFactsInIt(BusinessModel model, Selection businessColumn, DatabaseMeta databaseMeta, String locale) {
        if (businessColumn.hasAggregate()) {
            return true;
        }
        SQLAndTables sqlAndTables = SQLGenerator.getBusinessColumnSQL(model, businessColumn, null, databaseMeta, locale);
        for (Selection column : sqlAndTables.getUsedColumns()) {
            if (!column.hasAggregate()) continue;
            return true;
        }
        return false;
    }

    public <T> List<List<T>> getSubsetsOfSize(int size, List<T> list) {
        if (size <= 0) {
            return new ArrayList<List<T>>();
        }
        return SQLGenerator.getSubsets(0, size, new ArrayList(), list);
    }

    public static <T> List<List<T>> getSubsets(int indexToStart, int subSize, List<T> toClone, List<T> origList) {
        ArrayList<List<T>> allSubsets = new ArrayList<List<T>>();
        for (int i = indexToStart; i <= origList.size() - subSize; ++i) {
            ArrayList<T> subset = new ArrayList<T>(toClone);
            subset.add(origList.get(i));
            if (subSize == 1) {
                allSubsets.add(subset);
                continue;
            }
            allSubsets.addAll(SQLGenerator.getSubsets(i + 1, subSize - 1, subset, origList));
        }
        return allSubsets;
    }

    public Path getShortestPathBetweenOrig(BusinessModel model, List<BusinessTable> tables) {
        Path path;
        ArrayList<Path> paths = new ArrayList<Path>();
        ArrayList<BusinessTable> origSelectedTables = new ArrayList<BusinessTable>(tables);
        boolean allUsed = tables.size() == 0;
        List<BusinessTable> notSelectedTables = this.getNonSelectedTables(model, origSelectedTables);
        for (int ns = 0; ns <= notSelectedTables.size() && !allUsed; ++ns) {
            List<List<BusinessTable>> uniqueCombos = this.getSubsetsOfSize(ns, notSelectedTables);
            if (ns == 0) {
                uniqueCombos.add(new ArrayList());
            }
            for (int i = 0; i < uniqueCombos.size(); ++i) {
                List<BusinessTable> uc = uniqueCombos.get(i);
                uc.addAll(origSelectedTables);
            }
            for (int p = 0; p < uniqueCombos.size(); ++p) {
                List<BusinessTable> selectedTables = uniqueCombos.get(p);
                path = new Path();
                for (int i = 0; i < selectedTables.size(); ++i) {
                    for (int j = i + 1; j < selectedTables.size(); ++j) {
                        BusinessTable two;
                        BusinessTable one = selectedTables.get(i);
                        RelationshipMeta relationship = model.findRelationshipUsing(one, two = selectedTables.get(j));
                        if (relationship == null || path.contains(relationship)) continue;
                        path.addRelationship(relationship);
                    }
                    if (path.size() != selectedTables.size() - 1) continue;
                    paths.add(path);
                    allUsed = true;
                }
            }
        }
        int minSize = Integer.MAX_VALUE;
        int minScore = Integer.MAX_VALUE;
        Path minPath = null;
        for (int i = 0; i < paths.size(); ++i) {
            path = (Path)paths.get(i);
            if (path.size() >= minSize && (path.size() != minSize || path.score() >= minScore)) continue;
            minPath = path;
            minScore = path.score();
            minSize = path.size();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Exiting getShortestPathBetween() " + tables + "  with result " + minPath));
        }
        return minPath;
    }

    public Path getShortestPathBetween(BusinessModel model, List<BusinessTable> tables) {
        Path p;
        ConceptInterface concept;
        ConceptPropertyInterface pathMethod;
        logger.debug((Object)"Enter getShortestPathBetween() - new");
        if (tables.size() == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Optimization 1 - one table = empty path.");
            }
            return new Path();
        }
        if (tables.size() == 2) {
            List<RelationshipMeta> rels = model.getRelationships();
            BusinessTable t1 = tables.get(0);
            BusinessTable t2 = tables.get(1);
            BusinessTable t3 = null;
            BusinessTable t4 = null;
            for (RelationshipMeta rel : rels) {
                t3 = rel.getTableFrom();
                t4 = rel.getTableTo();
                if ((!t3.equals(t1) || !t4.equals(t2)) && (!t3.equals(t2) || !t4.equals(t1))) continue;
                Path rtn = new Path();
                rtn.addRelationship(rel);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Optimization 2 - two tables + matching relation: " + rtn));
                }
                return rtn;
            }
        }
        String pathMethodString = (pathMethod = (concept = model.getConcept()).getProperty("path_build_method")) != null && pathMethod.getType().equals(ConceptPropertyType.STRING) ? (String)pathMethod.getValue() : (this.preferClassicShortestPath ? "CLASSIC" : "SHORTEST");
        PathType pathBuildMethod = null;
        if (pathMethodString.equals("CLASSIC")) {
            return this.getShortestPathBetweenOrig(model, tables);
        }
        pathBuildMethod = PathType.valueOf(pathMethodString);
        MqlGraph graph = new MqlGraph(model);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempting to build path using technique: " + (Object)((Object)pathBuildMethod)));
        }
        if ((p = graph.getPath(pathBuildMethod, tables)) == null) {
            logger.debug((Object)"Unable to calculate shortest path for query, no path found");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Exiting getShortestPathBetween() " + tables + "  with result " + p));
        }
        return p;
    }

    protected List<BusinessTable> getNonSelectedTables(BusinessModel model, List<BusinessTable> selectedTables) {
        ArrayList<BusinessTableNeighbours> extra = new ArrayList<BusinessTableNeighbours>(model.nrBusinessTables());
        ArrayList<BusinessTable> unused = new ArrayList<BusinessTable>();
        ArrayList<BusinessTable> used = new ArrayList<BusinessTable>(selectedTables);
        for (int i = 0; i < model.nrBusinessTables(); ++i) {
            unused.add(model.getBusinessTable(i));
        }
        boolean anyFound = true;
        while (anyFound) {
            anyFound = false;
            Iterator iter = unused.iterator();
            while (iter.hasNext()) {
                boolean found = false;
                BusinessTable check = (BusinessTable)iter.next();
                for (int j = 0; j < used.size(); ++j) {
                    BusinessTable businessTable = (BusinessTable)used.get(j);
                    if (!check.equals(businessTable)) continue;
                    found = true;
                }
                if (found) continue;
                BusinessTableNeighbours btn = new BusinessTableNeighbours();
                btn.businessTable = check;
                btn.nrNeighbours = model.getNrNeighbours(check, used);
                if (btn.nrNeighbours <= 0) continue;
                extra.add(btn);
                used.add(check);
                iter.remove();
                anyFound = true;
            }
        }
        Collections.sort(extra);
        ArrayList<BusinessTable> retval = new ArrayList<BusinessTable>(extra.size());
        for (int i = 0; i < extra.size(); ++i) {
            BusinessTableNeighbours btn = (BusinessTableNeighbours)extra.get(i);
            if (btn.nrNeighbours <= 0) continue;
            retval.add(0, btn.businessTable);
        }
        return retval;
    }

    public static SQLAndTables getBusinessColumnSQL(BusinessModel businessModel, Selection column, Map<BusinessTable, String> tableAliases, DatabaseMeta databaseMeta, String locale) {
        if (column.getBusinessColumn().isExact()) {
            try {
                PMSFormula formula = new PMSFormula(businessModel, column.getBusinessColumn().getBusinessTable(), databaseMeta, column.getBusinessColumn().getFormula(), tableAliases);
                formula.parseAndValidate();
                String formulaSql = formula.generateSQL(locale);
                if (column.hasAggregate() && !SQLGenerator.hasAggregateDefinedAlready(formulaSql, databaseMeta)) {
                    formulaSql = SQLGenerator.getFunctionExpression(column, formulaSql, databaseMeta);
                }
                return new SQLAndTables(formulaSql, formula.getBusinessTables(), formula.getBusinessColumns());
            }
            catch (PentahoMetadataException e) {
                logger.error((Object)Messages.getErrorString("BusinessColumn.ERROR_0001_FAILED_TO_PARSE_FORMULA", column.getBusinessColumn().getFormula()), (Throwable)e);
                return new SQLAndTables(column.getBusinessColumn().getFormula(), column.getBusinessColumn().getBusinessTable(), column);
            }
        }
        String tableColumn = "";
        String tableAlias = null;
        tableAlias = tableAliases != null ? tableAliases.get(column.getBusinessColumn().getBusinessTable()) : column.getBusinessColumn().getBusinessTable().getId();
        tableColumn = tableColumn + databaseMeta.quoteField(tableAlias);
        tableColumn = tableColumn + ".";
        tableColumn = tableColumn + databaseMeta.quoteField(column.getBusinessColumn().getFormula());
        if (column.hasAggregate()) {
            return new SQLAndTables(SQLGenerator.getFunctionExpression(column, tableColumn, databaseMeta), column.getBusinessColumn().getBusinessTable(), column);
        }
        return new SQLAndTables(tableColumn, column.getBusinessColumn().getBusinessTable(), column);
    }

    private static boolean hasAggregateDefinedAlready(String sql, DatabaseMeta databaseMeta) {
        String trimmed = sql.trim();
        return trimmed.startsWith(databaseMeta.getFunctionAverage() + "(") || trimmed.startsWith(databaseMeta.getFunctionCount() + "(") || trimmed.startsWith(databaseMeta.getFunctionMaximum() + "(") || trimmed.startsWith(databaseMeta.getFunctionMinimum() + "(") || trimmed.startsWith(databaseMeta.getFunctionSum() + "(");
    }

    public static String getFunctionExpression(Selection column, String tableColumn, DatabaseMeta databaseMeta) {
        String expression = SQLGenerator.getFunction(column, databaseMeta);
        switch (column.getActiveAggregationType().getType()) {
            case 4: {
                expression = expression + "(DISTINCT " + tableColumn + ")";
                break;
            }
            default: {
                expression = expression + "(" + tableColumn + ")";
            }
        }
        return expression;
    }

    public static String getFunction(Selection column, DatabaseMeta databaseMeta) {
        String fn = "";
        switch (column.getActiveAggregationType().getType()) {
            case 2: {
                fn = databaseMeta.getFunctionAverage();
                break;
            }
            case 3: 
            case 4: {
                fn = databaseMeta.getFunctionCount();
                break;
            }
            case 6: {
                fn = databaseMeta.getFunctionMaximum();
                break;
            }
            case 5: {
                fn = databaseMeta.getFunctionMinimum();
                break;
            }
            case 1: {
                fn = databaseMeta.getFunctionSum();
                break;
            }
        }
        return fn;
    }

    public String getJoin(BusinessModel businessModel, RelationshipMeta relation, Map<BusinessTable, String> tableAliases, DatabaseMeta databaseMeta, String locale) {
        String join = "";
        if (relation.isComplex()) {
            try {
                PMSFormula formula = new PMSFormula(businessModel, databaseMeta, relation.getComplexJoin(), tableAliases);
                formula.parseAndValidate();
                join = formula.generateSQL(locale);
            }
            catch (PentahoMetadataException e) {
                logger.error((Object)Messages.getErrorString("MQLQueryImpl.ERROR_0017_FAILED_TO_PARSE_COMPLEX_JOIN", relation.getComplexJoin()), (Throwable)e);
                join = relation.getComplexJoin();
            }
        } else if (relation.getTableFrom() != null && relation.getTableTo() != null && relation.getFieldFrom() != null && relation.getFieldTo() != null) {
            String leftTableAlias = null;
            leftTableAlias = tableAliases != null ? tableAliases.get(relation.getFieldFrom().getBusinessTable()) : relation.getFieldFrom().getBusinessTable().getId();
            join = databaseMeta.quoteField(leftTableAlias);
            join = join + ".";
            join = join + databaseMeta.quoteField(relation.getFieldFrom().getFormula());
            join = join + " = ";
            String rightTableAlias = null;
            rightTableAlias = tableAliases != null ? tableAliases.get(relation.getFieldTo().getBusinessTable()) : relation.getFieldTo().getBusinessTable().getId();
            join = join + databaseMeta.quoteField(rightTableAlias);
            join = join + ".";
            join = join + databaseMeta.quoteField(relation.getFieldTo().getFormula());
        } else {
            logger.error((Object)Messages.getErrorString("SQLGenerator.ERROR_0001_INVALID_RELATION", relation.toString()));
        }
        return join;
    }

    protected class BusinessTableNeighbours
    implements Comparable<BusinessTableNeighbours> {
        public BusinessTable businessTable;
        public int nrNeighbours;

        protected BusinessTableNeighbours() {
        }

        @Override
        public int compareTo(BusinessTableNeighbours obj) {
            if (this.nrNeighbours == obj.nrNeighbours) {
                return this.businessTable.compareTo(obj.businessTable);
            }
            return new Integer(this.nrNeighbours).compareTo(new Integer(obj.nrNeighbours));
        }
    }
}

