/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.sqoop.mapreduce.SqoopMapper;

public class AutoProgressMapper<KEYIN, VALIN, KEYOUT, VALOUT>
extends SqoopMapper<KEYIN, VALIN, KEYOUT, VALOUT> {
    public static final Log LOG = LogFactory.getLog((String)AutoProgressMapper.class.getName());
    private int maxProgressPeriod;
    private int sleepInterval;
    private int reportInterval;
    public static final String MAX_PROGRESS_PERIOD_KEY = "sqoop.mapred.auto.progress.max";
    public static final String SLEEP_INTERVAL_KEY = "sqoop.mapred.auto.progress.sleep";
    public static final String REPORT_INTERVAL_KEY = "sqoop.mapred.auto.progress.report";
    public static final int DEFAULT_SLEEP_INTERVAL = 10000;
    public static final int DEFAULT_REPORT_INTERVAL = 30000;
    public static final int DEFAULT_MAX_PROGRESS = 0;

    private void configureAutoProgress(Configuration job) {
        this.maxProgressPeriod = job.getInt(MAX_PROGRESS_PERIOD_KEY, 0);
        this.sleepInterval = job.getInt(SLEEP_INTERVAL_KEY, 10000);
        this.reportInterval = job.getInt(REPORT_INTERVAL_KEY, 30000);
        if (this.reportInterval < 1) {
            LOG.warn((Object)"Invalid sqoop.mapred.auto.progress.report; setting to 30000");
            this.reportInterval = 30000;
        }
        if (this.sleepInterval > this.reportInterval || this.sleepInterval < 1) {
            LOG.warn((Object)"Invalid sqoop.mapred.auto.progress.sleep; setting to 10000");
            this.sleepInterval = 10000;
        }
        if (this.maxProgressPeriod < 0) {
            LOG.warn((Object)"Invalid sqoop.mapred.auto.progress.max; setting to 0");
            this.maxProgressPeriod = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Mapper.Context context) throws IOException, InterruptedException {
        this.configureAutoProgress(context.getConfiguration());
        ProgressThread thread = new ProgressThread(context);
        try {
            thread.setDaemon(true);
            thread.start();
            super.run(context);
        }
        finally {
            LOG.debug((Object)"Instructing auto-progress thread to quit.");
            thread.signalShutdown();
            try {
                LOG.debug((Object)"Waiting for progress thread shutdown...");
                thread.join();
                LOG.debug((Object)"Progress thread shutdown detected.");
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)("Interrupted when waiting on auto-progress thread: " + ie.toString()));
            }
        }
    }

    private class ProgressThread
    extends Thread {
        private volatile boolean keepGoing;
        private Mapper.Context context;
        private long startTimeMillis;
        private long lastReportMillis;

        public ProgressThread(Mapper.Context ctxt) {
            this.context = ctxt;
            this.keepGoing = true;
        }

        public void signalShutdown() {
            this.keepGoing = false;
            this.interrupt();
        }

        @Override
        public void run() {
            this.startTimeMillis = this.lastReportMillis = System.currentTimeMillis();
            long MAX_PROGRESS = AutoProgressMapper.this.maxProgressPeriod;
            long REPORT_INTERVAL = AutoProgressMapper.this.reportInterval;
            long SLEEP_INTERVAL = AutoProgressMapper.this.sleepInterval;
            while (this.keepGoing) {
                long curTimeMillis = System.currentTimeMillis();
                if (MAX_PROGRESS != 0L && curTimeMillis - this.startTimeMillis > MAX_PROGRESS) {
                    this.keepGoing = false;
                    LOG.info((Object)("Auto-progress thread exiting after " + MAX_PROGRESS + " ms."));
                    break;
                }
                if (curTimeMillis - this.lastReportMillis > REPORT_INTERVAL) {
                    LOG.debug((Object)"Auto-progress thread reporting progress");
                    this.context.progress();
                    this.lastReportMillis = curTimeMillis;
                }
                if (Thread.interrupted()) continue;
                try {
                    Thread.sleep(SLEEP_INTERVAL);
                }
                catch (InterruptedException ie) {}
            }
            LOG.info((Object)("Auto-progress thread is finished. keepGoing=" + this.keepGoing));
        }
    }
}

