/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.webdav;

import java.net.URLStreamHandler;
import java.util.Collection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.DefaultURLStreamHandler;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.http.HttpFileSystem;
import org.apache.commons.vfs.provider.webdav.WebdavFileObject;
import org.apache.commons.vfs.provider.webdav.WebdavFileProvider;

public class WebdavFileSystem
extends HttpFileSystem
implements FileSystem {
    protected WebdavFileSystem(GenericFileName genericFileName, HttpClient httpClient, FileSystemOptions fileSystemOptions) {
        super(genericFileName, httpClient, fileSystemOptions);
    }

    protected HttpClient getClient() {
        return super.getClient();
    }

    protected void addCapabilities(Collection collection) {
        collection.addAll(WebdavFileProvider.capabilities);
    }

    protected FileObject createFile(FileName fileName) {
        return new WebdavFileObject(fileName, this);
    }

    public URLStreamHandler getURLStreamHandler() {
        return new DefaultURLStreamHandler(this.getContext(), this.getFileSystemOptions());
    }
}

