/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cassandra.legacy;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.DynamicCompositeType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LexicalUUIDType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.KsDef;
import org.pentaho.cassandra.legacy.CassandraConnection;
import org.pentaho.cassandra.legacy.LegacyKeyspace;
import org.pentaho.cassandra.spi.ColumnFamilyMetaData;
import org.pentaho.cassandra.spi.Keyspace;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;

public class CassandraColumnMetaData
implements ColumnFamilyMetaData {
    protected static final Class<?> PKG = CassandraColumnMetaData.class;
    public static final String UTF8 = "UTF-8";
    protected String m_columnFamilyName;
    protected List<String> m_keyColumnNames;
    protected String m_keyValidator;
    protected String m_columnComparator;
    protected String m_columnNameEncoding;
    protected String m_defaultValidationClass;
    protected Map<String, String> m_columnMeta;
    protected Map<String, ValueMetaInterface> m_kettleColumnMeta;
    protected Map<String, HashSet<Object>> m_indexedVals;
    protected StringBuffer m_schemaDescription;
    protected LegacyKeyspace m_keyspace;
    protected boolean m_cql3;

    public CassandraColumnMetaData(LegacyKeyspace keyspace, String columnFamily, boolean cql3) throws Exception {
        this.m_cql3 = cql3;
        this.m_keyspace = keyspace;
        this.m_columnFamilyName = columnFamily;
        this.refresh((CassandraConnection)this.m_keyspace.getConnection());
    }

    @Override
    public void setKeyspace(Keyspace k) {
        this.m_keyspace = (LegacyKeyspace)k;
    }

    @Override
    public void setColumnFamilyName(String colFamName) {
        this.m_columnFamilyName = colFamName;
    }

    public String getDefaultValidationClass() {
        return this.m_defaultValidationClass;
    }

    protected void refreshCQL3(CassandraConnection conn) throws Exception {
        Object colName;
        Column type;
        Column minComp;
        Column defWrite;
        Column defRead;
        Column compression;
        Object compV;
        Column compaction;
        Column caching;
        int i;
        String colName2;
        List<String> colFamNames = this.m_keyspace.getColumnFamilyNames();
        if (!colFamNames.contains(this.m_columnFamilyName)) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.UnableToFindRequestedColumnFamily", (String[])new String[]{this.m_columnFamilyName, conn.m_keyspaceName}));
        }
        ConsistencyLevel c = ConsistencyLevel.ONE;
        Compression z = Compression.NONE;
        this.m_columnMeta = new LinkedHashMap<String, String>();
        this.m_indexedVals = new HashMap<String, HashSet<Object>>();
        this.m_keyColumnNames = new ArrayList<String>();
        this.m_schemaDescription = new StringBuffer();
        String columnFamNameAdditionalInfo = "";
        String cqlQ = "select comparator, default_validator, column_aliases, key_aliases, key_validator, bloom_filter_fp_chance, caching, compaction_strategy_class, compaction_strategy_options, compression_parameters, default_read_consistency, default_write_consistency, gc_grace_seconds, local_read_repair_chance, max_compaction_threshold, min_compaction_threshold, populate_io_cache_on_flush, read_repair_chance, replicate_on_write, type, value_alias from system.schema_columnfamilies where keyspace_name='" + conn.m_keyspaceName + "' and columnfamily_name='" + this.m_columnFamilyName + "';";
        byte[] data = cqlQ.getBytes(Charset.forName(UTF8));
        CqlResult result = conn.m_client.execute_cql3_query(ByteBuffer.wrap(data), z, c);
        List rl = result.getRows();
        if (rl.size() != 1) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.CQLQueryToObtainMetaData", (String[])new String[]{this.m_columnFamilyName}));
        }
        cqlQ = "select column_name, validator, index_name from system.schema_columns where keyspace_name='" + conn.m_keyspaceName + "' AND columnfamily_name='" + this.m_columnFamilyName + "';";
        data = cqlQ.getBytes(Charset.forName(UTF8));
        CqlResult result2 = conn.m_client.execute_cql3_query(ByteBuffer.wrap(data), z, c);
        List rl2 = result2.getRows();
        UTF8Type deserializer = UTF8Type.instance;
        CqlRow row = (CqlRow)rl.get(0);
        List cols = row.getColumns();
        Column keyCols = (Column)cols.get(2);
        Object keyColsS = deserializer.compose(keyCols.bufferForValue());
        String p = keyColsS.toString().trim();
        String[] colAliasParts = p.split(",");
        int numColAliases = p.equals("[]") ? 0 : colAliasParts.length;
        boolean compactStorage = false;
        String compactStorageColumnComparator = null;
        ArrayList<String> decodersForAdditionalCompoundKeyCols = new ArrayList<String>();
        ArrayList<String> namesOfAdditionalCompoundKeyCols = new ArrayList<String>();
        Column compCol = (Column)cols.get(0);
        Object decodedComp = deserializer.compose(compCol.bufferForValue());
        String pOrig = p = decodedComp.toString();
        if (p.indexOf(40) > 0) {
            String[] parts = (p = p.substring(p.indexOf(40) + 1, p.length() - 1).trim()).split(",");
            if (parts.length - 1 != numColAliases) {
                compactStorage = true;
            }
            if (!compactStorage) {
                this.m_columnComparator = parts[parts.length - 1].trim();
            } else {
                this.m_columnComparator = "org.apache.cassandra.db.marshal.UTF8Type";
                compactStorageColumnComparator = pOrig.trim();
            }
            for (int i2 = 0; i2 < (compactStorage ? parts.length : parts.length - 1); ++i2) {
                decodersForAdditionalCompoundKeyCols.add(parts[i2].trim());
            }
        } else {
            this.m_columnComparator = p.trim();
            compactStorageColumnComparator = pOrig.trim();
            compactStorage = true;
        }
        if (compactStorage) {
            columnFamNameAdditionalInfo = " (COMPACT STORAGE)";
        }
        Column defaultV = (Column)cols.get(1);
        Object decodedValidator = deserializer.compose(defaultV.bufferForValue());
        this.m_defaultValidationClass = decodedValidator.toString();
        if (decodersForAdditionalCompoundKeyCols.size() > 0 && !compactStorage) {
            for (int i3 = 0; i3 < colAliasParts.length; ++i3) {
                colName2 = colAliasParts[i3].replace("[", "").replace("]", "").replace("\"", "").trim();
                namesOfAdditionalCompoundKeyCols.add(colName2);
                this.m_columnMeta.put(colName2, (String)decodersForAdditionalCompoundKeyCols.get(i3));
            }
        } else if (compactStorage && rl2.size() == 0) {
            Object valueAliasS;
            Column valueAlias;
            columnFamNameAdditionalInfo = " (COMPACT STORAGE dynamic column family)";
            if (decodersForAdditionalCompoundKeyCols.size() == 0) {
                if (numColAliases == 0) {
                    namesOfAdditionalCompoundKeyCols.add("column1");
                    this.m_columnMeta.put("column1", this.m_columnComparator);
                } else {
                    String colName3 = colAliasParts[0].replace("[", "").replace("]", "").replace("\"", "").trim();
                    namesOfAdditionalCompoundKeyCols.add(colName3);
                    this.m_columnMeta.put(colName3, this.m_columnComparator);
                }
                valueAlias = (Column)cols.get(20);
                if (valueAlias != null && valueAlias.bufferForValue() != null) {
                    valueAliasS = deserializer.compose(valueAlias.bufferForValue());
                    this.m_columnMeta.put(valueAliasS.toString().trim(), this.m_defaultValidationClass);
                } else {
                    this.m_columnMeta.put("value", this.m_defaultValidationClass);
                }
            } else {
                for (int i4 = 0; i4 < decodersForAdditionalCompoundKeyCols.size(); ++i4) {
                    colName2 = "";
                    colName2 = numColAliases != 0 ? colAliasParts[i4].replace("[", "").replace("]", "").replace("\"", "").trim() : "column" + (i4 + 1);
                    namesOfAdditionalCompoundKeyCols.add(colName2);
                    this.m_columnMeta.put(colName2, (String)decodersForAdditionalCompoundKeyCols.get(i4));
                }
                valueAlias = (Column)cols.get(20);
                if (valueAlias != null && valueAlias.bufferForValue() != null) {
                    valueAliasS = deserializer.compose(valueAlias.bufferForValue());
                    this.m_columnMeta.put(valueAliasS.toString().trim(), this.m_defaultValidationClass);
                } else {
                    this.m_columnMeta.put("value", this.m_defaultValidationClass);
                }
            }
            this.m_columnComparator = "org.apache.cassandra.db.marshal.UTF8Type";
        }
        boolean compoundKey = namesOfAdditionalCompoundKeyCols.size() > 0;
        String keyName = "key";
        ArrayList<String> partitionKeyNames = new ArrayList<String>();
        Column keyV = (Column)cols.get(4);
        Object kV = deserializer.compose(keyV.bufferForValue());
        String keyValParts = this.m_keyValidator = kV.toString().trim();
        ArrayList<String> decodersForPartitionKeyParts = new ArrayList<String>();
        if (keyValParts.indexOf("(") > 0) {
            String[] kvp;
            keyValParts = keyValParts.substring(keyValParts.indexOf(40) + 1, keyValParts.length() - 1).trim();
            for (String k : kvp = keyValParts.split(",")) {
                decodersForPartitionKeyParts.add(k.trim());
            }
        }
        LinkedHashMap<String, String> tempColMeta = new LinkedHashMap<String, String>();
        Column keyAlias = (Column)cols.get(3);
        if (keyAlias != null && keyAlias.bufferForValue() != null) {
            Object alias = deserializer.compose(keyAlias.bufferForValue());
            String aliasS = alias.toString();
            if (aliasS.equals("[]")) {
                if (decodersForPartitionKeyParts.size() == 0) {
                    keyName = "key";
                    tempColMeta.put(keyName, this.m_keyValidator);
                    this.m_keyColumnNames.add(keyName);
                    partitionKeyNames.add(keyName);
                } else {
                    keyName = "key";
                    tempColMeta.put(keyName, (String)decodersForPartitionKeyParts.get(0));
                    this.m_keyColumnNames.add(keyName);
                    partitionKeyNames.add(keyName);
                    for (int i5 = 1; i5 < decodersForPartitionKeyParts.size(); ++i5) {
                        keyName = "key" + (i5 + 1);
                        tempColMeta.put(keyName, (String)decodersForPartitionKeyParts.get(i5));
                        this.m_keyColumnNames.add(keyName);
                        partitionKeyNames.add(keyName);
                    }
                }
            } else {
                colAliasParts = aliasS.trim().split(",");
                if (decodersForPartitionKeyParts.size() == 0) {
                    keyName = colAliasParts[0].replace("[", "").replace("]", "").replace("\"", "").trim();
                    tempColMeta.put(keyName, this.m_keyValidator);
                    this.m_keyColumnNames.add(keyName);
                    partitionKeyNames.add(keyName);
                } else {
                    for (int i6 = 0; i6 < decodersForPartitionKeyParts.size(); ++i6) {
                        keyName = colAliasParts[i6].replace("[", "").replace("]", "").replace("\"", "").trim();
                        tempColMeta.put(keyName, (String)decodersForPartitionKeyParts.get(i6));
                        this.m_keyColumnNames.add(keyName);
                        partitionKeyNames.add(keyName);
                    }
                }
            }
        }
        tempColMeta.putAll(this.m_columnMeta);
        this.m_columnMeta = tempColMeta;
        this.m_schemaDescription.append("Column family: " + this.m_columnFamilyName + columnFamNameAdditionalInfo);
        String keyDescription = "\n\n\tKey" + (compoundKey ? (partitionKeyNames.size() > 1 ? " ((composite) compound): " : " (compound): ") : " : ");
        this.m_schemaDescription.append(keyDescription);
        if (partitionKeyNames.size() == 1) {
            this.m_schemaDescription.append((String)partitionKeyNames.get(0));
        } else {
            this.m_schemaDescription.append("(");
            for (i = 0; i < partitionKeyNames.size(); ++i) {
                this.m_schemaDescription.append((String)partitionKeyNames.get(i));
                this.m_schemaDescription.append(i == partitionKeyNames.size() - 1 ? "" : ", ");
            }
            this.m_schemaDescription.append(")");
        }
        for (i = 0; i < namesOfAdditionalCompoundKeyCols.size(); ++i) {
            if (i < namesOfAdditionalCompoundKeyCols.size()) {
                this.m_schemaDescription.append(", ");
            }
            this.m_schemaDescription.append((String)namesOfAdditionalCompoundKeyCols.get(i));
            this.m_keyColumnNames.add((String)namesOfAdditionalCompoundKeyCols.get(i));
        }
        this.m_schemaDescription.append("\n\tPartition key validator: " + this.m_keyValidator);
        this.m_schemaDescription.append("\n\tColumn comparator: " + (compactStorageColumnComparator != null ? compactStorageColumnComparator : this.m_columnComparator));
        this.m_schemaDescription.append("\n\tDefault column validator: " + this.m_defaultValidationClass);
        DoubleType axDeserializer = null;
        Column bf = (Column)cols.get(5);
        axDeserializer = DoubleType.instance;
        if (bf != null && bf.bufferForValue() != null) {
            Object bfv = axDeserializer.compose(bf.bufferForValue());
            this.m_schemaDescription.append("\n\tBloom filter fp chance: " + bfv.toString());
        }
        if ((caching = (Column)cols.get(6)) != null && caching.bufferForValue() != null) {
            Object cachV = deserializer.compose(caching.bufferForValue());
            this.m_schemaDescription.append("\n\tCaching: " + cachV.toString());
        }
        if ((compaction = (Column)cols.get(7)) != null && compaction.bufferForValue() != null) {
            compV = deserializer.compose(compaction.bufferForValue());
            this.m_schemaDescription.append("\n\tCompaction strategy: " + compV.toString());
        }
        if ((compaction = (Column)cols.get(8)) != null && compaction.bufferForValue() != null) {
            compV = deserializer.compose(compaction.bufferForValue());
            this.m_schemaDescription.append("\n\tCompaction strategy options: " + compV.toString());
        }
        if ((compression = (Column)cols.get(9)) != null && compression.bufferForValue() != null) {
            Object compV2 = deserializer.compose(compression.bufferForValue());
            this.m_schemaDescription.append("\n\tCompression parameters: " + compV2.toString());
        }
        if ((defRead = (Column)cols.get(10)) != null && defRead.bufferForValue() != null) {
            Object readV = deserializer.compose(defRead.bufferForValue());
            this.m_schemaDescription.append("\n\tDefault read consistency: " + readV.toString());
        }
        if ((defWrite = (Column)cols.get(11)) != null && defWrite.bufferForValue() != null) {
            Object writeV = deserializer.compose(defWrite.bufferForValue());
            this.m_schemaDescription.append("\n\tDefault write consistency: " + writeV.toString());
        }
        Column gc = (Column)cols.get(12);
        axDeserializer = IntegerType.instance;
        if (gc != null && gc.bufferForValue() != null) {
            Object gcV = axDeserializer.compose(gc.bufferForValue());
            this.m_schemaDescription.append("\n\tGC grace seconds: " + gcV.toString());
        }
        Column localRead = (Column)cols.get(13);
        axDeserializer = DoubleType.instance;
        if (localRead != null && localRead.bufferForValue() != null) {
            Object localV = axDeserializer.compose(localRead.bufferForValue());
            this.m_schemaDescription.append("\n\tLocal read repair chance: " + localV.toString());
        }
        Column maxComp = (Column)cols.get(14);
        axDeserializer = IntegerType.instance;
        if (maxComp != null && maxComp.bufferForValue() != null) {
            Object compV3 = axDeserializer.compose(maxComp.bufferForValue());
            this.m_schemaDescription.append("\n\tMax compaction threshold: " + compV3.toString());
        }
        if ((minComp = (Column)cols.get(15)) != null && minComp.bufferForValue() != null) {
            Object compV4 = axDeserializer.compose(minComp.bufferForValue());
            this.m_schemaDescription.append("\n\tMin compaction threshold: " + compV4.toString());
        }
        Column pop = (Column)cols.get(16);
        axDeserializer = BooleanType.instance;
        if (pop != null && pop.bufferForValue() != null) {
            Object popV = axDeserializer.compose(pop.bufferForValue());
            this.m_schemaDescription.append("\n\tPopulate IO cache on flush: " + popV.toString());
        }
        Column readRep = (Column)cols.get(17);
        axDeserializer = DoubleType.instance;
        if (readRep != null && readRep.bufferForValue() != null) {
            Object readV = axDeserializer.compose(readRep.bufferForValue());
            this.m_schemaDescription.append("\n\tRead repair chance: " + readV.toString());
        }
        Column repWrite = (Column)cols.get(18);
        axDeserializer = BooleanType.instance;
        if (repWrite != null && repWrite.bufferForValue() != null) {
            Object repV = axDeserializer.compose(repWrite.bufferForValue());
            this.m_schemaDescription.append("\n\tReplicate on write: " + repV.toString());
        }
        if ((type = (Column)cols.get(19)) != null && type.bufferForValue() != null) {
            Object typeV = deserializer.compose(type.bufferForValue());
            this.m_schemaDescription.append("\n\tType: " + typeV.toString());
        }
        this.m_schemaDescription.append("\n\n\tColumn metadata:");
        for (Map.Entry<String, String> e : this.m_columnMeta.entrySet()) {
            this.m_schemaDescription.append("\n\tColumn name: " + e.getKey());
            this.m_schemaDescription.append("\n\t\tColumn validator: " + e.getValue());
        }
        for (CqlRow r : rl2) {
            Object decodedIndexN;
            cols = r.getColumns();
            colName = (Column)cols.get(0);
            Column colV = (Column)cols.get(1);
            Column indexN = (Column)cols.get(2);
            Object decodedColName = deserializer.compose(colName.bufferForValue());
            Object decodedColValidator = deserializer.compose(colV.bufferForValue());
            this.m_columnMeta.put(decodedColName.toString().replace("\"", "").replace("'", "").trim(), decodedColValidator.toString().trim());
            this.m_schemaDescription.append("\n\tColumn name: " + decodedColName.toString().replace("\"", "").replace("'", "").trim());
            this.m_schemaDescription.append("\n\t\tColumn validator: " + decodedColValidator.toString().trim());
            if (indexN == null || indexN.bufferForValue() == null || (decodedIndexN = deserializer.compose(indexN.bufferForValue())) == null || decodedIndexN.toString().trim().length() <= 0) continue;
            this.m_schemaDescription.append("\n\t\tIndex name: " + decodedIndexN.toString().trim());
        }
        this.m_kettleColumnMeta = new HashMap<String, ValueMetaInterface>();
        for (Map.Entry<String, String> e : this.m_columnMeta.entrySet()) {
            colName = e.getKey();
            this.m_kettleColumnMeta.put((String)colName, this.getValueMetaForColumn((String)colName));
        }
    }

    public void refresh(CassandraConnection conn) throws Exception {
        String colName;
        Iterator colMetaData;
        ByteBuffer b;
        if (this.m_cql3) {
            this.refreshCQL3(conn);
            return;
        }
        this.m_schemaDescription = new StringBuffer();
        KsDef keySpace = conn.describeKeyspace();
        List colFams = null;
        if (keySpace == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.UnableToGetMetaDataForKeyspace", (String[])new String[]{conn.m_keyspaceName}));
        }
        colFams = keySpace.getCf_defs();
        this.m_columnMeta = new LinkedHashMap<String, String>();
        this.m_indexedVals = new HashMap<String, HashSet<Object>>();
        this.m_keyColumnNames = new ArrayList<String>();
        CfDef colDefs = null;
        for (CfDef fam : colFams) {
            String columnFamilyName = fam.getName();
            if (!columnFamilyName.equals(this.m_columnFamilyName)) continue;
            this.m_schemaDescription.append("Column family: " + this.m_columnFamilyName);
            this.m_keyValidator = fam.getKey_validation_class();
            this.m_columnComparator = fam.getComparator_type();
            b = fam.key_alias;
            String keyName = "KEY";
            if (b != null) {
                String keyNameDecoder = "org.apache.cassandra.db.marshal.UTF8Type";
                keyName = this.getColumnValue(b, keyNameDecoder).toString();
                this.m_schemaDescription.append("\n\tKey name: " + keyName);
            }
            this.m_columnMeta.put(keyName, this.m_keyValidator);
            this.m_keyColumnNames.add(keyName);
            this.m_defaultValidationClass = fam.getDefault_validation_class();
            this.m_schemaDescription.append("\n\tKey validator: " + this.m_keyValidator);
            if (this.m_keyValidator.contains("CompositeType")) {
                this.m_schemaDescription.append("\n\t\tWARNING: column family with composite key cannot\n\t\tbe accessed from CQL 2 - turn on \"Use Thrift IO\"");
            }
            this.m_schemaDescription.append("\n\tColumn comparator: " + this.m_columnComparator);
            this.m_schemaDescription.append("\n\tDefault column validator: " + this.m_defaultValidationClass);
            this.m_schemaDescription.append("\n\tRead repair chance: " + fam.getRead_repair_chance());
            this.m_schemaDescription.append("\n\tGC grace: " + fam.getGc_grace_seconds());
            this.m_schemaDescription.append("\n\tMin compaction threshold: " + fam.getMin_compaction_threshold());
            this.m_schemaDescription.append("\n\tMax compaction threshold: " + fam.getMax_compaction_threshold());
            this.m_schemaDescription.append("\n\tReplicate on write: " + fam.replicate_on_write);
            this.m_schemaDescription.append("\n\n\tColumn metadata:");
            colDefs = fam;
            break;
        }
        if (colDefs == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.UnableToFindRequestedColumnFamily", (String[])new String[]{this.m_columnFamilyName, conn.m_keyspaceName}));
        }
        this.m_columnNameEncoding = this.m_columnComparator;
        String comment = colDefs.getComment();
        if (comment != null && comment.length() > 0) {
            this.extractIndexedMeta(comment, this.m_indexedVals);
        }
        if ((colMetaData = colDefs.getColumn_metadataIterator()) != null) {
            while (colMetaData.hasNext()) {
                ColumnDef currentDef = (ColumnDef)colMetaData.next();
                b = ByteBuffer.wrap(currentDef.getName());
                colName = this.getColumnValue(b, this.m_columnComparator).toString();
                String colType = currentDef.getValidation_class();
                this.m_columnMeta.put(colName, colType);
                this.m_schemaDescription.append("\n\tColumn name: " + colName);
                this.m_schemaDescription.append("\n\t\tColumn validator: " + colType);
                String indexName = currentDef.getIndex_name();
                if (!Const.isEmpty((String)indexName)) {
                    this.m_schemaDescription.append("\n\t\tIndex name: " + currentDef.getIndex_name());
                }
                if (!this.m_indexedVals.containsKey(colName)) continue;
                HashSet<Object> indexedVals = this.m_indexedVals.get(colName);
                this.m_schemaDescription.append("\n\t\tLegal values: {");
                int count = 0;
                for (Object val : indexedVals) {
                    this.m_schemaDescription.append(val.toString());
                    if (++count != indexedVals.size()) {
                        this.m_schemaDescription.append(",");
                        continue;
                    }
                    this.m_schemaDescription.append("}");
                }
            }
        }
        this.m_kettleColumnMeta = new HashMap<String, ValueMetaInterface>();
        for (Map.Entry<String, String> e : this.m_columnMeta.entrySet()) {
            colName = e.getKey();
            this.m_kettleColumnMeta.put(colName, this.getValueMetaForColumn(colName));
        }
    }

    protected void extractIndexedMeta(String comment, Map<String, HashSet<Object>> indexedVals) {
        String[] fields;
        if (comment.indexOf("@@@") < 0) {
            return;
        }
        String meta = comment.substring(comment.indexOf("@@@"), comment.lastIndexOf("@@@"));
        meta = meta.replace("@@@", "");
        for (String field : fields = meta.split(";")) {
            String[] parts = (field = field.trim()).split(":");
            if (parts.length != 2) continue;
            String fieldName = parts[0].trim();
            String valsS = parts[1];
            valsS = valsS.replace("{", "");
            String[] vals = (valsS = valsS.replace("}", "")).split(",");
            if (vals.length <= 0) continue;
            HashSet<String> valsSet = new HashSet<String>();
            for (String aVal : vals) {
                valsSet.add(aVal.trim());
            }
            indexedVals.put(fieldName, valsSet);
        }
    }

    @Override
    public String describe() throws Exception {
        this.refresh((CassandraConnection)this.m_keyspace.getConnection());
        return this.getSchemaDescription();
    }

    public String getSchemaDescription() {
        return this.m_schemaDescription.toString();
    }

    public static String getCassandraTypeForValueMeta(ValueMetaInterface vm) {
        switch (vm.getType()) {
            case 2: {
                return "UTF8Type";
            }
            case 6: {
                return "DecimalType";
            }
            case 4: {
                return "BooleanType";
            }
            case 5: {
                return "LongType";
            }
            case 1: {
                return "DoubleType";
            }
            case 3: {
                return "DateType";
            }
            case 7: 
            case 8: {
                return "BytesType";
            }
        }
        return "UTF8Type";
    }

    public static String getCQLTypeForValueMeta(ValueMetaInterface vm) {
        switch (vm.getType()) {
            case 2: {
                return "varchar";
            }
            case 6: {
                return "decimal";
            }
            case 4: {
                return "boolean";
            }
            case 5: {
                return "bigint";
            }
            case 1: {
                return "double";
            }
            case 3: {
                return "timestamp";
            }
            case 7: 
            case 8: {
                return "blob";
            }
        }
        return "blob";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ByteBuffer kettleValueToByteBuffer(ValueMetaInterface vm, Object value, boolean isKey) throws KettleException {
        String fullTransCoder = this.m_defaultValidationClass;
        if (isKey) {
            fullTransCoder = this.m_keyValidator;
        } else {
            fullTransCoder = this.m_columnMeta.get(vm.getName());
            if (fullTransCoder == null) {
                fullTransCoder = this.m_defaultValidationClass;
            }
        }
        String transCoder = fullTransCoder;
        if (transCoder.indexOf(40) > 0) {
            transCoder = transCoder.substring(0, transCoder.indexOf(40));
        }
        ByteBuffer decomposed = null;
        if (transCoder.indexOf("UTF8Type") > 0) {
            UTF8Type u = UTF8Type.instance;
            decomposed = u.decompose(vm.getString(value));
        } else if (transCoder.indexOf("AsciiType") > 0) {
            AsciiType at = AsciiType.instance;
            decomposed = at.decompose(vm.getString(value));
        } else if (transCoder.indexOf("LongType") > 0) {
            LongType lt = LongType.instance;
            decomposed = lt.decompose(vm.getInteger(value));
        } else if (transCoder.indexOf("DoubleType") > 0) {
            DoubleType dt = DoubleType.instance;
            decomposed = dt.decompose(vm.getNumber(value));
        } else if (transCoder.indexOf("DateType") > 0) {
            DateType dt = DateType.instance;
            decomposed = dt.decompose(vm.getDate(value));
        } else if (transCoder.indexOf("IntegerType") > 0) {
            IntegerType it = IntegerType.instance;
            decomposed = it.decompose(vm.getBigNumber(value).toBigInteger());
        } else if (transCoder.indexOf("FloatType") > 0) {
            FloatType ft = FloatType.instance;
            decomposed = ft.decompose(Float.valueOf(vm.getNumber(value).floatValue()));
        } else if (transCoder.indexOf("LexicalUUIDType") > 0) {
            LexicalUUIDType lt = LexicalUUIDType.instance;
            UUID uuid = UUID.fromString(vm.getString(value));
            decomposed = lt.decompose(uuid);
        } else if (transCoder.indexOf("UUIDType") > 0) {
            UUIDType ut = UUIDType.instance;
            UUID uuid = UUID.fromString(vm.getString(value));
            decomposed = ut.decompose(uuid);
        } else if (transCoder.indexOf("BooleanType") > 0) {
            BooleanType bt = BooleanType.instance;
            decomposed = bt.decompose(vm.getBoolean(value));
        } else if (transCoder.indexOf("Int32Type") > 0) {
            Int32Type it = Int32Type.instance;
            decomposed = it.decompose(Integer.valueOf(vm.getInteger(value).intValue()));
        } else if (transCoder.indexOf("DecimalType") > 0) {
            DecimalType dt = DecimalType.instance;
            decomposed = dt.decompose(vm.getBigNumber(value));
        } else {
            if (transCoder.indexOf("DynamicCompositeType") > 0) {
                AbstractType serializer = null;
                if (!vm.isString()) throw new KettleException(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.CantConvertTypeThrift", (String[])new String[]{vm.getTypeDesc(), fullTransCoder}));
                try {
                    serializer = TypeParser.parse((String)fullTransCoder);
                    decomposed = ((DynamicCompositeType)serializer).fromString(vm.getString(value));
                }
                catch (Exception e) {
                    throw new KettleException(e.getMessage(), (Throwable)e);
                }
            }
            if (transCoder.indexOf("CompositeType") > 0) {
                AbstractType serializer = null;
                if (!vm.isString()) throw new KettleException(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.CantConvertTypeThrift", (String[])new String[]{vm.getTypeDesc(), fullTransCoder}));
                try {
                    serializer = TypeParser.parse((String)fullTransCoder);
                    decomposed = ((CompositeType)serializer).fromString(vm.toString());
                }
                catch (Exception e) {
                    throw new KettleException(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (decomposed != null) return decomposed;
        throw new KettleException(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.UnableToConvertValue", (String[])new String[]{vm.getName()}));
    }

    public ByteBuffer columnNameToByteBuffer(String colName) throws KettleException {
        UTF8Type serializer = null;
        String fullEncoder = this.m_columnComparator;
        String encoder = fullEncoder;
        if (encoder.indexOf(40) > 0) {
            encoder = encoder.substring(0, encoder.indexOf(40));
        }
        if (encoder.indexOf("UTF8Type") > 0) {
            serializer = UTF8Type.instance;
        } else if (encoder.indexOf("AsciiType") > 0) {
            serializer = AsciiType.instance;
        } else if (encoder.indexOf("LongType") > 0) {
            serializer = LongType.instance;
        } else if (encoder.indexOf("DoubleType") > 0) {
            serializer = DoubleType.instance;
        } else if (encoder.indexOf("DateType") > 0) {
            serializer = DateType.instance;
        } else if (encoder.indexOf("IntegerType") > 0) {
            serializer = IntegerType.instance;
        } else if (encoder.indexOf("FloatType") > 0) {
            serializer = FloatType.instance;
        } else if (encoder.indexOf("LexicalUUIDType") > 0) {
            serializer = LexicalUUIDType.instance;
        } else if (encoder.indexOf("UUIDType") > 0) {
            serializer = UUIDType.instance;
        } else if (encoder.indexOf("BooleanType") > 0) {
            serializer = BooleanType.instance;
        } else if (encoder.indexOf("Int32Type") > 0) {
            serializer = Int32Type.instance;
        } else if (encoder.indexOf("DecimalType") > 0) {
            serializer = DecimalType.instance;
        } else {
            if (encoder.indexOf("DynamicCompositeType") > 0) {
                try {
                    serializer = TypeParser.parse((String)fullEncoder);
                }
                catch (Exception e) {
                    throw new KettleException(e.getMessage(), (Throwable)e);
                }
            }
            if (encoder.indexOf("CompositeType") > 0) {
                try {
                    serializer = TypeParser.parse((String)fullEncoder);
                }
                catch (Exception e) {
                    throw new KettleException(e.getMessage(), (Throwable)e);
                }
            }
        }
        ByteBuffer result = serializer.fromString(colName);
        return result;
    }

    @Override
    public ValueMetaInterface getValueMetaForKey() {
        int kettleType = this.cassandraTypeToKettleType(this.m_keyValidator);
        if (this.getKeyColumnNames().size() > 0) {
            return new ValueMeta("KEY", 2);
        }
        return new ValueMeta("KEY", kettleType);
    }

    @Override
    public ValueMetaInterface getValueMetaForDefaultValidator() {
        return this.getValueMetaForColumn("");
    }

    protected int cassandraTypeToKettleType(String type) {
        int kettleType = 0;
        if (type.indexOf("UTF8Type") > 0 || type.indexOf("AsciiType") > 0 || type.indexOf("UUIDType") > 0 || type.indexOf("CompositeType") > 0) {
            kettleType = 2;
        } else if (type.indexOf("LongType") > 0 || type.indexOf("IntegerType") > 0 || type.indexOf("Int32Type") > 0) {
            kettleType = 5;
        } else if (type.indexOf("DoubleType") > 0 || type.indexOf("FloatType") > 0) {
            kettleType = 1;
        } else if (type.indexOf("DateType") > 0) {
            kettleType = 3;
        } else if (type.indexOf("DecimalType") > 0) {
            kettleType = 6;
        } else if (type.indexOf("BytesType") > 0) {
            kettleType = 8;
        } else if (type.indexOf("BooleanType") > 0) {
            kettleType = 4;
        }
        return kettleType;
    }

    @Override
    public ValueMetaInterface getValueMetaForColumn(String colName) {
        String type = null;
        type = this.m_columnMeta.get(colName);
        if (type == null) {
            type = this.m_defaultValidationClass;
        } else if (this.m_kettleColumnMeta.containsKey(colName)) {
            return this.m_kettleColumnMeta.get(colName);
        }
        int kettleType = this.cassandraTypeToKettleType(type);
        ValueMeta newVM = new ValueMeta(colName, kettleType);
        if (this.m_indexedVals.containsKey(colName)) {
            newVM.setStorageType(2);
            HashSet<Object> indexedV = this.m_indexedVals.get(colName);
            Object[] iv = indexedV.toArray();
            newVM.setIndex(iv);
        }
        return newVM;
    }

    @Override
    public List<ValueMetaInterface> getValueMetasForSchema() {
        ArrayList<ValueMetaInterface> newL = new ArrayList<ValueMetaInterface>();
        for (String colName : this.m_columnMeta.keySet()) {
            ValueMetaInterface colVM = this.getValueMetaForColumn(colName);
            newL.add(colVM);
        }
        return newL;
    }

    public Set<String> getColumnNames() {
        return this.m_columnMeta.keySet();
    }

    @Override
    public boolean columnExistsInSchema(String colName) {
        return this.m_columnMeta.get(colName) != null;
    }

    @Override
    public List<String> getKeyColumnNames() {
        return this.m_keyColumnNames;
    }

    @Override
    public String getColumnFamilyName() {
        return this.m_columnFamilyName;
    }

    public Object getKeyValue(CqlRow row) throws KettleException {
        ByteBuffer key = row.bufferForKey();
        if (!this.m_keyValidator.contains("CompositeType") && this.m_keyValidator.indexOf("BytesType") > 0) {
            return row.getKey();
        }
        return this.getColumnValue(key, this.m_keyValidator);
    }

    public Object getKeyValue(KeySlice row) throws KettleException {
        ByteBuffer key = row.bufferForKey();
        if (!this.m_keyValidator.contains("CompositeType") && this.m_keyValidator.indexOf("BytesType") > 0) {
            return row.getKey();
        }
        return this.getColumnValue(key, this.m_keyValidator);
    }

    public String getColumnName(Column aCol) throws KettleException {
        ByteBuffer b = aCol.bufferForName();
        String decodedColName = this.getColumnValue(b, this.m_columnComparator).toString();
        return decodedColName;
    }

    private Object getColumnValue(ByteBuffer valueBuff, String decoder) throws KettleException {
        if (valueBuff == null) {
            return null;
        }
        Object result = null;
        UTF8Type deserializer = null;
        String fullDecoder = decoder;
        if (decoder.indexOf(40) > 0) {
            decoder = decoder.substring(0, decoder.indexOf(40));
        }
        if (decoder.indexOf("UTF8Type") > 0) {
            deserializer = UTF8Type.instance;
        } else if (decoder.indexOf("AsciiType") > 0) {
            deserializer = AsciiType.instance;
        } else if (decoder.indexOf("LongType") > 0) {
            deserializer = LongType.instance;
        } else if (decoder.indexOf("DoubleType") > 0) {
            deserializer = DoubleType.instance;
        } else if (decoder.indexOf("DateType") > 0) {
            deserializer = DateType.instance;
        } else {
            if (decoder.indexOf("IntegerType") > 0) {
                deserializer = IntegerType.instance;
                result = new Long(((IntegerType)deserializer).compose(valueBuff).longValue());
                return result;
            }
            if (decoder.indexOf("FloatType") > 0) {
                deserializer = FloatType.instance;
                result = (double)new Double(((FloatType)deserializer).compose(valueBuff).floatValue());
                return result;
            }
            if (decoder.indexOf("LexicalUUIDType") > 0) {
                deserializer = LexicalUUIDType.instance;
                result = new String(((LexicalUUIDType)deserializer).compose(valueBuff).toString());
                return result;
            }
            if (decoder.indexOf("UUIDType") > 0) {
                deserializer = UUIDType.instance;
                result = new String(((UUIDType)deserializer).compose(valueBuff).toString());
                return result;
            }
            if (decoder.indexOf("BooleanType") > 0) {
                deserializer = BooleanType.instance;
            } else {
                if (decoder.indexOf("Int32Type") > 0) {
                    deserializer = Int32Type.instance;
                    result = (long)new Long(((Int32Type)deserializer).compose(valueBuff).intValue());
                    return result;
                }
                if (decoder.indexOf("DecimalType") > 0) {
                    deserializer = DecimalType.instance;
                } else {
                    if (decoder.indexOf("DynamicCompositeType") > 0) {
                        try {
                            deserializer = TypeParser.parse((String)fullDecoder);
                            result = ((DynamicCompositeType)deserializer).getString(valueBuff);
                            return result;
                        }
                        catch (Exception e) {
                            throw new KettleException(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (decoder.indexOf("CompositeType") > 0) {
                        try {
                            deserializer = TypeParser.parse((String)fullDecoder);
                            result = ((CompositeType)deserializer).getString(valueBuff);
                            return result;
                        }
                        catch (Exception e) {
                            throw new KettleException(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
        if (deserializer == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"CassandraColumnMetaData.Error.CantFindADeserializerForType", (String[])new String[]{fullDecoder}));
        }
        result = deserializer.compose(valueBuff);
        return result;
    }

    public Object getColumnValue(Column aCol) throws KettleException {
        String colName = this.getColumnName(aCol);
        String decoder = null;
        decoder = this.m_columnMeta.get(colName);
        if (decoder == null) {
            decoder = this.m_defaultValidationClass;
        }
        String fullDecoder = decoder;
        if (decoder.indexOf(40) > 0) {
            decoder = decoder.substring(0, decoder.indexOf(40));
        }
        if (decoder.indexOf("BytesType") > 0) {
            return aCol.getValue();
        }
        ByteBuffer valueBuff = aCol.bufferForValue();
        Object result = this.getColumnValue(valueBuff, fullDecoder);
        if (this.m_indexedVals.containsKey(colName)) {
            HashSet<Object> vals = this.m_indexedVals.get(colName);
            int foundIndex = -1;
            Object[] indexedV = vals.toArray();
            for (int i = 0; i < indexedV.length; ++i) {
                if (!indexedV[i].equals(result)) continue;
                foundIndex = i;
                break;
            }
            result = foundIndex >= 0 ? new Integer(foundIndex) : null;
        }
        return result;
    }
}

