/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cassandra.legacy;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.pentaho.cassandra.CassandraUtils;
import org.pentaho.cassandra.legacy.CassandraColumnMetaData;
import org.pentaho.cassandra.legacy.CassandraConnection;
import org.pentaho.cassandra.legacy.LegacyKeyspace;
import org.pentaho.cassandra.spi.CQLRowHandler;
import org.pentaho.cassandra.spi.Keyspace;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.StepInterface;

public class LegacyCQLRowHandler
implements CQLRowHandler {
    protected static final Class<?> PKG = LegacyCQLRowHandler.class;
    protected LegacyKeyspace m_keyspace;
    protected Map<String, String> m_options;
    protected CassandraColumnMetaData m_metaData;
    protected Iterator<CqlRow> m_resultIterator;
    protected Iterator<Column> m_cassandraColIter;
    protected CqlRow m_currentTupleRow;
    protected Object m_currentRowKey = null;
    protected boolean m_cql3;
    protected int m_timeout;
    protected boolean m_isSelectStarQuery;
    protected boolean m_outputTuples;
    protected StepInterface m_requestingStep;

    @Override
    public boolean supportsCQLVersion(int cqlMajVersion) {
        return cqlMajVersion == 2 || cqlMajVersion == 3;
    }

    @Override
    public void setOptions(Map<String, String> options) {
        this.m_options = options;
        if (this.m_options != null) {
            for (Map.Entry<String, String> e : this.m_options.entrySet()) {
                if (e.getKey().equalsIgnoreCase("cqlVersion") && e.getValue().equals("3.0.1")) {
                    this.m_cql3 = true;
                }
                if (!e.getKey().equalsIgnoreCase("batchTimeout")) continue;
                try {
                    this.m_timeout = Integer.parseInt(e.getValue());
                }
                catch (NumberFormatException ex) {}
            }
        }
    }

    @Override
    public void commitCQLBatch(StepInterface requestingStep, StringBuilder batch, String compress, String consistencyLevel, LogChannelInterface log) throws Exception {
        this.m_requestingStep = requestingStep;
        if (!batch.toString().toLowerCase().endsWith("apply batch")) {
            CassandraUtils.completeCQLBatch(batch);
        }
        ConsistencyLevel c = ConsistencyLevel.ONE;
        if (!Const.isEmpty((String)consistencyLevel)) {
            try {
                c = ConsistencyLevel.valueOf((String)consistencyLevel);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        Compression comp = Compression.NONE;
        if (!Const.isEmpty((String)compress) && (comp = Compression.valueOf((String)compress)) == null) {
            comp = Compression.NONE;
        }
        final byte[] toSend = CassandraUtils.compressCQLQuery(batch.toString(), comp);
        if (log != null) {
            log.logDetailed(BaseMessages.getString(PKG, (String)"LegacyCQLRowHandler.Message.UsingConsistencyLevel", (String[])new String[]{c.toString()}));
        }
        long start = System.currentTimeMillis();
        long time = System.currentTimeMillis() - start;
        final Exception[] e = new Exception[1];
        final AtomicBoolean done = new AtomicBoolean(false);
        final Compression comp2 = comp;
        final ConsistencyLevel c2 = c;
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (LegacyCQLRowHandler.this.m_cql3) {
                        ((CassandraConnection)LegacyCQLRowHandler.this.m_keyspace.getConnection()).getClient().execute_cql3_query(ByteBuffer.wrap(toSend), comp2, c2);
                    } else {
                        ((CassandraConnection)LegacyCQLRowHandler.this.m_keyspace.getConnection()).getClient().execute_cql_query(ByteBuffer.wrap(toSend), comp2);
                    }
                }
                catch (Exception ex) {
                    e[0] = ex;
                }
                finally {
                    done.set(true);
                }
            }
        });
        t.start();
        while (!done.get()) {
            time = System.currentTimeMillis() - start;
            if (this.m_timeout > 0 && time > (long)this.m_timeout) {
                try {
                    t.stop();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new KettleException(BaseMessages.getString(PKG, (String)"LegacyCQLRowHandler.Error.TimeoutReached", (String[])new String[0]));
            }
            Thread.sleep(100L);
        }
        if (e[0] != null) {
            throw e[0];
        }
    }

    @Override
    public boolean addRowToCQLBatch(StringBuilder batch, String colFamilyName, RowMetaInterface inputMeta, Object[] row, boolean insertFieldsNotInMetaData, LogChannelInterface log) throws Exception {
        if (this.m_metaData == null || !colFamilyName.equalsIgnoreCase(this.m_metaData.getColumnFamilyName())) {
            this.m_metaData = (CassandraColumnMetaData)this.m_keyspace.getColumnFamilyMetaData(colFamilyName);
        }
        return CassandraUtils.addRowToCQLBatch(batch, colFamilyName, inputMeta, row, this.m_metaData, insertFieldsNotInMetaData, this.m_cql3 ? 3 : 2, this.m_options, log);
    }

    @Override
    public void newRowQuery(StepInterface requestingStep, String colFamName, String cqlQuery, String compress, String consistencyLevel, boolean outputTuples, LogChannelInterface log) throws Exception {
        if (this.m_keyspace == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"LegacyCQLRowHandler.Error.NoKeyspaceSpecified", (String[])new String[0]));
        }
        this.m_metaData = (CassandraColumnMetaData)this.m_keyspace.getColumnFamilyMetaData(colFamName);
        this.m_isSelectStarQuery = cqlQuery.toLowerCase().indexOf("select *") >= 0;
        this.m_outputTuples = outputTuples;
        this.m_requestingStep = requestingStep;
        ConsistencyLevel c = ConsistencyLevel.ONE;
        Compression z = Compression.NONE;
        if (!Const.isEmpty((String)consistencyLevel)) {
            try {
                c = ConsistencyLevel.valueOf((String)consistencyLevel);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (!Const.isEmpty((String)compress)) {
            z = compress.equalsIgnoreCase("gzip") ? Compression.GZIP : Compression.NONE;
        }
        byte[] queryBytes = CassandraUtils.compressCQLQuery(cqlQuery, z);
        CqlResult result = null;
        result = this.m_cql3 ? ((CassandraConnection)this.m_keyspace.getConnection()).getClient().execute_cql3_query(ByteBuffer.wrap(queryBytes), z, c) : ((CassandraConnection)this.m_keyspace.getConnection()).getClient().execute_cql_query(ByteBuffer.wrap(queryBytes), z);
        this.m_resultIterator = result.getRowsIterator();
    }

    @Override
    public Object[] getNextOutputRow(RowMetaInterface outputRowMeta, Map<String, Integer> outputFormatMap) throws Exception {
        if (!this.m_outputTuples) {
            if (!this.m_resultIterator.hasNext()) {
                return null;
            }
            CqlRow nextRow = this.m_resultIterator.next();
            return this.cassandraRowToKettle(nextRow, outputRowMeta, outputFormatMap);
        }
        if (this.m_cassandraColIter == null || !this.m_cassandraColIter.hasNext()) {
            if (!this.m_resultIterator.hasNext()) {
                return null;
            }
            this.m_currentTupleRow = this.m_resultIterator.next();
            if (this.m_currentTupleRow == null) {
                this.m_cassandraColIter = null;
                return null;
            }
            List colsList = this.m_currentTupleRow.getColumns();
            this.m_cassandraColIter = colsList.iterator();
            if (!this.m_cql3) {
                this.m_currentRowKey = this.m_metaData.getKeyValue(this.m_currentTupleRow);
                if (this.m_isSelectStarQuery && this.m_cassandraColIter.hasNext()) {
                    this.m_cassandraColIter.next();
                }
            } else {
                List<String> keyColNames = this.m_metaData.getKeyColumnNames();
                int totalKeyCols = keyColNames.size();
                int keyColCount = 0;
                StringBuilder buff = new StringBuilder();
                for (Column c : colsList) {
                    String valS;
                    String colName = this.m_metaData.getColumnName(c).trim();
                    if (!keyColNames.contains(colName)) continue;
                    Object val = this.m_metaData.getColumnValue(c);
                    ValueMetaInterface cv = this.m_metaData.getValueMetaForColumn(colName);
                    String string = valS = val == null ? null : cv.getString(val);
                    if (keyColCount == 0) {
                        buff.append(valS);
                    } else {
                        buff.append(",").append(valS);
                    }
                    if (++keyColCount != totalKeyCols) continue;
                    break;
                }
                this.m_currentRowKey = buff.toString();
            }
            if (this.m_currentRowKey == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"LegacyCQLRowHandler.Error.UnableToObtainAKeyValueForRow", (String[])new String[0]));
            }
        }
        return this.cassandraRowToKettleTupleMode(outputRowMeta);
    }

    @Override
    public void setKeyspace(Keyspace keyspace) {
        this.m_keyspace = (LegacyKeyspace)keyspace;
    }

    protected Object[] cassandraRowToKettleTupleMode(RowMetaInterface outputRowMeta) throws Exception {
        Column aCol;
        Object[] outputRowData = RowDataUtil.allocateRowData((int)outputRowMeta.size());
        String keyName = "KEY";
        int keyIndex = outputRowMeta.indexOfValue(keyName);
        if (keyIndex < 0) {
            throw new Exception(BaseMessages.getString(PKG, (String)"LegacyCQLRowHandler.Error.UnableToFindKeyFieldName", (String[])new String[]{keyName}));
        }
        outputRowData[keyIndex] = this.m_currentRowKey;
        if (this.m_cassandraColIter.hasNext()) {
            aCol = this.m_cassandraColIter.next();
            String colName = this.m_metaData.getColumnName(aCol);
            while (this.m_metaData.getColumnValue(aCol) == null) {
                if (this.m_cassandraColIter.hasNext()) {
                    aCol = this.m_cassandraColIter.next();
                    colName = this.m_metaData.getColumnName(aCol);
                    continue;
                }
                return null;
            }
            outputRowData[1] = colName;
            Object colValue = this.m_metaData.getColumnValue(aCol);
            ValueMetaInterface colMeta = this.m_metaData.getValueMetaForColumn(colName);
            String stringV = colMeta.getString(colValue);
            outputRowData[2] = stringV;
            if (colValue instanceof Date) {
                ValueMeta tempDateMeta = new ValueMeta("temp", 3);
                stringV = tempDateMeta.getString(colValue);
                outputRowData[2] = stringV;
            } else if (colValue instanceof byte[]) {
                outputRowData[2] = colValue;
            }
        } else {
            this.m_currentRowKey = null;
            return null;
        }
        long timestampL = aCol.getTimestamp();
        outputRowData[3] = timestampL;
        return outputRowData;
    }

    protected Object[] cassandraRowToKettle(CqlRow cassandraRow, RowMetaInterface outputRowMeta, Map<String, Integer> outputFormatMap) throws Exception {
        Object[] outputRowData = RowDataUtil.allocateRowData((int)outputRowMeta.size());
        List rowColumns = cassandraRow.getColumns();
        for (Column aCol : rowColumns) {
            Object colValue;
            String colName = this.m_metaData.getColumnName(aCol);
            Integer outputIndex = outputFormatMap.get(colName);
            if (outputIndex == null) continue;
            outputRowData[outputIndex.intValue()] = colValue = this.m_metaData.getColumnValue(aCol);
        }
        return outputRowData;
    }
}

