/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cassandra.legacy;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.KsDef;
import org.pentaho.cassandra.CassandraUtils;
import org.pentaho.cassandra.legacy.CassandraColumnMetaData;
import org.pentaho.cassandra.legacy.CassandraConnection;
import org.pentaho.cassandra.legacy.LegacyCQLRowHandler;
import org.pentaho.cassandra.legacy.LegacyNonCQLRowHandler;
import org.pentaho.cassandra.spi.CQLRowHandler;
import org.pentaho.cassandra.spi.ColumnFamilyMetaData;
import org.pentaho.cassandra.spi.Connection;
import org.pentaho.cassandra.spi.Keyspace;
import org.pentaho.cassandra.spi.NonCQLRowHandler;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;

public class LegacyKeyspace
implements Keyspace {
    protected static final Class<?> PKG = LegacyKeyspace.class;
    protected CassandraConnection m_conn;
    protected Map<String, String> m_options;
    protected String m_currentKeyspace;
    protected boolean m_cql3 = false;

    @Override
    public void setConnection(Connection conn) {
        this.m_conn = (CassandraConnection)conn;
        this.m_currentKeyspace = this.m_conn.m_keyspaceName;
    }

    @Override
    public Connection getConnection() {
        return this.m_conn;
    }

    @Override
    public void setKeyspace(String keyspaceName) throws Exception {
        if (this.m_conn != null) {
            this.m_conn.setKeyspace(keyspaceName);
        }
        this.m_currentKeyspace = keyspaceName;
    }

    @Override
    public void setOptions(Map<String, String> options) {
        this.m_options = options;
        if (this.m_options != null) {
            for (Map.Entry<String, String> e : this.m_options.entrySet()) {
                if (!e.getKey().equalsIgnoreCase("cqlVersion") || !e.getValue().equals("3.0.1")) continue;
                this.m_cql3 = true;
            }
        }
    }

    @Override
    public void executeCQL(String cql, String compression, String consistencyLevel, LogChannelInterface log) throws UnsupportedOperationException, Exception {
        ConsistencyLevel c = ConsistencyLevel.ONE;
        Compression z = Compression.NONE;
        if (!Const.isEmpty((String)consistencyLevel)) {
            c = ConsistencyLevel.valueOf((String)consistencyLevel);
        }
        if (!Const.isEmpty((String)compression)) {
            z = compression.equalsIgnoreCase("gzip") ? Compression.GZIP : Compression.NONE;
        }
        byte[] queryBytes = CassandraUtils.compressCQLQuery(cql, z);
        if (this.m_conn != null) {
            if (this.m_cql3) {
                this.m_conn.getClient().execute_cql3_query(ByteBuffer.wrap(queryBytes), z, c);
            } else {
                this.m_conn.getClient().execute_cql_query(ByteBuffer.wrap(queryBytes), z);
            }
        }
    }

    @Override
    public List<String> getColumnFamilyNames() throws Exception {
        if (this.m_cql3) {
            return this.getColumnFamilyNamesCQL3();
        }
        KsDef keySpace = this.m_conn.describeKeyspace();
        List colFams = null;
        if (keySpace == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"LegacyKeyspace.Error.UnableToGetMetaDataForKeyspace", (String[])new String[]{this.m_currentKeyspace}));
        }
        colFams = keySpace.getCf_defs();
        ArrayList<String> colFamNames = new ArrayList<String>();
        for (CfDef fam : colFams) {
            colFamNames.add(fam.getName());
        }
        return colFamNames;
    }

    protected List<String> getColumnFamilyNamesCQL3() throws Exception {
        ConsistencyLevel c = ConsistencyLevel.ONE;
        Compression z = Compression.NONE;
        ArrayList<String> colFamNames = new ArrayList<String>();
        String keyspaceName = this.m_currentKeyspace;
        String cqlQ = "select keyspace_name, columnfamily_name from system.schema_columnfamilies where keyspace_name='" + keyspaceName + "';";
        byte[] data = cqlQ.getBytes(Charset.forName("UTF-8"));
        CqlResult result = this.m_conn.m_client.execute_cql3_query(ByteBuffer.wrap(data), z, c);
        List rl = result.getRows();
        for (CqlRow r : rl) {
            List cols = r.getColumns();
            Column fN = (Column)cols.get(1);
            UTF8Type deserializer = UTF8Type.instance;
            Object decodedFN = deserializer.compose(fN.bufferForValue());
            colFamNames.add(decodedFN.toString());
        }
        return colFamNames;
    }

    @Override
    public void createKeyspace(String keyspaceName, Map<String, Object> options, LogChannelInterface log) throws UnsupportedOperationException, Exception {
        throw new UnsupportedOperationException("Legacy driver does not support keyspace creation");
    }

    @Override
    public boolean columnFamilyExists(String colFamName) throws Exception {
        List<String> colFamNames = this.getColumnFamilyNames();
        return colFamNames.contains(colFamName);
    }

    @Override
    public ColumnFamilyMetaData getColumnFamilyMetaData(String familyName) throws Exception {
        CassandraColumnMetaData meta = new CassandraColumnMetaData(this, familyName, this.m_cql3);
        return meta;
    }

    @Override
    public boolean createColumnFamily(String colFamilyName, RowMetaInterface rowMeta, List<Integer> keyIndexes, String createTableWithClause, LogChannelInterface log) throws Exception {
        int i;
        if (keyIndexes.size() > 1 && !this.m_cql3) {
            throw new Exception(BaseMessages.getString(PKG, (String)"LegacyKeyspace.Error.OnlySingleColumnKeysAreSupported", (String[])new String[0]));
        }
        String quoteChar = this.m_cql3 ? "\"" : "'";
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE TABLE " + colFamilyName);
        ValueMetaInterface kvm = rowMeta.getValueMeta(keyIndexes.get(0).intValue());
        buff.append(" (");
        if (!this.m_cql3) {
            buff.append(quoteChar + kvm.getName() + quoteChar).append(" " + CassandraUtils.getCQLTypeForValueMeta(kvm));
            buff.append(" PRIMARY KEY");
        }
        ArrayList<ValueMetaInterface> indexedVals = new ArrayList<ValueMetaInterface>();
        if (rowMeta.size() > 1) {
            for (i = 0; i < rowMeta.size(); ++i) {
                if (i == keyIndexes.get(0) && !this.m_cql3) continue;
                ValueMetaInterface vm = rowMeta.getValueMeta(i);
                if (vm.getStorageType() == 2) {
                    indexedVals.add(vm);
                }
                String colName = vm.getName();
                String colType = CassandraUtils.getCQLTypeForValueMeta(vm);
                if (i != 0 || !this.m_cql3) {
                    buff.append(", ");
                }
                buff.append(quoteChar + colName + quoteChar).append(" ");
                buff.append(colType);
            }
        } else if (!this.m_cql3) {
            return false;
        }
        if (this.m_cql3) {
            buff.append(", PRIMARY KEY (");
            for (i = 0; i < keyIndexes.size(); ++i) {
                int ki = keyIndexes.get(i);
                ValueMetaInterface vm = rowMeta.getValueMeta(ki);
                buff.append(i == 0 ? "" : ", ").append(quoteChar + vm.getName() + quoteChar);
            }
            buff.append(")");
        }
        if (!Const.isEmpty((String)createTableWithClause)) {
            buff.append(") ");
            if (!createTableWithClause.toLowerCase().trim().startsWith("with")) {
                buff.append("WITH ");
            }
            buff.append(createTableWithClause);
        }
        if (indexedVals.size() == 0) {
            if (Const.isEmpty((String)createTableWithClause)) {
                buff.append(");");
            }
        } else {
            boolean ok = false;
            if (Const.isEmpty((String)createTableWithClause)) {
                buff.append(") WITH comment = '@@@");
                ok = true;
            } else if (!createTableWithClause.toLowerCase().contains("comment")) {
                buff.append(" AND comment = '@@@");
                ok = true;
            }
            if (ok) {
                int count = 0;
                for (ValueMetaInterface vm : indexedVals) {
                    String colName = vm.getName();
                    Object[] legalVals = vm.getIndex();
                    buff.append(colName).append(":{");
                    for (int i2 = 0; i2 < legalVals.length; ++i2) {
                        buff.append(legalVals[i2].toString());
                        if (i2 == legalVals.length - 1) continue;
                        buff.append(",");
                    }
                    buff.append("}");
                    if (count != indexedVals.size() - 1) {
                        buff.append(";");
                    }
                    ++count;
                }
                buff.append("@@@';");
            }
        }
        if (!buff.toString().endsWith(";")) {
            buff.append(";");
        }
        if (log != null) {
            log.logBasic(BaseMessages.getString(PKG, (String)"LegacyKeyspace.Message.CreatingColumnFamily", (String[])new String[]{colFamilyName, buff.toString()}));
        }
        this.executeCQL(buff.toString(), null, null, log);
        return true;
    }

    protected void updateColumnFamilyCQL3(String colFamName, RowMetaInterface rowMeta, List<Integer> keyIndexes, LogChannelInterface log) throws Exception {
        CassandraColumnMetaData cassandraMeta = (CassandraColumnMetaData)this.getColumnFamilyMetaData(colFamName);
        if (cassandraMeta == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"LegacyKeyspace.Error.CantUpdateMetaData", (String[])new String[]{colFamName}));
        }
        String alter = "ALTER TABLE " + colFamName + " ADD ";
        for (int i = 0; i < rowMeta.size(); ++i) {
            ValueMetaInterface vm = rowMeta.getValueMeta(i);
            if (keyIndexes.contains(vm.getName()) || cassandraMeta.columnExistsInSchema(vm.getName())) continue;
            String alter2 = alter + vm.getName() + " " + CassandraUtils.getCQLTypeForValueMeta(vm) + ";";
            log.logBasic("Exeucting: " + alter2);
            this.executeCQL(alter2, null, null, log);
        }
    }

    @Override
    public void updateColumnFamily(String colFamilyName, RowMetaInterface rowMeta, List<Integer> keyIndexes, LogChannelInterface log) throws UnsupportedOperationException, Exception {
        if (this.m_cql3) {
            this.updateColumnFamilyCQL3(colFamilyName, rowMeta, keyIndexes, log);
            return;
        }
        if (keyIndexes.size() > 1 || keyIndexes.size() == 0) {
            throw new Exception(BaseMessages.getString(PKG, (String)"LegacyKeyspace.Error.OnlySingleColumnKeysAreSupported", (String[])new String[0]));
        }
        KsDef keySpace = this.m_conn.describeKeyspace();
        List colFams = null;
        if (keySpace == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"LegacyKeyspace.Error.UnableToGetColumnFamilyMetaData", (String[])new String[]{colFamilyName}));
        }
        colFams = keySpace.getCf_defs();
        CassandraColumnMetaData cassandraMeta = (CassandraColumnMetaData)this.getColumnFamilyMetaData(colFamilyName);
        if (cassandraMeta == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"LegacyKeyspace.Error.UnableToGetColumnFamilyMetaData", (String[])new String[]{colFamilyName}));
        }
        CfDef colFamDefToUpdate = null;
        for (CfDef fam : colFams) {
            String columnFamilyName = fam.getName();
            if (!columnFamilyName.equals(colFamilyName)) continue;
            colFamDefToUpdate = fam;
            break;
        }
        if (colFamDefToUpdate == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"LegacyKeyspace.Error.CantUpdateMetaData", (String[])new String[]{colFamilyName}));
        }
        String comment = colFamDefToUpdate.getComment();
        ArrayList<ValueMetaInterface> indexedVals = new ArrayList<ValueMetaInterface>();
        for (int i = 0; i < rowMeta.size(); ++i) {
            String colName;
            if (i == keyIndexes.get(0)) continue;
            ValueMetaInterface colMeta = rowMeta.getValueMeta(i);
            if (colMeta.getStorageType() == 2) {
                indexedVals.add(colMeta);
            }
            if (cassandraMeta.columnExistsInSchema(colName = colMeta.getName())) continue;
            String colType = CassandraColumnMetaData.getCassandraTypeForValueMeta(colMeta);
            ColumnDef newCol = new ColumnDef(ByteBuffer.wrap(colName.getBytes()), colType);
            colFamDefToUpdate.addToColumn_metadata(newCol);
        }
        if (indexedVals.size() > 0) {
            String before = "";
            String after = "";
            String meta = "";
            if (comment != null && comment.length() > 0 && comment.indexOf("@@@") >= 0) {
                before = comment.substring(0, comment.indexOf("@@@"));
                after = comment.substring(comment.lastIndexOf("@@@") + 3, comment.length());
                meta = comment.substring(comment.indexOf("@@@", comment.lastIndexOf("@@@")));
                meta = meta.replace("@@@", "");
            }
            StringBuffer buff = new StringBuffer();
            buff.append(meta);
            for (ValueMetaInterface vm : indexedVals) {
                String colName = vm.getName();
                if (meta.indexOf(colName) >= 0) continue;
                Object[] legalVals = vm.getIndex();
                if (buff.length() > 0) {
                    buff.append(";").append(colName).append(":{");
                } else {
                    buff.append(colName).append(":{");
                }
                for (int i = 0; i < legalVals.length; ++i) {
                    buff.append(legalVals[i].toString());
                    if (i == legalVals.length - 1) continue;
                    buff.append(",");
                }
                buff.append("}");
            }
            comment = before + "@@@" + buff.toString() + "@@@" + after;
            colFamDefToUpdate.setComment(comment);
        }
        this.m_conn.getClient().system_update_column_family(colFamDefToUpdate);
    }

    @Override
    public void truncateColumnFamily(String colFamName, LogChannelInterface log) throws UnsupportedOperationException, Exception {
        String cqlCommand = "TRUNCATE " + colFamName;
        if (log != null) {
            log.logBasic(BaseMessages.getString(PKG, (String)"LegacyKeyspace.Message.TruncateColumnFamily", (String[])new String[]{colFamName}));
        }
        this.executeCQL(cqlCommand, null, null, log);
    }

    @Override
    public CQLRowHandler getCQLRowHandler() {
        LegacyCQLRowHandler rowHandler = new LegacyCQLRowHandler();
        rowHandler.setKeyspace(this);
        rowHandler.setOptions(this.m_options);
        return rowHandler;
    }

    @Override
    public NonCQLRowHandler getNonCQLRowHandler() {
        LegacyNonCQLRowHandler rowHandler = new LegacyNonCQLRowHandler();
        rowHandler.setKeyspace(this);
        rowHandler.setOptions(this.m_options);
        return rowHandler;
    }
}

