/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cassandra.legacy;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.TimedOutException;
import org.pentaho.cassandra.legacy.CassandraColumnMetaData;
import org.pentaho.cassandra.legacy.CassandraConnection;
import org.pentaho.cassandra.legacy.LegacyKeyspace;
import org.pentaho.cassandra.spi.Keyspace;
import org.pentaho.cassandra.spi.NonCQLRowHandler;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.StepInterface;

public class LegacyNonCQLRowHandler
implements NonCQLRowHandler {
    protected static final Class<?> PKG = LegacyNonCQLRowHandler.class;
    protected LegacyKeyspace m_keyspace;
    protected Map<String, String> m_options;
    protected CassandraColumnMetaData m_metaData;
    protected StepInterface m_requestingStep;
    protected int m_timeout;
    protected boolean m_newSliceQuery = false;
    protected List<String> m_requestedCols = null;
    protected int m_sliceRowsMax;
    protected int m_sliceColsMax;
    protected int m_sliceRowsBatchSize;
    protected int m_sliceColsBatchSize;
    protected SliceRange m_sliceRange;
    protected KeyRange m_keyRange;
    protected SlicePredicate m_slicePredicate;
    protected ColumnParent m_colParent;
    protected int m_rowIndex;
    protected int m_colIndex;
    protected ConsistencyLevel m_consistencyLevel;
    protected List<KeySlice> m_cassandraRows;
    protected List<ColumnOrSuperColumn> m_currentCols;
    protected int m_colCount;
    protected int m_rowCount;
    protected int m_currentBatchCounter = -1;
    protected Object m_currentRowKeyValue = null;

    @Override
    public void setOptions(Map<String, String> options) {
        this.m_options = options;
        if (this.m_options != null) {
            for (Map.Entry<String, String> e : this.m_options.entrySet()) {
                if (!e.getKey().equalsIgnoreCase("batchTimeout")) continue;
                try {
                    this.m_timeout = Integer.parseInt(e.getValue());
                }
                catch (NumberFormatException ex) {}
            }
        }
    }

    @Override
    public void setKeyspace(Keyspace keyspace) {
        this.m_keyspace = (LegacyKeyspace)keyspace;
    }

    @Override
    public void newRowQuery(StepInterface requestingStep, String colFamilyName, List<String> colNames, int rowLimit, int colLimit, int rowBatchSize, int colBatchSize, String consistencyLevel, LogChannelInterface log) throws Exception {
        if (this.m_keyspace == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"LegacyNonCQLRowHandler.Error.NoKeyspaceSpecified", (String[])new String[0]));
        }
        this.m_metaData = (CassandraColumnMetaData)this.m_keyspace.getColumnFamilyMetaData(colFamilyName);
        this.m_requestingStep = requestingStep;
        this.m_newSliceQuery = true;
        this.m_requestedCols = colNames;
        this.m_sliceRowsMax = rowLimit;
        this.m_sliceColsMax = colLimit;
        this.m_sliceRowsBatchSize = rowBatchSize;
        this.m_sliceColsBatchSize = colBatchSize;
        this.m_rowIndex = 0;
        this.m_colIndex = 0;
        this.m_currentBatchCounter = -1;
        this.m_consistencyLevel = !Const.isEmpty((String)consistencyLevel) ? ConsistencyLevel.valueOf((String)consistencyLevel) : ConsistencyLevel.ONE;
        if (this.m_sliceColsBatchSize <= 0) {
            this.m_sliceColsBatchSize = Integer.MAX_VALUE;
        }
        if (this.m_sliceRowsBatchSize <= 0) {
            this.m_sliceRowsBatchSize = Integer.MAX_VALUE;
        }
        ArrayList<ByteBuffer> specificCols = null;
        if (this.m_requestedCols != null && this.m_requestedCols.size() > 0) {
            specificCols = new ArrayList<ByteBuffer>();
            for (String colName : this.m_requestedCols) {
                ByteBuffer encoded = this.m_metaData.columnNameToByteBuffer(colName);
                specificCols.add(encoded);
            }
        }
        this.m_slicePredicate = new SlicePredicate();
        if (specificCols == null) {
            this.m_sliceRange = new SliceRange(ByteBuffer.wrap(new byte[0]), ByteBuffer.wrap(new byte[0]), false, this.m_sliceColsBatchSize);
            this.m_slicePredicate.setSlice_range(this.m_sliceRange);
        } else {
            this.m_slicePredicate.setColumn_names(specificCols);
        }
        this.m_keyRange = new KeyRange(this.m_sliceRowsBatchSize);
        this.m_keyRange.setStart_key(new byte[0]);
        this.m_keyRange.setEnd_key(new byte[0]);
        this.m_colParent = new ColumnParent(colFamilyName);
    }

    private void advanceToNonEmptyRow() {
        KeySlice row = this.m_cassandraRows.get(this.m_rowIndex);
        this.m_currentCols = row.getColumns();
        int skipSize = 0;
        while (this.m_currentCols.size() == skipSize && this.m_rowIndex < this.m_cassandraRows.size() - 1) {
            ++this.m_rowIndex;
            row = this.m_cassandraRows.get(this.m_rowIndex);
            this.m_currentCols = row.getColumns();
        }
        if (this.m_currentCols.size() == skipSize) {
            this.m_currentCols = null;
        }
    }

    private void getNextBatchOfRows() throws Exception {
        if (this.m_requestingStep.isStopped() || this.m_requestingStep.isPaused()) {
            return;
        }
        if (this.m_requestedCols == null) {
            this.m_sliceRange = this.m_sliceRange.setStart(ByteBuffer.wrap(new byte[0]));
            this.m_sliceRange = this.m_sliceRange.setFinish(ByteBuffer.wrap(new byte[0]));
            this.m_slicePredicate.setSlice_range(this.m_sliceRange);
        }
        this.m_keyRange.setStart_key(this.m_cassandraRows.get(this.m_cassandraRows.size() - 1).getKey());
        this.m_cassandraRows = ((CassandraConnection)this.m_keyspace.getConnection()).getClient().get_range_slices(this.m_colParent, this.m_slicePredicate, this.m_keyRange, this.m_consistencyLevel);
        this.m_colCount = 0;
        this.m_rowIndex = 1;
        if (this.m_cassandraRows == null || this.m_cassandraRows.size() <= 1 || this.m_rowCount == this.m_sliceRowsMax) {
            this.m_currentCols = null;
            this.m_cassandraRows = null;
        } else {
            this.advanceToNonEmptyRow();
        }
    }

    private void getNextBatchOfColumns() throws Exception {
        if (this.m_requestingStep.isStopped() || this.m_requestingStep.isPaused()) {
            return;
        }
        this.m_sliceRange = this.m_sliceRange.setStart(this.m_currentCols.get(this.m_currentCols.size() - 1).getColumn().bufferForName());
        this.m_slicePredicate.setSlice_range(this.m_sliceRange);
        this.m_currentCols = ((CassandraConnection)this.m_keyspace.getConnection()).getClient().get_slice(this.m_cassandraRows.get(this.m_rowIndex).bufferForKey(), this.m_colParent, this.m_slicePredicate, ConsistencyLevel.ONE);
        if (this.m_currentCols == null || this.m_currentCols.size() <= 1) {
            ++this.m_rowCount;
            ++this.m_rowIndex;
            this.m_colCount = 0;
            if (this.m_rowIndex == this.m_cassandraRows.size()) {
                this.getNextBatchOfRows();
                while (this.m_cassandraRows != null && this.m_currentCols == null) {
                    this.getNextBatchOfRows();
                }
            } else {
                this.advanceToNonEmptyRow();
                while (this.m_cassandraRows != null && this.m_currentCols == null) {
                    this.getNextBatchOfRows();
                }
            }
        } else {
            this.m_currentCols.remove(0);
        }
    }

    private boolean getMoreData() throws Exception {
        KeySlice row;
        int timeouts;
        this.m_currentRowKeyValue = null;
        for (timeouts = 0; timeouts < 5; ++timeouts) {
            try {
                if (this.m_newSliceQuery) {
                    this.m_cassandraRows = ((CassandraConnection)this.m_keyspace.getConnection()).getClient().get_range_slices(this.m_colParent, this.m_slicePredicate, this.m_keyRange, ConsistencyLevel.ONE);
                    if (this.m_cassandraRows == null || this.m_cassandraRows.size() == 0) {
                        return false;
                    }
                    this.advanceToNonEmptyRow();
                    while (this.m_cassandraRows != null && this.m_currentCols == null) {
                        this.getNextBatchOfRows();
                    }
                    if (this.m_cassandraRows == null) {
                        return false;
                    }
                    this.m_colCount = 0;
                    this.m_rowCount = 0;
                    this.m_newSliceQuery = false;
                } else {
                    if (this.m_rowCount == this.m_sliceRowsMax) {
                        return false;
                    }
                    if (this.m_rowIndex == this.m_cassandraRows.size()) {
                        this.getNextBatchOfRows();
                        while (this.m_cassandraRows != null && this.m_currentCols == null) {
                            this.getNextBatchOfRows();
                        }
                        if (this.m_cassandraRows == null) {
                            return false;
                        }
                    } else if (this.m_colCount == -1) {
                        row = this.m_cassandraRows.get(this.m_rowIndex);
                        this.m_currentCols = row.getColumns();
                        this.m_colCount = 0;
                    } else {
                        this.getNextBatchOfColumns();
                        if (this.m_rowCount == this.m_sliceRowsMax) {
                            return false;
                        }
                        if (this.m_cassandraRows == null) {
                            return false;
                        }
                    }
                }
                break;
            }
            catch (TimedOutException e) {
                continue;
            }
        }
        if (timeouts == 5) {
            throw new Exception(BaseMessages.getString(PKG, (String)"LegacyNonCQLRowHandler.Error.MaximumNumberOfConsecutiveTimeoutsExceeded", (String[])new String[0]));
        }
        this.m_currentBatchCounter = 0;
        row = this.m_cassandraRows.get(this.m_rowIndex);
        this.m_currentRowKeyValue = this.m_metaData.getKeyValue(row);
        if (this.m_currentRowKeyValue == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"LegacyNonCQLRowHandler.Error.UnableToObtainAKeyValueForRow", (String[])new String[0]));
        }
        return true;
    }

    private boolean skipNullColumns() throws Exception {
        Column col = this.m_currentCols.get(this.m_currentBatchCounter++).getColumn();
        Object colValue = this.m_metaData.getColumnValue(col);
        while (colValue == null && this.m_currentBatchCounter < this.m_currentCols.size()) {
            col = this.m_currentCols.get(this.m_currentBatchCounter++).getColumn();
            colValue = this.m_metaData.getColumnValue(col);
        }
        if (colValue == null) {
            if (!this.getMoreData()) {
                return false;
            }
            return this.skipNullColumns();
        }
        --this.m_currentBatchCounter;
        return true;
    }

    @Override
    public Object[] getNextOutputRow(RowMetaInterface outputRowMeta) throws Exception {
        if (this.m_currentBatchCounter < 0 && !this.getMoreData()) {
            return null;
        }
        String keyName = "KEY";
        int keyIndex = outputRowMeta.indexOfValue(keyName);
        if (keyIndex < 0) {
            throw new Exception(BaseMessages.getString(PKG, (String)"LegacyNonCQLRowHandler.Error.UnableToFindKeyFieldName", (String[])new String[]{keyName}));
        }
        Object[] outputRowData = RowDataUtil.allocateRowData((int)outputRowMeta.size());
        if (!this.skipNullColumns()) {
            return null;
        }
        Column col = this.m_currentCols.get(this.m_currentBatchCounter++).getColumn();
        String colName = this.m_metaData.getColumnName(col);
        Object colValue = this.m_metaData.getColumnValue(col);
        outputRowData[keyIndex] = this.m_currentRowKeyValue;
        outputRowData[1] = colName;
        String stringV = colValue.toString();
        outputRowData[2] = stringV;
        if (colValue instanceof Date) {
            ValueMeta tempDateMeta = new ValueMeta("temp", 3);
            stringV = tempDateMeta.getString(colValue);
            outputRowData[2] = stringV;
        } else if (colValue instanceof byte[]) {
            outputRowData[2] = colValue;
        }
        long timestampL = col.getTimestamp();
        outputRowData[3] = timestampL;
        ++this.m_colCount;
        if (this.m_colCount == this.m_sliceColsMax && this.m_requestedCols == null) {
            this.m_colCount = -1;
            this.m_currentBatchCounter = -1;
            ++this.m_rowCount;
            ++this.m_rowIndex;
        }
        if (this.m_requestedCols != null && this.m_currentBatchCounter == this.m_currentCols.size()) {
            this.m_colCount = -1;
            ++this.m_rowCount;
            ++this.m_rowIndex;
        }
        if (this.m_currentBatchCounter == this.m_currentCols.size()) {
            this.m_currentBatchCounter = -1;
        }
        return outputRowData;
    }

    private static Map<ByteBuffer, Map<String, List<Mutation>>> createThriftBatch(List<Object[]> rowBatch) {
        HashMap<ByteBuffer, Map<String, List<Mutation>>> thriftBatch = new HashMap<ByteBuffer, Map<String, List<Mutation>>>(rowBatch.size());
        return thriftBatch;
    }

    @Override
    public void commitNonCQLBatch(StepInterface requestingStep, List<Object[]> batch, RowMetaInterface rowMeta, int keyIndex, String colFamName, String consistencyLevel, LogChannelInterface log) throws Exception {
        this.m_requestingStep = requestingStep;
        CassandraColumnMetaData famMeta = (CassandraColumnMetaData)this.m_keyspace.getColumnFamilyMetaData(colFamName);
        ValueMetaInterface keyMeta = rowMeta.getValueMeta(keyIndex);
        Map<ByteBuffer, Map<String, List<Mutation>>> thriftBatch = LegacyNonCQLRowHandler.createThriftBatch(batch);
        for (Object[] row : batch) {
            ByteBuffer keyBuff = famMeta.kettleValueToByteBuffer(keyMeta, row[keyIndex], true);
            Map<String, List<Mutation>> mapCF = thriftBatch.get(keyBuff);
            List<Mutation> mutList = null;
            if (mapCF != null) {
                mutList = mapCF.get(colFamName);
            } else {
                mapCF = new HashMap<String, List<Mutation>>(1);
                mutList = new ArrayList<Mutation>();
            }
            for (int i = 0; i < rowMeta.size(); ++i) {
                if (i == keyIndex) continue;
                ValueMetaInterface colMeta = rowMeta.getValueMeta(i);
                String colName = colMeta.getName();
                if (colMeta.isNull(row[i])) continue;
                Column col = new Column(famMeta.columnNameToByteBuffer(colName));
                col = col.setValue(famMeta.kettleValueToByteBuffer(colMeta, row[i], false));
                col = col.setTimestamp(System.currentTimeMillis());
                ColumnOrSuperColumn cosc = new ColumnOrSuperColumn();
                cosc.setColumn(col);
                Mutation mut = new Mutation();
                mut.setColumn_or_supercolumn(cosc);
                mutList.add(mut);
            }
            mapCF.put(colFamName, mutList);
            thriftBatch.put(keyBuff, mapCF);
        }
        ConsistencyLevel levelToUse = ConsistencyLevel.ANY;
        if (!Const.isEmpty((String)consistencyLevel)) {
            try {
                levelToUse = ConsistencyLevel.valueOf((String)consistencyLevel);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        final ConsistencyLevel fLevelToUse = levelToUse;
        final Map<ByteBuffer, Map<String, List<Mutation>>> fThriftBatch = thriftBatch;
        long start = System.currentTimeMillis();
        long time = System.currentTimeMillis() - start;
        final Exception[] e = new Exception[1];
        final AtomicBoolean done = new AtomicBoolean(false);
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ((CassandraConnection)LegacyNonCQLRowHandler.this.m_keyspace.getConnection()).getClient().batch_mutate(fThriftBatch, fLevelToUse);
                }
                catch (Exception ex) {
                    e[0] = ex;
                }
                finally {
                    done.set(true);
                }
            }
        });
        if (!this.m_requestingStep.isStopped()) {
            t.start();
            while (!done.get()) {
                time = System.currentTimeMillis() - start;
                if (this.m_timeout > 0 && time > (long)this.m_timeout) {
                    try {
                        t.stop();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    throw new Exception(BaseMessages.getString(PKG, (String)"LegacyNonCQLRowHandler.Error.TimeoutReached", (String[])new String[0]));
                }
                Thread.sleep(100L);
            }
        }
        if (e[0] != null) {
            throw e[0];
        }
    }
}

