/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandrainput;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.cassandra.CassandraUtils;
import org.pentaho.cassandra.ConnectionFactory;
import org.pentaho.cassandra.legacy.CassandraColumnMetaData;
import org.pentaho.cassandra.spi.Connection;
import org.pentaho.cassandra.spi.Keyspace;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.cassandrainput.CassandraInputMeta;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.dialog.ShowMessageDialog;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.tableinput.SQLValuesHighlight;

public class CassandraInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static final Class<?> PKG = CassandraInputMeta.class;
    private final CassandraInputMeta m_currentMeta;
    private final CassandraInputMeta m_originalMeta;
    private Label m_stepnameLabel;
    private Text m_stepnameText;
    private Label m_hostLab;
    private TextVar m_hostText;
    private Label m_portLab;
    private TextVar m_portText;
    private Label m_userLab;
    private TextVar m_userText;
    private Label m_passLab;
    private TextVar m_passText;
    private Label m_keyspaceLab;
    private TextVar m_keyspaceText;
    private Label m_compressionLab;
    private Button m_useCompressionBut;
    private Label m_outputTuplesLab;
    private Button m_outputTuplesBut;
    private Label m_useCQL3Lab;
    private Button m_useCQL3Check;
    private Label m_useThriftLab;
    private Button m_useThriftCheck;
    private Label m_timeoutLab;
    private TextVar m_timeoutText;
    private Label m_positionLab;
    private Button m_showSchemaBut;
    private Label m_cqlLab;
    private StyledTextComp m_cqlText;
    private Button m_executeForEachRowBut;

    public CassandraInputDialog(Shell parent, Object in, TransMeta tr, String name) {
        super(parent, (BaseStepMeta)in, tr, name);
        this.m_currentMeta = (CassandraInputMeta)((Object)in);
        this.m_originalMeta = (CassandraInputMeta)((Object)this.m_currentMeta.clone());
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.m_currentMeta);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CassandraInputDialog.this.m_currentMeta.setChanged();
            }
        };
        this.changed = this.m_currentMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.m_stepnameLabel = new Label((Composite)this.shell, 131072);
        this.m_stepnameLabel.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.StepName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_stepnameLabel);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment(0, margin);
        this.m_stepnameLabel.setLayoutData((Object)fd);
        this.m_stepnameText = new Text((Composite)this.shell, 18436);
        this.m_stepnameText.setText(this.stepname);
        this.props.setLook((Control)this.m_stepnameText);
        this.m_stepnameText.addModifyListener(lsMod);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(100, 0);
        this.m_stepnameText.setLayoutData((Object)fd);
        this.m_hostLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_hostLab);
        this.m_hostLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Hostname.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_stepnameText, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_hostLab.setLayoutData((Object)fd);
        this.m_hostText = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_hostText);
        this.m_hostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CassandraInputDialog.this.m_hostText.setToolTipText(CassandraInputDialog.this.transMeta.environmentSubstitute(CassandraInputDialog.this.m_hostText.getText()));
            }
        });
        this.m_hostText.addModifyListener(lsMod);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_stepnameText, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_hostText.setLayoutData((Object)fd);
        this.m_portLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_portLab);
        this.m_portLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Port.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_hostText, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_portLab.setLayoutData((Object)fd);
        this.m_portText = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_portText);
        this.m_portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CassandraInputDialog.this.m_portText.setToolTipText(CassandraInputDialog.this.transMeta.environmentSubstitute(CassandraInputDialog.this.m_portText.getText()));
            }
        });
        this.m_portText.addModifyListener(lsMod);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_hostText, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_portText.setLayoutData((Object)fd);
        this.m_timeoutLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_timeoutLab);
        this.m_timeoutLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Timeout.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_portText, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_timeoutLab.setLayoutData((Object)fd);
        this.m_timeoutText = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_timeoutText);
        this.m_timeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CassandraInputDialog.this.m_timeoutText.setToolTipText(CassandraInputDialog.this.transMeta.environmentSubstitute(CassandraInputDialog.this.m_timeoutText.getText()));
            }
        });
        this.m_timeoutText.addModifyListener(lsMod);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_portText, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_timeoutText.setLayoutData((Object)fd);
        this.m_userLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_userLab);
        this.m_userLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.User.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_timeoutText, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_userLab.setLayoutData((Object)fd);
        this.m_userText = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_userText);
        this.m_userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CassandraInputDialog.this.m_userText.setToolTipText(CassandraInputDialog.this.transMeta.environmentSubstitute(CassandraInputDialog.this.m_userText.getText()));
            }
        });
        this.m_userText.addModifyListener(lsMod);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_timeoutText, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_userText.setLayoutData((Object)fd);
        this.m_passLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_passLab);
        this.m_passLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Password.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_userText, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_passLab.setLayoutData((Object)fd);
        this.m_passText = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_passText);
        this.m_passText.setEchoChar('*');
        this.m_passText.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CassandraInputDialog.this.checkPasswordVisible();
            }
        });
        this.m_passText.addModifyListener(lsMod);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_userText, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_passText.setLayoutData((Object)fd);
        this.m_keyspaceLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_keyspaceLab);
        this.m_keyspaceLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Keyspace.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_passText, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_keyspaceLab.setLayoutData((Object)fd);
        this.m_keyspaceText = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.m_keyspaceText);
        this.m_keyspaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CassandraInputDialog.this.m_keyspaceText.setToolTipText(CassandraInputDialog.this.transMeta.environmentSubstitute(CassandraInputDialog.this.m_keyspaceText.getText()));
            }
        });
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_passText, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_keyspaceText.setLayoutData((Object)fd);
        this.m_outputTuplesLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_outputTuplesLab);
        this.m_outputTuplesLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.OutputTuples.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_keyspaceText, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_outputTuplesLab.setLayoutData((Object)fd);
        this.m_outputTuplesBut = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.m_outputTuplesBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_keyspaceText, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_outputTuplesBut.setLayoutData((Object)fd);
        this.m_outputTuplesBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CassandraInputDialog.this.checkWidgets();
            }
        });
        this.m_useCQL3Lab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_useCQL3Lab);
        this.m_useCQL3Lab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.UseCQL3.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_outputTuplesBut, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_useCQL3Lab.setLayoutData((Object)fd);
        this.m_useCQL3Check = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.m_useCQL3Check);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_outputTuplesBut, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_useCQL3Check.setLayoutData((Object)fd);
        this.m_useCQL3Check.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CassandraInputDialog.this.checkWidgets();
            }
        });
        this.m_useThriftLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_useThriftLab);
        this.m_useThriftLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Thrift.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_useCQL3Check, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_useThriftLab.setLayoutData((Object)fd);
        this.m_useThriftCheck = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.m_useThriftCheck);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_useCQL3Check, margin);
        fd.left = new FormAttachment(middle, 0);
        this.m_useThriftCheck.setLayoutData((Object)fd);
        this.m_useThriftCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CassandraInputDialog.this.checkWidgets();
            }
        });
        this.m_compressionLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)this.m_compressionLab);
        this.m_compressionLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.UseCompression.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_useThriftCheck, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_compressionLab.setLayoutData((Object)fd);
        this.m_useCompressionBut = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.m_useCompressionBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_useThriftCheck, margin);
        this.m_useCompressionBut.setLayoutData((Object)fd);
        this.m_useCompressionBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CassandraInputDialog.this.m_currentMeta.setChanged();
            }
        });
        Label executeForEachLab = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)executeForEachLab);
        executeForEachLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.ExecuteForEachRow.Label", (String[])new String[0]));
        fd = new FormData();
        fd.right = new FormAttachment(middle, -margin);
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_useCompressionBut, margin);
        executeForEachLab.setLayoutData((Object)fd);
        this.m_executeForEachRowBut = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.m_executeForEachRowBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_useCompressionBut, margin);
        this.m_executeForEachRowBut.setLayoutData((Object)fd);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wPreview, this.wCancel}, margin, (Control)this.m_cqlText);
        this.m_positionLab = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)this.m_positionLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.bottom = new FormAttachment((Control)this.wOK, -margin);
        this.m_positionLab.setLayoutData((Object)fd);
        this.m_showSchemaBut = new Button((Composite)this.shell, 8);
        this.m_showSchemaBut.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Schema.Button", (String[])new String[0]));
        this.props.setLook((Control)this.m_showSchemaBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment((Control)this.wOK, -margin);
        this.m_showSchemaBut.setLayoutData((Object)fd);
        this.m_showSchemaBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CassandraInputDialog.this.popupSchemaInfo();
            }
        });
        this.m_cqlLab = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)this.m_cqlLab);
        this.m_cqlLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.CQL.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_executeForEachRowBut, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_cqlLab.setLayoutData((Object)fd);
        this.m_cqlText = new StyledTextComp((VariableSpace)this.transMeta, (Composite)this.shell, 19202, "");
        this.props.setLook((Control)this.m_cqlText, 1);
        this.m_cqlText.addModifyListener(lsMod);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_cqlLab, margin);
        fd.right = new FormAttachment(100, -2 * margin);
        fd.bottom = new FormAttachment((Control)this.m_showSchemaBut, -margin);
        this.m_cqlText.setLayoutData((Object)fd);
        this.m_cqlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CassandraInputDialog.this.setPosition();
                CassandraInputDialog.this.m_cqlText.setToolTipText(CassandraInputDialog.this.transMeta.environmentSubstitute(CassandraInputDialog.this.m_cqlText.getText()));
            }
        });
        this.m_cqlText.addLineStyleListener((LineStyleListener)new SQLValuesHighlight());
        this.m_cqlText.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                CassandraInputDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                CassandraInputDialog.this.setPosition();
            }
        });
        this.m_cqlText.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                CassandraInputDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                CassandraInputDialog.this.setPosition();
            }
        });
        this.m_cqlText.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                CassandraInputDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                CassandraInputDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                CassandraInputDialog.this.setPosition();
            }
        });
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                CassandraInputDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                CassandraInputDialog.this.ok();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                CassandraInputDialog.this.preview();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.wPreview.addListener(13, this.lsPreview);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CassandraInputDialog.this.ok();
            }
        };
        this.m_stepnameText.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                CassandraInputDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void checkWidgets() {
        if (this.m_outputTuplesBut.getSelection()) {
            this.m_useThriftCheck.setEnabled(true);
        } else {
            this.m_useThriftCheck.setSelection(false);
            this.m_useThriftCheck.setEnabled(false);
        }
        if (this.m_useCQL3Check.getSelection()) {
            this.m_useThriftCheck.setSelection(false);
            this.m_useThriftCheck.setEnabled(false);
        } else if (this.m_outputTuplesBut.getSelection()) {
            this.m_useThriftCheck.setEnabled(true);
        }
        if (this.m_useThriftCheck.getSelection()) {
            this.m_useCQL3Check.setSelection(false);
            this.m_useCQL3Check.setEnabled(false);
        } else {
            this.m_useCQL3Check.setEnabled(true);
        }
        this.checkWidgetsWithRespectToDriver(ConnectionFactory.Driver.LEGACY_THRIFT);
    }

    private void checkWidgetsWithRespectToDriver(ConnectionFactory.Driver d) {
        Connection c = ConnectionFactory.getFactory().getConnection(d);
        this.m_useCQL3Check.setEnabled(c.supportsCQL());
        if (!c.supportsCQL()) {
            this.m_useCQL3Check.setSelection(false);
            this.m_outputTuplesBut.setEnabled(true);
            this.m_outputTuplesBut.setSelection(true);
            this.m_useThriftCheck.setEnabled(true);
            this.m_useThriftCheck.setSelection(true);
        }
        if (this.m_useThriftCheck.getEnabled()) {
            this.m_useThriftCheck.setEnabled(c.supportsNonCQL());
        }
        if (!c.supportsNonCQL()) {
            this.m_useThriftCheck.setSelection(false);
        }
        if (this.m_useCQL3Check.getSelection()) {
            this.m_outputTuplesBut.setSelection(false);
            this.m_outputTuplesBut.setEnabled(false);
            this.m_outputTuplesLab.setToolTipText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.OutputTuples.TipText", (String[])new String[0]));
        } else {
            this.m_outputTuplesBut.setEnabled(true);
            this.m_outputTuplesLab.setToolTipText("");
        }
    }

    private void getInfo(CassandraInputMeta meta) {
        meta.setCassandraHost(this.m_hostText.getText());
        meta.setCassandraPort(this.m_portText.getText());
        meta.setSocketTimeout(this.m_timeoutText.getText());
        meta.setUsername(this.m_userText.getText());
        meta.setPassword(this.m_passText.getText());
        meta.setCassandraKeyspace(this.m_keyspaceText.getText());
        meta.setUseCompression(this.m_useCompressionBut.getSelection());
        meta.setOutputKeyValueTimestampTuples(this.m_outputTuplesBut.getSelection());
        meta.setUseThriftIO(this.m_useThriftCheck.getSelection());
        meta.setUseCQL3(this.m_useCQL3Check.getSelection());
        meta.setCQLSelectQuery(this.m_cqlText.getText());
        meta.setExecuteForEachIncomingRow(this.m_executeForEachRowBut.getSelection());
    }

    protected void ok() {
        if (Const.isEmpty((String)this.m_stepnameText.getText())) {
            return;
        }
        this.stepname = this.m_stepnameText.getText();
        this.getInfo(this.m_currentMeta);
        if (!((Object)((Object)this.m_originalMeta)).equals((Object)this.m_currentMeta)) {
            this.m_currentMeta.setChanged();
            this.changed = this.m_currentMeta.hasChanged();
        }
        this.dispose();
    }

    protected void cancel() {
        this.stepname = null;
        this.m_currentMeta.setChanged(this.changed);
        this.dispose();
    }

    protected void getData() {
        if (!Const.isEmpty((String)this.m_currentMeta.getCassandraHost())) {
            this.m_hostText.setText(this.m_currentMeta.getCassandraHost());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getCassandraPort())) {
            this.m_portText.setText(this.m_currentMeta.getCassandraPort());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getSocketTimeout())) {
            this.m_timeoutText.setText(this.m_currentMeta.getSocketTimeout());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getUsername())) {
            this.m_userText.setText(this.m_currentMeta.getUsername());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getPassword())) {
            this.m_passText.setText(this.m_currentMeta.getPassword());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getCassandraKeyspace())) {
            this.m_keyspaceText.setText(this.m_currentMeta.getCassandraKeyspace());
        }
        this.m_useCompressionBut.setSelection(this.m_currentMeta.getUseCompression());
        this.m_outputTuplesBut.setSelection(this.m_currentMeta.getOutputKeyValueTimestampTuples());
        this.m_useThriftCheck.setSelection(this.m_currentMeta.getUseThriftIO());
        this.m_useCQL3Check.setSelection(this.m_currentMeta.getUseCQL3());
        this.m_executeForEachRowBut.setSelection(this.m_currentMeta.getExecuteForEachIncomingRow());
        if (!Const.isEmpty((String)this.m_currentMeta.getCQLSelectQuery())) {
            this.m_cqlText.setText(this.m_currentMeta.getCQLSelectQuery());
        }
        this.checkWidgets();
    }

    protected void setPosition() {
        String scr = this.m_cqlText.getText();
        int linenr = this.m_cqlText.getLineAtOffset(this.m_cqlText.getCaretOffset()) + 1;
        int posnr = this.m_cqlText.getCaretOffset();
        int colnr = 0;
        while (posnr > 0 && scr.charAt(posnr - 1) != '\n' && scr.charAt(posnr - 1) != '\r') {
            --posnr;
            ++colnr;
        }
        this.m_positionLab.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Position.Label", (String[])new String[]{"" + linenr, "" + colnr}));
    }

    private void checkPasswordVisible() {
        String password = this.m_passText.getText();
        ArrayList list = new ArrayList();
        StringUtil.getUsedVariables((String)password, list, (boolean)true);
        if (list.size() == 0) {
            this.m_passText.setEchoChar('*');
        } else {
            this.m_passText.setEchoChar('\u0000');
        }
    }

    private boolean checkForUnresolved(CassandraInputMeta meta, String title) {
        boolean notOk;
        String query = this.transMeta.environmentSubstitute(meta.getCQLSelectQuery());
        boolean bl = notOk = query.contains("${") || query.contains("?{");
        if (notOk) {
            ShowMessageDialog smd = new ShowMessageDialog(this.shell, 40, title, BaseMessages.getString(PKG, (String)"CassandraInputDialog.Warning.Message.CassandraQueryContainsUnresolvedVarsFieldSubs", (String[])new String[0]));
            smd.open();
        }
        return !notOk;
    }

    private void preview() {
        CassandraInputMeta oneMeta = new CassandraInputMeta();
        this.getInfo(oneMeta);
        oneMeta.setExecuteForEachIncomingRow(false);
        if (!this.checkForUnresolved(oneMeta, BaseMessages.getString(PKG, (String)"CassandraInputDialog.Warning.Message.CassandraQueryContainsUnresolvedVarsFieldSubs.PreviewTitle", (String[])new String[0]))) {
            return;
        }
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.m_stepnameText.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"CassandraInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CassandraInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.m_stepnameText.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.m_stepnameText.getText(), progressDialog.getPreviewRowsMeta(this.m_stepnameText.getText()), progressDialog.getPreviewRows(this.m_stepnameText.getText()), loggingText);
            prd.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void popupSchemaInfo() {
        Connection conn = null;
        Keyspace kSpace = null;
        try {
            String hostS = this.transMeta.environmentSubstitute(this.m_hostText.getText());
            String portS = this.transMeta.environmentSubstitute(this.m_portText.getText());
            String userS = this.m_userText.getText();
            String passS = this.m_passText.getText();
            if (!Const.isEmpty((String)userS) && !Const.isEmpty((String)passS)) {
                userS = this.transMeta.environmentSubstitute(userS);
                passS = this.transMeta.environmentSubstitute(passS);
            }
            String keyspaceS = this.transMeta.environmentSubstitute(this.m_keyspaceText.getText());
            String cqlText = this.transMeta.environmentSubstitute(this.m_cqlText.getText());
            try {
                HashMap<String, String> opts = new HashMap<String, String>();
                if (this.m_useCQL3Check.getSelection()) {
                    opts.put("cqlVersion", "3.0.1");
                }
                conn = CassandraUtils.getCassandraConnection(hostS, Integer.parseInt(portS), userS, passS, ConnectionFactory.Driver.LEGACY_THRIFT, opts);
                conn.setHosts(hostS);
                conn.setDefaultPort(Integer.parseInt(portS));
                conn.setUsername(userS);
                conn.setPassword(passS);
                kSpace = conn.getKeyspace(keyspaceS);
            }
            catch (InvalidRequestException ire) {
                this.logError(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + ire.why, ire);
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CassandraInputDialog.Error.ProblemGettingSchemaInfo.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CassandraInputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + ire.why, (Exception)((Object)ire));
                if (conn != null) {
                    try {
                        conn.closeConnection();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return;
            }
            String colFam = CassandraUtils.getColumnFamilyNameFromCQLSelectQuery(cqlText);
            if (Const.isEmpty((String)colFam)) {
                throw new Exception(BaseMessages.getString(PKG, (String)"CassandraInput.Error.NoFromClauseInQuery", (String[])new String[0]));
            }
            if (!kSpace.columnFamilyExists(colFam)) {
                throw new Exception(BaseMessages.getString(PKG, (String)"CassandraInput.Error.NonExistentColumnFamily", (String[])new String[]{colFam, keyspaceS}));
            }
            CassandraColumnMetaData cassMeta = (CassandraColumnMetaData)kSpace.getColumnFamilyMetaData(colFam);
            String schemaDescription = cassMeta.getSchemaDescription();
            ShowMessageDialog smd = new ShowMessageDialog(this.shell, 34, "Schema info", schemaDescription, true);
            smd.open();
        }
        catch (Exception e1) {
            this.logError(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + e1.getMessage(), e1);
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Error.ProblemGettingSchemaInfo.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + e1.getMessage(), e1);
        }
        finally {
            if (conn != null) {
                try {
                    conn.closeConnection();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

