/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.typing.Type;

public class DefaultLocalizationContext
implements LocalizationContext,
Serializable {
    private static final String CONFIG_TIMEZONE_KEY = "org.pentaho.reporting.libraries.formula.timezone";
    private static final String CONFIG_LOCALE_KEY = "org.pentaho.reporting.libraries.formula.locale";
    private ArrayList<DateFormat> dateFormats = new ArrayList();
    private ArrayList<DateFormat> datetimeFormats = new ArrayList();
    private ArrayList<DateFormat> timeFormats = new ArrayList();
    private ArrayList<NumberFormat> numberFormats = new ArrayList();
    private Locale locale;
    private TimeZone timeZone;

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public ResourceBundle getBundle(String id) {
        return ResourceBundle.getBundle(id, this.getLocale());
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public List<DateFormat> getDateFormats(Type type) {
        if (type.isFlagSet(64)) {
            return (List)this.dateFormats.clone();
        }
        if (type.isFlagSet(256)) {
            return (List)this.datetimeFormats.clone();
        }
        if (type.isFlagSet(128)) {
            return (List)this.timeFormats.clone();
        }
        return Collections.emptyList();
    }

    @Override
    public List<NumberFormat> getNumberFormats() {
        return (List)this.numberFormats.clone();
    }

    private String[] createLocale(String locale) {
        StringTokenizer strtok = new StringTokenizer(locale, "_");
        String[] retval = new String[]{strtok.hasMoreElements() ? strtok.nextToken() : "", strtok.hasMoreElements() ? strtok.nextToken() : "", strtok.hasMoreElements() ? strtok.nextToken() : ""};
        return retval;
    }

    public void initialize(Configuration config) {
        this.initialize(config, null, null);
    }

    public void initialize(Configuration config, Locale locale, TimeZone timeZone) {
        DateFormat dateFormat;
        int i;
        if (config == null) {
            throw new NullPointerException();
        }
        if (locale == null) {
            String declaredLocale = config.getConfigProperty(CONFIG_LOCALE_KEY, Locale.getDefault().toString());
            String[] declaredLocaleParts = this.createLocale(declaredLocale);
            this.locale = new Locale(declaredLocaleParts[0], declaredLocaleParts[1], declaredLocaleParts[2]);
        } else {
            this.locale = locale;
        }
        if (timeZone == null) {
            String timeZoneId = config.getConfigProperty(CONFIG_TIMEZONE_KEY, TimeZone.getDefault().getID());
            this.timeZone = TimeZone.getTimeZone(timeZoneId);
        } else {
            this.timeZone = TimeZone.getDefault();
        }
        Locale[] locales = new Locale[]{this.getLocale(), Locale.US};
        for (i = 0; i < locales.length; ++i) {
            Locale activeLocale = locales[i];
            this.datetimeFormats.add(DateFormat.getDateTimeInstance(0, 0, activeLocale));
            this.dateFormats.add(DateFormat.getDateInstance(0, activeLocale));
            this.timeFormats.add(DateFormat.getTimeInstance(0, activeLocale));
            this.datetimeFormats.add(DateFormat.getDateTimeInstance(1, 1, activeLocale));
            this.dateFormats.add(DateFormat.getDateInstance(1, activeLocale));
            this.timeFormats.add(DateFormat.getTimeInstance(1, activeLocale));
            this.datetimeFormats.add(DateFormat.getDateTimeInstance(2, 2, activeLocale));
            this.dateFormats.add(DateFormat.getDateInstance(2, activeLocale));
            this.timeFormats.add(DateFormat.getTimeInstance(2, activeLocale));
            this.datetimeFormats.add(DateFormat.getDateTimeInstance(3, 3, activeLocale));
            this.dateFormats.add(DateFormat.getDateInstance(3, activeLocale));
            this.timeFormats.add(DateFormat.getTimeInstance(3, activeLocale));
            this.numberFormats.add(new DecimalFormat("#0.#############################", new DecimalFormatSymbols(activeLocale)));
            this.numberFormats.add(NumberFormat.getCurrencyInstance(activeLocale));
            this.numberFormats.add(NumberFormat.getInstance(activeLocale));
            this.numberFormats.add(NumberFormat.getIntegerInstance(activeLocale));
            this.numberFormats.add(NumberFormat.getNumberInstance(activeLocale));
            this.numberFormats.add(NumberFormat.getPercentInstance(activeLocale));
        }
        this.datetimeFormats.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US));
        this.datetimeFormats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US));
        this.dateFormats.add(new SimpleDateFormat("yyyy-MM-dd", Locale.US));
        this.timeFormats.add(new SimpleDateFormat("HH:mm:ss", Locale.US));
        this.timeFormats.add(new SimpleDateFormat("HH:mm", Locale.US));
        for (i = 0; i < this.dateFormats.size(); ++i) {
            dateFormat = this.dateFormats.get(i);
            dateFormat.setLenient(false);
        }
        for (i = 0; i < this.datetimeFormats.size(); ++i) {
            dateFormat = this.datetimeFormats.get(i);
            dateFormat.setLenient(false);
        }
        for (i = 0; i < this.timeFormats.size(); ++i) {
            dateFormat = this.timeFormats.get(i);
            dateFormat.setLenient(false);
        }
        for (i = 0; i < this.numberFormats.size(); ++i) {
            NumberFormat format = this.numberFormats.get(i);
            if (!(format instanceof DecimalFormat)) continue;
            DecimalFormat fmt = (DecimalFormat)format;
            fmt.setParseBigDecimal(true);
        }
    }
}

