/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.typing;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.lvalues.DefaultDataTable;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.DefaultComparator;
import org.pentaho.reporting.libraries.formula.typing.ExtendedComparator;
import org.pentaho.reporting.libraries.formula.typing.NumberSequence;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeConversionException;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.DateTimeType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;
import org.pentaho.reporting.libraries.formula.typing.sequence.AnyNumberSequence;
import org.pentaho.reporting.libraries.formula.typing.sequence.AnySequence;
import org.pentaho.reporting.libraries.formula.typing.sequence.DefaultNumberSequence;
import org.pentaho.reporting.libraries.formula.util.DateUtil;
import org.pentaho.reporting.libraries.formula.util.HSSFDateUtil;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class DefaultTypeRegistry
implements TypeRegistry {
    private static final Log logger = LogFactory.getLog(DefaultTypeRegistry.class);
    private static final BigDecimal NUM_TRUE = new BigDecimal("1");
    private static final BigDecimal NUM_FALSE;
    private static final BigDecimal ZERO;
    private FormulaContext context;

    @Override
    public ExtendedComparator getComparator(Type type1, Type type2) {
        DefaultComparator comparator = new DefaultComparator();
        comparator.inititalize(this.context);
        return comparator;
    }

    @Override
    public Number convertToNumber(Type sourceType, Object value) throws EvaluationException {
        LocalizationContext localizationContext = this.context.getLocalizationContext();
        if (value == null) {
            throw TypeConversionException.getInstance();
        }
        boolean isAnyType = sourceType.isFlagSet(1);
        if (sourceType.isFlagSet(16) || isAnyType) {
            if ((sourceType.isFlagSet(256) || sourceType.isFlagSet(128) || sourceType.isFlagSet(64) || isAnyType) && value instanceof java.util.Date) {
                BigDecimal serial = HSSFDateUtil.getExcelDate((java.util.Date)value);
                return DateUtil.normalizeDate(serial, sourceType);
            }
            if (value instanceof Number) {
                return (Number)value;
            }
        }
        if ((sourceType.isFlagSet(32) || isAnyType) && value instanceof Boolean) {
            if (Boolean.TRUE.equals(value)) {
                return NUM_TRUE;
            }
            return NUM_FALSE;
        }
        if (sourceType.isFlagSet(2) || isAnyType) {
            String val = this.computeStringValue(value);
            try {
                return new BigDecimal(val);
            }
            catch (NumberFormatException e) {
                java.util.Date date;
                for (DateFormat df : localizationContext.getDateFormats(DateTimeType.DATETIME_TYPE)) {
                    date = DefaultTypeRegistry.parse(df, val);
                    if (date == null) continue;
                    return HSSFDateUtil.getExcelDate(date);
                }
                for (DateFormat df : localizationContext.getDateFormats(DateTimeType.DATE_TYPE)) {
                    date = DefaultTypeRegistry.parse(df, val);
                    if (date == null) continue;
                    return HSSFDateUtil.getExcelDate(date);
                }
                for (DateFormat df : localizationContext.getDateFormats(DateTimeType.TIME_TYPE)) {
                    date = DefaultTypeRegistry.parse(df, val);
                    if (date == null) continue;
                    return HSSFDateUtil.getExcelDate(date);
                }
                for (NumberFormat format : localizationContext.getNumberFormats()) {
                    Number number = DefaultTypeRegistry.parse(format, val);
                    if (number == null) continue;
                    return number;
                }
            }
        }
        throw TypeConversionException.getInstance();
    }

    private static Number parse(NumberFormat format, String source) {
        ParsePosition parsePosition = new ParsePosition(0);
        Number result = format.parse(source, parsePosition);
        if (parsePosition.getIndex() == 0 || parsePosition.getIndex() != source.length()) {
            return null;
        }
        return result;
    }

    private static java.util.Date parse(DateFormat format, String source) {
        ParsePosition parsePosition = new ParsePosition(0);
        java.util.Date result = format.parse(source, parsePosition);
        if (parsePosition.getIndex() == 0 || parsePosition.getIndex() != source.length()) {
            return null;
        }
        return result;
    }

    public void initialize(Configuration configuration, FormulaContext formulaContext) {
        this.initialize(formulaContext);
    }

    public void initialize(FormulaContext formulaContext) {
        if (formulaContext == null) {
            throw new NullPointerException();
        }
        this.context = formulaContext;
    }

    @Override
    public String convertToText(Type type1, Object value) throws EvaluationException {
        if (value == null) {
            return "";
        }
        if (type1.isFlagSet(2)) {
            return this.computeStringValue(value);
        }
        if (type1.isFlagSet(32)) {
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                if (Boolean.TRUE.equals(b)) {
                    return "TRUE";
                }
                return "FALSE";
            }
            throw TypeConversionException.getInstance();
        }
        if (type1.isFlagSet(16)) {
            LocalizationContext localizationContext = this.context.getLocalizationContext();
            if (type1.isFlagSet(256) || type1.isFlagSet(64) || type1.isFlagSet(128)) {
                java.util.Date d = this.convertToDate(type1, value);
                List<DateFormat> dateFormats = localizationContext.getDateFormats(type1);
                if (dateFormats != null && dateFormats.size() >= 1) {
                    DateFormat format = dateFormats.get(0);
                    return format.format(d);
                }
                return DateFormat.getDateTimeInstance(0, 0, localizationContext.getLocale()).format(d);
            }
            try {
                Number n = this.convertToNumber(type1, value);
                List<NumberFormat> numberFormats = localizationContext.getNumberFormats();
                if (numberFormats.isEmpty()) {
                    return NumberFormat.getNumberInstance(localizationContext.getLocale()).format(n);
                }
                numberFormats.get(0).format(n);
            }
            catch (EvaluationException nfe) {
                // empty catch block
            }
        }
        return this.computeStringValue(value);
    }

    private String computeStringValue(Object retval) {
        if (retval instanceof Clob) {
            try {
                return IOUtils.getInstance().readClob((Clob)retval);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (retval != null) {
            return retval.toString();
        }
        return null;
    }

    @Override
    public Boolean convertToLogical(Type type1, Object value) throws TypeConversionException {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (type1.isFlagSet(32) || type1.isFlagSet(1)) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if ("true".equalsIgnoreCase(String.valueOf(value))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (type1.isFlagSet(16)) {
            Number num;
            if (value instanceof Number && !ZERO.equals(num = (Number)value)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (type1.isFlagSet(2)) {
            String str = this.computeStringValue(value);
            if ("TRUE".equalsIgnoreCase(str)) {
                return Boolean.TRUE;
            }
            if ("FALSE".equalsIgnoreCase(str)) {
                return Boolean.FALSE;
            }
        }
        throw TypeConversionException.getInstance();
    }

    @Override
    public java.util.Date convertToDate(Type type1, Object value) throws EvaluationException {
        if ((type1.isFlagSet(16) || type1.isFlagSet(1)) && (type1.isFlagSet(64) || type1.isFlagSet(256) || type1.isFlagSet(128) || type1.isFlagSet(1)) && value instanceof java.util.Date) {
            return DateUtil.normalizeDate((java.util.Date)value, type1);
        }
        Number serial = this.convertToNumber(type1, value);
        BigDecimal bd = NumberUtil.getAsBigDecimal(serial);
        return HSSFDateUtil.getJavaDate(bd);
    }

    @Override
    public ArrayCallback convertToArray(Type type, Object value) throws EvaluationException {
        if (value instanceof ArrayCallback) {
            return (ArrayCallback)value;
        }
        if (value == null) {
            return new DefaultDataTable().getAsArray();
        }
        Class<?> valueType = value.getClass();
        if (!valueType.isArray()) {
            if (value instanceof Collection) {
                Collection colVal = (Collection)value;
                DefaultDataTable table = new DefaultDataTable();
                Iterator iterator = colVal.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    table.setObject(i, 0, new StaticValue(iterator.next()));
                    ++i;
                }
                return table.getAsArray();
            }
            return new ArrayConverterCallback(value, type);
        }
        Class<?> componentType = valueType.getComponentType();
        if (componentType.isArray()) {
            DefaultDataTable table = new DefaultDataTable();
            int length = Array.getLength(value);
            for (int row = 0; row < length; ++row) {
                Object innerArray = Array.get(value, row);
                int innerLength = Array.getLength(innerArray);
                for (int col = 0; col < innerLength; ++col) {
                    table.setObject(row, col, new StaticValue(Array.get(innerArray, col)));
                }
            }
            return table.getAsArray();
        }
        DefaultDataTable table = new DefaultDataTable();
        int length = Array.getLength(value);
        for (int i = 0; i < length; ++i) {
            table.setObject(i, 0, new StaticValue(Array.get(value, i)));
        }
        return table.getAsArray();
    }

    private TypeValuePair convertToSequence(Type targetType, TypeValuePair valuePair) throws EvaluationException {
        if (targetType.isFlagSet(2048)) {
            return new TypeValuePair(targetType, this.convertToNumberSequence(valuePair.getType(), valuePair.getValue(), true));
        }
        return new TypeValuePair(targetType, this.convertToSequence(valuePair.getType(), valuePair.getValue()));
    }

    @Override
    public Sequence convertToSequence(Type type, Object value) throws EvaluationException {
        if (type.isFlagSet(8)) {
            return new AnySequence(new StaticValue(value, type), this.context);
        }
        if (type.isFlagSet(1024)) {
            if (value instanceof Sequence) {
                return (Sequence)value;
            }
            logger.warn((Object)"Assertation failure: Type declared to be a sequence, but no sequence found inside.");
            throw TypeConversionException.getInstance();
        }
        if (type.isFlagSet(512)) {
            if (value instanceof ArrayCallback) {
                return new AnySequence((ArrayCallback)value, this.context);
            }
            if (value instanceof Object[]) {
                return new AnySequence(this.convertToArray(type, value), this.context);
            }
            logger.warn((Object)"Assertation failure: Type declared to be array, but no array callback found inside.");
            throw TypeConversionException.getInstance();
        }
        throw TypeConversionException.getInstance();
    }

    @Override
    public NumberSequence convertToNumberSequence(Type type, Object value, boolean strict) throws EvaluationException {
        if (type.isFlagSet(2048)) {
            if (value instanceof DefaultNumberSequence) {
                return (NumberSequence)value;
            }
            return new DefaultNumberSequence(this.context);
        }
        if (type.isFlagSet(512)) {
            if (value instanceof ArrayCallback) {
                if (strict) {
                    return new DefaultNumberSequence((ArrayCallback)value, this.context);
                }
                return new AnyNumberSequence((ArrayCallback)value, this.context);
            }
            logger.warn((Object)"Assertation failure: Type declared to be array, but no array callback found inside.");
            throw TypeConversionException.getInstance();
        }
        if (type.isFlagSet(8) || type.isFlagSet(16)) {
            return new DefaultNumberSequence(new StaticValue((Object)this.convertToNumber(type, value), NumberType.GENERIC_NUMBER), this.context);
        }
        return new DefaultNumberSequence(this.context);
    }

    @Override
    public TypeValuePair convertTo(Type targetType, TypeValuePair valuePair) throws EvaluationException {
        Object o;
        if (targetType.isFlagSet(512)) {
            if (valuePair.getType().isFlagSet(512)) {
                return valuePair;
            }
            if (targetType.isFlagSet(1024)) {
                return this.convertTo(targetType, valuePair);
            }
            Object o2 = valuePair.getValue();
            if (o2 != null && o2.getClass().isArray()) {
                return new TypeValuePair(targetType, this.convertToArray(valuePair.getType(), o2));
            }
            Object retval = this.convertPlainToPlain(targetType, valuePair.getType(), valuePair.getValue());
            return new TypeValuePair(targetType, new ArrayConverterCallback(retval, targetType));
        }
        if (targetType.isFlagSet(1024)) {
            if (valuePair.getType().isFlagSet(512)) {
                return this.convertToSequence(targetType, valuePair);
            }
            if (targetType.isFlagSet(1024)) {
                return valuePair;
            }
            Object retval = this.convertPlainToPlain(targetType, valuePair.getType(), valuePair.getValue());
            ArrayConverterCallback converterCallback = new ArrayConverterCallback(retval, targetType);
            return this.convertToSequence(targetType, new TypeValuePair(AnyType.ANY_ARRAY, converterCallback));
        }
        Object value = valuePair.getValue();
        if (value == (o = this.convertPlainToPlain(targetType, valuePair.getType(), value))) {
            return valuePair;
        }
        return new TypeValuePair(targetType, o);
    }

    private Object convertPlainToPlain(Type targetType, Type sourceType, Object value) throws EvaluationException {
        if (targetType.isFlagSet(16)) {
            if (targetType.isFlagSet(32)) {
                if (sourceType.isFlagSet(32)) {
                    return value;
                }
                return this.convertToLogical(sourceType, value);
            }
            if (value instanceof java.util.Date && (targetType.isFlagSet(64) || targetType.isFlagSet(256) || targetType.isFlagSet(128))) {
                java.util.Date toJavaDate = (java.util.Date)value;
                return DateUtil.normalizeDate(toJavaDate, targetType, false);
            }
            Number serial = this.convertToNumber(sourceType, value);
            if (targetType.isFlagSet(64) || targetType.isFlagSet(256) || targetType.isFlagSet(128)) {
                BigDecimal fromAsBigDecimal = NumberUtil.getAsBigDecimal(serial);
                BigDecimal normalizedSerial = DateUtil.normalizeDate(fromAsBigDecimal, targetType);
                java.util.Date toJavaDate = HSSFDateUtil.getJavaDate(normalizedSerial);
                return DateUtil.normalizeDate(toJavaDate, targetType, false);
            }
            return serial;
        }
        if (targetType.isFlagSet(2)) {
            return this.convertToText(sourceType, value);
        }
        return value;
    }

    @Override
    public Type guessTypeOfObject(Object o) {
        if (o instanceof Number) {
            return NumberType.GENERIC_NUMBER;
        }
        if (o instanceof Time) {
            return DateTimeType.TIME_TYPE;
        }
        if (o instanceof Date) {
            return DateTimeType.DATE_TYPE;
        }
        if (o instanceof java.util.Date) {
            return DateTimeType.DATETIME_TYPE;
        }
        if (o instanceof Boolean) {
            return LogicalType.TYPE;
        }
        if (o instanceof String) {
            return TextType.TYPE;
        }
        return AnyType.TYPE;
    }

    static {
        ZERO = NUM_FALSE = new BigDecimal("0");
    }

    private static class ArrayConverterCallback
    implements ArrayCallback {
        private Object retval;
        private Type targetType;

        private ArrayConverterCallback(Object retval, Type targetType) {
            this.retval = retval;
            this.targetType = targetType;
        }

        @Override
        public LValue getRaw(int row, int column) {
            return new StaticValue(this.retval, this.targetType);
        }

        @Override
        public Object getValue(int row, int column) throws EvaluationException {
            if (row == 0 && column == 0) {
                return this.retval;
            }
            return null;
        }

        @Override
        public Type getType(int row, int column) throws EvaluationException {
            if (row == 0 && column == 0) {
                return this.targetType;
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return 1;
        }
    }
}

