/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.util;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.base.util.LinkedMap;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.lvalues.ContextLookup;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;
import org.pentaho.reporting.libraries.formula.lvalues.Term;
import org.pentaho.reporting.libraries.formula.parser.FormulaParser;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

public class FormulaUtil {
    private static final char QUOTE_CHAR = '\"';
    private static final char DEFAULT_CONTEXT_ID = '=';
    private static final char FORMULA_CONTEXT_SEPARATOR = ':';

    private FormulaUtil() {
    }

    public static String quoteReference(String reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        char[] referenceChars = reference.toCharArray();
        if (!FormulaUtil.isQuotingNeeded(referenceChars)) {
            return '[' + reference + ']';
        }
        return '[' + FormulaUtil.quoteString(reference) + ']';
    }

    private static boolean isQuotingNeeded(char[] referenceChars) {
        if (referenceChars == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < referenceChars.length; ++i) {
            char c = referenceChars[i];
            if (Character.isJavaIdentifierPart(c)) continue;
            return true;
        }
        return false;
    }

    public static String quoteString(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(text.length());
        char[] chars = text.toCharArray();
        b.append('\"');
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\"') {
                b.append('\"');
            }
            b.append(c);
        }
        b.append('\"');
        return b.toString();
    }

    public static Object[] getReferences(String formula) throws ParseException {
        if (formula == null) {
            throw new NullPointerException();
        }
        String formulaExpression = FormulaUtil.extractFormula(formula);
        if (formulaExpression == null) {
            throw new ParseException("Formula is invalid");
        }
        return FormulaUtil.getReferences(new Formula(formulaExpression));
    }

    public static Object[] getReferences(Formula formula) {
        if (formula == null) {
            throw new NullPointerException();
        }
        LinkedMap map = new LinkedMap();
        LValue lValue = formula.getRootReference();
        FormulaUtil.collectReferences(lValue, map);
        return map.keys();
    }

    private static void collectReferences(LValue lval, LinkedMap map) {
        if (lval instanceof Term) {
            Term t = (Term)lval;
            LValue[] childValues = t.getChildValues();
            for (int i = 0; i < childValues.length; ++i) {
                LValue childValue = childValues[i];
                FormulaUtil.collectReferences(childValue, map);
            }
        } else if (lval instanceof ContextLookup) {
            ContextLookup cl = (ContextLookup)lval;
            map.put((Object)cl.getName(), (Object)Boolean.TRUE);
        }
    }

    public static String extractFormula(String formula) {
        if (formula == null) {
            return null;
        }
        if (formula.length() > 0 && formula.charAt(0) == '=') {
            return formula.substring(1);
        }
        int separator = -1;
        char[] chars = formula.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            if (Character.isJavaIdentifierPart(aChar) || aChar != ':') continue;
            separator = i - 1;
            break;
        }
        if (separator <= 0 || separator + 1 == formula.length()) {
            return null;
        }
        return formula.substring(separator + 1);
    }

    public static String extractStaticTextFromFormula(String formula) {
        if (formula == null) {
            return null;
        }
        String formulaFragment = FormulaUtil.extractFormula(formula);
        return FormulaUtil.extractStaticTextFromFormulaFragment(formulaFragment);
    }

    public static String extractStaticTextFromFormulaFragment(String formula) {
        if (formula == null) {
            return null;
        }
        try {
            FormulaParser parser = new FormulaParser();
            LValue lValue = parser.parse(formula);
            if (lValue.isConstant() && lValue instanceof StaticValue) {
                StaticValue staticValue = (StaticValue)lValue;
                Object o = staticValue.getValue();
                if (o == null) {
                    return null;
                }
                return String.valueOf(o);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isValidFormulaFragment(String formula) {
        try {
            FormulaParser parser = new FormulaParser();
            LValue lValue = parser.parse(formula);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String createCellUITextFromFormula(String formula) {
        try {
            FormulaParser parser = new FormulaParser();
            LValue lValue = parser.parse(formula);
            if (lValue.isConstant() && lValue instanceof StaticValue) {
                StaticValue staticValue = (StaticValue)lValue;
                Object o = staticValue.getValue();
                if (o == null) {
                    return "=NA()";
                }
                return String.valueOf(o);
            }
            String cellText = lValue.toString();
            return cellText.startsWith("=") ? cellText : "=" + cellText;
        }
        catch (Exception e) {
            return formula.startsWith("=") ? formula : "=" + formula;
        }
    }

    public static String createEditorTextFromFormula(String formula, FormulaContext formulaContext) {
        try {
            FormulaParser parser = new FormulaParser();
            LValue lValue = parser.parse(formula);
            lValue.initialize(formulaContext);
            if (lValue.isConstant() && lValue instanceof StaticValue) {
                StaticValue staticValue = (StaticValue)lValue;
                Object o = staticValue.getValue();
                if (o == null) {
                    return "=NA()";
                }
                if (o instanceof Number) {
                    return String.valueOf(o);
                }
                return '\'' + String.valueOf(o);
            }
            String cellText = lValue.toString();
            return cellText.startsWith("=") ? cellText : "=" + cellText;
        }
        catch (Exception e) {
            return "'" + formula;
        }
    }

    public static String createFormulaFromUIText(String formula) {
        if (formula.startsWith("=")) {
            return formula.substring(1);
        }
        try {
            BigDecimal bd = new BigDecimal(formula.trim());
            return formula.trim();
        }
        catch (NumberFormatException numberFormatException) {
            if (formula.startsWith("'")) {
                return FormulaUtil.quoteString(formula.substring(1));
            }
            return FormulaUtil.quoteString(formula);
        }
    }
}

