/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.LastUsedFile;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.gui.GUIOption;
import org.pentaho.di.core.gui.GUIPositionInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.plugins.LifecyclePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.laf.BasePropertyHandler;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;

public class PropsUI
extends Props {
    private static final String NO = "N";
    private static final String YES = "Y";
    private static Display display;
    protected List<LastUsedFile> lastUsedFiles;
    protected List<LastUsedFile> openTabFiles;
    protected String overriddenFileName;
    private Hashtable<String, WindowProperty> screens;
    private static final String STRING_SHOW_COPY_OR_DISTRIBUTE_WARNING = "ShowCopyOrDistributeWarning";
    private static final String STRING_SHOW_WELCOME_PAGE_ON_STARTUP = "ShowWelcomePageOnStartup";
    private static final String STRING_SHOW_BRANDING_GRAPHICS = "ShowBrandingGraphics";
    private static final String STRING_ONLY_SHOW_ACTIVE_FILE = "OnlyShowActiveFileInTree";
    private static final String SHOW_TOOL_TIPS = "ShowToolTips";
    private static final String SHOW_HELP_TOOL_TIPS = "ShowHelpToolTips";
    private static final String CANVAS_GRID_SIZE = "CanvasGridSize";
    private static List<GUIOption<Object>> editables;

    public static final void init(Display d, int t) {
        if (props != null) {
            throw new RuntimeException("The Properties systems settings are already initialised!");
        }
        display = d;
        props = new PropsUI(t);
        GUIResource.getInstance();
    }

    public static final void init(Display d, String filename) {
        if (props != null) {
            throw new RuntimeException("The properties systems settings are already initialised!");
        }
        display = d;
        props = new PropsUI(filename);
        GUIResource.getInstance();
    }

    public static final boolean isInitialized() {
        return props != null;
    }

    public static final PropsUI getInstance() {
        if (props != null) {
            return (PropsUI)props;
        }
        throw new RuntimeException("Properties, Kettle systems settings, not initialised!");
    }

    private PropsUI(int t) {
        super(t);
    }

    private PropsUI(String filename) {
        super(filename);
    }

    protected synchronized void init() {
        super.createLogChannel();
        this.properties = new Properties();
        this.pluginHistory = new ArrayList();
        this.setDefault();
        this.loadProps();
        this.addDefaultEntries();
        this.loadPluginHistory();
        this.loadScreens();
        this.loadLastUsedFiles();
        this.loadOpenTabFiles();
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = registry.getPlugins(LifecyclePluginType.class);
        ArrayList<Object> leditables = new ArrayList<Object>();
        for (PluginInterface plugin : plugins) {
            try {
                leditables.add(registry.loadClass(plugin, GUIOption.class));
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Unexpected error loading class for plugin " + plugin.getName(), (Throwable)e);
            }
        }
        editables = Collections.unmodifiableList(leditables);
    }

    public void setDefault() {
        this.lastUsedFiles = new ArrayList<LastUsedFile>();
        this.openTabFiles = new ArrayList<LastUsedFile>();
        this.screens = new Hashtable();
        this.properties.setProperty("LogLevel", this.getLogLevel());
        this.properties.setProperty("LogFilter", this.getLogFilter());
        if (display != null) {
            FontData fd = this.getFixedFont();
            this.properties.setProperty("FontFixedName", fd.getName());
            this.properties.setProperty("FontFixedSize", "" + fd.getHeight());
            this.properties.setProperty("FontFixedStyle", "" + fd.getStyle());
            fd = this.getDefaultFont();
            this.properties.setProperty("FontDefaultName", fd.getName());
            this.properties.setProperty("FontDefaultSize", "" + fd.getHeight());
            this.properties.setProperty("FontDefaultStyle", "" + fd.getStyle());
            fd = this.getDefaultFont();
            this.properties.setProperty("FontGraphName", fd.getName());
            this.properties.setProperty("FontGraphSize", "" + fd.getHeight());
            this.properties.setProperty("FontGraphStyle", "" + fd.getStyle());
            fd = this.getDefaultFont();
            this.properties.setProperty("FontGridName", fd.getName());
            this.properties.setProperty("FontGridSize", "" + fd.getHeight());
            this.properties.setProperty("FontGridStyle", "" + fd.getStyle());
            fd = this.getDefaultFont();
            this.properties.setProperty("FontNoteName", fd.getName());
            this.properties.setProperty("FontNoteSize", "" + fd.getHeight());
            this.properties.setProperty("FontNoteStyle", "" + fd.getStyle());
            RGB col = this.getBackgroundRGB();
            this.properties.setProperty("BackgroundColorR", "" + col.red);
            this.properties.setProperty("BackgroundColorG", "" + col.green);
            this.properties.setProperty("BackgroundColorB", "" + col.blue);
            col = this.getGraphColorRGB();
            this.properties.setProperty("GraphColorR", "" + col.red);
            this.properties.setProperty("GraphColorG", "" + col.green);
            this.properties.setProperty("GraphColorB", "" + col.blue);
            this.properties.setProperty("IconSize", "" + this.getIconSize());
            this.properties.setProperty("LineWidth", "" + this.getLineWidth());
            this.properties.setProperty("ShadowSize", "" + this.getShadowSize());
            this.properties.setProperty("MaxUndo", "" + this.getMaxUndo());
            this.setSashWeights(this.getSashWeights());
            String prop = BasePropertyHandler.getProperty((String)"Default_UI_Properties_Resource", (String)"org.pentaho.di.ui.core.default");
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(prop);
                if (bundle != null) {
                    Enumeration<String> enumer = bundle.getKeys();
                    while (enumer.hasMoreElements()) {
                        String theKey = enumer.nextElement();
                        this.properties.setProperty(theKey, bundle.getString(theKey));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void storeScreens() {
        Enumeration<String> keys = this.screens.keys();
        int nr = 1;
        while (keys.hasMoreElements()) {
            String name = keys.nextElement();
            this.properties.setProperty("ScreenName" + nr, name);
            WindowProperty winprop = this.screens.get(name);
            this.properties.setProperty("SizeMax" + nr, winprop.isMaximized() ? YES : NO);
            if (winprop.getRectangle() != null) {
                this.properties.setProperty("SizeX" + nr, "" + winprop.getX());
                this.properties.setProperty("SizeY" + nr, "" + winprop.getY());
                this.properties.setProperty("SizeW" + nr, "" + winprop.getWidth());
                this.properties.setProperty("SizeH" + nr, "" + winprop.getHeight());
            }
            ++nr;
        }
    }

    public void loadScreens() {
        this.screens = new Hashtable();
        int nr = 1;
        String name = this.properties.getProperty("ScreenName" + nr);
        while (name != null) {
            boolean max = YES.equalsIgnoreCase(this.properties.getProperty("SizeMax" + nr));
            int x = Const.toInt((String)this.properties.getProperty("SizeX" + nr), (int)0);
            int y = Const.toInt((String)this.properties.getProperty("SizeY" + nr), (int)0);
            int w = Const.toInt((String)this.properties.getProperty("SizeW" + nr), (int)320);
            int h = Const.toInt((String)this.properties.getProperty("SizeH" + nr), (int)200);
            WindowProperty winprop = new WindowProperty(name, max, x, y, w, h);
            this.screens.put(name, winprop);
            name = this.properties.getProperty("ScreenName" + ++nr);
        }
    }

    public void saveProps() {
        this.storeScreens();
        this.setLastFiles();
        this.setOpenTabFiles();
        super.saveProps();
    }

    public void setLastFiles() {
        this.properties.setProperty("lastfiles", "" + this.lastUsedFiles.size());
        for (int i = 0; i < this.lastUsedFiles.size(); ++i) {
            LastUsedFile lastUsedFile = this.lastUsedFiles.get(i);
            this.properties.setProperty("filetype" + (i + 1), Const.NVL((String)lastUsedFile.getFileType(), (String)"Trans"));
            this.properties.setProperty("lastfile" + (i + 1), Const.NVL((String)lastUsedFile.getFilename(), (String)""));
            this.properties.setProperty("lastdir" + (i + 1), Const.NVL((String)lastUsedFile.getDirectory(), (String)""));
            this.properties.setProperty("lasttype" + (i + 1), lastUsedFile.isSourceRepository() ? YES : NO);
            this.properties.setProperty("lastrepo" + (i + 1), Const.NVL((String)lastUsedFile.getRepositoryName(), (String)""));
        }
    }

    public void setOpenTabFiles() {
        this.properties.setProperty("tabfiles", "" + this.openTabFiles.size());
        for (int i = 0; i < this.openTabFiles.size(); ++i) {
            LastUsedFile openTabFile = this.openTabFiles.get(i);
            this.properties.setProperty("tabtype" + (i + 1), Const.NVL((String)openTabFile.getFileType(), (String)"Trans"));
            this.properties.setProperty("tabfile" + (i + 1), Const.NVL((String)openTabFile.getFilename(), (String)""));
            this.properties.setProperty("tabdir" + (i + 1), Const.NVL((String)openTabFile.getDirectory(), (String)""));
            this.properties.setProperty("tabrep" + (i + 1), openTabFile.isSourceRepository() ? YES : NO);
            this.properties.setProperty("tabrepname" + (i + 1), Const.NVL((String)openTabFile.getRepositoryName(), (String)""));
            this.properties.setProperty("tabopened" + (i + 1), openTabFile.isOpened() ? YES : NO);
            this.properties.setProperty("tabopentypes" + (i + 1), "" + openTabFile.getOpenItemTypes());
        }
    }

    public void addLastFile(String fileType, String filename, String directory, boolean sourceRepository, String repositoryName) {
        LastUsedFile lastUsedFile = new LastUsedFile(fileType, filename, directory, sourceRepository, repositoryName, false, 1);
        int idx = this.lastUsedFiles.indexOf(lastUsedFile);
        if (idx >= 0) {
            this.lastUsedFiles.remove(idx);
        }
        this.lastUsedFiles.add(0, lastUsedFile);
        while (this.lastUsedFiles.size() > 9) {
            this.lastUsedFiles.remove(this.lastUsedFiles.size() - 1);
        }
    }

    public void addOpenTabFile(String fileType, String filename, String directory, boolean sourceRepository, String repositoryName, int openTypes) {
        LastUsedFile lastUsedFile = new LastUsedFile(fileType, filename, directory, sourceRepository, repositoryName, true, openTypes);
        this.openTabFiles.add(lastUsedFile);
    }

    public void loadLastUsedFiles() {
        this.lastUsedFiles = new ArrayList<LastUsedFile>();
        int nr = Const.toInt((String)this.properties.getProperty("lastfiles"), (int)0);
        for (int i = 0; i < nr; ++i) {
            String fileType = this.properties.getProperty("filetype" + (i + 1), "Trans");
            String filename = this.properties.getProperty("lastfile" + (i + 1), "");
            String directory = this.properties.getProperty("lastdir" + (i + 1), "");
            boolean sourceRepository = YES.equalsIgnoreCase(this.properties.getProperty("lasttype" + (i + 1), NO));
            String repositoryName = this.properties.getProperty("lastrepo" + (i + 1));
            boolean isOpened = YES.equalsIgnoreCase(this.properties.getProperty("lastopened" + (i + 1), NO));
            int openItemTypes = Const.toInt((String)this.properties.getProperty("lastopentypes" + (i + 1), "0"), (int)0);
            this.lastUsedFiles.add(new LastUsedFile(fileType, filename, directory, sourceRepository, repositoryName, isOpened, openItemTypes));
        }
    }

    public void loadOpenTabFiles() {
        this.openTabFiles = new ArrayList<LastUsedFile>();
        int nr = Const.toInt((String)this.properties.getProperty("tabfiles"), (int)0);
        for (int i = 0; i < nr; ++i) {
            String fileType = this.properties.getProperty("tabtype" + (i + 1), "Trans");
            String filename = this.properties.getProperty("tabfile" + (i + 1), "");
            String directory = this.properties.getProperty("tabdir" + (i + 1), "");
            boolean sourceRepository = YES.equalsIgnoreCase(this.properties.getProperty("tabrep" + (i + 1), NO));
            String repositoryName = this.properties.getProperty("tabrepname" + (i + 1));
            boolean isOpened = YES.equalsIgnoreCase(this.properties.getProperty("tabopened" + (i + 1), NO));
            int openItemTypes = Const.toInt((String)this.properties.getProperty("tabopentypes" + (i + 1), "0"), (int)0);
            this.openTabFiles.add(new LastUsedFile(fileType, filename, directory, sourceRepository, repositoryName, isOpened, openItemTypes));
        }
    }

    public List<LastUsedFile> getLastUsedFiles() {
        return this.lastUsedFiles;
    }

    public void setLastUsedFiles(List<LastUsedFile> lastUsedFiles) {
        this.lastUsedFiles = lastUsedFiles;
    }

    public String[] getLastFileTypes() {
        String[] retval = new String[this.lastUsedFiles.size()];
        for (int i = 0; i < retval.length; ++i) {
            LastUsedFile lastUsedFile = this.lastUsedFiles.get(i);
            retval[i] = lastUsedFile.getFileType();
        }
        return retval;
    }

    public String[] getLastFiles() {
        String[] retval = new String[this.lastUsedFiles.size()];
        for (int i = 0; i < retval.length; ++i) {
            LastUsedFile lastUsedFile = this.lastUsedFiles.get(i);
            retval[i] = lastUsedFile.getFilename();
        }
        return retval;
    }

    public String getFilename() {
        if (this.filename == null) {
            String s = System.getProperty("org.pentaho.di.ui.PropsUIFile");
            if (s != null) {
                return s;
            }
            return super.getFilename();
        }
        return this.filename;
    }

    public String[] getLastDirs() {
        String[] retval = new String[this.lastUsedFiles.size()];
        for (int i = 0; i < retval.length; ++i) {
            LastUsedFile lastUsedFile = this.lastUsedFiles.get(i);
            retval[i] = lastUsedFile.getDirectory();
        }
        return retval;
    }

    public boolean[] getLastTypes() {
        boolean[] retval = new boolean[this.lastUsedFiles.size()];
        for (int i = 0; i < retval.length; ++i) {
            LastUsedFile lastUsedFile = this.lastUsedFiles.get(i);
            retval[i] = lastUsedFile.isSourceRepository();
        }
        return retval;
    }

    public String[] getLastRepositories() {
        String[] retval = new String[this.lastUsedFiles.size()];
        for (int i = 0; i < retval.length; ++i) {
            LastUsedFile lastUsedFile = this.lastUsedFiles.get(i);
            retval[i] = lastUsedFile.getRepositoryName();
        }
        return retval;
    }

    public void setFixedFont(FontData fd) {
        this.properties.setProperty("FontFixedName", fd.getName());
        this.properties.setProperty("FontFixedSize", "" + fd.getHeight());
        this.properties.setProperty("FontFixedStyle", "" + fd.getStyle());
    }

    public FontData getFixedFont() {
        String name = this.properties.getProperty("FontFixedName", "Courier");
        String ssize = this.properties.getProperty("FontFixedSize");
        String sstyle = this.properties.getProperty("FontFixedStyle");
        int size = Const.toInt((String)ssize, (int)9);
        int style = Const.toInt((String)sstyle, (int)0);
        FontData fd = new FontData(name, size, style);
        return fd;
    }

    public void setDefaultFont(FontData fd) {
        if (fd != null) {
            this.properties.setProperty("FontDefaultName", fd.getName());
            this.properties.setProperty("FontDefaultSize", "" + fd.getHeight());
            this.properties.setProperty("FontDefaultStyle", "" + fd.getStyle());
        }
    }

    public FontData getDefaultFont() {
        if (this.isOSLookShown()) {
            return display.getSystemFont().getFontData()[0];
        }
        FontData def = this.getDefaultFontData();
        String name = this.properties.getProperty("FontDefaultName");
        String ssize = this.properties.getProperty("FontDefaultSize");
        String sstyle = this.properties.getProperty("FontDefaultStyle");
        int size = Const.toInt((String)ssize, (int)def.getHeight());
        int style = Const.toInt((String)sstyle, (int)def.getStyle());
        if (name == null || name.length() == 0) {
            name = def.getName();
            size = def.getHeight();
            style = def.getStyle();
        }
        if (name == null || name.length() == 0) {
            name = "Arial";
            size = 10;
            style = 0;
        }
        FontData fd = new FontData(name, size, style);
        return fd;
    }

    public void setGraphFont(FontData fd) {
        this.properties.setProperty("FontGraphName", fd.getName());
        this.properties.setProperty("FontGraphSize", "" + fd.getHeight());
        this.properties.setProperty("FontGraphStyle", "" + fd.getStyle());
    }

    public FontData getGraphFont() {
        FontData def = this.getDefaultFontData();
        String name = this.properties.getProperty("FontGraphName", def.getName());
        String ssize = this.properties.getProperty("FontGraphSize");
        String sstyle = this.properties.getProperty("FontGraphStyle");
        int size = Const.toInt((String)ssize, (int)def.getHeight());
        int style = Const.toInt((String)sstyle, (int)def.getStyle());
        FontData fd = new FontData(name, size, style);
        return fd;
    }

    public void setGridFont(FontData fd) {
        this.properties.setProperty("FontGridName", fd.getName());
        this.properties.setProperty("FontGridSize", "" + fd.getHeight());
        this.properties.setProperty("FontGridStyle", "" + fd.getStyle());
    }

    public FontData getGridFont() {
        FontData def = this.getDefaultFontData();
        String name = this.properties.getProperty("FontGridName", def.getName());
        String ssize = this.properties.getProperty("FontGridSize");
        String sstyle = this.properties.getProperty("FontGridStyle");
        int size = Const.toInt((String)ssize, (int)def.getHeight());
        int style = Const.toInt((String)sstyle, (int)def.getStyle());
        FontData fd = new FontData(name, size, style);
        return fd;
    }

    public void setNoteFont(FontData fd) {
        this.properties.setProperty("FontNoteName", fd.getName());
        this.properties.setProperty("FontNoteSize", "" + fd.getHeight());
        this.properties.setProperty("FontNoteStyle", "" + fd.getStyle());
    }

    public FontData getNoteFont() {
        FontData def = this.getDefaultFontData();
        String name = this.properties.getProperty("FontNoteName", def.getName());
        String ssize = this.properties.getProperty("FontNoteSize");
        String sstyle = this.properties.getProperty("FontNoteStyle");
        int size = Const.toInt((String)ssize, (int)def.getHeight());
        int style = Const.toInt((String)sstyle, (int)def.getStyle());
        FontData fd = new FontData(name, size, style);
        return fd;
    }

    public void setBackgroundRGB(RGB c) {
        this.properties.setProperty("BackgroundColorR", c != null ? "" + c.red : "");
        this.properties.setProperty("BackgroundColorG", c != null ? "" + c.green : "");
        this.properties.setProperty("BackgroundColorB", c != null ? "" + c.blue : "");
    }

    public RGB getBackgroundRGB() {
        int r = Const.toInt((String)this.properties.getProperty("BackgroundColorR"), (int)255);
        int g = Const.toInt((String)this.properties.getProperty("BackgroundColorG"), (int)255);
        int b = Const.toInt((String)this.properties.getProperty("BackgroundColorB"), (int)255);
        RGB rgb = new RGB(r, g, b);
        return rgb;
    }

    @Deprecated
    public RGB getBackupgroundRGB() {
        return this.getBackgroundRGB();
    }

    public void setGraphColorRGB(RGB c) {
        this.properties.setProperty("GraphColorR", "" + c.red);
        this.properties.setProperty("GraphColorG", "" + c.green);
        this.properties.setProperty("GraphColorB", "" + c.blue);
    }

    public RGB getGraphColorRGB() {
        int r = Const.toInt((String)this.properties.getProperty("GraphColorR"), (int)255);
        int g = Const.toInt((String)this.properties.getProperty("GraphColorG"), (int)255);
        int b = Const.toInt((String)this.properties.getProperty("GraphColorB"), (int)255);
        RGB rgb = new RGB(r, g, b);
        return rgb;
    }

    public void setTabColorRGB(RGB c) {
        this.properties.setProperty("TabColorR", "" + c.red);
        this.properties.setProperty("TabColorG", "" + c.green);
        this.properties.setProperty("TabColorB", "" + c.blue);
    }

    public RGB getTabColorRGB() {
        int r = Const.toInt((String)this.properties.getProperty("TabColorR"), (int)200);
        int g = Const.toInt((String)this.properties.getProperty("TabColorG"), (int)200);
        int b = Const.toInt((String)this.properties.getProperty("TabColorB"), (int)255);
        RGB rgb = new RGB(r, g, b);
        return rgb;
    }

    public void setIconSize(int size) {
        this.properties.setProperty("IconSize", "" + size);
    }

    public int getIconSize() {
        return Const.toInt((String)this.properties.getProperty("IconSize"), (int)32);
    }

    public void setLineWidth(int width) {
        this.properties.setProperty("LineWidth", "" + width);
    }

    public int getLineWidth() {
        return Const.toInt((String)this.properties.getProperty("LineWidth"), (int)1);
    }

    public void setShadowSize(int size) {
        this.properties.setProperty("ShadowSize", "" + size);
    }

    public int getShadowSize() {
        return Const.toInt((String)this.properties.getProperty("ShadowSize"), (int)4);
    }

    public void setLastTrans(String trans) {
        this.properties.setProperty("LastPreviewTrans", trans);
    }

    public String getLastTrans() {
        return this.properties.getProperty("LastPreviewTrans", "");
    }

    public void setLastPreview(String[] lastpreview, int[] stepsize) {
        this.properties.setProperty("LastPreviewStep", "" + lastpreview.length);
        for (int i = 0; i < lastpreview.length; ++i) {
            this.properties.setProperty("LastPreviewStep" + (i + 1), lastpreview[i]);
            this.properties.setProperty("LastPreviewSize" + (i + 1), "" + stepsize[i]);
        }
    }

    public String[] getLastPreview() {
        String snr = this.properties.getProperty("LastPreviewStep");
        int nr = Const.toInt((String)snr, (int)0);
        String[] lp = new String[nr];
        for (int i = 0; i < nr; ++i) {
            lp[i] = this.properties.getProperty("LastPreviewStep" + (i + 1), "");
        }
        return lp;
    }

    public int[] getLastPreviewSize() {
        String snr = this.properties.getProperty("LastPreviewStep");
        int nr = Const.toInt((String)snr, (int)0);
        int[] si = new int[nr];
        for (int i = 0; i < nr; ++i) {
            si[i] = Const.toInt((String)this.properties.getProperty("LastPreviewSize" + (i + 1), ""), (int)0);
        }
        return si;
    }

    public FontData getDefaultFontData() {
        return display.getSystemFont().getFontData()[0];
    }

    public void setMaxUndo(int max) {
        this.properties.setProperty("MaxUndo", "" + max);
    }

    public int getMaxUndo() {
        return Const.toInt((String)this.properties.getProperty("MaxUndo"), (int)100);
    }

    public void setMiddlePct(int pct) {
        this.properties.setProperty("MiddlePct", "" + pct);
    }

    public int getMiddlePct() {
        return Const.toInt((String)this.properties.getProperty("MiddlePct"), (int)35);
    }

    public void setScreen(WindowProperty winprop) {
        this.screens.put(winprop.getName(), winprop);
    }

    public WindowProperty getScreen(String windowname) {
        if (windowname == null) {
            return null;
        }
        return this.screens.get(windowname);
    }

    public void setSashWeights(int[] w) {
        this.properties.setProperty("SashWeight1", "" + w[0]);
        this.properties.setProperty("SashWeight2", "" + w[1]);
    }

    public int[] getSashWeights() {
        int w1 = Const.toInt((String)this.properties.getProperty("SashWeight1"), (int)25);
        int w2 = Const.toInt((String)this.properties.getProperty("SashWeight2"), (int)75);
        return new int[]{w1, w2};
    }

    public void setTipNr(int nr) {
        this.properties.setProperty("TipNr", "" + nr);
    }

    public int getTipNr() {
        return Const.toInt((String)this.properties.getProperty("TipNr"), (int)0);
    }

    public void setShowTips(boolean show) {
        this.properties.setProperty("ShowTips", show ? YES : NO);
    }

    public boolean showTips() {
        String show = this.properties.getProperty("ShowTips");
        return !NO.equalsIgnoreCase(show);
    }

    public void setOpenLastFile(boolean open) {
        this.properties.setProperty("OpenLastFile", open ? YES : NO);
    }

    public boolean openLastFile() {
        String open = this.properties.getProperty("OpenLastFile");
        return !NO.equalsIgnoreCase(open);
    }

    public void setAutoSave(boolean autosave) {
        this.properties.setProperty("AutoSave", autosave ? YES : NO);
    }

    public boolean getAutoSave() {
        String autosave = this.properties.getProperty("AutoSave");
        return YES.equalsIgnoreCase(autosave);
    }

    public void setSaveConfirmation(boolean saveconf) {
        this.properties.setProperty("SaveConfirmation", saveconf ? YES : NO);
    }

    public boolean getSaveConfirmation() {
        String saveconf = this.properties.getProperty("SaveConfirmation");
        return YES.equalsIgnoreCase(saveconf);
    }

    public void setAutoSplit(boolean autosplit) {
        this.properties.setProperty("AutoSplit", autosplit ? YES : NO);
    }

    public boolean getAutoSplit() {
        String autosplit = this.properties.getProperty("AutoSplit");
        return YES.equalsIgnoreCase(autosplit);
    }

    public void setAutoCollapseCoreObjectsTree(boolean autoCollapse) {
        this.properties.setProperty("AutoCollapseCoreObjectsTree", autoCollapse ? YES : NO);
    }

    public boolean getAutoCollapseCoreObjectsTree() {
        String autoCollapse = this.properties.getProperty("AutoCollapseCoreObjectsTree");
        return YES.equalsIgnoreCase(autoCollapse);
    }

    public boolean showRepositoriesDialogAtStartup() {
        String show = this.properties.getProperty("ShowRepositoriesAtStartup", YES);
        return YES.equalsIgnoreCase(show);
    }

    public void setExitWarningShown(boolean show) {
        this.properties.setProperty("ShowExitWarning", show ? YES : NO);
    }

    public boolean isAntiAliasingEnabled() {
        String anti = this.properties.getProperty("EnableAntiAliasing", NO);
        return YES.equalsIgnoreCase(anti);
    }

    public void setAntiAliasingEnabled(boolean anti) {
        this.properties.setProperty("EnableAntiAliasing", anti ? YES : NO);
    }

    public boolean showExitWarning() {
        String show = this.properties.getProperty("ShowExitWarning", YES);
        return YES.equalsIgnoreCase(show);
    }

    public void setRepositoriesDialogAtStartupShown(boolean show) {
        this.properties.setProperty("ShowRepositoriesAtStartup", show ? YES : NO);
    }

    public boolean isOSLookShown() {
        String show = this.properties.getProperty("ShowOSLook", NO);
        return YES.equalsIgnoreCase(show);
    }

    public void setOSLookShown(boolean show) {
        this.properties.setProperty("ShowOSLook", show ? YES : NO);
    }

    public static final void setGCFont(GC gc, Device device, FontData fontData) {
        if (Const.getOS().startsWith("Windows")) {
            Font font = new Font(device, fontData);
            gc.setFont(font);
            font.dispose();
        } else {
            gc.setFont(device.getSystemFont());
        }
    }

    public void setLook(Control widget) {
        this.setLook(widget, 0);
    }

    public void setLook(Control control, int style) {
        if (this.isOSLookShown() && style != 1) {
            return;
        }
        GUIResource gui = GUIResource.getInstance();
        Font font = null;
        Color background = null;
        switch (style) {
            case 0: {
                background = gui.getColorBackground();
                font = null;
                break;
            }
            case 1: {
                if (!this.isOSLookShown()) {
                    background = gui.getColorBackground();
                }
                font = gui.getFontFixed();
                break;
            }
            case 2: {
                background = gui.getColorBackground();
                font = null;
                break;
            }
            case 3: {
                background = gui.getColorBackground();
                font = gui.getFontNote();
                break;
            }
            case 4: {
                background = gui.getColorBackground();
                font = gui.getFontGraph();
                break;
            }
            case 5: {
                background = gui.getColorBackground();
                CTabFolder tabFolder = (CTabFolder)control;
                tabFolder.setSimple(false);
                tabFolder.setBorderVisible(false);
                tabFolder.setSelectionBackground(new Color[]{display.getSystemColor(18), display.getSystemColor(19)}, new int[]{55}, true);
                break;
            }
            default: {
                background = gui.getColorBackground();
                font = null;
            }
        }
        if (font != null && !font.isDisposed()) {
            control.setFont(font);
        }
        if (background != null && !background.isDisposed()) {
            Button b;
            if (control instanceof Button && ((b = (Button)control).getStyle() & 8) != 0) {
                return;
            }
            control.setBackground(background);
        }
    }

    public static void setTableItemLook(TableItem item, Display disp) {
        if (!Const.getOS().startsWith("Windows")) {
            return;
        }
        Color background = GUIResource.getInstance().getColorBackground();
        if (background != null) {
            item.setBackground(background);
        }
    }

    public static Display getDisplay() {
        return display;
    }

    public static void setDisplay(Display d) {
        display = d;
    }

    public void setDefaultPreviewSize(int size) {
        this.properties.setProperty("DefaultPreviewSize", "" + size);
    }

    public int getDefaultPreviewSize() {
        return Const.toInt((String)this.properties.getProperty("DefaultPreviewSize"), (int)1000);
    }

    public boolean showCopyOrDistributeWarning() {
        String show = this.properties.getProperty(STRING_SHOW_COPY_OR_DISTRIBUTE_WARNING, YES);
        return YES.equalsIgnoreCase(show);
    }

    public void setShowCopyOrDistributeWarning(boolean show) {
        this.properties.setProperty(STRING_SHOW_COPY_OR_DISTRIBUTE_WARNING, show ? YES : NO);
    }

    public boolean showWelcomePageOnStartup() {
        String show = this.properties.getProperty(STRING_SHOW_WELCOME_PAGE_ON_STARTUP, YES);
        return YES.equalsIgnoreCase(show);
    }

    public void setShowWelcomePageOnStartup(boolean show) {
        this.properties.setProperty(STRING_SHOW_WELCOME_PAGE_ON_STARTUP, show ? YES : NO);
    }

    public int getJobsDialogStyle() {
        String prop = this.properties.getProperty("JobDialogStyle");
        return this.parseStyle(prop);
    }

    public int getDialogStyle(String styleProperty) {
        String prop = this.properties.getProperty(styleProperty);
        if (Const.isEmpty((String)prop)) {
            return 0;
        }
        return this.parseStyle(prop);
    }

    private int parseStyle(String sStyle) {
        int style = 2144;
        String[] styles = sStyle.split(",");
        for (int i = 0; i < styles.length; ++i) {
            if ("APPLICATION_MODAL".equals(styles[i])) {
                style |= 0x10010000;
                continue;
            }
            if ("RESIZE".equals(styles[i])) {
                style |= 0x10;
                continue;
            }
            if ("MIN".equals(styles[i])) {
                style |= 0x80;
                continue;
            }
            if (!"MAX".equals(styles[i])) continue;
            style |= 0x400;
        }
        return style;
    }

    public void setDialogSize(Shell shell, String styleProperty) {
        String prop = this.properties.getProperty(styleProperty);
        if (Const.isEmpty((String)prop)) {
            return;
        }
        String[] xy = prop.split(",");
        if (xy.length != 2) {
            return;
        }
        shell.setSize(Integer.parseInt(xy[0]), Integer.parseInt(xy[1]));
    }

    public boolean isBrandingActive() {
        String show = this.properties.getProperty(STRING_SHOW_BRANDING_GRAPHICS, NO);
        return YES.equalsIgnoreCase(show);
    }

    public void setBrandingActive(boolean active) {
        this.properties.setProperty(STRING_SHOW_BRANDING_GRAPHICS, active ? YES : NO);
    }

    public boolean isOnlyActiveFileShownInTree() {
        String show = this.properties.getProperty(STRING_ONLY_SHOW_ACTIVE_FILE, YES);
        return YES.equalsIgnoreCase(show);
    }

    public void setOnlyActiveFileShownInTree(boolean show) {
        this.properties.setProperty(STRING_ONLY_SHOW_ACTIVE_FILE, show ? YES : NO);
    }

    public boolean showToolTips() {
        return YES.equalsIgnoreCase(this.properties.getProperty(SHOW_TOOL_TIPS, YES));
    }

    public void setShowToolTips(boolean show) {
        this.properties.setProperty(SHOW_TOOL_TIPS, show ? YES : NO);
    }

    public List<GUIOption<Object>> getRegisteredEditableComponents() {
        return editables;
    }

    public boolean isShowingHelpToolTips() {
        return YES.equalsIgnoreCase(this.properties.getProperty(SHOW_HELP_TOOL_TIPS, YES));
    }

    public void setShowingHelpToolTips(boolean show) {
        this.properties.setProperty(SHOW_HELP_TOOL_TIPS, show ? YES : NO);
    }

    public List<LastUsedFile> getOpenTabFiles() {
        return this.openTabFiles;
    }

    public void setOpenTabFiles(List<LastUsedFile> openTabFiles) {
        this.openTabFiles = openTabFiles;
    }

    public int getCanvasGridSize() {
        return Const.toInt((String)this.properties.getProperty(CANVAS_GRID_SIZE, "1"), (int)1);
    }

    public void setCanvasGridSize(int gridSize) {
        this.properties.setProperty(CANVAS_GRID_SIZE, Integer.toString(gridSize));
    }

    public static final void setLocation(GUIPositionInterface guiElement, int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        guiElement.setLocation(PropsUI.calculateGridPosition(new Point(x, y)));
    }

    public static final Point calculateGridPosition(Point p) {
        int gridSize = PropsUI.getInstance().getCanvasGridSize();
        if (gridSize > 1) {
            return new Point(gridSize * Math.round(p.x / gridSize), gridSize * Math.round(p.y / gridSize));
        }
        return p;
    }

    public boolean isIndicateSlowTransStepsEnabled() {
        String indicate = this.properties.getProperty("IndicateSlowTransSteps", YES);
        return YES.equalsIgnoreCase(indicate);
    }

    public void setIndicateSlowTransStepsEnabled(boolean indicate) {
        this.properties.setProperty("IndicateSlowTransSteps", indicate ? YES : NO);
    }
}

