/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.database.dialog;

import java.util.ListIterator;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerNode;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.util.AbstractModelNode;

public class XulDatabaseExplorerModel
extends XulEventSourceAdapter {
    private XulDatabaseExplorerNode database = new XulDatabaseExplorerNode();
    protected DatabaseMeta databaseMeta;
    private DatabaseExplorerNode selectedNode;

    public XulDatabaseExplorerModel(DatabaseMeta aDatabaseMeta) {
        this.databaseMeta = aDatabaseMeta;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public XulDatabaseExplorerNode getDatabase() {
        return this.database;
    }

    public void setDatabase(XulDatabaseExplorerNode aDatabase) {
        this.database = aDatabase;
    }

    public String getTable() {
        if (this.selectedNode != null && this.selectedNode.isTable()) {
            return this.selectedNode.getName();
        }
        return null;
    }

    public String getSchema() {
        if (this.selectedNode != null) {
            return this.selectedNode.getSchema();
        }
        return null;
    }

    public DatabaseExplorerNode findBy(String aSchema, String aTable) {
        ListIterator theNodes = this.database.listIterator();
        return this.drillDown(theNodes, aSchema, aTable);
    }

    private DatabaseExplorerNode drillDown(ListIterator<DatabaseExplorerNode> aNodes, String aSchema, String aTable) {
        boolean lookingForSchema = aTable == null || Const.isEmpty((String)aTable);
        DatabaseExplorerNode theNode = null;
        while (aNodes.hasNext()) {
            theNode = aNodes.next();
            if (!(lookingForSchema && theNode.isSchema() && theNode.getName().equals(aSchema) || !lookingForSchema && theNode.isTable() && theNode.getName().equals(aTable) && (theNode.getSchema() == null ? aSchema == null : theNode.getSchema().equals(aSchema))) && (theNode = this.drillDown(theNode.listIterator(), aSchema, aTable)) == null) continue;
            break;
        }
        return theNode;
    }

    public DatabaseExplorerNode getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(DatabaseExplorerNode selectedNode) {
        DatabaseExplorerNode prevVal = this.selectedNode;
        this.selectedNode = selectedNode;
        this.firePropertyChange("selectedNode", (Object)prevVal, (Object)this.selectedNode);
    }

    public static class XulDatabaseExplorerNode
    extends AbstractModelNode<DatabaseExplorerNode> {
        private static final long serialVersionUID = 2466708563640027488L;
    }
}

