/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.i18n.KeyOccurrence;
import org.pentaho.di.ui.i18n.SourceCrawlerPackageException;
import org.pentaho.di.ui.i18n.SourceCrawlerXMLElement;
import org.pentaho.di.ui.i18n.SourceCrawlerXMLFolder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessagesSourceCrawler {
    private String[] scanPhrases;
    private List<String> sourceDirectories;
    private Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences;
    private List<String> filesToAvoid;
    private String singleMessagesFile;
    private List<SourceCrawlerXMLFolder> xmlFolders;
    private Pattern packagePattern;
    private Pattern importPattern;
    private Pattern importMessagesPattern;
    private Pattern stringPkgPattern;
    private Pattern classPkgPattern;
    private LogChannelInterface log;

    public MessagesSourceCrawler(LogChannelInterface log, List<String> sourceDirectories, String singleMessagesFile, List<SourceCrawlerXMLFolder> xmlFolders) {
        this.log = log;
        this.sourceDirectories = sourceDirectories;
        this.singleMessagesFile = singleMessagesFile;
        this.filesToAvoid = new ArrayList<String>();
        this.xmlFolders = xmlFolders;
        this.sourcePackageOccurrences = new HashMap<String, Map<String, List<KeyOccurrence>>>();
        this.packagePattern = Pattern.compile("^\\s*package .*;[ \t]*$");
        this.importPattern = Pattern.compile("^\\s*import [a-z\\._0-9]*\\.[A-Z].*;[ \t]*$");
        this.importMessagesPattern = Pattern.compile("^\\s*import [a-z\\._0-9]*\\.Messages;[ \t]*$");
        this.stringPkgPattern = Pattern.compile("^.*private static String PKG.*=.*$");
        this.classPkgPattern = Pattern.compile("^.*private static Class.*\\sPKG\\s*=.*$");
    }

    public List<String> getSourceDirectories() {
        return this.sourceDirectories;
    }

    public void setSourceDirectories(List<String> sourceDirectories) {
        this.sourceDirectories = sourceDirectories;
    }

    public List<String> getFilesToAvoid() {
        return this.filesToAvoid;
    }

    public void setFilesToAvoid(List<String> filesToAvoid) {
        this.filesToAvoid = filesToAvoid;
    }

    public void addKeyOccurrence(KeyOccurrence occ) {
        List<KeyOccurrence> occurrences;
        String sourceFolder = occ.getSourceFolder();
        if (sourceFolder == null) {
            throw new RuntimeException("No source folder found for key: " + occ.getKey() + " in package " + occ.getMessagesPackage());
        }
        String messagesPackage = occ.getMessagesPackage();
        Map<String, List<KeyOccurrence>> packageOccurrences = this.sourcePackageOccurrences.get(sourceFolder);
        if (packageOccurrences == null) {
            packageOccurrences = new HashMap<String, List<KeyOccurrence>>();
            this.sourcePackageOccurrences.put(sourceFolder, packageOccurrences);
        }
        if ((occurrences = packageOccurrences.get(messagesPackage)) == null) {
            occurrences = new ArrayList<KeyOccurrence>();
            occurrences.add(occ);
            packageOccurrences.put(messagesPackage, occurrences);
        } else {
            int index = Collections.binarySearch(occurrences, occ);
            if (index < 0) {
                occurrences.add(-index - 1, occ);
            }
        }
    }

    public void crawl() throws Exception {
        for (String sourceDirectory : this.sourceDirectories) {
            FileObject[] javaFiles;
            FileObject folder = KettleVFS.getFileObject((String)sourceDirectory);
            for (FileObject javaFile : javaFiles = folder.findFiles(new FileSelector(){

                public boolean traverseDescendents(FileSelectInfo info) throws Exception {
                    return true;
                }

                public boolean includeFile(FileSelectInfo info) throws Exception {
                    return info.getFile().getName().getExtension().equals("java");
                }
            })) {
                boolean skip = false;
                for (String filename : this.filesToAvoid) {
                    if (!javaFile.getName().getBaseName().equals(filename)) continue;
                    skip = true;
                }
                if (skip) continue;
                this.lookForOccurrencesInFile(sourceDirectory, javaFile);
            }
        }
        for (SourceCrawlerXMLFolder xmlFolder : this.xmlFolders) {
            String[] xmlDirs = new String[]{xmlFolder.getFolder()};
            String[] xmlMasks = new String[]{xmlFolder.getWildcard()};
            String[] xmlReq = new String[]{"N"};
            boolean[] xmlSubdirs = new boolean[]{true};
            FileInputList xulFileInputList = FileInputList.createFileList((VariableSpace)new Variables(), (String[])xmlDirs, (String[])xmlMasks, (String[])xmlReq, (boolean[])xmlSubdirs);
            for (FileObject fileObject : xulFileInputList.getFiles()) {
                try {
                    Document doc = XMLHandler.loadXMLFile((FileObject)fileObject);
                    for (SourceCrawlerXMLElement xmlElement : xmlFolder.getElements()) {
                        this.addLabelOccurrences(xmlFolder.getDefaultSourceFolder(), fileObject, doc.getElementsByTagName(xmlElement.getSearchElement()), xmlFolder.getKeyPrefix(), xmlElement.getKeyTag(), xmlElement.getKeyAttribute(), xmlFolder.getDefaultPackage(), xmlFolder.getPackageExceptions());
                    }
                }
                catch (KettleXMLException e) {
                    this.log.logError("Unable to open XUL / XML document: " + fileObject);
                }
            }
        }
    }

    private void addLabelOccurrences(String sourceFolder, FileObject fileObject, NodeList nodeList, String keyPrefix, String tag, String attribute, String defaultPackage, List<SourceCrawlerPackageException> packageExcpeptions) throws Exception {
        if (nodeList == null) {
            return;
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String labelString = null;
            if (!Const.isEmpty((String)attribute)) {
                labelString = XMLHandler.getTagAttribute((Node)node, (String)attribute);
            } else if (!Const.isEmpty((String)tag)) {
                labelString = XMLHandler.getTagValue((Node)node, (String)tag);
            }
            keyPrefix = "$";
            if (labelString == null || !labelString.startsWith(keyPrefix)) continue;
            String key = labelString.substring(1);
            key = labelString.substring(2, labelString.length() - 1).trim();
            String messagesPackage = defaultPackage;
            for (SourceCrawlerPackageException packageException : packageExcpeptions) {
                if (!key.startsWith(packageException.getStartsWith())) continue;
                messagesPackage = packageException.getPackageName();
            }
            StringWriter bodyXML = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(bodyXML));
            String xml = bodyXML.getBuffer().toString();
            KeyOccurrence keyOccurrence = new KeyOccurrence(fileObject, sourceFolder, messagesPackage, -1, -1, key, "?", xml);
            this.addKeyOccurrence(keyOccurrence);
        }
    }

    public void lookForOccurrencesInFile(String sourceFolder, FileObject javaFile) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(KettleVFS.getInputStream((FileObject)javaFile)));
        String messagesPackage = null;
        int row = 0;
        String classPackage = null;
        Hashtable<String, String> importedClasses = new Hashtable<String, String>();
        String line = reader.readLine();
        while (line != null) {
            int beginIndex;
            String expression;
            int lastDotIndex;
            int endIndex;
            boolean extraLine;
            ++row;
            String line2 = line;
            do {
                extraLine = false;
                for (String scanPhrase : this.scanPhrases) {
                    if (!line2.endsWith(scanPhrase)) continue;
                    extraLine = true;
                    break;
                }
                if (!extraLine) continue;
                line2 = reader.readLine();
                line = line + line2;
            } while (extraLine);
            if (this.packagePattern.matcher(line).matches()) {
                int beginIndex2 = line.indexOf("org.pentaho.");
                endIndex = line.indexOf(59);
                if (beginIndex2 >= 0 && endIndex >= 0) {
                    classPackage = messagesPackage = line.substring(beginIndex2, endIndex);
                }
            }
            if (this.importPattern.matcher(line).matches() && (lastDotIndex = (expression = line.substring(beginIndex = line.indexOf("import") + "import".length() + 1, endIndex = line.indexOf(";", beginIndex))).lastIndexOf(46)) > 0) {
                String packageName = expression.substring(0, lastDotIndex);
                String className = expression.substring(lastDotIndex + 1);
                if (!"*".equals(className)) {
                    importedClasses.put(className, packageName);
                }
            }
            if (this.importMessagesPattern.matcher(line).matches()) {
                beginIndex = line.indexOf("org.pentaho.");
                endIndex = line.indexOf(".Messages;");
                messagesPackage = line.substring(beginIndex, endIndex);
            }
            if (this.stringPkgPattern.matcher(line).matches()) {
                beginIndex = line.indexOf(34) + 1;
                endIndex = line.indexOf(34, beginIndex);
                messagesPackage = line.substring(beginIndex, endIndex);
            }
            if (classPackage != null && this.classPkgPattern.matcher(line).matches()) {
                int toIndex;
                int fromIndex = line.indexOf(61) + 1;
                expression = Const.trim((String)line.substring(fromIndex, toIndex = line.indexOf(".class", fromIndex)));
                if (expression.contains(".")) {
                    lastDotIndex = expression.lastIndexOf(46);
                    messagesPackage = expression.substring(0, lastDotIndex);
                } else {
                    String packageName = (String)importedClasses.get(expression);
                    messagesPackage = packageName == null ? classPackage : packageName;
                }
            }
            for (String scanPhrase : this.scanPhrases) {
                int index = line.indexOf(scanPhrase);
                while (index >= 0) {
                    if (index == 0 || index > 0 & !Character.isJavaIdentifierPart(line.charAt(index - 1))) {
                        this.addLineOccurrence(sourceFolder, javaFile, messagesPackage, line, row, index, scanPhrase);
                    }
                    index = line.indexOf(scanPhrase, index + 1);
                }
            }
            line = reader.readLine();
        }
        reader.close();
    }

    private void addLineOccurrence(String sourceFolder, FileObject fileObject, String messagesPackage, String line, int row, int index, String scanPhrase) {
        String key;
        int column = index + scanPhrase.length();
        String arguments = "";
        int startKeyIndex = line.indexOf(34, column) + 1;
        int endKeyIndex = line.indexOf(34, startKeyIndex);
        if (endKeyIndex >= 0) {
            int bracketIndex;
            key = line.substring(startKeyIndex, endKeyIndex);
            int nrOpen = 1;
            for (bracketIndex = endKeyIndex; bracketIndex < line.length() && nrOpen != 0; ++bracketIndex) {
                char c = line.charAt(bracketIndex);
                if (c == '(') {
                    ++nrOpen;
                }
                if (c != ')') continue;
                --nrOpen;
            }
            arguments = bracketIndex + 1 < line.length() ? line.substring(endKeyIndex + 1, bracketIndex) : line.substring(endKeyIndex + 1);
        } else {
            key = line.substring(startKeyIndex);
        }
        if (key.contains("\t") || key.contains(" ")) {
            System.out.println("Suspect key found: [" + key + "] in file [" + fileObject + "]");
        }
        if (key.startsWith("System.")) {
            String i18nPackage = BaseMessages.class.getPackage().getName();
            KeyOccurrence keyOccurrence = new KeyOccurrence(fileObject, sourceFolder, i18nPackage, row, column, key, arguments, line);
            KeyOccurrence lookup = this.getKeyOccurrence(key, i18nPackage);
            if (lookup == null) {
                this.addKeyOccurrence(keyOccurrence);
            } else {
                lookup.setSourceLine(lookup.getSourceLine() + Const.CR + keyOccurrence.getSourceLine());
                lookup.incrementOccurrences();
            }
        } else {
            KeyOccurrence keyOccurrence = new KeyOccurrence(fileObject, sourceFolder, messagesPackage, row, column, key, arguments, line);
            this.addKeyOccurrence(keyOccurrence);
        }
    }

    public List<String> getMessagesPackagesList(String sourceFolder) {
        Map<String, List<KeyOccurrence>> packageOccurrences = this.sourcePackageOccurrences.get(sourceFolder);
        ArrayList<String> list = new ArrayList<String>(packageOccurrences.keySet());
        Collections.sort(list);
        return list;
    }

    public List<KeyOccurrence> getOccurrencesForPackage(String messagesPackage) {
        ArrayList<KeyOccurrence> list = new ArrayList<KeyOccurrence>();
        for (String sourceFolder : this.sourcePackageOccurrences.keySet()) {
            Map<String, List<KeyOccurrence>> po = this.sourcePackageOccurrences.get(sourceFolder);
            List<KeyOccurrence> occurrences = po.get(messagesPackage);
            if (occurrences == null) continue;
            list.addAll(occurrences);
        }
        return list;
    }

    public KeyOccurrence getKeyOccurrence(String key, String selectedMessagesPackage) {
        for (String sourceFolder : this.sourcePackageOccurrences.keySet()) {
            List<KeyOccurrence> occurrences;
            Map<String, List<KeyOccurrence>> po = this.sourcePackageOccurrences.get(sourceFolder);
            if (po == null || (occurrences = po.get(selectedMessagesPackage)) == null) continue;
            for (KeyOccurrence keyOccurrence : occurrences) {
                if (!keyOccurrence.getKey().equals(key) || !keyOccurrence.getMessagesPackage().equals(selectedMessagesPackage)) continue;
                return keyOccurrence;
            }
        }
        return null;
    }

    public String getSingleMessagesFile() {
        return this.singleMessagesFile;
    }

    public void setSingleMessagesFile(String singleMessagesFile) {
        this.singleMessagesFile = singleMessagesFile;
    }

    public String[] getScanPhrases() {
        return this.scanPhrases;
    }

    public void setScanPhrases(String[] scanPhrases) {
        this.scanPhrases = scanPhrases;
    }

    public Map<String, Map<String, List<KeyOccurrence>>> getSourcePackageOccurrences() {
        return this.sourcePackageOccurrences;
    }

    public void setSourcePackageOccurrences(Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences) {
        this.sourcePackageOccurrences = sourcePackageOccurrences;
    }

    public List<KeyOccurrence> getKeyOccurrences(String sourceFolder) {
        HashMap<String, KeyOccurrence> map = new HashMap<String, KeyOccurrence>();
        Map<String, List<KeyOccurrence>> po = this.sourcePackageOccurrences.get(sourceFolder);
        if (po != null) {
            for (List<KeyOccurrence> keyOccurrences : po.values()) {
                for (KeyOccurrence keyOccurrence : keyOccurrences) {
                    String key = keyOccurrence.getMessagesPackage() + " - " + keyOccurrence.getKey();
                    map.put(key, keyOccurrence);
                }
            }
        }
        return new ArrayList<KeyOccurrence>(map.values());
    }
}

