/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.i18n.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs.FileObject;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.EnterStringDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.i18n.KeyOccurrence;
import org.pentaho.di.ui.i18n.MessagesSourceCrawler;
import org.pentaho.di.ui.i18n.MessagesStore;
import org.pentaho.di.ui.i18n.SourceCrawlerPackageException;
import org.pentaho.di.ui.i18n.SourceCrawlerXMLElement;
import org.pentaho.di.ui.i18n.SourceCrawlerXMLFolder;
import org.pentaho.di.ui.i18n.TranslationsStore;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Translator2 {
    private static Class<?> PKG = Translator2.class;
    public static final String APP_NAME = BaseMessages.getString(PKG, (String)"i18nDialog.ApplicationName", (String[])new String[0]);
    private Display display;
    private Shell shell;
    private LogChannelInterface log;
    private PropsUI props;
    private MessagesSourceCrawler crawler;
    private TranslationsStore store;
    private SashForm sashform;
    private org.eclipse.swt.widgets.List wLocale;
    private TableView wPackages;
    private org.eclipse.swt.widgets.List wTodo;
    private String selectedLocale;
    private String selectedMessagesPackage;
    private Text wKey;
    private Text wMain;
    private Text wValue;
    private Text wSource;
    private Button wReload;
    private Button wClose;
    private Button wApply;
    private Button wRevert;
    private Button wSave;
    private Button wZip;
    private Button wSearch;
    private Button wNext;
    private Button wSearchV;
    private Button wNextV;
    private Button wAll;
    private String referenceLocale;
    private List<String> rootDirectories;
    private List<String> localeList;
    private List<String> filesToAvoid;
    protected String lastValue;
    protected boolean lastValueChanged;
    protected String selectedKey;
    protected String searchString;
    protected String lastFoundKey;
    private String singleMessagesFile;
    private String[] scanPhrases;
    private List<SourceCrawlerXMLFolder> xmlFolders;
    private String selectedSourceFolder;

    public Translator2(Display display) {
        this.display = display;
        this.log = new LogChannel((Object)APP_NAME);
        this.props = PropsUI.getInstance();
    }

    public boolean showKey(String key, String messagesPackage) {
        return !key.startsWith("System.") || messagesPackage.equals(BaseMessages.class.getPackage().getName());
    }

    public void readFiles() throws KettleFileException {
        this.log.logBasic(BaseMessages.getString(PKG, (String)"i18n.Log.ScanningSourceDirectories", (String[])new String[0]));
        try {
            this.crawler = new MessagesSourceCrawler(this.log, this.rootDirectories, this.singleMessagesFile, this.xmlFolders);
            this.crawler.setScanPhrases(this.scanPhrases);
            this.crawler.setFilesToAvoid(this.filesToAvoid);
            this.crawler.crawl();
            this.store = new TranslationsStore(this.log, this.localeList, this.referenceLocale, this.crawler.getSourcePackageOccurrences());
            this.store.read(this.rootDirectories);
            HashMap<String, int[]> folderKeyCounts = new HashMap<String, int[]>();
            HashMap<String, Integer> nrKeysPerFolder = new HashMap<String, Integer>();
            for (String sourceFolder : this.rootDirectories) {
                folderKeyCounts.put(sourceFolder, new int[this.localeList.size()]);
            }
            for (String sourceFolder : this.rootDirectories) {
                int[] keyCounts = (int[])folderKeyCounts.get(sourceFolder);
                int nrKeys = 0;
                for (int i = 0; i < this.localeList.size(); ++i) {
                    String locale = this.localeList.get(i);
                    for (KeyOccurrence keyOccurrence : this.crawler.getKeyOccurrences(sourceFolder)) {
                        if (!this.showKey(keyOccurrence.getKey(), keyOccurrence.getMessagesPackage())) continue;
                        String value = this.store.lookupKeyValue(locale, keyOccurrence.getMessagesPackage(), keyOccurrence.getKey());
                        if (!Const.isEmpty((String)value)) {
                            int n = i;
                            keyCounts[n] = keyCounts[n] + 1;
                        }
                        if (!locale.equals(this.referenceLocale)) continue;
                        ++nrKeys;
                    }
                }
                nrKeysPerFolder.put(sourceFolder, new Integer(nrKeys));
            }
            DecimalFormat pctFormat = new DecimalFormat("#00.00");
            DecimalFormat nrFormat = new DecimalFormat("00");
            for (String sourceFolder : this.rootDirectories) {
                int i;
                System.out.println("-------------------------------------");
                System.out.println("Folder: " + sourceFolder);
                System.out.println("-------------------------------------");
                int nrKeys = (Integer)nrKeysPerFolder.get(sourceFolder);
                System.out.println(BaseMessages.getString(PKG, (String)"i18n.Log.NumberOfKeysFound", (String[])new String[]{"" + nrKeys}));
                int[] keyCounts = (int[])folderKeyCounts.get(sourceFolder);
                String[] locales = this.localeList.toArray(new String[this.localeList.size()]);
                for (i = 0; i < locales.length; ++i) {
                    for (int j = 0; j < locales.length - 1; ++j) {
                        if (keyCounts[j] >= keyCounts[j + 1]) continue;
                        int c = keyCounts[j];
                        keyCounts[j] = keyCounts[j + 1];
                        keyCounts[j + 1] = c;
                        String l = locales[j];
                        locales[j] = locales[j + 1];
                        locales[j + 1] = l;
                    }
                }
                for (i = 0; i < locales.length; ++i) {
                    double donePct = 100.0 * (double)keyCounts[i] / (double)nrKeys;
                    int missingKeys = nrKeys - keyCounts[i];
                    String statusKeys = "# " + nrFormat.format(i + 1) + " : " + locales[i] + " : " + pctFormat.format(donePct) + "% " + BaseMessages.getString(PKG, (String)"i18n.Log.CompleteKeys", (Object[])new Object[]{keyCounts[i]}) + (missingKeys != 0 ? BaseMessages.getString(PKG, (String)"i18n.Log.MissingKeys", (Object[])new Object[]{missingKeys}) : "");
                    System.out.println(statusKeys);
                }
            }
        }
        catch (Exception e) {
            throw new KettleFileException(BaseMessages.getString(PKG, (String)"i18n.Log.UnableToGetFiles", (String[])new String[]{this.rootDirectories.toString()}), (Throwable)e);
        }
    }

    public void loadConfiguration(String configFile, String sourceFolder) throws Exception {
        this.localeList = new ArrayList<String>();
        this.rootDirectories = new ArrayList<String>();
        this.filesToAvoid = new ArrayList<String>();
        this.xmlFolders = new ArrayList<SourceCrawlerXMLFolder>();
        FileObject file = KettleVFS.getFileObject((String)configFile);
        if (file.exists()) {
            try {
                Document doc = XMLHandler.loadXMLFile((FileObject)file);
                Node configNode = XMLHandler.getSubNode((Node)doc, (String)"translator-config");
                this.referenceLocale = XMLHandler.getTagValue((Node)configNode, (String)"reference-locale");
                this.singleMessagesFile = XMLHandler.getTagValue((Node)configNode, (String)"single-messages-file");
                Node localeListNode = XMLHandler.getSubNode((Node)configNode, (String)"locale-list");
                int nrLocale = XMLHandler.countNodes((Node)localeListNode, (String)"locale");
                if (nrLocale > 0) {
                    this.localeList.clear();
                }
                for (int i = 0; i < nrLocale; ++i) {
                    Node localeNode = XMLHandler.getSubNodeByNr((Node)localeListNode, (String)"locale", (int)i);
                    String locale = XMLHandler.getTagValue((Node)localeNode, (String)"code");
                    this.localeList.add(locale);
                }
                Node phrasesNode = XMLHandler.getSubNode((Node)configNode, (String)"scan-phrases");
                int nrPhrases = XMLHandler.countNodes((Node)phrasesNode, (String)"scan-phrase");
                this.scanPhrases = new String[nrPhrases];
                for (int i = 0; i < nrPhrases; ++i) {
                    Node phraseNode = XMLHandler.getSubNodeByNr((Node)phrasesNode, (String)"scan-phrase", (int)i);
                    this.scanPhrases[i] = XMLHandler.getNodeValue((Node)phraseNode);
                }
                Node rootsNode = XMLHandler.getSubNode((Node)configNode, (String)"source-directories");
                int nrRoots = XMLHandler.countNodes((Node)rootsNode, (String)"root");
                if (nrRoots > 0) {
                    this.rootDirectories.clear();
                }
                for (int i = 0; i < nrRoots; ++i) {
                    Node rootNode = XMLHandler.getSubNodeByNr((Node)rootsNode, (String)"root", (int)i);
                    String directory = XMLHandler.getNodeValue((Node)rootNode);
                    directory = sourceFolder + File.separator + directory;
                    this.rootDirectories.add(directory);
                }
                Node filesNode = XMLHandler.getSubNode((Node)configNode, (String)"files-to-avoid");
                int nrFiles = XMLHandler.countNodes((Node)filesNode, (String)"filename");
                if (nrFiles > 0) {
                    this.filesToAvoid.clear();
                }
                for (int i = 0; i < nrFiles; ++i) {
                    Node fileNode = XMLHandler.getSubNodeByNr((Node)filesNode, (String)"filename", (int)i);
                    String filename = XMLHandler.getNodeValue((Node)fileNode);
                    this.filesToAvoid.add(filename);
                }
                Node foldersToScanNode = XMLHandler.getSubNode((Node)configNode, (String)"xml-folders-to-scan");
                int nrFolders = XMLHandler.countNodes((Node)foldersToScanNode, (String)"xml-folder-to-scan");
                if (nrFolders > 0) {
                    this.xmlFolders.clear();
                }
                for (int i = 0; i < nrFolders; ++i) {
                    Node folderToScanNode = XMLHandler.getSubNodeByNr((Node)foldersToScanNode, (String)"xml-folder-to-scan", (int)i);
                    String folderName = sourceFolder + File.separator + XMLHandler.getTagValue((Node)folderToScanNode, (String)"folder");
                    String wildcard = XMLHandler.getTagValue((Node)folderToScanNode, (String)"wildcard");
                    String keyPrefix = XMLHandler.getTagValue((Node)folderToScanNode, (String)"key-prefix");
                    SourceCrawlerXMLFolder xmlFolder = new SourceCrawlerXMLFolder(folderName, wildcard, keyPrefix);
                    Node elementsNode = XMLHandler.getSubNode((Node)folderToScanNode, (String)"elements-to-scan");
                    int nrElements = XMLHandler.countNodes((Node)elementsNode, (String)"element-to-scan");
                    for (int j = 0; j < nrElements; ++j) {
                        Node elementNode = XMLHandler.getSubNodeByNr((Node)elementsNode, (String)"element-to-scan", (int)j);
                        String element = XMLHandler.getTagValue((Node)elementNode, (String)"element");
                        String tag = XMLHandler.getTagValue((Node)elementNode, (String)"tag");
                        String attribute = XMLHandler.getTagValue((Node)elementNode, (String)"attribute");
                        xmlFolder.getElements().add(new SourceCrawlerXMLElement(element, tag, attribute));
                    }
                    String defaultPackage = XMLHandler.getTagValue((Node)folderToScanNode, (String)"package-default");
                    xmlFolder.setDefaultPackage(defaultPackage);
                    String defaultSourceFolder = XMLHandler.getTagValue((Node)folderToScanNode, (String)"package-source-folder");
                    xmlFolder.setDefaultSourceFolder(sourceFolder + File.separator + defaultSourceFolder);
                    Node packageExceptionsNode = XMLHandler.getSubNode((Node)folderToScanNode, (String)"package-exceptions");
                    int nrExceptions = XMLHandler.countNodes((Node)packageExceptionsNode, (String)"package-exception");
                    for (int j = 0; j < nrExceptions; ++j) {
                        Node packageExceptionNode = XMLHandler.getSubNodeByNr((Node)packageExceptionsNode, (String)"package-exception", (int)j);
                        String startsWith = XMLHandler.getTagValue((Node)packageExceptionNode, (String)"starts-with");
                        String packageName = XMLHandler.getTagValue((Node)packageExceptionNode, (String)"package");
                        xmlFolder.getPackageExceptions().add(new SourceCrawlerPackageException(startsWith, packageName));
                    }
                    this.xmlFolders.add(xmlFolder);
                }
                System.out.println(BaseMessages.getString(PKG, (String)"i18n.Log.XMLFoldersToScan", (Object[])new Object[]{this.xmlFolders.size()}));
                for (SourceCrawlerXMLFolder xmlFolder : this.xmlFolders) {
                    System.out.println(BaseMessages.getString(PKG, (String)"i18n.Log.Folder", (Object[])new Object[]{xmlFolder.getFolder(), xmlFolder.getWildcard(), xmlFolder.getElements().size()}));
                }
            }
            catch (Exception e) {
                this.log.logError("Translator", new Object[]{"Error reading translator.xml", e});
            }
        }
    }

    public void open() {
        this.shell = new Shell(this.display);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setText(APP_NAME);
        this.shell.setImage(GUIResource.getInstance().getImageLogoSmall());
        try {
            this.readFiles();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error reading translations", "There was an unexpected error reading the translations", e);
        }
        this.sashform = new SashForm((Composite)this.shell, 256);
        this.sashform.setLayout((Layout)new FormLayout());
        this.addLists();
        this.addGrid();
        this.addListeners();
        this.sashform.setWeights(new int[]{20, 80});
        this.sashform.setVisible(true);
        this.shell.pack();
        this.refresh();
        this.shell.setSize(1024, 768);
        this.shell.open();
    }

    private void addListeners() {
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = Translator2.this.quitFile();
            }
        });
        this.wReload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = ((Translator2)Translator2.this).wPackages.table.getSelectionIndices();
                Translator2.this.reload();
                ((Translator2)Translator2.this).wPackages.table.setSelection(idx);
            }
        });
        this.wZip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Translator2.this.saveFilesToZip();
            }
        });
        this.wClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Translator2.this.quitFile();
            }
        });
    }

    public void reload() {
        try {
            this.shell.setCursor(this.display.getSystemCursor(1));
            this.readFiles();
            this.shell.setCursor(null);
            this.refresh();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error loading data", "There was an unexpected error re-loading the data", e);
        }
    }

    public boolean quitFile() {
        List<MessagesStore> changedMessagesStores = this.store.getChangedMessagesStores();
        if (changedMessagesStores.size() > 0) {
            MessageBox mb = new MessageBox(this.shell, 200);
            mb.setMessage(BaseMessages.getString(PKG, (String)"i18nDialog.ChangedFilesWhenExit", (String[])new String[]{changedMessagesStores.size() + ""}));
            mb.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Warning", (String[])new String[0]));
            int answer = mb.open();
            if (answer == 128) {
                return false;
            }
        }
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.props.saveProps();
        this.shell.dispose();
        this.display.dispose();
        return true;
    }

    private void addLists() {
        Composite composite = new Composite((Composite)this.sashform, 0);
        this.props.setLook((Control)composite);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 5;
        formLayout.marginWidth = 5;
        composite.setLayout((Layout)formLayout);
        this.wLocale = new org.eclipse.swt.widgets.List(composite, 2820);
        FormData fdLocale = new FormData();
        fdLocale.left = new FormAttachment(0, 0);
        fdLocale.right = new FormAttachment(100, 0);
        fdLocale.top = new FormAttachment(0, 0);
        fdLocale.bottom = new FormAttachment(20, 0);
        this.wLocale.setLayoutData((Object)fdLocale);
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"i18nDialog.SourceFolder", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"i18nDialog.Packagename", (String[])new String[0]), 1, false, true)};
        this.wPackages = new TableView((VariableSpace)new Variables(), composite, 67588, colinfo, 1, true, null, this.props);
        FormData fdPackages = new FormData();
        fdPackages.left = new FormAttachment(0, 0);
        fdPackages.right = new FormAttachment(100, 0);
        fdPackages.top = new FormAttachment((Control)this.wLocale, 4);
        fdPackages.bottom = new FormAttachment(100, 0);
        this.wPackages.setLayoutData(fdPackages);
        this.wPackages.setSortable(false);
        FormData fdComposite = new FormData();
        fdComposite.left = new FormAttachment(0, 0);
        fdComposite.right = new FormAttachment(100, 0);
        fdComposite.top = new FormAttachment(0, 0);
        fdComposite.bottom = new FormAttachment(100, 0);
        composite.setLayoutData((Object)fdComposite);
        this.wLocale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator2.this.refreshGrid();
            }
        });
        this.wPackages.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator2.this.refreshGrid();
            }
        });
        composite.layout();
    }

    private void addGrid() {
        Composite composite = new Composite((Composite)this.sashform, 0);
        this.props.setLook((Control)composite);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        composite.setLayout((Layout)formLayout);
        this.wReload = new Button(composite, 0);
        this.wReload.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Reload", (String[])new String[0]));
        this.wSave = new Button(composite, 0);
        this.wSave.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Save", (String[])new String[0]));
        this.wZip = new Button(composite, 0);
        this.wZip.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Zip", (String[])new String[0]));
        this.wZip.setToolTipText(BaseMessages.getString(PKG, (String)"i18nDialog.Zip.Tip", (String[])new String[0]));
        this.wClose = new Button(composite, 0);
        this.wClose.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Close", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons(composite, new Button[]{this.wReload, this.wSave, this.wZip, this.wClose}, 12, null);
        int left = 25;
        int middle = 40;
        this.wAll = new Button(composite, 32);
        this.wAll.setText(BaseMessages.getString(PKG, (String)"i18nDialog.ShowAllkeys", (String[])new String[0]));
        this.props.setLook((Control)this.wAll);
        FormData fdAll = new FormData();
        fdAll.left = new FormAttachment(0, 0);
        fdAll.right = new FormAttachment(left, 0);
        fdAll.bottom = new FormAttachment((Control)this.wClose, -4);
        this.wAll.setLayoutData((Object)fdAll);
        Label wlTodo = new Label(composite, 16384);
        this.props.setLook((Control)wlTodo);
        wlTodo.setText(BaseMessages.getString(PKG, (String)"i18nDialog.ToDoList", (String[])new String[0]));
        FormData fdlTodo = new FormData();
        fdlTodo.left = new FormAttachment(0, 0);
        fdlTodo.right = new FormAttachment(left, 0);
        fdlTodo.top = new FormAttachment(0, 0);
        wlTodo.setLayoutData((Object)fdlTodo);
        this.wTodo = new org.eclipse.swt.widgets.List(composite, 2820);
        FormData fdTodo = new FormData();
        fdTodo.left = new FormAttachment(0, 0);
        fdTodo.right = new FormAttachment(left, 0);
        fdTodo.top = new FormAttachment((Control)wlTodo, 4);
        fdTodo.bottom = new FormAttachment((Control)this.wAll, -4);
        this.wTodo.setLayoutData((Object)fdTodo);
        Label wlKey = new Label(composite, 131072);
        wlKey.setText(BaseMessages.getString(PKG, (String)"i18nDialog.TranslationKey", (String[])new String[0]));
        this.props.setLook((Control)wlKey);
        FormData fdlKey = new FormData();
        fdlKey.left = new FormAttachment(left, 4);
        fdlKey.right = new FormAttachment(middle, 0);
        fdlKey.top = new FormAttachment((Control)wlTodo, 4);
        wlKey.setLayoutData((Object)fdlKey);
        this.wKey = new Text(composite, 2820);
        this.props.setLook((Control)this.wKey);
        FormData fdKey = new FormData();
        fdKey.left = new FormAttachment(middle, 4);
        fdKey.right = new FormAttachment(100, 0);
        fdKey.top = new FormAttachment((Control)wlTodo, 4);
        this.wKey.setLayoutData((Object)fdKey);
        this.wKey.setEditable(false);
        Label wlMain = new Label(composite, 131072);
        wlMain.setText(BaseMessages.getString(PKG, (String)"i18nDialog.MainTranslation", (String[])new String[0]));
        this.props.setLook((Control)wlMain);
        FormData fdlMain = new FormData();
        fdlMain.left = new FormAttachment(left, 4);
        fdlMain.right = new FormAttachment(middle, 0);
        fdlMain.top = new FormAttachment((Control)this.wKey, 4);
        wlMain.setLayoutData((Object)fdlMain);
        this.wMain = new Text(composite, 2818);
        this.props.setLook((Control)this.wMain);
        FormData fdMain = new FormData();
        fdMain.left = new FormAttachment(middle, 4);
        fdMain.right = new FormAttachment(100, 0);
        fdMain.top = new FormAttachment((Control)this.wKey, 4);
        fdMain.bottom = new FormAttachment((Control)this.wKey, 154);
        this.wMain.setLayoutData((Object)fdMain);
        this.wMain.setEditable(false);
        this.wSearch = new Button(composite, 8);
        this.wSearch.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Search", (String[])new String[0]));
        FormData fdSearch = new FormData();
        fdSearch.right = new FormAttachment(middle, -8);
        fdSearch.top = new FormAttachment((Control)this.wMain, 0, 0x1000000);
        this.wSearch.setLayoutData((Object)fdSearch);
        this.wNext = new Button(composite, 8);
        this.wNext.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Next", (String[])new String[0]));
        FormData fdNext = new FormData();
        fdNext.right = new FormAttachment(middle, -8);
        fdNext.top = new FormAttachment((Control)this.wSearch, 8);
        this.wNext.setLayoutData((Object)fdNext);
        Label wlSource = new Label(composite, 131072);
        wlSource.setText(BaseMessages.getString(PKG, (String)"i18nDialog.LineOfSourceCode", (String[])new String[0]));
        this.props.setLook((Control)wlSource);
        FormData fdlSource = new FormData();
        fdlSource.left = new FormAttachment(left, 4);
        fdlSource.right = new FormAttachment(middle, 0);
        fdlSource.top = new FormAttachment((Control)this.wClose, -104);
        wlSource.setLayoutData((Object)fdlSource);
        this.wSource = new Text(composite, 2626);
        this.props.setLook((Control)this.wSource);
        FormData fdSource = new FormData();
        fdSource.left = new FormAttachment(middle, 4);
        fdSource.right = new FormAttachment(100, 0);
        fdSource.top = new FormAttachment((Control)this.wClose, -104);
        fdSource.bottom = new FormAttachment((Control)this.wClose, -4);
        this.wSource.setLayoutData((Object)fdSource);
        this.wSource.setEditable(false);
        Label wlValue = new Label(composite, 131072);
        wlValue.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Translation", (String[])new String[0]));
        this.props.setLook((Control)wlValue);
        FormData fdlValue = new FormData();
        fdlValue.left = new FormAttachment(left, 4);
        fdlValue.right = new FormAttachment(middle, 0);
        fdlValue.top = new FormAttachment((Control)this.wMain, 4);
        wlValue.setLayoutData((Object)fdlValue);
        this.wValue = new Text(composite, 2818);
        this.props.setLook((Control)this.wValue);
        FormData fdValue = new FormData();
        fdValue.left = new FormAttachment(middle, 4);
        fdValue.right = new FormAttachment(100, 0);
        fdValue.top = new FormAttachment((Control)this.wMain, 4);
        fdValue.bottom = new FormAttachment((Control)this.wSource, -4);
        this.wValue.setLayoutData((Object)fdValue);
        this.wValue.setEditable(true);
        this.wApply = new Button(composite, 8);
        this.wApply.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Apply", (String[])new String[0]));
        FormData fdApply = new FormData();
        fdApply.right = new FormAttachment(middle, -8);
        fdApply.top = new FormAttachment((Control)this.wValue, 0, 0x1000000);
        this.wApply.setLayoutData((Object)fdApply);
        this.wApply.setEnabled(false);
        this.wRevert = new Button(composite, 8);
        this.wRevert.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Revert", (String[])new String[0]));
        FormData fdRevert = new FormData();
        fdRevert.right = new FormAttachment(middle, -8);
        fdRevert.top = new FormAttachment((Control)this.wApply, 8);
        this.wRevert.setLayoutData((Object)fdRevert);
        this.wRevert.setEnabled(false);
        this.wSearchV = new Button(composite, 8);
        this.wSearchV.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Search", (String[])new String[0]));
        FormData fdSearchV = new FormData();
        fdSearchV.right = new FormAttachment(middle, -8);
        fdSearchV.top = new FormAttachment((Control)this.wRevert, 16);
        this.wSearchV.setLayoutData((Object)fdSearchV);
        this.wNextV = new Button(composite, 8);
        this.wNextV.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Next", (String[])new String[0]));
        FormData fdNextV = new FormData();
        fdNextV.right = new FormAttachment(middle, -8);
        fdNextV.top = new FormAttachment((Control)this.wSearchV, 8);
        this.wNextV.setLayoutData((Object)fdNextV);
        this.wAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator2.this.refreshGrid();
            }
        });
        this.wTodo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Translator2.this.wTodo.getSelectionCount() == 1) {
                    String key = Translator2.this.wTodo.getSelection()[0];
                    Translator2.this.showKeySelection(key);
                }
            }
        });
        this.wValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Translator2.this.lastValueChanged = true;
                Translator2.this.lastValue = Translator2.this.wValue.getText();
                Translator2.this.wApply.setEnabled(true);
                Translator2.this.wRevert.setEnabled(true);
            }
        });
        this.wApply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator2.this.applyChangedValue();
            }
        });
        this.wRevert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator2.this.revertChangedValue();
            }
        });
        this.wSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Translator2.this.saveFiles();
            }
        });
        this.wSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator2.this.search(Translator2.this.referenceLocale);
            }
        });
        this.wNext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator2.this.searchAgain(Translator2.this.referenceLocale);
            }
        });
        this.wSearchV.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator2.this.search(Translator2.this.selectedLocale);
            }
        });
        this.wNextV.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator2.this.searchAgain(Translator2.this.selectedLocale);
            }
        });
    }

    protected boolean saveFiles() {
        List<MessagesStore> changedMessagesStores = this.store.getChangedMessagesStores();
        if (changedMessagesStores.size() > 0) {
            StringBuffer msg = new StringBuffer();
            for (MessagesStore messagesStore : changedMessagesStores) {
                String filename = messagesStore.getSaveFilename(messagesStore.getSourceFolder());
                messagesStore.setFilename(filename);
                msg.append(messagesStore.getFilename());
                if (!new File(filename).exists()) {
                    msg.append(" (NEW!)");
                }
                msg.append(Const.CR);
            }
            EnterTextDialog dialog = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"i18nDialog.ChangedFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"i18nDialog.ChangedMessagesFiles", (String[])new String[0]), msg.toString());
            if (dialog.open() != null) {
                try {
                    for (MessagesStore messagesStore : changedMessagesStores) {
                        messagesStore.write();
                        this.log.logBasic(BaseMessages.getString(PKG, (String)"i18n.Log.SavedMessagesFile", (String[])new String[]{messagesStore.getFilename()}));
                    }
                }
                catch (KettleException e) {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"i18n.UnexpectedError", (String[])new String[0]), "There was an error saving the changed messages files:", (Exception)((Object)e));
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    protected void saveFilesToZip() {
        List<MessagesStore> messagesStores;
        if (this.saveFiles() && (messagesStores = this.store.getMessagesStores(this.selectedLocale, null)).size() > 0) {
            StringBuffer msg = new StringBuffer();
            for (MessagesStore messagesStore : messagesStores) {
                MessagesStore mainLocaleMessagesStore = this.store.findMainLocaleMessagesStore(messagesStore.getSourceFolder(), messagesStore.getMessagesPackage());
                String sourceDirectory = mainLocaleMessagesStore.getSourceDirectory(this.rootDirectories);
                String filename = messagesStore.getSaveFilename(sourceDirectory);
                messagesStore.setFilename(filename);
                msg.append(filename).append(Const.CR);
            }
            FileDialog dialog = new FileDialog(this.shell, 4096);
            dialog.setFilterExtensions(new String[]{"*.zip", "*"});
            dialog.setFilterNames(new String[]{BaseMessages.getString(PKG, (String)"System.FileType.ZIPFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
            if (dialog.open() != null) {
                String zipFilename = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
                try {
                    ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFilename));
                    byte[] buf = new byte[1024];
                    for (MessagesStore messagesStore : messagesStores) {
                        int len;
                        FileInputStream in = new FileInputStream(messagesStore.getFilename());
                        out.putNextEntry(new ZipEntry(messagesStore.getFilename()));
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                        out.closeEntry();
                        in.close();
                    }
                    out.close();
                }
                catch (Exception e) {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"i18n.UnexpectedError", (String[])new String[0]), "There was an error saving the changed messages files:", e);
                }
            }
        }
    }

    protected void search(String searchLocale) {
        EnterStringDialog dialog = new EnterStringDialog(this.shell, Const.NVL((String)this.searchString, (String)""), BaseMessages.getString(PKG, (String)"i18nDialog.SearchKey", (String[])new String[0]), BaseMessages.getString(PKG, (String)"i18nDialog.SearchLocale1", (String[])new String[0]) + " '" + Const.NVL((String)searchLocale, (String)"") + "' " + BaseMessages.getString(PKG, (String)"i18nDialog.SearchLocale2", (String[])new String[0]));
        this.searchString = dialog.open();
        this.lastFoundKey = null;
        this.searchAgain(searchLocale);
    }

    protected void searchAgain(String searchLocale) {
        if (this.searchString != null) {
            String upperSearchString = this.searchString.toUpperCase();
            boolean lastKeyFound = this.lastFoundKey == null;
            List<MessagesStore> mainLocaleMessagesStores = this.store.getMessagesStores(searchLocale, this.selectedMessagesPackage);
            for (MessagesStore messagesStore : mainLocaleMessagesStores) {
                for (String key : messagesStore.getMessagesMap().keySet()) {
                    int index;
                    String value = messagesStore.getMessagesMap().get(key);
                    String upperValue = value.toUpperCase();
                    if (upperValue.indexOf(upperSearchString) < 0) continue;
                    if (lastKeyFound && (index = this.wTodo.indexOf(key)) >= 0) {
                        this.lastFoundKey = key;
                        this.wTodo.setSelection(index);
                        this.showKeySelection(this.wTodo.getSelection()[0]);
                        return;
                    }
                    if (!key.equals(this.lastFoundKey)) continue;
                    lastKeyFound = true;
                }
            }
        }
    }

    protected void showKeySelection(String key) {
        if (!key.equals(this.selectedKey)) {
            this.applyChangedValue();
        }
        if (this.selectedLocale != null && key != null && this.selectedMessagesPackage != null) {
            String mainValue = this.store.lookupKeyValue(this.referenceLocale, this.selectedMessagesPackage, key);
            String value = this.store.lookupKeyValue(this.selectedLocale, this.selectedMessagesPackage, key);
            KeyOccurrence keyOccurrence = this.crawler.getKeyOccurrence(key, this.selectedMessagesPackage);
            this.wKey.setText(key);
            this.wMain.setText(Const.NVL((String)mainValue, (String)""));
            this.wValue.setText(Const.NVL((String)value, (String)""));
            this.wSource.setText(Const.NVL((String)keyOccurrence.getSourceLine(), (String)""));
            this.wValue.setFocus();
            this.wValue.setSelection(this.wValue.getText().length());
            this.wValue.showSelection();
            this.wValue.clearSelection();
            this.selectedKey = key;
            this.lastValueChanged = false;
            this.wApply.setEnabled(false);
            this.wRevert.setEnabled(false);
        }
    }

    public void refreshGrid() {
        this.applyChangedValue();
        this.wTodo.removeAll();
        this.wKey.setText("");
        this.wMain.setText("");
        this.wValue.setText("");
        this.wSource.setText("");
        this.selectedLocale = this.wLocale.getSelectionCount() == 0 ? null : this.wLocale.getSelection()[0];
        this.selectedSourceFolder = this.wPackages.table.getSelectionCount() == 0 ? null : this.wPackages.table.getSelection()[0].getText(1);
        this.selectedMessagesPackage = this.wPackages.table.getSelectionCount() == 0 ? null : this.wPackages.table.getSelection()[0].getText(2);
        this.refreshPackages();
        if (this.selectedLocale != null && this.selectedSourceFolder != null && this.selectedMessagesPackage != null) {
            List<KeyOccurrence> todo = this.getTodoList(this.selectedLocale, this.selectedMessagesPackage, this.selectedSourceFolder, false);
            String[] todoItems = new String[todo.size()];
            for (int i = 0; i < todoItems.length; ++i) {
                todoItems[i] = todo.get(i).getKey();
            }
            this.wTodo.setItems(todoItems);
        }
    }

    private List<KeyOccurrence> getTodoList(String locale, String messagesPackage, String sourceFolder, boolean strict) {
        List<KeyOccurrence> keys = this.crawler.getOccurrencesForPackage(messagesPackage);
        ArrayList<KeyOccurrence> todo = new ArrayList<KeyOccurrence>();
        for (KeyOccurrence keyOccurrence : keys) {
            String value;
            if (!this.showKey(keyOccurrence.getKey(), keyOccurrence.getMessagesPackage()) || !Const.isEmpty((String)(value = this.store.lookupKeyValue(locale, messagesPackage, keyOccurrence.getKey()))) && (!this.wAll.getSelection() || strict)) continue;
            todo.add(keyOccurrence);
        }
        return todo;
    }

    private void applyChangedValue() {
        int todoIndex = this.wTodo.getSelectionIndex();
        if (this.selectedKey != null && this.selectedLocale != null && this.selectedMessagesPackage != null && this.lastValueChanged && this.selectedSourceFolder != null) {
            if (!Const.isEmpty((String)this.lastValue)) {
                this.store.storeValue(this.selectedLocale, this.selectedSourceFolder, this.selectedMessagesPackage, this.selectedKey, this.lastValue);
                this.lastValueChanged = false;
                if (!this.wAll.getSelection()) {
                    this.wTodo.remove(this.selectedKey);
                    if (this.wTodo.getSelectionIndex() < 0) {
                        if (todoIndex > this.wTodo.getItemCount()) {
                            todoIndex = this.wTodo.getItemCount() - 1;
                        }
                        if (todoIndex >= 0 && todoIndex < this.wTodo.getItemCount()) {
                            this.wTodo.setSelection(todoIndex);
                            this.showKeySelection(this.wTodo.getSelection()[0]);
                        } else {
                            this.refreshGrid();
                        }
                    }
                }
            }
            this.lastValue = null;
            this.wApply.setEnabled(false);
            this.wRevert.setEnabled(false);
        }
    }

    private void revertChangedValue() {
        this.lastValueChanged = false;
        this.refreshGrid();
    }

    public void refresh() {
        this.refreshLocale();
        this.refreshPackages();
        this.refreshGrid();
    }

    public void refreshPackages() {
        int index = this.wPackages.getSelectionIndex();
        this.wPackages.table.removeAll();
        Map<String, Map<String, List<KeyOccurrence>>> sourceMessagesPackages = this.crawler.getSourcePackageOccurrences();
        for (String sourceFolder : sourceMessagesPackages.keySet()) {
            Map<String, List<KeyOccurrence>> messagesPackages = sourceMessagesPackages.get(sourceFolder);
            for (String messagesPackage : messagesPackages.keySet()) {
                TableItem item = new TableItem(this.wPackages.table, 0);
                item.setText(1, sourceFolder);
                item.setText(2, messagesPackage);
                if (this.selectedLocale == null) continue;
                List<KeyOccurrence> todo = this.getTodoList(this.selectedLocale, messagesPackage, sourceFolder, true);
                if (todo.size() > 50) {
                    item.setBackground(GUIResource.getInstance().getColorRed());
                    continue;
                }
                if (todo.size() > 25) {
                    item.setBackground(GUIResource.getInstance().getColorOrange());
                    continue;
                }
                if (todo.size() > 10) {
                    item.setBackground(GUIResource.getInstance().getColorYellow());
                    continue;
                }
                if (todo.size() > 5) {
                    item.setBackground(GUIResource.getInstance().getColorBlue());
                    continue;
                }
                if (todo.size() <= 0) continue;
                item.setBackground(GUIResource.getInstance().getColorGreen());
            }
            if (messagesPackages.size() == 0) {
                new TableItem(this.wPackages.table, 0);
                continue;
            }
            this.wPackages.setRowNums();
            this.wPackages.optWidth(true);
        }
        if (index >= 0) {
            this.wPackages.table.setSelection(index);
            this.wPackages.table.showSelection();
        }
    }

    public void refreshLocale() {
        this.wLocale.removeAll();
        this.wLocale.setItems(this.localeList.toArray(new String[this.localeList.size()]));
    }

    public String toString() {
        return APP_NAME;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: Translator <translator.xml> <path-to-source>");
            System.err.println("Example:");
            System.err.println("sh translator.sh translator.xml .");
            System.exit(1);
        }
        KettleClientEnvironment.init();
        String configFile = args[0];
        String sourceFolder = args[1];
        Display display = new Display();
        LogChannel log = new LogChannel((Object)APP_NAME);
        PropsUI.init(display, 1);
        Translator2 translator = new Translator2(display);
        translator.loadConfiguration(configFile, sourceFolder);
        translator.open();
        try {
            while (!display.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Throwable e) {
            log.logError(BaseMessages.getString(PKG, (String)"i18n.UnexpectedError", (String[])new String[]{e.getMessage()}));
            log.logError(Const.getStackTracker((Throwable)e));
        }
    }
}

