/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.ftpsput;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.ftpsget.FTPSConnection;
import org.pentaho.di.job.entries.ftpsput.JobEntryFTPSPUT;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.LabelTextVar;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class JobEntryFTPSPUTDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntryFTPSPUT.class;
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;
    private Label wlServerName;
    private TextVar wServerName;
    private FormData fdlServerName;
    private FormData fdServerName;
    private Label wlServerPort;
    private TextVar wServerPort;
    private FormData fdlServerPort;
    private FormData fdServerPort;
    private Label wlUserName;
    private TextVar wUserName;
    private FormData fdlUserName;
    private FormData fdUserName;
    private Label wlPassword;
    private TextVar wPassword;
    private FormData fdlPassword;
    private FormData fdPassword;
    private Label wlLocalDirectory;
    private TextVar wLocalDirectory;
    private FormData fdlLocalDirectory;
    private FormData fdLocalDirectory;
    private Label wlRemoteDirectory;
    private TextVar wRemoteDirectory;
    private FormData fdlRemoteDirectory;
    private FormData fdRemoteDirectory;
    private Label wlWildcard;
    private TextVar wWildcard;
    private FormData fdlWildcard;
    private FormData fdWildcard;
    private Label wlRemove;
    private Button wRemove;
    private FormData fdlRemove;
    private FormData fdRemove;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private Listener lsCheckRemoteFolder;
    private JobEntryFTPSPUT jobEntry;
    private Shell shell;
    private Button wbTestRemoteDirectoryExists;
    private FormData fdbTestRemoteDirectoryExists;
    private Button wTest;
    private FormData fdTest;
    private Listener lsTest;
    private SelectionAdapter lsDef;
    private boolean changed;
    private Label wlBinaryMode;
    private Button wBinaryMode;
    private FormData fdlBinaryMode;
    private FormData fdBinaryMode;
    private TextVar wTimeout;
    private Label wlTimeout;
    private FormData fdTimeout;
    private FormData fdlTimeout;
    private Label wlOnlyNew;
    private Button wOnlyNew;
    private FormData fdlOnlyNew;
    private FormData fdOnlyNew;
    private Label wlActive;
    private Button wActive;
    private FormData fdlActive;
    private FormData fdActive;
    private CTabFolder wTabFolder;
    private Composite wGeneralComp;
    private Composite wFilesComp;
    private CTabItem wGeneralTab;
    private CTabItem wFilesTab;
    private FormData fdGeneralComp;
    private FormData fdFilesComp;
    private FormData fdTabFolder;
    private Group wSourceSettings;
    private Group wTargetSettings;
    private FormData fdSourceSettings;
    private FormData fdTargetSettings;
    private Group wServerSettings;
    private FormData fdServerSettings;
    private Group wAdvancedSettings;
    private FormData fdAdvancedSettings;
    private FormData fdProxyHost;
    private LabelTextVar wProxyPort;
    private FormData fdProxyPort;
    private LabelTextVar wProxyUsername;
    private FormData fdProxyUsername;
    private LabelTextVar wProxyPassword;
    private FormData fdProxyPasswd;
    private LabelTextVar wProxyHost;
    private Label wlConnectionType;
    private FormData fdlConnectionType;
    private CCombo wConnectionType;
    private FormData fdConnectionType;
    private Button wbLocalDirectory;
    private FormData fdbLocalDirectory;
    private FTPSConnection connection = null;

    public JobEntryFTPSPUTDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntryFTPSPUT)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Name.Default", (String[])new String[0]));
        }
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryFTPSPUTDialog.this.connection = null;
                JobEntryFTPSPUTDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlName = new Label((Composite)this.shell, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.right = new FormAttachment(middle, -margin);
        this.fdlName.top = new FormAttachment(0, margin);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        this.fdName = new FormData();
        this.fdName.left = new FormAttachment(middle, 0);
        this.fdName.top = new FormAttachment(0, margin);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)this.fdName);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wGeneralTab = new CTabItem(this.wTabFolder, 0);
        this.wGeneralTab.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Tab.General.Label", (String[])new String[0]));
        this.wGeneralComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        this.wGeneralComp.setLayout((Layout)generalLayout);
        this.wServerSettings = new Group(this.wGeneralComp, 32);
        this.props.setLook((Control)this.wServerSettings);
        this.wServerSettings.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.ServerSettings.Group.Label", (String[])new String[0]));
        FormLayout ServerSettingsgroupLayout = new FormLayout();
        ServerSettingsgroupLayout.marginWidth = 10;
        ServerSettingsgroupLayout.marginHeight = 10;
        this.wServerSettings.setLayout((Layout)ServerSettingsgroupLayout);
        this.wlServerName = new Label((Composite)this.wServerSettings, 131072);
        this.wlServerName.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Server.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlServerName);
        this.fdlServerName = new FormData();
        this.fdlServerName.left = new FormAttachment(0, 0);
        this.fdlServerName.top = new FormAttachment((Control)this.wName, margin);
        this.fdlServerName.right = new FormAttachment(middle, 0);
        this.wlServerName.setLayoutData((Object)this.fdlServerName);
        this.wServerName = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, 18436);
        this.props.setLook((Control)this.wServerName);
        this.wServerName.addModifyListener(lsMod);
        this.fdServerName = new FormData();
        this.fdServerName.left = new FormAttachment(middle, margin);
        this.fdServerName.top = new FormAttachment((Control)this.wName, margin);
        this.fdServerName.right = new FormAttachment(100, 0);
        this.wServerName.setLayoutData(this.fdServerName);
        this.wlServerPort = new Label((Composite)this.wServerSettings, 131072);
        this.wlServerPort.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Port.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlServerPort);
        this.fdlServerPort = new FormData();
        this.fdlServerPort.left = new FormAttachment(0, 0);
        this.fdlServerPort.top = new FormAttachment((Control)this.wServerName, margin);
        this.fdlServerPort.right = new FormAttachment(middle, 0);
        this.wlServerPort.setLayoutData((Object)this.fdlServerPort);
        this.wServerPort = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, 18436);
        this.props.setLook((Control)this.wServerPort);
        this.wServerPort.setToolTipText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Port.Tooltip", (String[])new String[0]));
        this.wServerPort.addModifyListener(lsMod);
        this.fdServerPort = new FormData();
        this.fdServerPort.left = new FormAttachment(middle, margin);
        this.fdServerPort.top = new FormAttachment((Control)this.wServerName, margin);
        this.fdServerPort.right = new FormAttachment(100, 0);
        this.wServerPort.setLayoutData(this.fdServerPort);
        this.wlUserName = new Label((Composite)this.wServerSettings, 131072);
        this.wlUserName.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Username.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUserName);
        this.fdlUserName = new FormData();
        this.fdlUserName.left = new FormAttachment(0, 0);
        this.fdlUserName.top = new FormAttachment((Control)this.wServerPort, margin);
        this.fdlUserName.right = new FormAttachment(middle, 0);
        this.wlUserName.setLayoutData((Object)this.fdlUserName);
        this.wUserName = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, 18436);
        this.props.setLook((Control)this.wUserName);
        this.wUserName.addModifyListener(lsMod);
        this.fdUserName = new FormData();
        this.fdUserName.left = new FormAttachment(middle, margin);
        this.fdUserName.top = new FormAttachment((Control)this.wServerPort, margin);
        this.fdUserName.right = new FormAttachment(100, 0);
        this.wUserName.setLayoutData(this.fdUserName);
        this.wlPassword = new Label((Composite)this.wServerSettings, 131072);
        this.wlPassword.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Password.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPassword);
        this.fdlPassword = new FormData();
        this.fdlPassword.left = new FormAttachment(0, 0);
        this.fdlPassword.top = new FormAttachment((Control)this.wUserName, margin);
        this.fdlPassword.right = new FormAttachment(middle, 0);
        this.wlPassword.setLayoutData((Object)this.fdlPassword);
        this.wPassword = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, 18436);
        this.props.setLook((Control)this.wPassword);
        this.wPassword.setEchoChar('*');
        this.wPassword.addModifyListener(lsMod);
        this.fdPassword = new FormData();
        this.fdPassword.left = new FormAttachment(middle, margin);
        this.fdPassword.top = new FormAttachment((Control)this.wUserName, margin);
        this.fdPassword.right = new FormAttachment(100, 0);
        this.wPassword.setLayoutData(this.fdPassword);
        this.wProxyHost = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, BaseMessages.getString(PKG, (String)"JobFTPSPUT.ProxyHost.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobFTPSPUT.ProxyHost.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyHost);
        this.wProxyHost.addModifyListener(lsMod);
        this.fdProxyHost = new FormData();
        this.fdProxyHost.left = new FormAttachment(0, 0);
        this.fdProxyHost.top = new FormAttachment((Control)this.wPassword, 2 * margin);
        this.fdProxyHost.right = new FormAttachment(100, 0);
        this.wProxyHost.setLayoutData(this.fdProxyHost);
        this.wProxyPort = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, BaseMessages.getString(PKG, (String)"JobFTPSPUT.ProxyPort.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobFTPSPUT.ProxyPort.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyPort);
        this.wProxyPort.addModifyListener(lsMod);
        this.fdProxyPort = new FormData();
        this.fdProxyPort.left = new FormAttachment(0, 0);
        this.fdProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        this.fdProxyPort.right = new FormAttachment(100, 0);
        this.wProxyPort.setLayoutData(this.fdProxyPort);
        this.wProxyUsername = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, BaseMessages.getString(PKG, (String)"JobFTPSPUT.ProxyUsername.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobFTPSPUT.ProxyUsername.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyUsername);
        this.wProxyUsername.addModifyListener(lsMod);
        this.fdProxyUsername = new FormData();
        this.fdProxyUsername.left = new FormAttachment(0, 0);
        this.fdProxyUsername.top = new FormAttachment((Control)this.wProxyPort, margin);
        this.fdProxyUsername.right = new FormAttachment(100, 0);
        this.wProxyUsername.setLayoutData(this.fdProxyUsername);
        this.wProxyPassword = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, BaseMessages.getString(PKG, (String)"JobFTPSPUT.ProxyPassword.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobFTPSPUT.ProxyPassword.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyPassword);
        this.wProxyPassword.addModifyListener(lsMod);
        this.fdProxyPasswd = new FormData();
        this.fdProxyPasswd.left = new FormAttachment(0, 0);
        this.fdProxyPasswd.top = new FormAttachment((Control)this.wProxyUsername, margin);
        this.fdProxyPasswd.right = new FormAttachment(100, 0);
        this.wProxyPassword.setLayoutData(this.fdProxyPasswd);
        this.wlConnectionType = new Label((Composite)this.wServerSettings, 131072);
        this.wlConnectionType.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.ConnectionType.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlConnectionType);
        this.fdlConnectionType = new FormData();
        this.fdlConnectionType.left = new FormAttachment(0, 0);
        this.fdlConnectionType.right = new FormAttachment(middle, 0);
        this.fdlConnectionType.top = new FormAttachment((Control)this.wProxyPassword, 2 * margin);
        this.wlConnectionType.setLayoutData((Object)this.fdlConnectionType);
        this.wConnectionType = new CCombo((Composite)this.wServerSettings, 2060);
        this.wConnectionType.setItems(FTPSConnection.connection_type_Desc);
        this.props.setLook((Control)this.wConnectionType);
        this.fdConnectionType = new FormData();
        this.fdConnectionType.left = new FormAttachment(middle, margin);
        this.fdConnectionType.top = new FormAttachment((Control)this.wProxyPassword, 2 * margin);
        this.fdConnectionType.right = new FormAttachment(100, 0);
        this.wConnectionType.setLayoutData((Object)this.fdConnectionType);
        this.wConnectionType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.wTest = new Button((Composite)this.wServerSettings, 8);
        this.wTest.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.TestConnection.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wTest);
        this.fdTest = new FormData();
        this.wTest.setToolTipText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.TestConnection.Tooltip", (String[])new String[0]));
        this.fdTest.top = new FormAttachment((Control)this.wConnectionType, margin);
        this.fdTest.right = new FormAttachment(100, 0);
        this.wTest.setLayoutData((Object)this.fdTest);
        this.fdServerSettings = new FormData();
        this.fdServerSettings.left = new FormAttachment(0, margin);
        this.fdServerSettings.top = new FormAttachment((Control)this.wName, margin);
        this.fdServerSettings.right = new FormAttachment(100, -margin);
        this.wServerSettings.setLayoutData((Object)this.fdServerSettings);
        this.wAdvancedSettings = new Group(this.wGeneralComp, 32);
        this.props.setLook((Control)this.wAdvancedSettings);
        this.wAdvancedSettings.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.AdvancedSettings.Group.Label", (String[])new String[0]));
        FormLayout AdvancedSettingsgroupLayout = new FormLayout();
        AdvancedSettingsgroupLayout.marginWidth = 10;
        AdvancedSettingsgroupLayout.marginHeight = 10;
        this.wAdvancedSettings.setLayout((Layout)AdvancedSettingsgroupLayout);
        this.wlBinaryMode = new Label((Composite)this.wAdvancedSettings, 131072);
        this.wlBinaryMode.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.BinaryMode.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlBinaryMode);
        this.fdlBinaryMode = new FormData();
        this.fdlBinaryMode.left = new FormAttachment(0, 0);
        this.fdlBinaryMode.top = new FormAttachment((Control)this.wServerSettings, margin);
        this.fdlBinaryMode.right = new FormAttachment(middle, 0);
        this.wlBinaryMode.setLayoutData((Object)this.fdlBinaryMode);
        this.wBinaryMode = new Button((Composite)this.wAdvancedSettings, 32);
        this.props.setLook((Control)this.wBinaryMode);
        this.wBinaryMode.setToolTipText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.BinaryMode.Tooltip", (String[])new String[0]));
        this.fdBinaryMode = new FormData();
        this.fdBinaryMode.left = new FormAttachment(middle, 0);
        this.fdBinaryMode.top = new FormAttachment((Control)this.wServerSettings, margin);
        this.fdBinaryMode.right = new FormAttachment(100, 0);
        this.wBinaryMode.setLayoutData((Object)this.fdBinaryMode);
        this.wlTimeout = new Label((Composite)this.wAdvancedSettings, 131072);
        this.wlTimeout.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Timeout.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTimeout);
        this.fdlTimeout = new FormData();
        this.fdlTimeout.left = new FormAttachment(0, 0);
        this.fdlTimeout.top = new FormAttachment((Control)this.wBinaryMode, margin);
        this.fdlTimeout.right = new FormAttachment(middle, 0);
        this.wlTimeout.setLayoutData((Object)this.fdlTimeout);
        this.wTimeout = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wAdvancedSettings, 18436, BaseMessages.getString(PKG, (String)"JobFTPSPUT.Timeout.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wTimeout);
        this.wTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Timeout.Tooltip", (String[])new String[0]));
        this.fdTimeout = new FormData();
        this.fdTimeout.left = new FormAttachment(middle, 0);
        this.fdTimeout.top = new FormAttachment((Control)this.wBinaryMode, margin);
        this.fdTimeout.right = new FormAttachment(100, 0);
        this.wTimeout.setLayoutData(this.fdTimeout);
        this.wlActive = new Label((Composite)this.wAdvancedSettings, 131072);
        this.wlActive.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.ActiveConns.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlActive);
        this.fdlActive = new FormData();
        this.fdlActive.left = new FormAttachment(0, 0);
        this.fdlActive.top = new FormAttachment((Control)this.wTimeout, margin);
        this.fdlActive.right = new FormAttachment(middle, 0);
        this.wlActive.setLayoutData((Object)this.fdlActive);
        this.wActive = new Button((Composite)this.wAdvancedSettings, 32);
        this.wActive.setToolTipText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.ActiveConns.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wActive);
        this.fdActive = new FormData();
        this.fdActive.left = new FormAttachment(middle, 0);
        this.fdActive.top = new FormAttachment((Control)this.wTimeout, margin);
        this.fdActive.right = new FormAttachment(100, 0);
        this.wActive.setLayoutData((Object)this.fdActive);
        this.fdAdvancedSettings = new FormData();
        this.fdAdvancedSettings.left = new FormAttachment(0, margin);
        this.fdAdvancedSettings.top = new FormAttachment((Control)this.wServerSettings, margin);
        this.fdAdvancedSettings.right = new FormAttachment(100, -margin);
        this.wAdvancedSettings.setLayoutData((Object)this.fdAdvancedSettings);
        this.fdGeneralComp = new FormData();
        this.fdGeneralComp.left = new FormAttachment(0, 0);
        this.fdGeneralComp.top = new FormAttachment(0, 0);
        this.fdGeneralComp.right = new FormAttachment(100, 0);
        this.fdGeneralComp.bottom = new FormAttachment(100, 0);
        this.wGeneralComp.setLayoutData((Object)this.fdGeneralComp);
        this.wGeneralComp.layout();
        this.wGeneralTab.setControl((Control)this.wGeneralComp);
        this.props.setLook((Control)this.wGeneralComp);
        this.wFilesTab = new CTabItem(this.wTabFolder, 0);
        this.wFilesTab.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Tab.Files.Label", (String[])new String[0]));
        this.wFilesComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wFilesComp);
        FormLayout FilesLayout = new FormLayout();
        FilesLayout.marginWidth = 3;
        FilesLayout.marginHeight = 3;
        this.wFilesComp.setLayout((Layout)FilesLayout);
        this.wSourceSettings = new Group(this.wFilesComp, 32);
        this.props.setLook((Control)this.wSourceSettings);
        this.wSourceSettings.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.SourceSettings.Group.Label", (String[])new String[0]));
        FormLayout SourceSettinsgroupLayout = new FormLayout();
        SourceSettinsgroupLayout.marginWidth = 10;
        SourceSettinsgroupLayout.marginHeight = 10;
        this.wSourceSettings.setLayout((Layout)SourceSettinsgroupLayout);
        this.wlLocalDirectory = new Label((Composite)this.wSourceSettings, 131072);
        this.wlLocalDirectory.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.LocalDir.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLocalDirectory);
        this.fdlLocalDirectory = new FormData();
        this.fdlLocalDirectory.left = new FormAttachment(0, 0);
        this.fdlLocalDirectory.top = new FormAttachment(0, margin);
        this.fdlLocalDirectory.right = new FormAttachment(middle, -margin);
        this.wlLocalDirectory.setLayoutData((Object)this.fdlLocalDirectory);
        this.wbLocalDirectory = new Button((Composite)this.wSourceSettings, 0x1000008);
        this.props.setLook((Control)this.wbLocalDirectory);
        this.wbLocalDirectory.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.BrowseFolders.Label", (String[])new String[0]));
        this.fdbLocalDirectory = new FormData();
        this.fdbLocalDirectory.right = new FormAttachment(100, 0);
        this.fdbLocalDirectory.top = new FormAttachment(0, margin);
        this.wbLocalDirectory.setLayoutData((Object)this.fdbLocalDirectory);
        this.wLocalDirectory = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wSourceSettings, 18436, BaseMessages.getString(PKG, (String)"JobFTPSPUT.LocalDir.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wLocalDirectory);
        this.wLocalDirectory.addModifyListener(lsMod);
        this.fdLocalDirectory = new FormData();
        this.fdLocalDirectory.left = new FormAttachment(middle, 0);
        this.fdLocalDirectory.top = new FormAttachment(0, margin);
        this.fdLocalDirectory.right = new FormAttachment((Control)this.wbLocalDirectory, -margin);
        this.wLocalDirectory.setLayoutData(this.fdLocalDirectory);
        this.wlWildcard = new Label((Composite)this.wSourceSettings, 131072);
        this.wlWildcard.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Wildcard.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlWildcard);
        this.fdlWildcard = new FormData();
        this.fdlWildcard.left = new FormAttachment(0, 0);
        this.fdlWildcard.top = new FormAttachment((Control)this.wLocalDirectory, margin);
        this.fdlWildcard.right = new FormAttachment(middle, -margin);
        this.wlWildcard.setLayoutData((Object)this.fdlWildcard);
        this.wWildcard = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wSourceSettings, 18436, BaseMessages.getString(PKG, (String)"JobFTPSPUT.Wildcard.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wWildcard);
        this.wWildcard.addModifyListener(lsMod);
        this.fdWildcard = new FormData();
        this.fdWildcard.left = new FormAttachment(middle, 0);
        this.fdWildcard.top = new FormAttachment((Control)this.wLocalDirectory, margin);
        this.fdWildcard.right = new FormAttachment(100, 0);
        this.wWildcard.setLayoutData(this.fdWildcard);
        this.wlRemove = new Label((Composite)this.wSourceSettings, 131072);
        this.wlRemove.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.RemoveFiles.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlRemove);
        this.fdlRemove = new FormData();
        this.fdlRemove.left = new FormAttachment(0, 0);
        this.fdlRemove.top = new FormAttachment((Control)this.wWildcard, 2 * margin);
        this.fdlRemove.right = new FormAttachment(middle, -margin);
        this.wlRemove.setLayoutData((Object)this.fdlRemove);
        this.wRemove = new Button((Composite)this.wSourceSettings, 32);
        this.props.setLook((Control)this.wRemove);
        this.wRemove.setToolTipText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.RemoveFiles.Tooltip", (String[])new String[0]));
        this.fdRemove = new FormData();
        this.fdRemove.left = new FormAttachment(middle, 0);
        this.fdRemove.top = new FormAttachment((Control)this.wWildcard, 2 * margin);
        this.fdRemove.right = new FormAttachment(100, 0);
        this.wRemove.setLayoutData((Object)this.fdRemove);
        this.wlOnlyNew = new Label((Composite)this.wSourceSettings, 131072);
        this.wlOnlyNew.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.DontOverwrite.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOnlyNew);
        this.fdlOnlyNew = new FormData();
        this.fdlOnlyNew.left = new FormAttachment(0, 0);
        this.fdlOnlyNew.top = new FormAttachment((Control)this.wRemove, margin);
        this.fdlOnlyNew.right = new FormAttachment(middle, 0);
        this.wlOnlyNew.setLayoutData((Object)this.fdlOnlyNew);
        this.wOnlyNew = new Button((Composite)this.wSourceSettings, 32);
        this.wOnlyNew.setToolTipText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.DontOverwrite.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wOnlyNew);
        this.fdOnlyNew = new FormData();
        this.fdOnlyNew.left = new FormAttachment(middle, 0);
        this.fdOnlyNew.top = new FormAttachment((Control)this.wRemove, margin);
        this.fdOnlyNew.right = new FormAttachment(100, 0);
        this.wOnlyNew.setLayoutData((Object)this.fdOnlyNew);
        this.fdSourceSettings = new FormData();
        this.fdSourceSettings.left = new FormAttachment(0, margin);
        this.fdSourceSettings.top = new FormAttachment(0, 2 * margin);
        this.fdSourceSettings.right = new FormAttachment(100, -margin);
        this.wSourceSettings.setLayoutData((Object)this.fdSourceSettings);
        this.wTargetSettings = new Group(this.wFilesComp, 32);
        this.props.setLook((Control)this.wTargetSettings);
        this.wTargetSettings.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.TargetSettings.Group.Label", (String[])new String[0]));
        FormLayout TargetSettinsgroupLayout = new FormLayout();
        TargetSettinsgroupLayout.marginWidth = 10;
        TargetSettinsgroupLayout.marginHeight = 10;
        this.wTargetSettings.setLayout((Layout)TargetSettinsgroupLayout);
        this.wlRemoteDirectory = new Label((Composite)this.wTargetSettings, 131072);
        this.wlRemoteDirectory.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.RemoteDir.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlRemoteDirectory);
        this.fdlRemoteDirectory = new FormData();
        this.fdlRemoteDirectory.left = new FormAttachment(0, 0);
        this.fdlRemoteDirectory.top = new FormAttachment((Control)this.wSourceSettings, margin);
        this.fdlRemoteDirectory.right = new FormAttachment(middle, -margin);
        this.wlRemoteDirectory.setLayoutData((Object)this.fdlRemoteDirectory);
        this.wbTestRemoteDirectoryExists = new Button((Composite)this.wTargetSettings, 0x1000008);
        this.props.setLook((Control)this.wbTestRemoteDirectoryExists);
        this.wbTestRemoteDirectoryExists.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.TestFolderExists.Label", (String[])new String[0]));
        this.fdbTestRemoteDirectoryExists = new FormData();
        this.fdbTestRemoteDirectoryExists.right = new FormAttachment(100, 0);
        this.fdbTestRemoteDirectoryExists.top = new FormAttachment((Control)this.wSourceSettings, margin);
        this.wbTestRemoteDirectoryExists.setLayoutData((Object)this.fdbTestRemoteDirectoryExists);
        this.wRemoteDirectory = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wTargetSettings, 18436, BaseMessages.getString(PKG, (String)"JobFTPSPUT.RemoteDir.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wRemoteDirectory);
        this.wRemoteDirectory.addModifyListener(lsMod);
        this.fdRemoteDirectory = new FormData();
        this.fdRemoteDirectory.left = new FormAttachment(middle, 0);
        this.fdRemoteDirectory.top = new FormAttachment((Control)this.wSourceSettings, margin);
        this.fdRemoteDirectory.right = new FormAttachment((Control)this.wbTestRemoteDirectoryExists, -margin);
        this.wRemoteDirectory.setLayoutData(this.fdRemoteDirectory);
        this.fdTargetSettings = new FormData();
        this.fdTargetSettings.left = new FormAttachment(0, margin);
        this.fdTargetSettings.top = new FormAttachment((Control)this.wSourceSettings, margin);
        this.fdTargetSettings.right = new FormAttachment(100, -margin);
        this.wTargetSettings.setLayoutData((Object)this.fdTargetSettings);
        this.fdFilesComp = new FormData();
        this.fdFilesComp.left = new FormAttachment(0, 0);
        this.fdFilesComp.top = new FormAttachment(0, 0);
        this.fdFilesComp.right = new FormAttachment(100, 0);
        this.fdFilesComp.bottom = new FormAttachment(100, 0);
        this.wFilesComp.setLayoutData((Object)this.fdFilesComp);
        this.wFilesComp.layout();
        this.wFilesTab.setControl((Control)this.wFilesComp);
        this.props.setLook((Control)this.wFilesComp);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wName, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wTabFolder);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntryFTPSPUTDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntryFTPSPUTDialog.this.ok();
            }
        };
        this.lsTest = new Listener(){

            public void handleEvent(Event e) {
                JobEntryFTPSPUTDialog.this.test();
            }
        };
        this.lsCheckRemoteFolder = new Listener(){

            public void handleEvent(Event e) {
                JobEntryFTPSPUTDialog.this.checkRemoteFolder(JobEntryFTPSPUTDialog.this.jobMeta.environmentSubstitute(JobEntryFTPSPUTDialog.this.wRemoteDirectory.getText()));
            }
        };
        this.wbLocalDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir;
                DirectoryDialog ddialog = new DirectoryDialog(JobEntryFTPSPUTDialog.this.shell, 4096);
                if (JobEntryFTPSPUTDialog.this.wLocalDirectory.getText() != null) {
                    ddialog.setFilterPath(JobEntryFTPSPUTDialog.this.jobMeta.environmentSubstitute(JobEntryFTPSPUTDialog.this.wLocalDirectory.getText()));
                }
                if ((dir = ddialog.open()) != null) {
                    JobEntryFTPSPUTDialog.this.wLocalDirectory.setText(dir);
                }
            }
        });
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.wbTestRemoteDirectoryExists.addListener(13, this.lsCheckRemoteFolder);
        this.wTest.addListener(13, this.lsTest);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntryFTPSPUTDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)this.lsDef);
        this.wServerName.addSelectionListener(this.lsDef);
        this.wUserName.addSelectionListener(this.lsDef);
        this.wPassword.addSelectionListener(this.lsDef);
        this.wRemoteDirectory.addSelectionListener(this.lsDef);
        this.wLocalDirectory.addSelectionListener(this.lsDef);
        this.wWildcard.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntryFTPSPUTDialog.this.cancel();
            }
        });
        this.getData();
        this.wTabFolder.setSelection(0);
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobSFTPDialogSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    private void closeFTPSConnection() {
        if (this.connection != null) {
            try {
                this.connection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void test() {
        if (this.connectToFTP(false, null)) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Connected.OK", (String[])new String[]{this.wServerName.getText()}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Connected.Title.Ok", (String[])new String[0]));
            mb.open();
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Connected.NOK.ConnectionBad", (String[])new String[]{this.wServerName.getText()}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.Connected.Title.Bad", (String[])new String[0]));
            mb.open();
        }
    }

    private void checkRemoteFolder(String remoteFoldername) {
        if (!Const.isEmpty((String)remoteFoldername)) {
            if (this.connectToFTP(true, remoteFoldername)) {
                MessageBox mb = new MessageBox(this.shell, 34);
                mb.setMessage(BaseMessages.getString(PKG, (String)"JobFTPSPUT.FolderExists.OK", (String[])new String[]{remoteFoldername}) + Const.CR);
                mb.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.FolderExists.Title.Ok", (String[])new String[0]));
                mb.open();
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"JobFTPSPUT.FolderExists.NOK", (String[])new String[]{remoteFoldername}) + Const.CR);
                mb.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.FolderExists.Title.Bad", (String[])new String[0]));
                mb.open();
            }
        }
    }

    private boolean connectToFTP(boolean checkfolder, String remoteFoldername) {
        boolean retval = false;
        try {
            String realServername = this.jobMeta.environmentSubstitute(this.wServerName.getText());
            int realPort = Const.toInt((String)this.jobMeta.environmentSubstitute(this.wServerPort.getText()), (int)0);
            String realUsername = this.jobMeta.environmentSubstitute(this.wUserName.getText());
            String realPassword = this.jobMeta.environmentSubstitute(this.wPassword.getText());
            if (this.connection == null) {
                this.connection = new FTPSConnection(FTPSConnection.getConnectionTypeByDesc((String)this.wConnectionType.getText()), realServername, realPort, realUsername, realPassword);
                if (!Const.isEmpty((String)this.wProxyHost.getText())) {
                    String realProxy_host = this.jobMeta.environmentSubstitute(this.wProxyHost.getText());
                    String realProxy_user = this.jobMeta.environmentSubstitute(this.wProxyUsername.getText());
                    String realProxy_pass = this.jobMeta.environmentSubstitute(this.wProxyPassword.getText());
                    this.connection.setProxyHost(realProxy_host);
                    int proxyport = Const.toInt((String)this.jobMeta.environmentSubstitute(this.wProxyPort.getText()), (int)990);
                    if (proxyport != 0) {
                        this.connection.setProxyPort(proxyport);
                    }
                    if (!Const.isEmpty((String)realProxy_user)) {
                        this.connection.setProxyUser(realProxy_user);
                    }
                    if (!Const.isEmpty((String)realProxy_pass)) {
                        this.connection.setProxyPassword(realProxy_pass);
                    }
                }
                this.connection.connect();
            }
            if (checkfolder && !Const.isEmpty((String)remoteFoldername)) {
                String realFtpDirectory = this.jobMeta.environmentSubstitute(remoteFoldername);
                retval = this.connection.isDirectoryExists(realFtpDirectory);
            }
            retval = true;
        }
        catch (Exception e) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"JobFTPSPUT.ErrorConnect.NOK", (String[])new String[]{e.getMessage()}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"JobFTPSPUT.ErrorConnect.Title.Bad", (String[])new String[0]));
            mb.open();
        }
        return retval;
    }

    public void dispose() {
        this.closeFTPSConnection();
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        if (this.jobEntry.getName() != null) {
            this.wName.setText(this.jobEntry.getName());
        }
        this.wServerName.setText(Const.NVL((String)this.jobEntry.getServerName(), (String)""));
        this.wServerPort.setText(this.jobEntry.getServerPort());
        this.wUserName.setText(Const.NVL((String)this.jobEntry.getUserName(), (String)""));
        this.wPassword.setText(Const.NVL((String)this.jobEntry.getPassword(), (String)""));
        this.wRemoteDirectory.setText(Const.NVL((String)this.jobEntry.getRemoteDirectory(), (String)""));
        this.wLocalDirectory.setText(Const.NVL((String)this.jobEntry.getLocalDirectory(), (String)""));
        this.wWildcard.setText(Const.NVL((String)this.jobEntry.getWildcard(), (String)""));
        this.wRemove.setSelection(this.jobEntry.getRemove());
        this.wBinaryMode.setSelection(this.jobEntry.isBinaryMode());
        this.wTimeout.setText("" + this.jobEntry.getTimeout());
        this.wOnlyNew.setSelection(this.jobEntry.isOnlyPuttingNewFiles());
        this.wActive.setSelection(this.jobEntry.isActiveConnection());
        this.wProxyHost.setText(Const.NVL((String)this.jobEntry.getProxyHost(), (String)""));
        this.wProxyPort.setText(Const.NVL((String)this.jobEntry.getProxyPort(), (String)""));
        this.wProxyUsername.setText(Const.NVL((String)this.jobEntry.getProxyUsername(), (String)""));
        this.wProxyPassword.setText(Const.NVL((String)this.jobEntry.getProxyPassword(), (String)""));
        this.wConnectionType.setText(FTPSConnection.getConnectionTypeDesc((int)this.jobEntry.getConnectionType()));
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setServerName(this.wServerName.getText());
        this.jobEntry.setServerPort(this.wServerPort.getText());
        this.jobEntry.setUserName(this.wUserName.getText());
        this.jobEntry.setPassword(this.wPassword.getText());
        this.jobEntry.setRemoteDirectory(this.wRemoteDirectory.getText());
        this.jobEntry.setLocalDirectory(this.wLocalDirectory.getText());
        this.jobEntry.setWildcard(this.wWildcard.getText());
        this.jobEntry.setRemove(this.wRemove.getSelection());
        this.jobEntry.setBinaryMode(this.wBinaryMode.getSelection());
        this.jobEntry.setTimeout(Const.toInt((String)this.wTimeout.getText(), (int)10000));
        this.jobEntry.setOnlyPuttingNewFiles(this.wOnlyNew.getSelection());
        this.jobEntry.setActiveConnection(this.wActive.getSelection());
        this.jobEntry.setProxyHost(this.wProxyHost.getText());
        this.jobEntry.setProxyPort(this.wProxyPort.getText());
        this.jobEntry.setProxyUsername(this.wProxyUsername.getText());
        this.jobEntry.setProxyPassword(this.wProxyPassword.getText());
        this.jobEntry.setConnectionType(FTPSConnection.getConnectionTypeByDesc((String)this.wConnectionType.getText()));
        this.dispose();
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }
}

