/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.dialog;

import java.util.Date;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.imp.ImportRules;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.IRepositoryImporter;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryImportFeedbackInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class RepositoryImportProgressDialog
extends Dialog
implements ProgressMonitorListener,
RepositoryImportFeedbackInterface {
    private static Class<?> PKG = RepositoryImportProgressDialog.class;
    private Shell shell;
    private Shell parent;
    private Display display;
    private PropsUI props = PropsUI.getInstance();
    private Label wLabel;
    private Text wLogging;
    private Button wClose;
    private boolean askOverwrite = true;
    private String fileDirectory;
    private String[] filenames;
    private RepositoryDirectoryInterface baseDirectory;
    private Repository rep;
    private String versionComment;
    private ImportRules importRules;

    public RepositoryImportProgressDialog(Shell parent, int style, Repository rep, String fileDirectory, String[] filenames, RepositoryDirectoryInterface baseDirectory, String versionComment) {
        this(parent, style, rep, fileDirectory, filenames, baseDirectory, versionComment, new ImportRules());
    }

    public RepositoryImportProgressDialog(Shell parent, int style, Repository rep, String fileDirectory, String[] filenames, RepositoryDirectoryInterface baseDirectory, String versionComment, ImportRules importRules) {
        super(parent, style);
        this.parent = parent;
        this.rep = rep;
        this.fileDirectory = fileDirectory;
        this.filenames = filenames;
        this.baseDirectory = baseDirectory;
        this.versionComment = versionComment;
        this.importRules = importRules;
    }

    public void open() {
        this.display = this.parent.getDisplay();
        this.shell = new Shell(this.parent, 3312);
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setText(BaseMessages.getString(PKG, (String)"RepositoryImportDialog.Title", (String[])new String[0]));
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        this.shell.setLayout((Layout)formLayout);
        this.wLabel = new Label((Composite)this.shell, 16384);
        this.props.setLook((Control)this.wLabel);
        FormData fdLabel = new FormData();
        fdLabel.left = new FormAttachment(0, 0);
        fdLabel.top = new FormAttachment(0, 0);
        fdLabel.right = new FormAttachment(100, 0);
        this.wLabel.setLayoutData((Object)fdLabel);
        this.wClose = new Button((Composite)this.shell, 8);
        this.wClose.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wClose}, 4, null);
        this.wClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryImportProgressDialog.this.dispose();
            }
        });
        this.wLogging = new Text((Composite)this.shell, 770);
        this.props.setLook((Control)this.wLabel);
        FormData fdLogging = new FormData();
        fdLogging.left = new FormAttachment(0, 0);
        fdLogging.top = new FormAttachment((Control)this.wLabel, 4);
        fdLogging.right = new FormAttachment(100, 0);
        fdLogging.bottom = new FormAttachment((Control)this.wClose, -4);
        this.wLogging.setLayoutData((Object)fdLogging);
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                RepositoryImportProgressDialog.this.shell.addShellListener((ShellListener)new ShellAdapter(){

                    public void shellClosed(ShellEvent e) {
                        RepositoryImportProgressDialog.this.dispose();
                    }
                });
            }
        });
        BaseStepDialog.setSize(this.shell, 1024, 768, true);
        this.shell.open();
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IRepositoryImporter importer = RepositoryImportProgressDialog.this.rep.getImporter();
                importer.setImportRules(RepositoryImportProgressDialog.this.importRules);
                importer.importAll((RepositoryImportFeedbackInterface)RepositoryImportProgressDialog.this, RepositoryImportProgressDialog.this.fileDirectory, RepositoryImportProgressDialog.this.filenames, RepositoryImportProgressDialog.this.baseDirectory, false, false, RepositoryImportProgressDialog.this.versionComment);
            }
        });
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void setLabel(String labelText) {
        this.wLabel.setText(labelText);
    }

    public void updateDisplay() {
        this.shell.getDisplay().update();
    }

    public void showError(String title, String message, Exception e) {
        new ErrorDialog(this.shell, title, message, e);
    }

    public boolean transOverwritePrompt(TransMeta transMeta) {
        MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"RepositoryImportDialog.OverwriteTrans.Title", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"RepositoryImportDialog.OverwriteTrans.Message", (String[])new String[]{transMeta.getName()}), 3, new String[]{BaseMessages.getString(PKG, (String)"System.Button.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Button.No", (String[])new String[0])}, 1, BaseMessages.getString(PKG, (String)"RepositoryImportDialog.DontAskAgain.Label", (String[])new String[0]), !this.askOverwrite);
        MessageDialogWithToggle.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
        int answer = md.open();
        this.askOverwrite = !md.getToggleState();
        return (answer & 0xFF) == 0;
    }

    public boolean jobOverwritePrompt(JobMeta jobMeta) {
        MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"RepositoryImportDialog.OverwriteJob.Title", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"RepositoryImportDialog.OverwriteJob.Message", (String[])new String[]{jobMeta.getName()}), 3, new String[]{BaseMessages.getString(PKG, (String)"System.Button.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Button.No", (String[])new String[0])}, 1, BaseMessages.getString(PKG, (String)"RepositoryImportDialog.DontAskAgain.Label", (String[])new String[0]), !this.askOverwrite);
        MessageDialogWithToggle.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
        int answer = md.open();
        this.askOverwrite = !md.getToggleState();
        return (answer & 0xFF) == 0;
    }

    public void addLog(String line) {
        StringBuffer rest = new StringBuffer(this.wLogging.getText());
        rest.append(XMLHandler.date2string((Date)new Date())).append(" : ");
        rest.append(line).append(Const.CR);
        this.wLogging.setText(rest.toString());
        this.wLogging.setSelection(rest.length());
    }

    public boolean askContinueOnErrorQuestion(String title, String message) {
        MessageBox mb = new MessageBox(this.shell, 196);
        mb.setMessage(message);
        mb.setText(title);
        int answer = mb.open();
        return answer != 128;
    }

    public void beginTask(String message, int nrWorks) {
        this.addLog(message);
    }

    public void done() {
    }

    public boolean isCanceled() {
        return false;
    }

    public void setTaskName(String taskName) {
        this.addLog(taskName);
    }

    public void subTask(String message) {
        this.addLog(message);
    }

    public void worked(int nrWorks) {
    }

    public boolean isAskingOverwriteConfirmation() {
        return this.askOverwrite;
    }
}

