/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.controllers;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.repository.dialog.RepositoryExplorerDialog;
import org.pentaho.di.ui.repository.repositoryexplorer.RepositoryExplorerCallback;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.swt.SwtBindingFactory;
import org.pentaho.ui.xul.util.DialogController;

public class MainController
extends AbstractXulEventHandler
implements DialogController<Object> {
    private static Class<?> PKG = RepositoryExplorerDialog.class;
    private RepositoryExplorerCallback callback;
    public static final int CANCELLED = 0;
    public static final int OK = 1;
    private int lastClicked = 0;
    private XulDialog dialog;
    private List<DialogController.DialogListener<Object>> listeners = new ArrayList<DialogController.DialogListener<Object>>();
    private Repository repository = null;
    BindingFactory bf;

    public boolean getOkClicked() {
        return this.lastClicked == 1;
    }

    public void init() {
        this.bf = new SwtBindingFactory();
        this.bf.setDocument(this.getXulDomContainer().getDocumentRoot());
        this.createBindings();
        if (this.dialog != null && this.repository != null) {
            this.dialog.setTitle(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.DevTitle", (String[])new String[]{this.repository.getName()}));
        }
    }

    public void showDialog() {
        this.dialog.show();
    }

    private void createBindings() {
        this.dialog = (XulDialog)this.document.getElementById("repository-explorer-dialog");
    }

    public RepositoryExplorerCallback getCallback() {
        return this.callback;
    }

    public void setCallback(RepositoryExplorerCallback callback) {
        this.callback = callback;
    }

    public void setRepository(Repository rep) {
        this.repository = rep;
    }

    public String getName() {
        return "mainController";
    }

    @Bindable
    public void closeDialog() {
        this.lastClicked = 0;
        this.dialog.hide();
        Spoon.getInstance().refreshTree();
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onDialogCancel();
        }
    }

    public void addDialogListener(DialogController.DialogListener<Object> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeDialogListener(DialogController.DialogListener<Object> listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void hideDialog() {
        this.closeDialog();
    }
}

