/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.controllers;

import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectRecipient;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.IUISupportController;
import org.pentaho.di.ui.repository.repositoryexplorer.RepositoryExplorer;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.LazilyInitializedController;
import org.pentaho.di.ui.repository.repositoryexplorer.model.IUIUser;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectRegistry;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UISecurity;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UISecurityUser;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulConfirmBox;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.swt.SwtBindingFactory;
import org.pentaho.ui.xul.util.XulDialogCallback;

public class SecurityController
extends LazilyInitializedController
implements IUISupportController {
    private static Class<?> PKG = RepositoryExplorer.class;
    public static final int USER_DECK = 0;
    protected XulDialog userDialog;
    private XulListbox userListBox;
    private XulTextbox username;
    protected XulTextbox userPassword;
    protected XulTextbox userDescription;
    private XulButton userAddButton;
    private XulButton userEditButton;
    private XulButton userRemoveButton;
    protected RepositorySecurityManager service;
    protected UISecurity security;
    protected BindingFactory bf;
    protected UISecurityUser securityUser;
    protected XulMessageBox messageBox = null;
    protected boolean managed = false;

    @Override
    public void init(Repository rep) throws ControllerInitializationException {
        this.repository = rep;
    }

    @Override
    protected boolean doLazyInit() {
        boolean serviceInitialized = this.initService();
        if (!serviceInitialized) {
            return false;
        }
        try {
            this.managed = this.service.isManaged();
            this.createModel();
            this.messageBox = (XulMessageBox)this.document.createElement("messagebox");
            this.bf = new SwtBindingFactory();
            this.bf.setDocument(this.getXulDomContainer().getDocumentRoot());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.bf != null) {
            this.createBindings();
        }
        if (!this.managed) {
            this.showButtons(false, false, false);
        }
        this.setInitialDeck();
        return true;
    }

    protected boolean initService() {
        try {
            if (this.repository != null && this.repository.hasService(RepositorySecurityManager.class)) {
                this.service = (RepositorySecurityManager)this.repository.getService(RepositorySecurityManager.class);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void setInitialDeck() {
        this.changeToUserDeck();
    }

    public XulMessageBox getMessageBox() {
        return this.messageBox;
    }

    public void setMessageBox(XulMessageBox messageBox) {
        this.messageBox = messageBox;
    }

    protected void createModel() throws Exception {
        this.createSecurityUser();
        this.createSecurity();
    }

    protected void createSecurityUser() throws Exception {
        this.securityUser = new UISecurityUser(this.service);
    }

    protected void createSecurity() throws Exception {
        this.security = new UISecurity(this.service);
    }

    protected void createBindings() {
        this.userAddButton = (XulButton)this.document.getElementById("user-add");
        this.userEditButton = (XulButton)this.document.getElementById("user-edit");
        this.userRemoveButton = (XulButton)this.document.getElementById("user-remove");
        this.userDialog = (XulDialog)this.document.getElementById("add-user-dialog");
        this.userListBox = (XulListbox)this.document.getElementById("users-list");
        this.username = (XulTextbox)this.document.getElementById("user-name");
        this.userPassword = (XulTextbox)this.document.getElementById("user-password");
        this.userDescription = (XulTextbox)this.document.getElementById("user-description");
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding((Object)this.securityUser, "name", (Object)this.username, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.securityUser, "password", (Object)this.userPassword, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.securityUser, "description", (Object)this.userDescription, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.security, "selectedUserIndex", (Object)this.userListBox, "selectedIndex", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        try {
            this.bf.createBinding((Object)this.userListBox, "selectedIndex", (Object)this, "enableButtons", new BindingConvertor[0]);
            this.bf.createBinding((Object)this.userListBox, "selectedItem", (Object)this.security, "selectedUser", new BindingConvertor[0]);
            this.bf.createBinding((Object)this.security, "userList", (Object)this.userListBox, "elements", new BindingConvertor[0]).fireSourceChanged();
            BindingConvertor<UISecurity.Mode, Boolean> modeBindingConverter = new BindingConvertor<UISecurity.Mode, Boolean>(){

                public Boolean sourceToTarget(UISecurity.Mode arg0) {
                    if (arg0.equals((Object)UISecurity.Mode.ADD)) {
                        return false;
                    }
                    return true;
                }

                public UISecurity.Mode targetToSource(Boolean arg0) {
                    return null;
                }
            };
            this.bf.createBinding((Object)this.securityUser, "mode", (Object)this.username, "disabled", new BindingConvertor[]{modeBindingConverter});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return "iSecurityController";
    }

    public void showAddUserDialog() throws Exception {
        this.securityUser.clear();
        this.securityUser.setMode(UISecurity.Mode.ADD);
        this.userDialog.setTitle(BaseMessages.getString(PKG, (String)"AddUserDialog.Title", (String[])new String[0]));
        this.userDialog.show();
    }

    public void cancelAddUserDialog() throws Exception {
        this.userDialog.hide();
    }

    protected void addUser() {
        if (this.service != null) {
            try {
                this.service.saveUserInfo(this.securityUser.getUserInfo());
                this.security.addUser(UIObjectRegistry.getInstance().constructUIRepositoryUser(this.securityUser.getUserInfo()));
                this.userDialog.hide();
            }
            catch (Throwable th) {
                this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"AddUser.UnableToAddUser", (String[])new String[]{th.getLocalizedMessage()}));
                this.messageBox.open();
            }
        }
    }

    public void showEditUserDialog() throws Exception {
        if (this.service != null) {
            this.securityUser.clear();
            this.securityUser.setUser(this.security.getSelectedUser());
            this.securityUser.setMode(UISecurity.Mode.EDIT);
            this.userDialog.setTitle(BaseMessages.getString(PKG, (String)"EditUserDialog.Title", (String[])new String[0]));
            this.userDialog.show();
        }
    }

    protected void updateUser() {
        if (this.service != null) {
            try {
                IUIUser uiUser = this.security.getSelectedUser();
                uiUser.setDescription(this.securityUser.getDescription());
                uiUser.setPassword(this.securityUser.getPassword());
                this.service.updateUser(uiUser.getUserInfo());
                this.security.updateUser(uiUser);
                this.userDialog.hide();
            }
            catch (Throwable th) {
                this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"UpdateUser.UnableToUpdateUser", (String[])new String[]{th.getLocalizedMessage()}));
                this.messageBox.open();
            }
        }
    }

    public void removeUser() throws Exception {
        XulConfirmBox confirmBox = (XulConfirmBox)this.document.createElement("confirmbox");
        confirmBox.setTitle(BaseMessages.getString(PKG, (String)"ConfirmDialog.Title", (String[])new String[0]));
        confirmBox.setMessage(BaseMessages.getString(PKG, (String)"RemoveUserConfirmDialog.Message", (String[])new String[0]));
        confirmBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
        confirmBox.setCancelLabel(BaseMessages.getString(PKG, (String)"Dialog.Cancel", (String[])new String[0]));
        confirmBox.addDialogCallback((XulDialogCallback)new XulDialogCallback<Object>(){

            public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                if (returnCode == XulDialogCallback.Status.ACCEPT && SecurityController.this.service != null) {
                    if (SecurityController.this.security != null && SecurityController.this.security.getSelectedUser() != null) {
                        try {
                            SecurityController.this.service.delUser(SecurityController.this.security.getSelectedUser().getName());
                            SecurityController.this.security.removeUser(SecurityController.this.security.getSelectedUser().getName());
                        }
                        catch (Throwable th) {
                            SecurityController.this.messageBox.setTitle(BaseMessages.getString((Class)PKG, (String)"Dialog.Error", (String[])new String[0]));
                            SecurityController.this.messageBox.setAcceptLabel(BaseMessages.getString((Class)PKG, (String)"Dialog.Ok", (String[])new String[0]));
                            SecurityController.this.messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)"RemoveUser.UnableToRemoveUser", (String[])new String[]{th.getLocalizedMessage()}));
                            SecurityController.this.messageBox.open();
                        }
                    } else {
                        SecurityController.this.messageBox.setTitle(BaseMessages.getString((Class)PKG, (String)"Dialog.Error", (String[])new String[0]));
                        SecurityController.this.messageBox.setAcceptLabel(BaseMessages.getString((Class)PKG, (String)"Dialog.Ok", (String[])new String[0]));
                        SecurityController.this.messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)"RemoveUser.NoUserSelected", (String[])new String[0]));
                        SecurityController.this.messageBox.open();
                    }
                }
            }

            public void onError(XulComponent sender, Throwable t) {
                SecurityController.this.messageBox.setTitle(BaseMessages.getString((Class)PKG, (String)"Dialog.Error", (String[])new String[0]));
                SecurityController.this.messageBox.setAcceptLabel(BaseMessages.getString((Class)PKG, (String)"Dialog.Ok", (String[])new String[0]));
                SecurityController.this.messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)"RemoveUser.UnableToRemoveUser", (String[])new String[]{t.getLocalizedMessage()}));
                SecurityController.this.messageBox.open();
            }
        });
        confirmBox.open();
    }

    public void changeToUserDeck() {
        this.security.setSelectedDeck(ObjectRecipient.Type.USER);
    }

    public void saveUser() throws Exception {
        if (this.securityUser.getMode().equals((Object)UISecurity.Mode.ADD)) {
            this.addUser();
        } else {
            this.updateUser();
        }
    }

    public void setEnableButtons(int selectedIndex) {
        boolean enableAdd = true;
        boolean enableEdit = false;
        boolean enableRemove = false;
        if (this.managed) {
            if (selectedIndex >= 0) {
                enableRemove = true;
                enableEdit = true;
            } else {
                enableRemove = false;
                enableEdit = false;
            }
        } else {
            enableAdd = false;
        }
        this.enableButtons(enableAdd, enableEdit, enableRemove);
    }

    protected void enableButtons(boolean enableNew, boolean enableEdit, boolean enableRemove) {
        this.userAddButton.setDisabled(!enableNew);
        this.userEditButton.setDisabled(!enableEdit);
        this.userRemoveButton.setDisabled(!enableRemove);
    }

    protected void showButtons(boolean showNew, boolean showEdit, boolean showRemove) {
        this.userAddButton.setVisible(showNew);
        this.userEditButton.setVisible(showEdit);
        this.userRemoveButton.setVisible(showRemove);
    }

    public void tabClicked() {
        this.lazyInit();
    }
}

