/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.delegates;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonBrowser;
import org.pentaho.di.ui.spoon.TabItemInterface;
import org.pentaho.di.ui.spoon.TabMapEntry;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.di.ui.spoon.job.JobGraph;
import org.pentaho.di.ui.spoon.trans.TransGraph;
import org.pentaho.ui.util.Launch;
import org.pentaho.xul.swt.tab.TabItem;
import org.pentaho.xul.swt.tab.TabSet;

public class SpoonTabsDelegate
extends SpoonDelegate {
    private static Class<?> PKG = Spoon.class;
    private List<TabMapEntry> tabMap = new ArrayList<TabMapEntry>();

    public SpoonTabsDelegate(Spoon spoon) {
        super(spoon);
    }

    public boolean tabClose(TabItem item) throws KettleException {
        ArrayList<TabMapEntry> collection = new ArrayList<TabMapEntry>();
        collection.addAll(this.tabMap);
        boolean close = true;
        for (TabMapEntry entry : collection) {
            Composite comp;
            if (!item.equals(entry.getTabItem())) continue;
            TabItemInterface itemInterface = entry.getObject();
            if (!itemInterface.canBeClosed()) {
                int reply = itemInterface.showChangedWarning();
                close = reply == 64 ? itemInterface.applyChanges() : reply != 256;
            }
            if (!close) break;
            if (entry.getObject() instanceof TransGraph) {
                TransMeta transMeta = (TransMeta)entry.getObject().getManagedObject();
                this.spoon.delegates.trans.closeTransformation(transMeta);
                this.spoon.refreshTree();
                break;
            }
            if (entry.getObject() instanceof JobGraph) {
                JobMeta jobMeta = (JobMeta)entry.getObject().getManagedObject();
                this.spoon.delegates.jobs.closeJob(jobMeta);
                this.spoon.refreshTree();
                break;
            }
            if (entry.getObject() instanceof SpoonBrowser) {
                this.spoon.closeSpoonBrowser();
                this.spoon.refreshTree();
                break;
            }
            if (!(entry.getObject() instanceof Composite) || (comp = (Composite)entry.getObject()) == null || comp.isDisposed()) break;
            comp.dispose();
            break;
        }
        return close;
    }

    public void removeTab(TabMapEntry tabMapEntry) {
        for (TabMapEntry entry : this.getTabs()) {
            if (!tabMapEntry.equals(entry)) continue;
            this.tabMap.remove(tabMapEntry);
        }
        if (!tabMapEntry.getTabItem().isDisposed()) {
            tabMapEntry.getTabItem().dispose();
        }
    }

    public List<TabMapEntry> getTabs() {
        ArrayList<TabMapEntry> list = new ArrayList<TabMapEntry>();
        list.addAll(this.tabMap);
        return list;
    }

    public TabMapEntry getTab(TabItem tabItem) {
        for (TabMapEntry tabMapEntry : this.tabMap) {
            if (!tabMapEntry.getTabItem().equals(tabItem)) continue;
            return tabMapEntry;
        }
        return null;
    }

    public EngineMetaInterface getActiveMeta() {
        TabSet tabfolder = this.spoon.tabfolder;
        if (tabfolder == null) {
            return null;
        }
        TabItem tabItem = tabfolder.getSelected();
        if (tabItem == null) {
            return null;
        }
        TabMapEntry mapEntry = this.getTab(tabfolder.getSelected());
        EngineMetaInterface meta = null;
        if (mapEntry != null) {
            if (mapEntry.getObject() instanceof TransGraph) {
                meta = mapEntry.getObject().getMeta();
            }
            if (mapEntry.getObject() instanceof JobGraph) {
                meta = mapEntry.getObject().getMeta();
            }
        }
        return meta;
    }

    public String makeSlaveTabName(SlaveServer slaveServer) {
        return "Slave server: " + slaveServer.getName();
    }

    public boolean addSpoonBrowser(String name, String urlString) {
        return this.addSpoonBrowser(name, urlString, true, null);
    }

    public boolean addSpoonBrowser(String name, String urlString, LocationListener listener) {
        boolean ok = this.addSpoonBrowser(name, urlString, true, listener);
        return ok;
    }

    public boolean addSpoonBrowser(String name, String urlString, boolean isURL, LocationListener listener) {
        TabSet tabfolder = this.spoon.tabfolder;
        try {
            TabMapEntry tabMapEntry = this.findTabMapEntry(name, TabMapEntry.ObjectType.BROWSER);
            if (tabMapEntry == null) {
                CTabFolder cTabFolder = tabfolder.getSwtTabset();
                final SpoonBrowser browser = new SpoonBrowser((Composite)cTabFolder, this.spoon, urlString, isURL, true, listener);
                browser.getBrowser().addOpenWindowListener(new OpenWindowListener(){

                    public void open(WindowEvent event) {
                        if (event.required) {
                            event.browser = browser.getBrowser();
                        }
                    }
                });
                TabItem tabItem = new TabItem(tabfolder, name, name);
                tabItem.setImage(GUIResource.getInstance().getImageLogoSmall());
                tabItem.setControl((Control)browser.getComposite());
                tabMapEntry = new TabMapEntry(tabItem, isURL ? urlString : null, name, null, null, browser, TabMapEntry.ObjectType.BROWSER);
                this.tabMap.add(tabMapEntry);
            }
            int idx = tabfolder.indexOf(tabMapEntry.getTabItem());
            tabfolder.setSelected(idx);
            return true;
        }
        catch (Throwable e) {
            boolean ok = false;
            if (isURL) {
                Launch.Status status = Launch.openURL((String)urlString);
                ok = status.equals((Object)Launch.Status.Success);
            }
            if (!ok) {
                this.log.logError("Unable to open browser tab", e);
                return false;
            }
            return true;
        }
    }

    public TabMapEntry findTabMapEntry(String tabItemText, TabMapEntry.ObjectType objectType) {
        for (TabMapEntry entry : this.tabMap) {
            if (entry.getTabItem().isDisposed() || objectType != entry.getObjectType() || !entry.getTabItem().getText().equalsIgnoreCase(tabItemText)) continue;
            return entry;
        }
        return null;
    }

    public TabMapEntry findTabMapEntry(Object managedObject) {
        for (TabMapEntry entry : this.tabMap) {
            Object entryManagedObj;
            if (entry.getTabItem().isDisposed() || (entryManagedObj = entry.getObject().getManagedObject()) == null || managedObject == null || !entryManagedObj.getClass().equals(managedObject.getClass()) || !entryManagedObj.equals(managedObject)) continue;
            return entry;
        }
        return null;
    }

    public TabMapEntry findTabForTransformation(TransMeta trans) throws KettleFileException {
        FileObject transFile = null;
        for (TabMapEntry entry : this.tabMap) {
            EngineMetaInterface meta;
            if (entry == null || entry.getTabItem().isDisposed()) continue;
            if (trans.getFilename() != null && entry.getFilename() != null) {
                FileObject entryFile = KettleVFS.getFileObject((String)entry.getFilename());
                if (transFile == null) {
                    transFile = KettleVFS.getFileObject((String)trans.getFilename());
                }
                if (!entryFile.equals(transFile)) continue;
                return entry;
            }
            if (trans.getObjectId() == null || entry.getObject() == null || (meta = entry.getObject().getMeta()) == null || !trans.getObjectId().equals(meta.getObjectId())) continue;
            return entry;
        }
        return null;
    }

    public void renameTabs() {
        ArrayList<TabMapEntry> list = new ArrayList<TabMapEntry>(this.tabMap);
        for (TabMapEntry entry : list) {
            if (entry.getTabItem().isDisposed()) {
                this.tabMap.remove(entry.getObjectName());
                continue;
            }
            Object managedObject = entry.getObject().getManagedObject();
            if (managedObject == null) continue;
            if (entry.getObject() instanceof TransGraph) {
                TransMeta transMeta = (TransMeta)managedObject;
                String tabText = this.makeTabName((EngineMetaInterface)transMeta, entry.isShowingLocation());
                entry.getTabItem().setText(tabText);
                String toolTipText = BaseMessages.getString(PKG, (String)"Spoon.TabTrans.Tooltip", (String[])new String[]{tabText});
                if (Const.isWindows() && !Const.isEmpty((String)transMeta.getFilename())) {
                    toolTipText = toolTipText + Const.CR + Const.CR + transMeta.getFilename();
                }
                entry.getTabItem().setToolTipText(toolTipText);
                continue;
            }
            if (!(entry.getObject() instanceof JobGraph)) continue;
            JobMeta jobMeta = (JobMeta)managedObject;
            entry.getTabItem().setText(this.makeTabName((EngineMetaInterface)jobMeta, entry.isShowingLocation()));
            String toolTipText = BaseMessages.getString(PKG, (String)"Spoon.TabJob.Tooltip", (String[])new String[]{this.makeTabName((EngineMetaInterface)jobMeta, entry.isShowingLocation())});
            if (Const.isWindows() && !Const.isEmpty((String)jobMeta.getFilename())) {
                toolTipText = toolTipText + Const.CR + Const.CR + jobMeta.getFilename();
            }
            entry.getTabItem().setToolTipText(toolTipText);
        }
        this.spoon.setShellText();
    }

    public void addTab(TabMapEntry entry) {
        this.tabMap.add(entry);
    }

    public String makeTabName(EngineMetaInterface transMeta, boolean showLocation) {
        ObjectRevision version;
        if (Const.isEmpty((String)transMeta.getName()) && Const.isEmpty((String)transMeta.getFilename())) {
            return Spoon.STRING_TRANS_NO_NAME;
        }
        if (Const.isEmpty((String)transMeta.getName()) || this.spoon.delegates.trans.isDefaultTransformationName(transMeta.getName())) {
            transMeta.nameFromFilename();
        }
        String name = "";
        if (showLocation) {
            name = !Const.isEmpty((String)transMeta.getFilename()) ? name + transMeta.getFilename() + " : " : name + transMeta.getRepositoryDirectory().getPath() + " : ";
        }
        name = name + transMeta.getName();
        if (showLocation && (version = transMeta.getObjectRevision()) != null) {
            name = name + " : r" + version.getName();
        }
        return name;
    }

    public void tabSelected(TabItem item) {
        ArrayList<TabMapEntry> collection = new ArrayList<TabMapEntry>(this.tabMap);
        for (TabMapEntry entry : collection) {
            boolean isTrans = entry.getObject() instanceof TransGraph;
            if (!item.equals(entry.getTabItem())) continue;
            if (isTrans || entry.getObject() instanceof JobGraph) {
                EngineMetaInterface meta = entry.getObject().getMeta();
                if (meta != null) {
                    meta.setInternalKettleVariables();
                }
                if (this.spoon.getCoreObjectsState() != 3) {
                    this.spoon.refreshCoreObjects();
                }
            }
            if (entry.getObject() instanceof JobGraph) {
                ((JobGraph)entry.getObject()).setFocus();
                break;
            }
            if (!(entry.getObject() instanceof TransGraph)) break;
            ((TransGraph)entry.getObject()).setFocus();
            break;
        }
        this.spoon.refreshTree();
        this.spoon.setShellText();
    }
}

