/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.job;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.di.core.gui.GCInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.logging.MetricsPainter;
import org.pentaho.di.core.metrics.MetricsDuration;
import org.pentaho.di.core.metrics.MetricsUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.SWTGC;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.di.ui.spoon.job.JobGraph;

public class JobMetricsDelegate
extends SpoonDelegate {
    private static Class<?> PKG = Spoon.class;
    private JobGraph jobGraph;
    private CTabItem jobMetricsTab;
    private Canvas canvas;
    private Image image;
    private ScrolledComposite sMetricsComposite;
    private Composite metricsComposite;
    private boolean emptyGraph;
    private List<MetricsPainter.MetricsDrawArea> drawAreas;
    private long lastRefreshTime = 0L;

    public JobMetricsDelegate(Spoon spoon, JobGraph jobGraph) {
        super(spoon);
        this.jobGraph = jobGraph;
    }

    public void addJobMetrics() {
        if (this.jobGraph.extraViewComposite == null || this.jobGraph.extraViewComposite.isDisposed()) {
            this.jobGraph.addExtraView();
        } else if (this.jobMetricsTab != null && !this.jobMetricsTab.isDisposed()) {
            this.jobGraph.extraViewTabFolder.setSelection(this.jobMetricsTab);
            return;
        }
        this.jobMetricsTab = new CTabItem(this.jobGraph.extraViewTabFolder, 0);
        this.jobMetricsTab.setImage(GUIResource.getInstance().getImageGantt());
        this.jobMetricsTab.setText(BaseMessages.getString(PKG, (String)"Spoon.JobGraph.MetricsTab.Name", (String[])new String[0]));
        this.sMetricsComposite = new ScrolledComposite((Composite)this.jobGraph.extraViewTabFolder, 768);
        this.sMetricsComposite.setLayout((Layout)new FillLayout());
        this.metricsComposite = new Composite((Composite)this.sMetricsComposite, 0);
        this.metricsComposite.setBackground(GUIResource.getInstance().getColorBackground());
        this.metricsComposite.setLayout((Layout)new FormLayout());
        this.spoon.props.setLook((Control)this.metricsComposite);
        this.setupContent();
        this.sMetricsComposite.setContent((Control)this.metricsComposite);
        this.sMetricsComposite.setExpandHorizontal(true);
        this.sMetricsComposite.setExpandVertical(true);
        this.sMetricsComposite.setMinWidth(800);
        this.sMetricsComposite.setMinHeight(500);
        this.jobMetricsTab.setControl((Control)this.sMetricsComposite);
        this.jobGraph.extraViewTabFolder.setSelection(this.jobMetricsTab);
        this.jobGraph.extraViewTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                JobMetricsDelegate.this.layoutMetricsComposite();
                JobMetricsDelegate.this.updateGraph();
            }
        });
    }

    public void setupContent() {
        if (this.metricsComposite.isDisposed()) {
            return;
        }
        for (Control control : this.metricsComposite.getChildren()) {
            if (control.isDisposed()) continue;
            control.dispose();
        }
        this.emptyGraph = false;
        this.canvas = new Canvas(this.metricsComposite, 0);
        this.spoon.props.setLook((Control)this.canvas);
        FormData fdCanvas = new FormData();
        fdCanvas.left = new FormAttachment(0, 0);
        fdCanvas.right = new FormAttachment(100, 0);
        fdCanvas.top = new FormAttachment(0, 0);
        fdCanvas.bottom = new FormAttachment(100, 0);
        this.canvas.setLayoutData((Object)fdCanvas);
        this.metricsComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                JobMetricsDelegate.this.updateGraph();
            }
        });
        this.metricsComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (JobMetricsDelegate.this.image != null) {
                    JobMetricsDelegate.this.image.dispose();
                }
            }
        });
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (((JobMetricsDelegate)JobMetricsDelegate.this).jobGraph.job != null && ((JobMetricsDelegate)JobMetricsDelegate.this).jobGraph.job.isFinished()) {
                    JobMetricsDelegate.this.refreshImage(event.gc);
                    if (JobMetricsDelegate.this.image != null && !JobMetricsDelegate.this.image.isDisposed()) {
                        event.gc.drawImage(JobMetricsDelegate.this.image, 0, 0);
                    }
                } else {
                    Rectangle bounds = JobMetricsDelegate.this.canvas.getBounds();
                    if (bounds.width <= 0 || bounds.height <= 0) {
                        return;
                    }
                    event.gc.setForeground(GUIResource.getInstance().getColorWhite());
                    event.gc.setBackground(GUIResource.getInstance().getColorWhite());
                    event.gc.fillRectangle(new Rectangle(0, 0, bounds.width, bounds.height));
                    event.gc.setForeground(GUIResource.getInstance().getColorBlack());
                    String metricsMessage = BaseMessages.getString((Class)PKG, (String)"JobMetricsDelegate.JobIsNotRunning.Message", (String[])new String[0]);
                    org.eclipse.swt.graphics.Point extent = event.gc.textExtent(metricsMessage);
                    event.gc.drawText(metricsMessage, (bounds.width - extent.x) / 2, (bounds.height - extent.y) / 2);
                }
            }
        });
        final Timer timer = new Timer("JobMetricsDelegate Timer");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                JobMetricsDelegate.this.updateGraph();
            }
        }, 0L, 5000L);
        this.jobMetricsTab.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                timer.cancel();
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (JobMetricsDelegate.this.drawAreas == null) {
                    return;
                }
                for (int i = JobMetricsDelegate.this.drawAreas.size() - 1; i >= 0; --i) {
                    MetricsDuration duration;
                    MetricsPainter.MetricsDrawArea drawArea = (MetricsPainter.MetricsDrawArea)JobMetricsDelegate.this.drawAreas.get(i);
                    if (!drawArea.getArea().contains(event.x, event.y) || (duration = drawArea.getDuration()) == null) continue;
                    System.out.println(duration.toString());
                    LoggingObjectInterface loggingObject = LoggingRegistry.getInstance().getLoggingObject(duration.getLogChannelId());
                    if (loggingObject == null) {
                        return;
                    }
                    System.out.println(loggingObject.getObjectType() + " : " + loggingObject.getObjectName());
                }
            }
        });
        this.canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                JobMetricsDelegate.this.lastRefreshTime = 0L;
            }
        });
    }

    public void showMetricsView() {
        if (this.jobMetricsTab == null || this.jobMetricsTab.isDisposed()) {
            this.addJobMetrics();
        } else {
            this.jobMetricsTab.dispose();
            this.jobGraph.checkEmptyExtraView();
        }
    }

    public void updateGraph() {
        this.jobGraph.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (JobMetricsDelegate.this.metricsComposite != null && !JobMetricsDelegate.this.metricsComposite.isDisposed() && JobMetricsDelegate.this.canvas != null && !JobMetricsDelegate.this.canvas.isDisposed() && JobMetricsDelegate.this.jobMetricsTab != null && !JobMetricsDelegate.this.jobMetricsTab.isDisposed() && JobMetricsDelegate.this.jobMetricsTab.isShowing()) {
                    JobMetricsDelegate.this.canvas.redraw();
                }
            }
        });
    }

    public void resetLastRefreshTime() {
        this.lastRefreshTime = 0L;
    }

    private void refreshImage(GC canvasGc) {
        Rectangle bounds = this.canvas.getBounds();
        if (bounds.width <= 0 || bounds.height <= 0) {
            return;
        }
        if (this.jobGraph.job == null) {
            this.image = null;
            return;
        }
        if (this.image != null && System.currentTimeMillis() - this.lastRefreshTime < 5000L) {
            return;
        }
        this.lastRefreshTime = System.currentTimeMillis();
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        List durations = MetricsUtil.getAllDurations((String)this.jobGraph.job.getLogChannelId());
        Collections.sort(durations, new Comparator<MetricsDuration>(){

            @Override
            public int compare(MetricsDuration o1, MetricsDuration o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        org.eclipse.swt.graphics.Point textExtent = canvasGc.textExtent("AagKkiw");
        int barHeight = textExtent.y + 8;
        bounds.height = Math.max(durations.size() * barHeight, bounds.height);
        this.canvas.setSize(bounds.width, bounds.height);
        SWTGC gc = new SWTGC((Device)Display.getCurrent(), new Point(bounds.width, bounds.height), PropsUI.getInstance().getIconSize());
        MetricsPainter painter = new MetricsPainter((GCInterface)gc, barHeight);
        this.drawAreas = painter.paint(durations);
        this.image = (Image)gc.getImage();
        this.sMetricsComposite.layout(true, true);
        gc.dispose();
        this.canvas.redraw();
    }

    public CTabItem getJobMetricsTab() {
        return this.jobMetricsTab;
    }

    public boolean isEmptyGraph() {
        return this.emptyGraph;
    }

    public void layoutMetricsComposite() {
        if (!this.metricsComposite.isDisposed()) {
            this.metricsComposite.layout(true, true);
        }
    }

    public void refresh() {
        this.canvas.update();
    }
}

