/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.trans;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.i18n.GlobalMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransAdapter;
import org.pentaho.di.trans.TransListener;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.di.ui.spoon.trans.TransGraph;
import org.pentaho.di.ui.xul.KettleXulLoader;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.containers.XulToolbar;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.tags.SwtRadio;

public class TransPreviewDelegate
extends SpoonDelegate
implements XulEventHandler {
    private static Class<?> PKG = Spoon.class;
    private static final String XUL_FILE_TRANS_PREVIEW_TOOLBAR = "ui/trans-preview-toolbar.xul";
    private TransGraph transGraph;
    private CTabItem transPreviewTab;
    private XulToolbar toolbar;
    private Composite transPreviewComposite;
    protected Map<StepMeta, RowMetaInterface> previewMetaMap;
    protected Map<StepMeta, List<Object[]>> previewDataMap;
    protected Map<StepMeta, StringBuffer> previewLogMap;
    private Composite previewComposite;
    private Text logText;
    private TableView tableView;
    private PreviewMode previewMode;
    private StepMeta selectedStep;
    protected StepMeta lastSelectedStep;
    private SwtRadio firstRadio;
    private SwtRadio lastRadio;
    private SwtRadio offRadio;

    public TransPreviewDelegate(Spoon spoon, TransGraph transGraph) {
        super(spoon);
        this.transGraph = transGraph;
        this.previewMetaMap = new HashMap<StepMeta, RowMetaInterface>();
        this.previewDataMap = new HashMap<StepMeta, List<Object[]>>();
        this.previewLogMap = new HashMap<StepMeta, StringBuffer>();
        this.previewMode = PreviewMode.FIRST;
    }

    public void showPreviewView() {
        if (this.transPreviewTab == null || this.transPreviewTab.isDisposed()) {
            this.addTransPreview();
        } else {
            this.transPreviewTab.dispose();
            this.transGraph.checkEmptyExtraView();
        }
    }

    public void addTransPreview() {
        if (this.transGraph.extraViewComposite == null || this.transGraph.extraViewComposite.isDisposed()) {
            this.transGraph.addExtraView();
        } else if (this.transPreviewTab != null && !this.transPreviewTab.isDisposed()) {
            this.transGraph.extraViewTabFolder.setSelection(this.transPreviewTab);
            return;
        }
        this.transPreviewTab = new CTabItem(this.transGraph.extraViewTabFolder, 0);
        this.transPreviewTab.setImage(GUIResource.getInstance().getImageTable());
        this.transPreviewTab.setText(BaseMessages.getString(PKG, (String)"Spoon.TransGraph.PreviewTab.Name", (String[])new String[0]));
        this.transPreviewComposite = new Composite((Composite)this.transGraph.extraViewTabFolder, 0);
        this.transPreviewComposite.setLayout((Layout)new FormLayout());
        this.addToolBar();
        Control toolbarControl = (Control)this.toolbar.getManagedObject();
        toolbarControl.setLayoutData((Object)new FormData());
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        toolbarControl.setLayoutData((Object)fd);
        toolbarControl.setParent(this.transPreviewComposite);
        this.previewComposite = new Composite(this.transPreviewComposite, 0);
        this.previewComposite.setLayout((Layout)new FillLayout());
        FormData fdPreview = new FormData();
        fdPreview.left = new FormAttachment(0, 0);
        fdPreview.right = new FormAttachment(100, 0);
        fdPreview.top = new FormAttachment((Control)this.toolbar.getManagedObject(), 0);
        fdPreview.bottom = new FormAttachment(100, 0);
        this.previewComposite.setLayoutData((Object)fdPreview);
        this.transPreviewTab.setControl((Control)this.transPreviewComposite);
        this.transGraph.extraViewTabFolder.setSelection(this.transPreviewTab);
        this.transGraph.extraViewTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransPreviewDelegate.this.refreshView();
            }
        });
    }

    private void addToolBar() {
        try {
            KettleXulLoader loader = new KettleXulLoader();
            loader.setSettingsManager(XulSpoonSettingsManager.getInstance());
            ResourceBundle bundle = GlobalMessages.getBundle((String)"org/pentaho/di/ui/spoon/messages/messages");
            XulDomContainer xulDomContainer = loader.loadXul(XUL_FILE_TRANS_PREVIEW_TOOLBAR, bundle);
            xulDomContainer.addEventHandler((XulEventHandler)this);
            this.toolbar = (XulToolbar)xulDomContainer.getDocumentRoot().getElementById("nav-toolbar");
            ToolBar swtToolBar = (ToolBar)this.toolbar.getManagedObject();
            swtToolBar.layout(true, true);
            swtToolBar.pack();
            this.firstRadio = (SwtRadio)xulDomContainer.getDocumentRoot().getElementById("preview-first");
            this.lastRadio = (SwtRadio)xulDomContainer.getDocumentRoot().getElementById("preview-last");
            this.offRadio = (SwtRadio)xulDomContainer.getDocumentRoot().getElementById("preview-off");
            PropsUI.getInstance().setLook((Control)this.firstRadio.getManagedObject());
            PropsUI.getInstance().setLook((Control)this.lastRadio.getManagedObject());
            PropsUI.getInstance().setLook((Control)this.offRadio.getManagedObject());
        }
        catch (Throwable t) {
            this.log.logError(this.toString(), new Object[]{Const.getStackTracker((Throwable)t)});
            new ErrorDialog(this.transPreviewComposite.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Message", (String[])new String[]{XUL_FILE_TRANS_PREVIEW_TOOLBAR}), new Exception(t));
        }
    }

    public synchronized void refreshView() {
        List steps;
        if (this.transGraph != null && this.transGraph.extraViewTabFolder != null && this.transGraph.extraViewTabFolder.getSelection() != this.transPreviewTab) {
            return;
        }
        if (this.previewComposite == null || this.previewComposite.isDisposed()) {
            return;
        }
        StepMeta stepMeta = this.selectedStep;
        if (stepMeta == null) {
            return;
        }
        this.lastSelectedStep = this.selectedStep;
        boolean errorStep = false;
        if (this.transGraph.trans != null && (steps = this.transGraph.trans.findBaseSteps(stepMeta.getName())) != null && steps.size() > 0) {
            errorStep = ((StepInterface)steps.get(0)).getErrors() > 0L;
        }
        StringBuffer logText = this.previewLogMap.get(stepMeta);
        if (errorStep && logText != null && logText.length() > 0) {
            this.showLogText(stepMeta, logText.toString());
            return;
        }
        RowMetaInterface rowMeta = this.previewMetaMap.get(stepMeta);
        if (rowMeta != null) {
            List<Object[]> rowData = this.previewDataMap.get(stepMeta);
            try {
                this.showPreviewGrid(this.transGraph.getManagedObject(), stepMeta, rowMeta, rowData);
            }
            catch (Exception e) {
                e.printStackTrace();
                logText.append(Const.getStackTracker((Throwable)e));
                this.showLogText(stepMeta, logText.toString());
            }
        }
    }

    protected void showPreviewGrid(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface rowMeta, List<Object[]> rowsData) throws KettleException {
        this.clearPreviewComposite();
        ColumnInfo[] columnInfo = new ColumnInfo[rowMeta.size()];
        for (int i = 0; i < columnInfo.length; ++i) {
            ValueMetaInterface valueMeta = rowMeta.getValueMeta(i);
            columnInfo[i] = new ColumnInfo(valueMeta.getName(), 1, false, true);
            columnInfo[i].setValueMeta(valueMeta);
        }
        this.tableView = new TableView((VariableSpace)transMeta, this.previewComposite, 0, columnInfo, rowsData.size(), null, PropsUI.getInstance());
        for (int rowNr = 0; rowNr < rowsData.size(); ++rowNr) {
            Object[] rowData = rowsData.get(rowNr);
            TableItem item = rowNr < this.tableView.table.getItemCount() ? this.tableView.table.getItem(rowNr) : new TableItem(this.tableView.table, 0);
            for (int colNr = 0; colNr < rowMeta.size(); ++colNr) {
                String string;
                try {
                    string = rowMeta.getString(rowData, colNr);
                }
                catch (Exception e) {
                    string = "Conversion error: " + e.getMessage();
                }
                if (string == null) {
                    item.setText(colNr + 1, "<null>");
                    item.setForeground(colNr + 1, GUIResource.getInstance().getColorBlue());
                    continue;
                }
                item.setText(colNr + 1, string);
            }
        }
        this.tableView.setRowNums();
        this.tableView.setShowingConversionErrorsInline(true);
        this.tableView.optWidth(true);
        this.previewComposite.layout(true, true);
    }

    protected void showLogText(StepMeta stepMeta, String loggingText) {
        this.clearPreviewComposite();
        this.logText = new Text(this.previewComposite, 770);
        this.logText.setText(loggingText);
        this.previewComposite.layout(true, true);
    }

    private void clearPreviewComposite() {
        for (Control control : this.previewComposite.getChildren()) {
            control.dispose();
        }
    }

    public CTabItem getTransGridTab() {
        return this.transPreviewTab;
    }

    public Object getData() {
        return null;
    }

    public String getName() {
        return "transpreview";
    }

    public XulDomContainer getXulDomContainer() {
        return null;
    }

    public void setData(Object data) {
    }

    public void setName(String name) {
    }

    public void setXulDomContainer(XulDomContainer xulDomContainer) {
    }

    public boolean isActive() {
        return this.previewMode != PreviewMode.OFF;
    }

    public void setPreviewMode(PreviewMode previewMode) {
        this.previewMode = previewMode;
    }

    public void capturePreviewData(Trans trans, List<StepMeta> stepMetas) {
        StringBuffer loggingText = new StringBuffer();
        this.previewLogMap.clear();
        this.previewMetaMap.clear();
        this.previewDataMap.clear();
        try {
            TransMeta transMeta = trans.getTransMeta();
            block5: for (StepMeta stepMeta : stepMetas) {
                RowMetaInterface rowMeta = transMeta.getStepFields(stepMeta).clone();
                this.previewMetaMap.put(stepMeta, rowMeta);
                final AbstractList rowsData = this.previewMode == PreviewMode.LAST ? new LinkedList() : new ArrayList();
                this.previewDataMap.put(stepMeta, rowsData);
                this.previewLogMap.put(stepMeta, loggingText);
                StepInterface step = trans.findRunThread(stepMeta.getName());
                if (step == null) continue;
                switch (this.previewMode) {
                    case LAST: {
                        step.addRowListener((RowListener)new RowAdapter(){

                            public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                                try {
                                    rowsData.add(rowMeta.cloneRow(row));
                                    if (rowsData.size() > PropsUI.getInstance().getDefaultPreviewSize()) {
                                        rowsData.remove(0);
                                    }
                                }
                                catch (Exception e) {
                                    throw new KettleStepException("Unable to clone row for metadata : " + rowMeta, (Throwable)e);
                                }
                            }
                        });
                        continue block5;
                    }
                }
                step.addRowListener((RowListener)new RowAdapter(){

                    public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                        if (rowsData.size() < PropsUI.getInstance().getDefaultPreviewSize()) {
                            try {
                                rowsData.add(rowMeta.cloneRow(row));
                            }
                            catch (Exception e) {
                                throw new KettleStepException("Unable to clone row for metadata : " + rowMeta, (Throwable)e);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            loggingText.append(Const.getStackTracker((Throwable)e));
        }
        trans.addTransListener((TransListener)new TransAdapter(){

            public void transFinished(Trans trans) throws KettleException {
                if (trans.getErrors() != 0) {
                    for (StepMetaDataCombi combi : trans.getSteps()) {
                        if (combi.copy != 0) continue;
                        StringBuffer logBuffer = KettleLogStore.getAppender().getBuffer(combi.step.getLogChannel().getLogChannelId(), false);
                        TransPreviewDelegate.this.previewLogMap.put(combi.stepMeta, logBuffer);
                    }
                }
            }
        });
    }

    public void addPreviewData(StepMeta stepMeta, RowMetaInterface rowMeta, List<Object[]> rowsData, StringBuffer buffer) {
        this.previewLogMap.put(stepMeta, buffer);
        this.previewMetaMap.put(stepMeta, rowMeta);
        this.previewDataMap.put(stepMeta, rowsData);
    }

    public StepMeta getSelectedStep() {
        return this.selectedStep;
    }

    public void setSelectedStep(StepMeta selectedStep) {
        this.selectedStep = selectedStep;
    }

    public PreviewMode getPreviewMode() {
        return this.previewMode;
    }

    public void first() {
        this.previewMode = PreviewMode.FIRST;
        this.firstRadio.setSelected(true);
        this.lastRadio.setSelected(false);
        this.offRadio.setSelected(false);
    }

    public void last() {
        this.previewMode = PreviewMode.LAST;
        this.firstRadio.setSelected(false);
        this.lastRadio.setSelected(true);
        this.offRadio.setSelected(false);
    }

    public void off() {
        this.previewMode = PreviewMode.OFF;
        this.firstRadio.setSelected(false);
        this.lastRadio.setSelected(false);
        this.offRadio.setSelected(true);
    }

    public static enum PreviewMode {
        FIRST,
        LAST,
        OFF;

    }
}

