/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.ChannelLogTable;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableField;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.MetricsLogTable;
import org.pentaho.di.core.logging.PerformanceLogTable;
import org.pentaho.di.core.logging.StepLogTable;
import org.pentaho.di.core.logging.TransLogTable;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.TransDependency;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupMeta;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.FieldDisabledListener;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.repository.dialog.SelectDirectoryDialog;
import org.pentaho.di.ui.trans.dialog.TransDialogPluginInterface;
import org.pentaho.di.ui.trans.dialog.TransDialogPluginType;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class TransDialog
extends Dialog {
    public static final int LOG_INDEX_TRANS = 0;
    public static final int LOG_INDEX_STEP = 1;
    public static final int LOG_INDEX_PERFORMANCE = 2;
    public static final int LOG_INDEX_CHANNEL = 3;
    public static final int LOG_INDEX_METRICS = 4;
    private static Class<?> PKG = TransDialog.class;
    private CTabFolder wTabFolder;
    private FormData fdTabFolder;
    private CTabItem wTransTab;
    private CTabItem wParamTab;
    private CTabItem wLogTab;
    private CTabItem wDateTab;
    private CTabItem wDepTab;
    private CTabItem wMiscTab;
    private CTabItem wMonitorTab;
    private Text wTransname;
    private Text wTransFilename;
    private Text wTransdescription;
    private Label wlExtendeddescription;
    private Text wExtendeddescription;
    private Label wlTransstatus;
    private CCombo wTransstatus;
    private FormData fdlTransstatus;
    private FormData fdTransstatus;
    private Text wTransversion;
    private FormData fdlExtendeddescription;
    private FormData fdExtendeddescription;
    private Text wDirectory;
    private Button wbDirectory;
    private Text wCreateUser;
    private Text wCreateDate;
    private Text wModUser;
    private Text wModDate;
    private Button wbLogconnection;
    private ComboVar wLogconnection;
    private TextVar wLogSizeLimit;
    private TextVar wLogTimeout;
    private int previousLogTableIndex = -1;
    private TableView wOptionFields;
    private TextVar wLogTable;
    private TextVar wLogSchema;
    private TextVar wLogInterval;
    private CCombo wMaxdateconnection;
    private Text wMaxdatetable;
    private Text wMaxdatefield;
    private Text wMaxdateoffset;
    private Text wMaxdatediff;
    private TableView wFields;
    private TableView wParamFields;
    private Text wSizeRowset;
    private Button wUniqueConnections;
    private Button wOK;
    private Button wGet;
    private Button wSQL;
    private Button wCancel;
    private FormData fdGet;
    private Listener lsOK;
    private Listener lsGet;
    private Listener lsSQL;
    private Listener lsCancel;
    private TransMeta transMeta;
    private Shell shell;
    private SelectionAdapter lsDef;
    private ModifyListener lsMod;
    private Repository rep;
    private PropsUI props = PropsUI.getInstance();
    private RepositoryDirectoryInterface newDirectory;
    private int middle;
    private int margin;
    private String[] connectionNames;
    private Button wShowFeedback;
    private Text wFeedbackSize;
    private TextVar wSharedObjectsFile;
    private boolean sharedObjectsFileChanged;
    private Button wManageThreads;
    private boolean directoryChangeAllowed;
    private Label wlDirectory;
    private Button wEnableStepPerfMonitor;
    private Text wStepPerfInterval;
    private CCombo wTransformationType;
    private Tabs currentTab = null;
    protected boolean changed;
    private org.eclipse.swt.widgets.List wLogTypeList;
    private Composite wLogOptionsComposite;
    private Composite wLogComp;
    private TransLogTable transLogTable;
    private PerformanceLogTable performanceLogTable;
    private ChannelLogTable channelLogTable;
    private StepLogTable stepLogTable;
    private MetricsLogTable metricsLogTable;
    private DatabaseDialog databaseDialog;
    private SelectionAdapter lsModSel;
    private TextVar wStepPerfMaxSize;
    private ArrayList<TransDialogPluginInterface> extraTabs;

    public TransDialog(Shell parent, int style, TransMeta transMeta, Repository rep, Tabs currentTab) {
        this(parent, style, transMeta, rep);
        this.currentTab = currentTab;
    }

    public TransDialog(Shell parent, int style, TransMeta transMeta, Repository rep) {
        super(parent, style);
        this.transMeta = transMeta;
        this.rep = rep;
        this.newDirectory = null;
        this.directoryChangeAllowed = true;
        this.changed = false;
        this.transLogTable = (TransLogTable)transMeta.getTransLogTable().clone();
        this.performanceLogTable = (PerformanceLogTable)transMeta.getPerformanceLogTable().clone();
        this.channelLogTable = (ChannelLogTable)transMeta.getChannelLogTable().clone();
        this.stepLogTable = (StepLogTable)transMeta.getStepLogTable().clone();
        this.metricsLogTable = (MetricsLogTable)transMeta.getMetricsLogTable().clone();
    }

    public TransMeta open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageTransGraph());
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TransDialog.this.changed = true;
            }
        };
        this.lsModSel = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransDialog.this.changed = true;
            }
        };
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"TransDialog.Shell.Title", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setSimple(false);
        this.addTransTab();
        this.addParamTab();
        this.addLogTab();
        this.addDateTab();
        this.addDepTab();
        this.addMiscTab();
        this.addMonitoringTab();
        this.extraTabs = new ArrayList();
        List transDialogPlugins = PluginRegistry.getInstance().getPlugins(TransDialogPluginType.class);
        for (PluginInterface transDialogPlugin : transDialogPlugins) {
            try {
                TransDialogPluginInterface extraTab = (TransDialogPluginInterface)PluginRegistry.getInstance().loadClass(transDialogPlugin);
                extraTab.addTab(this.transMeta, parent, this.wTabFolder);
                this.extraTabs.add(extraTab);
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error loading transformation dialog plugin with id " + transDialogPlugin.getIds()[0], e);
            }
        }
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment(0, 0);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wSQL = new Button((Composite)this.shell, 8);
        this.wSQL.setText(BaseMessages.getString(PKG, (String)"System.Button.SQL", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wSQL, this.wCancel}, 4, null);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                TransDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                TransDialog.this.get();
            }
        };
        this.lsSQL = new Listener(){

            public void handleEvent(Event e) {
                TransDialog.this.sql();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                TransDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wSQL.addListener(13, this.lsSQL);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TransDialog.this.ok();
            }
        };
        this.wTransname.addSelectionListener((SelectionListener)this.lsDef);
        this.wTransdescription.addSelectionListener((SelectionListener)this.lsDef);
        this.wTransversion.addSelectionListener((SelectionListener)this.lsDef);
        this.wMaxdatetable.addSelectionListener((SelectionListener)this.lsDef);
        this.wMaxdatefield.addSelectionListener((SelectionListener)this.lsDef);
        this.wMaxdateoffset.addSelectionListener((SelectionListener)this.lsDef);
        this.wMaxdatediff.addSelectionListener((SelectionListener)this.lsDef);
        this.wSizeRowset.addSelectionListener((SelectionListener)this.lsDef);
        this.wUniqueConnections.addSelectionListener((SelectionListener)this.lsDef);
        this.wFeedbackSize.addSelectionListener((SelectionListener)this.lsDef);
        this.wStepPerfInterval.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                TransDialog.this.cancel();
            }
        });
        if (this.currentTab != null) {
            this.setCurrentTab(this.currentTab);
        } else {
            this.wTabFolder.setSelection(0);
        }
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.changed = false;
        this.sharedObjectsFileChanged = false;
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.transMeta;
    }

    private DatabaseDialog getDatabaseDialog() {
        if (this.databaseDialog != null) {
            return this.databaseDialog;
        }
        this.databaseDialog = new DatabaseDialog(this.shell);
        return this.databaseDialog;
    }

    private void addTransTab() {
        this.wTransTab = new CTabItem(this.wTabFolder, 0);
        this.wTransTab.setText(BaseMessages.getString(PKG, (String)"TransDialog.TransTab.Label", (String[])new String[0]));
        Composite wTransComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wTransComp);
        FormLayout transLayout = new FormLayout();
        transLayout.marginWidth = 5;
        transLayout.marginHeight = 5;
        wTransComp.setLayout((Layout)transLayout);
        Label wlTransname = new Label(wTransComp, 131072);
        wlTransname.setText(BaseMessages.getString(PKG, (String)"TransDialog.Transname.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTransname);
        FormData fdlTransname = new FormData();
        fdlTransname.left = new FormAttachment(0, 0);
        fdlTransname.right = new FormAttachment(this.middle, -this.margin);
        fdlTransname.top = new FormAttachment(0, this.margin);
        wlTransname.setLayoutData((Object)fdlTransname);
        this.wTransname = new Text(wTransComp, 18436);
        this.props.setLook((Control)this.wTransname);
        this.wTransname.addModifyListener(this.lsMod);
        FormData fdTransname = new FormData();
        fdTransname.left = new FormAttachment(this.middle, 0);
        fdTransname.top = new FormAttachment(0, this.margin);
        fdTransname.right = new FormAttachment(100, 0);
        this.wTransname.setLayoutData((Object)fdTransname);
        Label wlTransFilename = new Label(wTransComp, 131072);
        wlTransFilename.setText(BaseMessages.getString(PKG, (String)"TransDialog.TransFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTransFilename);
        FormData fdlTransFilename = new FormData();
        fdlTransFilename.left = new FormAttachment(0, 0);
        fdlTransFilename.right = new FormAttachment(this.middle, -this.margin);
        fdlTransFilename.top = new FormAttachment((Control)this.wTransname, this.margin);
        wlTransFilename.setLayoutData((Object)fdlTransFilename);
        this.wTransFilename = new Text(wTransComp, 18436);
        this.props.setLook((Control)this.wTransFilename);
        this.wTransFilename.addModifyListener(this.lsMod);
        FormData fdTransFilename = new FormData();
        fdTransFilename.left = new FormAttachment(this.middle, 0);
        fdTransFilename.top = new FormAttachment((Control)this.wTransname, this.margin);
        fdTransFilename.right = new FormAttachment(100, 0);
        this.wTransFilename.setLayoutData((Object)fdTransFilename);
        this.wTransFilename.setEditable(false);
        this.wTransFilename.setBackground(GUIResource.getInstance().getColorLightGray());
        Label wlTransdescription = new Label(wTransComp, 131072);
        wlTransdescription.setText(BaseMessages.getString(PKG, (String)"TransDialog.Transdescription.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTransdescription);
        FormData fdlTransdescription = new FormData();
        fdlTransdescription.left = new FormAttachment(0, 0);
        fdlTransdescription.right = new FormAttachment(this.middle, -this.margin);
        fdlTransdescription.top = new FormAttachment((Control)this.wTransFilename, this.margin);
        wlTransdescription.setLayoutData((Object)fdlTransdescription);
        this.wTransdescription = new Text(wTransComp, 18436);
        this.props.setLook((Control)this.wTransdescription);
        this.wTransdescription.addModifyListener(this.lsMod);
        FormData fdTransdescription = new FormData();
        fdTransdescription.left = new FormAttachment(this.middle, 0);
        fdTransdescription.top = new FormAttachment((Control)this.wTransFilename, this.margin);
        fdTransdescription.right = new FormAttachment(100, 0);
        this.wTransdescription.setLayoutData((Object)fdTransdescription);
        this.wlExtendeddescription = new Label(wTransComp, 131072);
        this.wlExtendeddescription.setText(BaseMessages.getString(PKG, (String)"TransDialog.Extendeddescription.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlExtendeddescription);
        this.fdlExtendeddescription = new FormData();
        this.fdlExtendeddescription.left = new FormAttachment(0, 0);
        this.fdlExtendeddescription.top = new FormAttachment((Control)this.wTransdescription, this.margin);
        this.fdlExtendeddescription.right = new FormAttachment(this.middle, -this.margin);
        this.wlExtendeddescription.setLayoutData((Object)this.fdlExtendeddescription);
        this.wExtendeddescription = new Text(wTransComp, 19202);
        this.props.setLook((Control)this.wExtendeddescription, 1);
        this.wExtendeddescription.addModifyListener(this.lsMod);
        this.fdExtendeddescription = new FormData();
        this.fdExtendeddescription.left = new FormAttachment(this.middle, 0);
        this.fdExtendeddescription.top = new FormAttachment((Control)this.wTransdescription, this.margin);
        this.fdExtendeddescription.right = new FormAttachment(100, 0);
        this.fdExtendeddescription.bottom = new FormAttachment(50, -this.margin);
        this.wExtendeddescription.setLayoutData((Object)this.fdExtendeddescription);
        this.wlTransstatus = new Label(wTransComp, 131072);
        this.wlTransstatus.setText(BaseMessages.getString(PKG, (String)"TransDialog.Transstatus.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransstatus);
        this.fdlTransstatus = new FormData();
        this.fdlTransstatus.left = new FormAttachment(0, 0);
        this.fdlTransstatus.right = new FormAttachment(this.middle, 0);
        this.fdlTransstatus.top = new FormAttachment((Control)this.wExtendeddescription, this.margin * 2);
        this.wlTransstatus.setLayoutData((Object)this.fdlTransstatus);
        this.wTransstatus = new CCombo(wTransComp, 2060);
        this.wTransstatus.add(BaseMessages.getString(PKG, (String)"TransDialog.Draft_Transstatus.Label", (String[])new String[0]));
        this.wTransstatus.add(BaseMessages.getString(PKG, (String)"TransDialog.Production_Transstatus.Label", (String[])new String[0]));
        this.wTransstatus.add("");
        this.wTransstatus.select(-1);
        this.props.setLook((Control)this.wTransstatus);
        this.fdTransstatus = new FormData();
        this.fdTransstatus.left = new FormAttachment(this.middle, 0);
        this.fdTransstatus.top = new FormAttachment((Control)this.wExtendeddescription, this.margin * 2);
        this.fdTransstatus.right = new FormAttachment(100, 0);
        this.wTransstatus.setLayoutData((Object)this.fdTransstatus);
        Label wlTransversion = new Label(wTransComp, 131072);
        wlTransversion.setText(BaseMessages.getString(PKG, (String)"TransDialog.Transversion.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTransversion);
        FormData fdlTransversion = new FormData();
        fdlTransversion.left = new FormAttachment(0, 0);
        fdlTransversion.right = new FormAttachment(this.middle, -this.margin);
        fdlTransversion.top = new FormAttachment((Control)this.wTransstatus, this.margin);
        wlTransversion.setLayoutData((Object)fdlTransversion);
        this.wTransversion = new Text(wTransComp, 18436);
        this.props.setLook((Control)this.wTransversion);
        this.wTransversion.addModifyListener(this.lsMod);
        FormData fdTransversion = new FormData();
        fdTransversion.left = new FormAttachment(this.middle, 0);
        fdTransversion.top = new FormAttachment((Control)this.wTransstatus, this.margin);
        fdTransversion.right = new FormAttachment(100, 0);
        this.wTransversion.setLayoutData((Object)fdTransversion);
        this.wlDirectory = new Label(wTransComp, 131072);
        this.wlDirectory.setText(BaseMessages.getString(PKG, (String)"TransDialog.Directory.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDirectory);
        FormData fdlDirectory = new FormData();
        fdlDirectory.left = new FormAttachment(0, 0);
        fdlDirectory.right = new FormAttachment(this.middle, -this.margin);
        fdlDirectory.top = new FormAttachment((Control)this.wTransversion, this.margin);
        this.wlDirectory.setLayoutData((Object)fdlDirectory);
        this.wbDirectory = new Button(wTransComp, 8);
        this.wbDirectory.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.selectTransFolder.Tooltip", (String[])new String[0]));
        this.wbDirectory.setImage(GUIResource.getInstance().getImageArrow());
        this.props.setLook((Control)this.wbDirectory);
        FormData fdbDirectory = new FormData();
        fdbDirectory.right = new FormAttachment(100, 0);
        fdbDirectory.top = new FormAttachment((Control)this.wTransversion, 0);
        this.wbDirectory.setLayoutData((Object)fdbDirectory);
        this.wbDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (TransDialog.this.rep != null) {
                    RepositoryDirectoryInterface directoryFrom = TransDialog.this.transMeta.getRepositoryDirectory();
                    if (directoryFrom == null) {
                        directoryFrom = new RepositoryDirectory();
                    }
                    ObjectId idDirectoryFrom = directoryFrom.getObjectId();
                    SelectDirectoryDialog sdd = new SelectDirectoryDialog(TransDialog.this.shell, 0, TransDialog.this.rep);
                    RepositoryDirectoryInterface rd = sdd.open();
                    if (rd != null && idDirectoryFrom != rd.getObjectId()) {
                        TransDialog.this.newDirectory = rd;
                        TransDialog.this.wDirectory.setText(rd.getPath());
                    }
                }
            }
        });
        this.wDirectory = new Text(wTransComp, 18436);
        this.props.setLook((Control)this.wDirectory);
        this.wDirectory.setEditable(false);
        this.wDirectory.setEnabled(false);
        FormData fdDirectory = new FormData();
        fdDirectory.left = new FormAttachment(this.middle, 0);
        fdDirectory.top = new FormAttachment((Control)this.wTransversion, this.margin);
        fdDirectory.right = new FormAttachment((Control)this.wbDirectory, 0);
        this.wDirectory.setLayoutData((Object)fdDirectory);
        Label wlCreateUser = new Label(wTransComp, 131072);
        wlCreateUser.setText(BaseMessages.getString(PKG, (String)"TransDialog.CreateUser.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCreateUser);
        FormData fdlCreateUser = new FormData();
        fdlCreateUser.left = new FormAttachment(0, 0);
        fdlCreateUser.right = new FormAttachment(this.middle, -this.margin);
        fdlCreateUser.top = new FormAttachment((Control)this.wDirectory, this.margin);
        wlCreateUser.setLayoutData((Object)fdlCreateUser);
        this.wCreateUser = new Text(wTransComp, 18436);
        this.props.setLook((Control)this.wCreateUser);
        this.wCreateUser.setEditable(false);
        this.wCreateUser.addModifyListener(this.lsMod);
        FormData fdCreateUser = new FormData();
        fdCreateUser.left = new FormAttachment(this.middle, 0);
        fdCreateUser.top = new FormAttachment((Control)this.wDirectory, this.margin);
        fdCreateUser.right = new FormAttachment(100, 0);
        this.wCreateUser.setLayoutData((Object)fdCreateUser);
        Label wlCreateDate = new Label(wTransComp, 131072);
        wlCreateDate.setText(BaseMessages.getString(PKG, (String)"TransDialog.CreateDate.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCreateDate);
        FormData fdlCreateDate = new FormData();
        fdlCreateDate.left = new FormAttachment(0, 0);
        fdlCreateDate.right = new FormAttachment(this.middle, -this.margin);
        fdlCreateDate.top = new FormAttachment((Control)this.wCreateUser, this.margin);
        wlCreateDate.setLayoutData((Object)fdlCreateDate);
        this.wCreateDate = new Text(wTransComp, 18436);
        this.props.setLook((Control)this.wCreateDate);
        this.wCreateDate.setEditable(false);
        this.wCreateDate.addModifyListener(this.lsMod);
        FormData fdCreateDate = new FormData();
        fdCreateDate.left = new FormAttachment(this.middle, 0);
        fdCreateDate.top = new FormAttachment((Control)this.wCreateUser, this.margin);
        fdCreateDate.right = new FormAttachment(100, 0);
        this.wCreateDate.setLayoutData((Object)fdCreateDate);
        Label wlModUser = new Label(wTransComp, 131072);
        wlModUser.setText(BaseMessages.getString(PKG, (String)"TransDialog.LastModifiedUser.Label", (String[])new String[0]));
        this.props.setLook((Control)wlModUser);
        FormData fdlModUser = new FormData();
        fdlModUser.left = new FormAttachment(0, 0);
        fdlModUser.right = new FormAttachment(this.middle, -this.margin);
        fdlModUser.top = new FormAttachment((Control)this.wCreateDate, this.margin);
        wlModUser.setLayoutData((Object)fdlModUser);
        this.wModUser = new Text(wTransComp, 18436);
        this.props.setLook((Control)this.wModUser);
        this.wModUser.setEditable(false);
        this.wModUser.addModifyListener(this.lsMod);
        FormData fdModUser = new FormData();
        fdModUser.left = new FormAttachment(this.middle, 0);
        fdModUser.top = new FormAttachment((Control)this.wCreateDate, this.margin);
        fdModUser.right = new FormAttachment(100, 0);
        this.wModUser.setLayoutData((Object)fdModUser);
        Label wlModDate = new Label(wTransComp, 131072);
        wlModDate.setText(BaseMessages.getString(PKG, (String)"TransDialog.LastModifiedDate.Label", (String[])new String[0]));
        this.props.setLook((Control)wlModDate);
        FormData fdlModDate = new FormData();
        fdlModDate.left = new FormAttachment(0, 0);
        fdlModDate.right = new FormAttachment(this.middle, -this.margin);
        fdlModDate.top = new FormAttachment((Control)this.wModUser, this.margin);
        wlModDate.setLayoutData((Object)fdlModDate);
        this.wModDate = new Text(wTransComp, 18436);
        this.props.setLook((Control)this.wModDate);
        this.wModDate.setEditable(false);
        this.wModDate.addModifyListener(this.lsMod);
        FormData fdModDate = new FormData();
        fdModDate.left = new FormAttachment(this.middle, 0);
        fdModDate.top = new FormAttachment((Control)this.wModUser, this.margin);
        fdModDate.right = new FormAttachment(100, 0);
        this.wModDate.setLayoutData((Object)fdModDate);
        FormData fdTransComp = new FormData();
        fdTransComp.left = new FormAttachment(0, 0);
        fdTransComp.top = new FormAttachment(0, 0);
        fdTransComp.right = new FormAttachment(100, 0);
        fdTransComp.bottom = new FormAttachment(100, 0);
        wTransComp.setLayoutData((Object)fdTransComp);
        wTransComp.layout();
        this.wTransTab.setControl((Control)wTransComp);
    }

    private void addParamTab() {
        this.wParamTab = new CTabItem(this.wTabFolder, 0);
        this.wParamTab.setText(BaseMessages.getString(PKG, (String)"TransDialog.ParamTab.Label", (String[])new String[0]));
        FormLayout paramLayout = new FormLayout();
        paramLayout.marginWidth = 4;
        paramLayout.marginHeight = 4;
        Composite wParamComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wParamComp);
        wParamComp.setLayout((Layout)paramLayout);
        Label wlFields = new Label(wParamComp, 131072);
        wlFields.setText(BaseMessages.getString(PKG, (String)"TransDialog.Parameters.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment(0, 0);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsCols = 3;
        int FieldsRows = this.transMeta.listParameters().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDialog.ColumnInfo.Parameter.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDialog.ColumnInfo.Default.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDialog.ColumnInfo.Description.Label", (String[])new String[0]), 1, false)};
        this.wParamFields = new TableView((VariableSpace)this.transMeta, wParamComp, 67586, colinf, FieldsRows, this.lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, this.margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(100, 0);
        this.wParamFields.setLayoutData(fdFields);
        FormData fdDepComp = new FormData();
        fdDepComp.left = new FormAttachment(0, 0);
        fdDepComp.top = new FormAttachment(0, 0);
        fdDepComp.right = new FormAttachment(100, 0);
        fdDepComp.bottom = new FormAttachment(100, 0);
        wParamComp.setLayoutData((Object)fdDepComp);
        wParamComp.layout();
        this.wParamTab.setControl((Control)wParamComp);
    }

    private void addLogTab() {
        this.wLogTab = new CTabItem(this.wTabFolder, 0);
        this.wLogTab.setText(BaseMessages.getString(PKG, (String)"TransDialog.LogTab.Label", (String[])new String[0]));
        FormLayout LogLayout = new FormLayout();
        LogLayout.marginWidth = 4;
        LogLayout.marginHeight = 4;
        this.wLogComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wLogComp);
        this.wLogComp.setLayout((Layout)LogLayout);
        this.wLogTypeList = new org.eclipse.swt.widgets.List(this.wLogComp, 2820);
        this.props.setLook((Control)this.wLogTypeList);
        this.wLogTypeList.add(BaseMessages.getString(PKG, (String)"TransDialog.LogTableType.Transformation", (String[])new String[0]));
        this.wLogTypeList.add(BaseMessages.getString(PKG, (String)"TransDialog.LogTableType.Step", (String[])new String[0]));
        this.wLogTypeList.add(BaseMessages.getString(PKG, (String)"TransDialog.LogTableType.Performance", (String[])new String[0]));
        this.wLogTypeList.add(BaseMessages.getString(PKG, (String)"TransDialog.LogTableType.LoggingChannels", (String[])new String[0]));
        this.wLogTypeList.add(BaseMessages.getString(PKG, (String)"TransDialog.LogTableType.Metrics", (String[])new String[0]));
        FormData fdLogTypeList = new FormData();
        fdLogTypeList.left = new FormAttachment(0, 0);
        fdLogTypeList.top = new FormAttachment(0, 0);
        fdLogTypeList.right = new FormAttachment(this.middle / 2, 0);
        fdLogTypeList.bottom = new FormAttachment(100, 0);
        this.wLogTypeList.setLayoutData((Object)fdLogTypeList);
        this.wLogTypeList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TransDialog.this.showLogTypeOptions(TransDialog.this.wLogTypeList.getSelectionIndex());
            }
        });
        this.wLogOptionsComposite = new Composite(this.wLogComp, 2048);
        FormLayout logOptionsLayout = new FormLayout();
        logOptionsLayout.marginWidth = 4;
        logOptionsLayout.marginHeight = 4;
        this.wLogOptionsComposite.setLayout((Layout)logOptionsLayout);
        this.props.setLook((Control)this.wLogOptionsComposite);
        FormData fdLogOptionsComposite = new FormData();
        fdLogOptionsComposite.left = new FormAttachment((Control)this.wLogTypeList, this.margin);
        fdLogOptionsComposite.top = new FormAttachment(0, 0);
        fdLogOptionsComposite.right = new FormAttachment(100, 0);
        fdLogOptionsComposite.bottom = new FormAttachment(100, 0);
        this.wLogOptionsComposite.setLayoutData((Object)fdLogOptionsComposite);
        FormData fdLogComp = new FormData();
        fdLogComp.left = new FormAttachment(0, 0);
        fdLogComp.top = new FormAttachment(0, 0);
        fdLogComp.right = new FormAttachment(100, 0);
        fdLogComp.bottom = new FormAttachment(100, 0);
        this.wLogComp.setLayoutData((Object)fdLogComp);
        this.wLogComp.layout();
        this.wLogTab.setControl((Control)this.wLogComp);
    }

    private void showLogTypeOptions(int index) {
        if (index != this.previousLogTableIndex) {
            switch (this.previousLogTableIndex) {
                case 0: {
                    this.getTransLogTableOptions();
                    break;
                }
                case 2: {
                    this.getPerformanceLogTableOptions();
                    break;
                }
                case 3: {
                    this.getChannelLogTableOptions();
                    break;
                }
                case 1: {
                    this.getStepLogTableOptions();
                    break;
                }
                case 4: {
                    this.getMetricsLogTableOptions();
                    break;
                }
            }
            for (Control control : this.wLogOptionsComposite.getChildren()) {
                control.dispose();
            }
            switch (index) {
                case 0: {
                    this.showTransLogTableOptions();
                    break;
                }
                case 2: {
                    this.showPerformanceLogTableOptions();
                    break;
                }
                case 3: {
                    this.showChannelLogTableOptions();
                    break;
                }
                case 1: {
                    this.showStepLogTableOptions();
                    break;
                }
                case 4: {
                    this.showMetricsLogTableOptions();
                    break;
                }
            }
        }
    }

    private void getTransLogTableOptions() {
        if (this.previousLogTableIndex == 0) {
            this.transLogTable.setConnectionName(this.wLogconnection.getText());
            this.transLogTable.setSchemaName(this.wLogSchema.getText());
            this.transLogTable.setTableName(this.wLogTable.getText());
            this.transLogTable.setLogInterval(this.wLogInterval.getText());
            this.transLogTable.setLogSizeLimit(this.wLogSizeLimit.getText());
            this.transLogTable.setTimeoutInDays(this.wLogTimeout.getText());
            for (int i = 0; i < this.transLogTable.getFields().size(); ++i) {
                TableItem item = this.wOptionFields.table.getItem(i);
                LogTableField field = (LogTableField)this.transLogTable.getFields().get(i);
                field.setEnabled(item.getChecked());
                field.setFieldName(item.getText(1));
                if (!field.isSubjectAllowed()) continue;
                field.setSubject((Object)this.transMeta.findStep(item.getText(2)));
            }
        }
    }

    private Control addDBSchemaTableLogOptions(LogTableInterface logTable) {
        Label wlLogconnection = new Label(this.wLogOptionsComposite, 131072);
        wlLogconnection.setText(BaseMessages.getString(PKG, (String)"TransDialog.LogConnection.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLogconnection);
        FormData fdlLogconnection = new FormData();
        fdlLogconnection.left = new FormAttachment(0, 0);
        fdlLogconnection.right = new FormAttachment(this.middle, -this.margin);
        fdlLogconnection.top = new FormAttachment(0, 0);
        wlLogconnection.setLayoutData((Object)fdlLogconnection);
        this.wbLogconnection = new Button(this.wLogOptionsComposite, 8);
        this.wbLogconnection.setText(BaseMessages.getString(PKG, (String)"TransDialog.LogconnectionButton.Label", (String[])new String[0]));
        this.wbLogconnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseMeta databaseMeta = new DatabaseMeta();
                databaseMeta.shareVariablesWith((VariableSpace)TransDialog.this.transMeta);
                TransDialog.this.getDatabaseDialog().setDatabaseMeta(databaseMeta);
                if (TransDialog.this.getDatabaseDialog().open() != null) {
                    TransDialog.this.transMeta.addDatabase(TransDialog.this.getDatabaseDialog().getDatabaseMeta());
                    TransDialog.this.wLogconnection.add(TransDialog.this.getDatabaseDialog().getDatabaseMeta().getName());
                    TransDialog.this.wLogconnection.select(TransDialog.this.wLogconnection.getItemCount() - 1);
                }
            }
        });
        FormData fdbLogconnection = new FormData();
        fdbLogconnection.right = new FormAttachment(100, 0);
        fdbLogconnection.top = new FormAttachment(0, 0);
        this.wbLogconnection.setLayoutData((Object)fdbLogconnection);
        this.wLogconnection = new ComboVar((VariableSpace)this.transMeta, this.wLogOptionsComposite, 18436);
        this.props.setLook((Control)this.wLogconnection);
        this.wLogconnection.addModifyListener(this.lsMod);
        FormData fdLogconnection = new FormData();
        fdLogconnection.left = new FormAttachment(this.middle, 0);
        fdLogconnection.top = new FormAttachment(0, 0);
        fdLogconnection.right = new FormAttachment((Control)this.wbLogconnection, -this.margin);
        this.wLogconnection.setLayoutData(fdLogconnection);
        this.wLogconnection.setItems(this.transMeta.getDatabaseNames());
        this.wLogconnection.setText(Const.NVL((String)logTable.getConnectionName(), (String)""));
        this.wLogconnection.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.LogConnection.Tooltip", (String[])new String[]{logTable.getConnectionNameVariable()}));
        Label wlLogSchema = new Label(this.wLogOptionsComposite, 131072);
        wlLogSchema.setText(BaseMessages.getString(PKG, (String)"TransDialog.LogSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLogSchema);
        FormData fdlLogSchema = new FormData();
        fdlLogSchema.left = new FormAttachment(0, 0);
        fdlLogSchema.right = new FormAttachment(this.middle, -this.margin);
        fdlLogSchema.top = new FormAttachment((Control)this.wLogconnection, this.margin);
        wlLogSchema.setLayoutData((Object)fdlLogSchema);
        this.wLogSchema = new TextVar((VariableSpace)this.transMeta, this.wLogOptionsComposite, 18436);
        this.props.setLook((Control)this.wLogSchema);
        this.wLogSchema.addModifyListener(this.lsMod);
        FormData fdLogSchema = new FormData();
        fdLogSchema.left = new FormAttachment(this.middle, 0);
        fdLogSchema.top = new FormAttachment((Control)this.wLogconnection, this.margin);
        fdLogSchema.right = new FormAttachment(100, 0);
        this.wLogSchema.setLayoutData(fdLogSchema);
        this.wLogSchema.setText(Const.NVL((String)logTable.getSchemaName(), (String)""));
        this.wLogSchema.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.LogSchema.Tooltip", (String[])new String[]{logTable.getSchemaNameVariable()}));
        Label wlLogtable = new Label(this.wLogOptionsComposite, 131072);
        wlLogtable.setText(BaseMessages.getString(PKG, (String)"TransDialog.Logtable.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLogtable);
        FormData fdlLogtable = new FormData();
        fdlLogtable.left = new FormAttachment(0, 0);
        fdlLogtable.right = new FormAttachment(this.middle, -this.margin);
        fdlLogtable.top = new FormAttachment((Control)this.wLogSchema, this.margin);
        wlLogtable.setLayoutData((Object)fdlLogtable);
        this.wLogTable = new TextVar((VariableSpace)this.transMeta, this.wLogOptionsComposite, 18436);
        this.props.setLook((Control)this.wLogTable);
        this.wLogTable.addModifyListener(this.lsMod);
        FormData fdLogtable = new FormData();
        fdLogtable.left = new FormAttachment(this.middle, 0);
        fdLogtable.top = new FormAttachment((Control)this.wLogSchema, this.margin);
        fdLogtable.right = new FormAttachment(100, 0);
        this.wLogTable.setLayoutData(fdLogtable);
        this.wLogTable.setText(Const.NVL((String)logTable.getTableName(), (String)""));
        this.wLogTable.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.LogTable.Tooltip", (String[])new String[]{logTable.getTableNameVariable()}));
        return this.wLogTable;
    }

    private void showTransLogTableOptions() {
        this.previousLogTableIndex = 0;
        this.addDBSchemaTableLogOptions((LogTableInterface)this.transLogTable);
        Label wlLogInterval = new Label(this.wLogOptionsComposite, 131072);
        wlLogInterval.setText(BaseMessages.getString(PKG, (String)"TransDialog.LogInterval.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLogInterval);
        FormData fdlLogInterval = new FormData();
        fdlLogInterval.left = new FormAttachment(0, 0);
        fdlLogInterval.right = new FormAttachment(this.middle, -this.margin);
        fdlLogInterval.top = new FormAttachment((Control)this.wLogTable, this.margin);
        wlLogInterval.setLayoutData((Object)fdlLogInterval);
        this.wLogInterval = new TextVar((VariableSpace)this.transMeta, this.wLogOptionsComposite, 18436);
        this.props.setLook((Control)this.wLogInterval);
        this.wLogInterval.addModifyListener(this.lsMod);
        FormData fdLogInterval = new FormData();
        fdLogInterval.left = new FormAttachment(this.middle, 0);
        fdLogInterval.top = new FormAttachment((Control)this.wLogTable, this.margin);
        fdLogInterval.right = new FormAttachment(100, 0);
        this.wLogInterval.setLayoutData(fdLogInterval);
        this.wLogInterval.setText(Const.NVL((String)this.transLogTable.getLogInterval(), (String)""));
        Label wlLogTimeout = new Label(this.wLogOptionsComposite, 131072);
        wlLogTimeout.setText(BaseMessages.getString(PKG, (String)"TransDialog.LogTimeout.Label", (String[])new String[0]));
        wlLogTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.LogTimeout.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wlLogTimeout);
        FormData fdlLogTimeout = new FormData();
        fdlLogTimeout.left = new FormAttachment(0, 0);
        fdlLogTimeout.right = new FormAttachment(this.middle, -this.margin);
        fdlLogTimeout.top = new FormAttachment((Control)this.wLogInterval, this.margin);
        wlLogTimeout.setLayoutData((Object)fdlLogTimeout);
        this.wLogTimeout = new TextVar((VariableSpace)this.transMeta, this.wLogOptionsComposite, 18436);
        this.wLogTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.LogTimeout.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wLogTimeout);
        this.wLogTimeout.addModifyListener(this.lsMod);
        FormData fdLogTimeout = new FormData();
        fdLogTimeout.left = new FormAttachment(this.middle, 0);
        fdLogTimeout.top = new FormAttachment((Control)this.wLogInterval, this.margin);
        fdLogTimeout.right = new FormAttachment(100, 0);
        this.wLogTimeout.setLayoutData(fdLogTimeout);
        this.wLogTimeout.setText(Const.NVL((String)this.transLogTable.getTimeoutInDays(), (String)""));
        Label wlLogSizeLimit = new Label(this.wLogOptionsComposite, 131072);
        wlLogSizeLimit.setText(BaseMessages.getString(PKG, (String)"TransDialog.LogSizeLimit.Label", (String[])new String[0]));
        wlLogSizeLimit.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.LogSizeLimit.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wlLogSizeLimit);
        FormData fdlLogSizeLimit = new FormData();
        fdlLogSizeLimit.left = new FormAttachment(0, 0);
        fdlLogSizeLimit.right = new FormAttachment(this.middle, -this.margin);
        fdlLogSizeLimit.top = new FormAttachment((Control)this.wLogTimeout, this.margin);
        wlLogSizeLimit.setLayoutData((Object)fdlLogSizeLimit);
        this.wLogSizeLimit = new TextVar((VariableSpace)this.transMeta, this.wLogOptionsComposite, 18436);
        this.wLogSizeLimit.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.LogSizeLimit.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wLogSizeLimit);
        this.wLogSizeLimit.addModifyListener(this.lsMod);
        FormData fdLogSizeLimit = new FormData();
        fdLogSizeLimit.left = new FormAttachment(this.middle, 0);
        fdLogSizeLimit.top = new FormAttachment((Control)this.wLogTimeout, this.margin);
        fdLogSizeLimit.right = new FormAttachment(100, 0);
        this.wLogSizeLimit.setLayoutData(fdLogSizeLimit);
        this.wLogSizeLimit.setText(Const.NVL((String)this.transLogTable.getLogSizeLimit(), (String)""));
        Label wlFields = new Label(this.wLogOptionsComposite, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wLogSizeLimit, this.margin * 2);
        wlFields.setLayoutData((Object)fdlFields);
        final List fields = this.transLogTable.getFields();
        int nrRows = fields.size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.FieldName", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.StepName", (String[])new String[0]), 2, this.transMeta.getStepNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.Description", (String[])new String[0]), 1, false, true)};
        FieldDisabledListener disabledListener = new FieldDisabledListener(){

            @Override
            public boolean isFieldDisabled(int rowNr) {
                if (rowNr >= 0 && rowNr < fields.size()) {
                    LogTableField field = (LogTableField)fields.get(rowNr);
                    return !field.isSubjectAllowed();
                }
                return true;
            }
        };
        colinf[1].setDisabledListener(disabledListener);
        this.wOptionFields = new TableView((VariableSpace)this.transMeta, this.wLogOptionsComposite, 67618, colinf, nrRows, true, this.lsMod, this.props);
        this.wOptionFields.setSortable(false);
        for (int i = 0; i < fields.size(); ++i) {
            LogTableField field = (LogTableField)fields.get(i);
            TableItem item = this.wOptionFields.table.getItem(i);
            item.setChecked(field.isEnabled());
            item.setText(new String[]{"", Const.NVL((String)field.getFieldName(), (String)""), field.getSubject() == null ? "" : field.getSubject().toString(), Const.NVL((String)field.getDescription(), (String)"")});
            if (!disabledListener.isFieldDisabled(i)) continue;
            item.setBackground(2, GUIResource.getInstance().getColorLightGray());
        }
        this.wOptionFields.table.getColumn(0).setText(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.Enabled", (String[])new String[0]));
        FormData fdOptionFields = new FormData();
        fdOptionFields.left = new FormAttachment(0, 0);
        fdOptionFields.top = new FormAttachment((Control)wlFields, this.margin);
        fdOptionFields.right = new FormAttachment(100, 0);
        fdOptionFields.bottom = new FormAttachment(100, 0);
        this.wOptionFields.setLayoutData(fdOptionFields);
        this.wOptionFields.optWidth(true);
        this.wOptionFields.layout();
        this.wLogOptionsComposite.layout(true, true);
        this.wLogComp.layout(true, true);
    }

    private void getPerformanceLogTableOptions() {
        if (this.previousLogTableIndex == 2) {
            this.performanceLogTable.setConnectionName(this.wLogconnection.getText());
            this.performanceLogTable.setSchemaName(this.wLogSchema.getText());
            this.performanceLogTable.setTableName(this.wLogTable.getText());
            this.performanceLogTable.setLogInterval(this.wLogInterval.getText());
            this.performanceLogTable.setTimeoutInDays(this.wLogTimeout.getText());
            for (int i = 0; i < this.performanceLogTable.getFields().size(); ++i) {
                TableItem item = this.wOptionFields.table.getItem(i);
                LogTableField field = (LogTableField)this.performanceLogTable.getFields().get(i);
                field.setEnabled(item.getChecked());
                field.setFieldName(item.getText(1));
            }
        }
    }

    private void showPerformanceLogTableOptions() {
        this.previousLogTableIndex = 2;
        this.addDBSchemaTableLogOptions((LogTableInterface)this.performanceLogTable);
        Label wlLogInterval = new Label(this.wLogOptionsComposite, 131072);
        wlLogInterval.setText(BaseMessages.getString(PKG, (String)"TransDialog.LogInterval.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLogInterval);
        FormData fdlLogInterval = new FormData();
        fdlLogInterval.left = new FormAttachment(0, 0);
        fdlLogInterval.right = new FormAttachment(this.middle, -this.margin);
        fdlLogInterval.top = new FormAttachment((Control)this.wLogTable, this.margin);
        wlLogInterval.setLayoutData((Object)fdlLogInterval);
        this.wLogInterval = new TextVar((VariableSpace)this.transMeta, this.wLogOptionsComposite, 18436);
        this.props.setLook((Control)this.wLogInterval);
        this.wLogInterval.addModifyListener(this.lsMod);
        FormData fdLogInterval = new FormData();
        fdLogInterval.left = new FormAttachment(this.middle, 0);
        fdLogInterval.top = new FormAttachment((Control)this.wLogTable, this.margin);
        fdLogInterval.right = new FormAttachment(100, 0);
        this.wLogInterval.setLayoutData(fdLogInterval);
        this.wLogInterval.setText(Const.NVL((String)this.performanceLogTable.getLogInterval(), (String)""));
        Label wlLogTimeout = new Label(this.wLogOptionsComposite, 131072);
        wlLogTimeout.setText(BaseMessages.getString(PKG, (String)"TransDialog.LogTimeout.Label", (String[])new String[0]));
        wlLogTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.LogTimeout.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wlLogTimeout);
        FormData fdlLogTimeout = new FormData();
        fdlLogTimeout.left = new FormAttachment(0, 0);
        fdlLogTimeout.right = new FormAttachment(this.middle, -this.margin);
        fdlLogTimeout.top = new FormAttachment((Control)this.wLogInterval, this.margin);
        wlLogTimeout.setLayoutData((Object)fdlLogTimeout);
        this.wLogTimeout = new TextVar((VariableSpace)this.transMeta, this.wLogOptionsComposite, 18436);
        this.wLogTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.LogTimeout.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wLogTimeout);
        this.wLogTimeout.addModifyListener(this.lsMod);
        FormData fdLogTimeout = new FormData();
        fdLogTimeout.left = new FormAttachment(this.middle, 0);
        fdLogTimeout.top = new FormAttachment((Control)this.wLogInterval, this.margin);
        fdLogTimeout.right = new FormAttachment(100, 0);
        this.wLogTimeout.setLayoutData(fdLogTimeout);
        this.wLogTimeout.setText(Const.NVL((String)this.performanceLogTable.getTimeoutInDays(), (String)""));
        Label wlFields = new Label(this.wLogOptionsComposite, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wLogTimeout, this.margin * 2);
        wlFields.setLayoutData((Object)fdlFields);
        final List fields = this.performanceLogTable.getFields();
        int nrRows = fields.size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.FieldName", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.Description", (String[])new String[0]), 1, false, true)};
        FieldDisabledListener disabledListener = new FieldDisabledListener(){

            @Override
            public boolean isFieldDisabled(int rowNr) {
                if (rowNr >= 0 && rowNr < fields.size()) {
                    LogTableField field = (LogTableField)fields.get(rowNr);
                    return field.isSubjectAllowed();
                }
                return true;
            }
        };
        colinf[1].setDisabledListener(disabledListener);
        this.wOptionFields = new TableView((VariableSpace)this.transMeta, this.wLogOptionsComposite, 67618, colinf, nrRows, true, this.lsMod, this.props);
        this.wOptionFields.setSortable(false);
        for (int i = 0; i < fields.size(); ++i) {
            LogTableField field = (LogTableField)fields.get(i);
            TableItem item = this.wOptionFields.table.getItem(i);
            item.setChecked(field.isEnabled());
            item.setText(new String[]{"", Const.NVL((String)field.getFieldName(), (String)""), Const.NVL((String)field.getDescription(), (String)"")});
        }
        this.wOptionFields.table.getColumn(0).setText(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.Enabled", (String[])new String[0]));
        FormData fdOptionFields = new FormData();
        fdOptionFields.left = new FormAttachment(0, 0);
        fdOptionFields.top = new FormAttachment((Control)wlFields, this.margin);
        fdOptionFields.right = new FormAttachment(100, 0);
        fdOptionFields.bottom = new FormAttachment(100, 0);
        this.wOptionFields.setLayoutData(fdOptionFields);
        this.wOptionFields.optWidth(true);
        this.wOptionFields.layout();
        this.wLogOptionsComposite.layout(true, true);
        this.wLogComp.layout(true, true);
    }

    private void getChannelLogTableOptions() {
        if (this.previousLogTableIndex == 3) {
            this.channelLogTable.setConnectionName(this.wLogconnection.getText());
            this.channelLogTable.setSchemaName(this.wLogSchema.getText());
            this.channelLogTable.setTableName(this.wLogTable.getText());
            this.channelLogTable.setTimeoutInDays(this.wLogTimeout.getText());
            for (int i = 0; i < this.channelLogTable.getFields().size(); ++i) {
                TableItem item = this.wOptionFields.table.getItem(i);
                LogTableField field = (LogTableField)this.channelLogTable.getFields().get(i);
                field.setEnabled(item.getChecked());
                field.setFieldName(item.getText(1));
            }
        }
    }

    private void getMetricsLogTableOptions() {
        if (this.previousLogTableIndex == 4) {
            this.metricsLogTable.setConnectionName(this.wLogconnection.getText());
            this.metricsLogTable.setSchemaName(this.wLogSchema.getText());
            this.metricsLogTable.setTableName(this.wLogTable.getText());
            this.metricsLogTable.setTimeoutInDays(this.wLogTimeout.getText());
            for (int i = 0; i < this.metricsLogTable.getFields().size(); ++i) {
                TableItem item = this.wOptionFields.table.getItem(i);
                LogTableField field = (LogTableField)this.metricsLogTable.getFields().get(i);
                field.setEnabled(item.getChecked());
                field.setFieldName(item.getText(1));
            }
        }
    }

    private void showChannelLogTableOptions() {
        this.previousLogTableIndex = 3;
        this.addDBSchemaTableLogOptions((LogTableInterface)this.channelLogTable);
        Label wlLogTimeout = new Label(this.wLogOptionsComposite, 131072);
        wlLogTimeout.setText(BaseMessages.getString(PKG, (String)"TransDialog.LogTimeout.Label", (String[])new String[0]));
        wlLogTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.LogTimeout.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wlLogTimeout);
        FormData fdlLogTimeout = new FormData();
        fdlLogTimeout.left = new FormAttachment(0, 0);
        fdlLogTimeout.right = new FormAttachment(this.middle, -this.margin);
        fdlLogTimeout.top = new FormAttachment((Control)this.wLogTable, this.margin);
        wlLogTimeout.setLayoutData((Object)fdlLogTimeout);
        this.wLogTimeout = new TextVar((VariableSpace)this.transMeta, this.wLogOptionsComposite, 18436);
        this.wLogTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.LogTimeout.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wLogTimeout);
        this.wLogTimeout.addModifyListener(this.lsMod);
        FormData fdLogTimeout = new FormData();
        fdLogTimeout.left = new FormAttachment(this.middle, 0);
        fdLogTimeout.top = new FormAttachment((Control)this.wLogTable, this.margin);
        fdLogTimeout.right = new FormAttachment(100, 0);
        this.wLogTimeout.setLayoutData(fdLogTimeout);
        this.wLogTimeout.setText(Const.NVL((String)this.channelLogTable.getTimeoutInDays(), (String)""));
        Label wlFields = new Label(this.wLogOptionsComposite, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wLogTimeout, this.margin * 2);
        wlFields.setLayoutData((Object)fdlFields);
        final List fields = this.channelLogTable.getFields();
        int nrRows = fields.size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.FieldName", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.Description", (String[])new String[0]), 1, false, true)};
        FieldDisabledListener disabledListener = new FieldDisabledListener(){

            @Override
            public boolean isFieldDisabled(int rowNr) {
                if (rowNr >= 0 && rowNr < fields.size()) {
                    LogTableField field = (LogTableField)fields.get(rowNr);
                    return field.isSubjectAllowed();
                }
                return true;
            }
        };
        colinf[1].setDisabledListener(disabledListener);
        this.wOptionFields = new TableView((VariableSpace)this.transMeta, this.wLogOptionsComposite, 67618, colinf, nrRows, true, this.lsMod, this.props);
        this.wOptionFields.setSortable(false);
        for (int i = 0; i < fields.size(); ++i) {
            LogTableField field = (LogTableField)fields.get(i);
            TableItem item = this.wOptionFields.table.getItem(i);
            item.setChecked(field.isEnabled());
            item.setText(new String[]{"", Const.NVL((String)field.getFieldName(), (String)""), Const.NVL((String)field.getDescription(), (String)"")});
        }
        this.wOptionFields.table.getColumn(0).setText(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.Enabled", (String[])new String[0]));
        FormData fdOptionFields = new FormData();
        fdOptionFields.left = new FormAttachment(0, 0);
        fdOptionFields.top = new FormAttachment((Control)wlFields, this.margin);
        fdOptionFields.right = new FormAttachment(100, 0);
        fdOptionFields.bottom = new FormAttachment(100, 0);
        this.wOptionFields.setLayoutData(fdOptionFields);
        this.wOptionFields.optWidth(true);
        this.wOptionFields.layout();
        this.wLogOptionsComposite.layout(true, true);
        this.wLogComp.layout(true, true);
    }

    private void showMetricsLogTableOptions() {
        this.previousLogTableIndex = 4;
        this.addDBSchemaTableLogOptions((LogTableInterface)this.metricsLogTable);
        Label wlLogTimeout = new Label(this.wLogOptionsComposite, 131072);
        wlLogTimeout.setText(BaseMessages.getString(PKG, (String)"TransDialog.LogTimeout.Label", (String[])new String[0]));
        wlLogTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.LogTimeout.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wlLogTimeout);
        FormData fdlLogTimeout = new FormData();
        fdlLogTimeout.left = new FormAttachment(0, 0);
        fdlLogTimeout.right = new FormAttachment(this.middle, -this.margin);
        fdlLogTimeout.top = new FormAttachment((Control)this.wLogTable, this.margin);
        wlLogTimeout.setLayoutData((Object)fdlLogTimeout);
        this.wLogTimeout = new TextVar((VariableSpace)this.transMeta, this.wLogOptionsComposite, 18436);
        this.wLogTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.LogTimeout.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wLogTimeout);
        this.wLogTimeout.addModifyListener(this.lsMod);
        FormData fdLogTimeout = new FormData();
        fdLogTimeout.left = new FormAttachment(this.middle, 0);
        fdLogTimeout.top = new FormAttachment((Control)this.wLogTable, this.margin);
        fdLogTimeout.right = new FormAttachment(100, 0);
        this.wLogTimeout.setLayoutData(fdLogTimeout);
        this.wLogTimeout.setText(Const.NVL((String)this.channelLogTable.getTimeoutInDays(), (String)""));
        Label wlFields = new Label(this.wLogOptionsComposite, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wLogTimeout, this.margin * 2);
        wlFields.setLayoutData((Object)fdlFields);
        final List fields = this.metricsLogTable.getFields();
        int nrRows = fields.size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.FieldName", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.Description", (String[])new String[0]), 1, false, true)};
        FieldDisabledListener disabledListener = new FieldDisabledListener(){

            @Override
            public boolean isFieldDisabled(int rowNr) {
                if (rowNr >= 0 && rowNr < fields.size()) {
                    LogTableField field = (LogTableField)fields.get(rowNr);
                    return field.isSubjectAllowed();
                }
                return true;
            }
        };
        colinf[1].setDisabledListener(disabledListener);
        this.wOptionFields = new TableView((VariableSpace)this.transMeta, this.wLogOptionsComposite, 67618, colinf, nrRows, true, this.lsMod, this.props);
        this.wOptionFields.setSortable(false);
        for (int i = 0; i < fields.size(); ++i) {
            LogTableField field = (LogTableField)fields.get(i);
            TableItem item = this.wOptionFields.table.getItem(i);
            item.setChecked(field.isEnabled());
            item.setText(new String[]{"", Const.NVL((String)field.getFieldName(), (String)""), Const.NVL((String)field.getDescription(), (String)"")});
        }
        this.wOptionFields.table.getColumn(0).setText(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.Enabled", (String[])new String[0]));
        FormData fdOptionFields = new FormData();
        fdOptionFields.left = new FormAttachment(0, 0);
        fdOptionFields.top = new FormAttachment((Control)wlFields, this.margin);
        fdOptionFields.right = new FormAttachment(100, 0);
        fdOptionFields.bottom = new FormAttachment(100, 0);
        this.wOptionFields.setLayoutData(fdOptionFields);
        this.wOptionFields.optWidth(true);
        this.wOptionFields.layout();
        this.wLogOptionsComposite.layout(true, true);
        this.wLogComp.layout(true, true);
    }

    private void getStepLogTableOptions() {
        if (this.previousLogTableIndex == 1) {
            this.stepLogTable.setConnectionName(this.wLogconnection.getText());
            this.stepLogTable.setSchemaName(this.wLogSchema.getText());
            this.stepLogTable.setTableName(this.wLogTable.getText());
            this.stepLogTable.setTimeoutInDays(this.wLogTimeout.getText());
            for (int i = 0; i < this.stepLogTable.getFields().size(); ++i) {
                TableItem item = this.wOptionFields.table.getItem(i);
                LogTableField field = (LogTableField)this.stepLogTable.getFields().get(i);
                field.setEnabled(item.getChecked());
                field.setFieldName(item.getText(1));
            }
        }
    }

    private void showStepLogTableOptions() {
        this.previousLogTableIndex = 1;
        this.addDBSchemaTableLogOptions((LogTableInterface)this.stepLogTable);
        Label wlLogTimeout = new Label(this.wLogOptionsComposite, 131072);
        wlLogTimeout.setText(BaseMessages.getString(PKG, (String)"TransDialog.LogTimeout.Label", (String[])new String[0]));
        wlLogTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.LogTimeout.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wlLogTimeout);
        FormData fdlLogTimeout = new FormData();
        fdlLogTimeout.left = new FormAttachment(0, 0);
        fdlLogTimeout.right = new FormAttachment(this.middle, -this.margin);
        fdlLogTimeout.top = new FormAttachment((Control)this.wLogTable, this.margin);
        wlLogTimeout.setLayoutData((Object)fdlLogTimeout);
        this.wLogTimeout = new TextVar((VariableSpace)this.transMeta, this.wLogOptionsComposite, 18436);
        this.wLogTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.LogTimeout.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wLogTimeout);
        this.wLogTimeout.addModifyListener(this.lsMod);
        FormData fdLogTimeout = new FormData();
        fdLogTimeout.left = new FormAttachment(this.middle, 0);
        fdLogTimeout.top = new FormAttachment((Control)this.wLogTable, this.margin);
        fdLogTimeout.right = new FormAttachment(100, 0);
        this.wLogTimeout.setLayoutData(fdLogTimeout);
        this.wLogTimeout.setText(Const.NVL((String)this.stepLogTable.getTimeoutInDays(), (String)""));
        Label wlFields = new Label(this.wLogOptionsComposite, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wLogTimeout, this.margin * 2);
        wlFields.setLayoutData((Object)fdlFields);
        final List fields = this.stepLogTable.getFields();
        int nrRows = fields.size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.FieldName", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.Description", (String[])new String[0]), 1, false, true)};
        FieldDisabledListener disabledListener = new FieldDisabledListener(){

            @Override
            public boolean isFieldDisabled(int rowNr) {
                if (rowNr >= 0 && rowNr < fields.size()) {
                    LogTableField field = (LogTableField)fields.get(rowNr);
                    return field.isSubjectAllowed();
                }
                return true;
            }
        };
        colinf[1].setDisabledListener(disabledListener);
        this.wOptionFields = new TableView((VariableSpace)this.transMeta, this.wLogOptionsComposite, 67618, colinf, nrRows, true, this.lsMod, this.props);
        this.wOptionFields.setSortable(false);
        for (int i = 0; i < fields.size(); ++i) {
            LogTableField field = (LogTableField)fields.get(i);
            TableItem item = this.wOptionFields.table.getItem(i);
            item.setChecked(field.isEnabled());
            item.setText(new String[]{"", Const.NVL((String)field.getFieldName(), (String)""), Const.NVL((String)field.getDescription(), (String)"")});
        }
        this.wOptionFields.table.getColumn(0).setText(BaseMessages.getString(PKG, (String)"TransDialog.TransLogTable.Fields.Enabled", (String[])new String[0]));
        FormData fdOptionFields = new FormData();
        fdOptionFields.left = new FormAttachment(0, 0);
        fdOptionFields.top = new FormAttachment((Control)wlFields, this.margin);
        fdOptionFields.right = new FormAttachment(100, 0);
        fdOptionFields.bottom = new FormAttachment(100, 0);
        this.wOptionFields.setLayoutData(fdOptionFields);
        this.wOptionFields.optWidth(true);
        this.wOptionFields.layout();
        this.wLogOptionsComposite.layout(true, true);
        this.wLogComp.layout(true, true);
    }

    private void addDateTab() {
        this.wDateTab = new CTabItem(this.wTabFolder, 0);
        this.wDateTab.setText(BaseMessages.getString(PKG, (String)"TransDialog.DateTab.Label", (String[])new String[0]));
        FormLayout DateLayout = new FormLayout();
        DateLayout.marginWidth = 4;
        DateLayout.marginHeight = 4;
        Composite wDateComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wDateComp);
        wDateComp.setLayout((Layout)DateLayout);
        Label wlMaxdateconnection = new Label(wDateComp, 131072);
        wlMaxdateconnection.setText(BaseMessages.getString(PKG, (String)"TransDialog.MaxdateConnection.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMaxdateconnection);
        FormData fdlMaxdateconnection = new FormData();
        fdlMaxdateconnection.left = new FormAttachment(0, 0);
        fdlMaxdateconnection.right = new FormAttachment(this.middle, -this.margin);
        fdlMaxdateconnection.top = new FormAttachment(0, 0);
        wlMaxdateconnection.setLayoutData((Object)fdlMaxdateconnection);
        this.wMaxdateconnection = new CCombo(wDateComp, 18436);
        this.props.setLook((Control)this.wMaxdateconnection);
        this.wMaxdateconnection.addModifyListener(this.lsMod);
        FormData fdMaxdateconnection = new FormData();
        fdMaxdateconnection.left = new FormAttachment(this.middle, 0);
        fdMaxdateconnection.top = new FormAttachment(0, 0);
        fdMaxdateconnection.right = new FormAttachment(100, 0);
        this.wMaxdateconnection.setLayoutData((Object)fdMaxdateconnection);
        Label wlMaxdatetable = new Label(wDateComp, 131072);
        wlMaxdatetable.setText(BaseMessages.getString(PKG, (String)"TransDialog.MaxdateTable.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMaxdatetable);
        FormData fdlMaxdatetable = new FormData();
        fdlMaxdatetable.left = new FormAttachment(0, 0);
        fdlMaxdatetable.right = new FormAttachment(this.middle, -this.margin);
        fdlMaxdatetable.top = new FormAttachment((Control)this.wMaxdateconnection, this.margin);
        wlMaxdatetable.setLayoutData((Object)fdlMaxdatetable);
        this.wMaxdatetable = new Text(wDateComp, 18436);
        this.props.setLook((Control)this.wMaxdatetable);
        this.wMaxdatetable.addModifyListener(this.lsMod);
        FormData fdMaxdatetable = new FormData();
        fdMaxdatetable.left = new FormAttachment(this.middle, 0);
        fdMaxdatetable.top = new FormAttachment((Control)this.wMaxdateconnection, this.margin);
        fdMaxdatetable.right = new FormAttachment(100, 0);
        this.wMaxdatetable.setLayoutData((Object)fdMaxdatetable);
        Label wlMaxdatefield = new Label(wDateComp, 131072);
        wlMaxdatefield.setText(BaseMessages.getString(PKG, (String)"TransDialog.MaxdateField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMaxdatefield);
        FormData fdlMaxdatefield = new FormData();
        fdlMaxdatefield.left = new FormAttachment(0, 0);
        fdlMaxdatefield.right = new FormAttachment(this.middle, -this.margin);
        fdlMaxdatefield.top = new FormAttachment((Control)this.wMaxdatetable, this.margin);
        wlMaxdatefield.setLayoutData((Object)fdlMaxdatefield);
        this.wMaxdatefield = new Text(wDateComp, 18436);
        this.props.setLook((Control)this.wMaxdatefield);
        this.wMaxdatefield.addModifyListener(this.lsMod);
        FormData fdMaxdatefield = new FormData();
        fdMaxdatefield.left = new FormAttachment(this.middle, 0);
        fdMaxdatefield.top = new FormAttachment((Control)this.wMaxdatetable, this.margin);
        fdMaxdatefield.right = new FormAttachment(100, 0);
        this.wMaxdatefield.setLayoutData((Object)fdMaxdatefield);
        Label wlMaxdateoffset = new Label(wDateComp, 131072);
        wlMaxdateoffset.setText(BaseMessages.getString(PKG, (String)"TransDialog.MaxdateOffset.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMaxdateoffset);
        FormData fdlMaxdateoffset = new FormData();
        fdlMaxdateoffset.left = new FormAttachment(0, 0);
        fdlMaxdateoffset.right = new FormAttachment(this.middle, -this.margin);
        fdlMaxdateoffset.top = new FormAttachment((Control)this.wMaxdatefield, this.margin);
        wlMaxdateoffset.setLayoutData((Object)fdlMaxdateoffset);
        this.wMaxdateoffset = new Text(wDateComp, 18436);
        this.props.setLook((Control)this.wMaxdateoffset);
        this.wMaxdateoffset.addModifyListener(this.lsMod);
        FormData fdMaxdateoffset = new FormData();
        fdMaxdateoffset.left = new FormAttachment(this.middle, 0);
        fdMaxdateoffset.top = new FormAttachment((Control)this.wMaxdatefield, this.margin);
        fdMaxdateoffset.right = new FormAttachment(100, 0);
        this.wMaxdateoffset.setLayoutData((Object)fdMaxdateoffset);
        Label wlMaxdatediff = new Label(wDateComp, 131072);
        wlMaxdatediff.setText(BaseMessages.getString(PKG, (String)"TransDialog.Maxdatediff.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMaxdatediff);
        FormData fdlMaxdatediff = new FormData();
        fdlMaxdatediff.left = new FormAttachment(0, 0);
        fdlMaxdatediff.right = new FormAttachment(this.middle, -this.margin);
        fdlMaxdatediff.top = new FormAttachment((Control)this.wMaxdateoffset, this.margin);
        wlMaxdatediff.setLayoutData((Object)fdlMaxdatediff);
        this.wMaxdatediff = new Text(wDateComp, 18436);
        this.props.setLook((Control)this.wMaxdatediff);
        this.wMaxdatediff.addModifyListener(this.lsMod);
        FormData fdMaxdatediff = new FormData();
        fdMaxdatediff.left = new FormAttachment(this.middle, 0);
        fdMaxdatediff.top = new FormAttachment((Control)this.wMaxdateoffset, this.margin);
        fdMaxdatediff.right = new FormAttachment(100, 0);
        this.wMaxdatediff.setLayoutData((Object)fdMaxdatediff);
        this.connectionNames = new String[this.transMeta.nrDatabases()];
        for (int i = 0; i < this.transMeta.nrDatabases(); ++i) {
            DatabaseMeta ci = this.transMeta.getDatabase(i);
            this.wMaxdateconnection.add(ci.getName());
            this.connectionNames[i] = ci.getName();
        }
        FormData fdDateComp = new FormData();
        fdDateComp.left = new FormAttachment(0, 0);
        fdDateComp.top = new FormAttachment(0, 0);
        fdDateComp.right = new FormAttachment(100, 0);
        fdDateComp.bottom = new FormAttachment(100, 0);
        wDateComp.setLayoutData((Object)fdDateComp);
        wDateComp.layout();
        this.wDateTab.setControl((Control)wDateComp);
    }

    private void addDepTab() {
        this.wDepTab = new CTabItem(this.wTabFolder, 0);
        this.wDepTab.setText(BaseMessages.getString(PKG, (String)"TransDialog.DepTab.Label", (String[])new String[0]));
        FormLayout DepLayout = new FormLayout();
        DepLayout.marginWidth = 4;
        DepLayout.marginHeight = 4;
        Composite wDepComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wDepComp);
        wDepComp.setLayout((Layout)DepLayout);
        Label wlFields = new Label(wDepComp, 131072);
        wlFields.setText(BaseMessages.getString(PKG, (String)"TransDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment(0, 0);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsCols = 3;
        int FieldsRows = this.transMeta.nrDependencies();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDialog.ColumnInfo.Connection.Label", (String[])new String[0]), 2, this.connectionNames), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDialog.ColumnInfo.Table.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransDialog.ColumnInfo.Field.Label", (String[])new String[0]), 1, false)};
        this.wFields = new TableView((VariableSpace)this.transMeta, wDepComp, 67586, colinf, FieldsRows, this.lsMod, this.props);
        this.wGet = new Button(wDepComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"TransDialog.GetDependenciesButton.Label", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.bottom = new FormAttachment(100, 0);
        this.fdGet.left = new FormAttachment(50, 0);
        this.wGet.setLayoutData((Object)this.fdGet);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, this.margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wGet, 0);
        this.wFields.setLayoutData(fdFields);
        FormData fdDepComp = new FormData();
        fdDepComp.left = new FormAttachment(0, 0);
        fdDepComp.top = new FormAttachment(0, 0);
        fdDepComp.right = new FormAttachment(100, 0);
        fdDepComp.bottom = new FormAttachment(100, 0);
        wDepComp.setLayoutData((Object)fdDepComp);
        wDepComp.layout();
        this.wDepTab.setControl((Control)wDepComp);
    }

    private void addMiscTab() {
        this.wMiscTab = new CTabItem(this.wTabFolder, 0);
        this.wMiscTab.setText(BaseMessages.getString(PKG, (String)"TransDialog.MiscTab.Label", (String[])new String[0]));
        Composite wMiscComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wMiscComp);
        FormLayout perfLayout = new FormLayout();
        perfLayout.marginWidth = 5;
        perfLayout.marginHeight = 5;
        wMiscComp.setLayout((Layout)perfLayout);
        Label wlSizeRowset = new Label(wMiscComp, 131072);
        wlSizeRowset.setText(BaseMessages.getString(PKG, (String)"TransDialog.SizeRowset.Label", (String[])new String[0]));
        wlSizeRowset.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.SizeRowset.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wlSizeRowset);
        FormData fdlSizeRowset = new FormData();
        fdlSizeRowset.left = new FormAttachment(0, 0);
        fdlSizeRowset.right = new FormAttachment(this.middle, -this.margin);
        fdlSizeRowset.top = new FormAttachment(0, this.margin);
        wlSizeRowset.setLayoutData((Object)fdlSizeRowset);
        this.wSizeRowset = new Text(wMiscComp, 18436);
        this.wSizeRowset.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.SizeRowset.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wSizeRowset);
        this.wSizeRowset.addModifyListener(this.lsMod);
        FormData fdSizeRowset = new FormData();
        fdSizeRowset.left = new FormAttachment(this.middle, 0);
        fdSizeRowset.top = new FormAttachment(0, this.margin);
        fdSizeRowset.right = new FormAttachment(100, 0);
        this.wSizeRowset.setLayoutData((Object)fdSizeRowset);
        Label wlShowFeedback = new Label(wMiscComp, 131072);
        wlShowFeedback.setText(BaseMessages.getString(PKG, (String)"TransDialog.ShowFeedbackRow.Label", (String[])new String[0]));
        this.props.setLook((Control)wlShowFeedback);
        FormData fdlShowFeedback = new FormData();
        fdlShowFeedback.left = new FormAttachment(0, 0);
        fdlShowFeedback.top = new FormAttachment((Control)this.wSizeRowset, this.margin);
        fdlShowFeedback.right = new FormAttachment(this.middle, -this.margin);
        wlShowFeedback.setLayoutData((Object)fdlShowFeedback);
        this.wShowFeedback = new Button(wMiscComp, 32);
        this.props.setLook((Control)this.wShowFeedback);
        this.wShowFeedback.addSelectionListener((SelectionListener)this.lsModSel);
        FormData fdShowFeedback = new FormData();
        fdShowFeedback.left = new FormAttachment(this.middle, 0);
        fdShowFeedback.top = new FormAttachment((Control)this.wSizeRowset, this.margin);
        fdShowFeedback.right = new FormAttachment(100, 0);
        this.wShowFeedback.setLayoutData((Object)fdShowFeedback);
        Label wlFeedbackSize = new Label(wMiscComp, 131072);
        wlFeedbackSize.setText(BaseMessages.getString(PKG, (String)"TransDialog.FeedbackSize.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFeedbackSize);
        FormData fdlFeedbackSize = new FormData();
        fdlFeedbackSize.left = new FormAttachment(0, 0);
        fdlFeedbackSize.right = new FormAttachment(this.middle, -this.margin);
        fdlFeedbackSize.top = new FormAttachment((Control)this.wShowFeedback, this.margin);
        wlFeedbackSize.setLayoutData((Object)fdlFeedbackSize);
        this.wFeedbackSize = new Text(wMiscComp, 18436);
        this.props.setLook((Control)this.wFeedbackSize);
        this.wFeedbackSize.addModifyListener(this.lsMod);
        FormData fdFeedbackSize = new FormData();
        fdFeedbackSize.left = new FormAttachment(this.middle, 0);
        fdFeedbackSize.right = new FormAttachment(100, -this.margin);
        fdFeedbackSize.top = new FormAttachment((Control)this.wShowFeedback, this.margin);
        this.wFeedbackSize.setLayoutData((Object)fdFeedbackSize);
        Label wlUniqueConnections = new Label(wMiscComp, 131072);
        wlUniqueConnections.setText(BaseMessages.getString(PKG, (String)"TransDialog.UniqueConnections.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUniqueConnections);
        FormData fdlUniqueConnections = new FormData();
        fdlUniqueConnections.left = new FormAttachment(0, 0);
        fdlUniqueConnections.right = new FormAttachment(this.middle, -this.margin);
        fdlUniqueConnections.top = new FormAttachment((Control)this.wFeedbackSize, this.margin);
        wlUniqueConnections.setLayoutData((Object)fdlUniqueConnections);
        this.wUniqueConnections = new Button(wMiscComp, 32);
        this.props.setLook((Control)this.wUniqueConnections);
        this.wUniqueConnections.addSelectionListener((SelectionListener)this.lsModSel);
        FormData fdUniqueConnections = new FormData();
        fdUniqueConnections.left = new FormAttachment(this.middle, 0);
        fdUniqueConnections.top = new FormAttachment((Control)this.wFeedbackSize, this.margin);
        fdUniqueConnections.right = new FormAttachment(100, 0);
        this.wUniqueConnections.setLayoutData((Object)fdUniqueConnections);
        Label wlSharedObjectsFile = new Label(wMiscComp, 131072);
        wlSharedObjectsFile.setText(BaseMessages.getString(PKG, (String)"TransDialog.SharedObjectsFile.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSharedObjectsFile);
        FormData fdlSharedObjectsFile = new FormData();
        fdlSharedObjectsFile.left = new FormAttachment(0, 0);
        fdlSharedObjectsFile.right = new FormAttachment(this.middle, -this.margin);
        fdlSharedObjectsFile.top = new FormAttachment((Control)this.wUniqueConnections, this.margin);
        wlSharedObjectsFile.setLayoutData((Object)fdlSharedObjectsFile);
        this.wSharedObjectsFile = new TextVar((VariableSpace)this.transMeta, wMiscComp, 18436);
        wlSharedObjectsFile.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.SharedObjectsFile.Tooltip", (String[])new String[0]));
        this.wSharedObjectsFile.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.SharedObjectsFile.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wSharedObjectsFile);
        FormData fdSharedObjectsFile = new FormData();
        fdSharedObjectsFile.left = new FormAttachment(this.middle, 0);
        fdSharedObjectsFile.top = new FormAttachment((Control)this.wUniqueConnections, this.margin);
        fdSharedObjectsFile.right = new FormAttachment(100, 0);
        this.wSharedObjectsFile.setLayoutData(fdSharedObjectsFile);
        this.wSharedObjectsFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                TransDialog.this.sharedObjectsFileChanged = true;
            }
        });
        Label wlManageThreads = new Label(wMiscComp, 131072);
        wlManageThreads.setText(BaseMessages.getString(PKG, (String)"TransDialog.ManageThreadPriorities.Label", (String[])new String[0]));
        this.props.setLook((Control)wlManageThreads);
        FormData fdlManageThreads = new FormData();
        fdlManageThreads.left = new FormAttachment(0, 0);
        fdlManageThreads.top = new FormAttachment((Control)this.wSharedObjectsFile, this.margin);
        fdlManageThreads.right = new FormAttachment(this.middle, -this.margin);
        wlManageThreads.setLayoutData((Object)fdlManageThreads);
        this.wManageThreads = new Button(wMiscComp, 32);
        this.wManageThreads.addSelectionListener((SelectionListener)this.lsModSel);
        this.props.setLook((Control)this.wManageThreads);
        FormData fdManageThreads = new FormData();
        fdManageThreads.left = new FormAttachment(this.middle, 0);
        fdManageThreads.top = new FormAttachment((Control)this.wSharedObjectsFile, this.margin);
        fdManageThreads.right = new FormAttachment(100, 0);
        this.wManageThreads.setLayoutData((Object)fdManageThreads);
        Label wlTransformationType = new Label(wMiscComp, 131072);
        wlTransformationType.setText(BaseMessages.getString(PKG, (String)"TransDialog.TransformationType.Label", (String[])new String[0]));
        wlTransformationType.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.TransformationType.Tooltip", (String[])new String[]{Const.CR}));
        this.props.setLook((Control)wlTransformationType);
        FormData fdlTransformationType = new FormData();
        fdlTransformationType.left = new FormAttachment(0, 0);
        fdlTransformationType.right = new FormAttachment(this.middle, -this.margin);
        fdlTransformationType.top = new FormAttachment((Control)this.wManageThreads, this.margin);
        wlTransformationType.setLayoutData((Object)fdlTransformationType);
        this.wTransformationType = new CCombo(wMiscComp, 0);
        this.wTransformationType.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.TransformationType.Tooltip", (String[])new String[]{Const.CR}));
        this.wTransformationType.addSelectionListener((SelectionListener)this.lsModSel);
        this.props.setLook((Control)this.wTransformationType);
        FormData fdTransformationType = new FormData();
        fdTransformationType.left = new FormAttachment(this.middle, 0);
        fdTransformationType.top = new FormAttachment((Control)this.wManageThreads, this.margin);
        fdTransformationType.right = new FormAttachment(100, 0);
        this.wTransformationType.setLayoutData((Object)fdTransformationType);
        this.wTransformationType.setItems(TransMeta.TransformationType.getTransformationTypesDescriptions());
        FormData fdMiscComp = new FormData();
        fdMiscComp.left = new FormAttachment(0, 0);
        fdMiscComp.top = new FormAttachment(0, 0);
        fdMiscComp.right = new FormAttachment(100, 0);
        fdMiscComp.bottom = new FormAttachment(100, 0);
        wMiscComp.setLayoutData((Object)fdMiscComp);
        wMiscComp.layout();
        this.wMiscTab.setControl((Control)wMiscComp);
    }

    private void addMonitoringTab() {
        this.wMonitorTab = new CTabItem(this.wTabFolder, 0);
        this.wMonitorTab.setText(BaseMessages.getString(PKG, (String)"TransDialog.MonitorTab.Label", (String[])new String[0]));
        Composite wMonitorComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wMonitorComp);
        FormLayout monitorLayout = new FormLayout();
        monitorLayout.marginWidth = 5;
        monitorLayout.marginHeight = 5;
        wMonitorComp.setLayout((Layout)monitorLayout);
        Label wlEnableStepPerfMonitor = new Label(wMonitorComp, 16384);
        wlEnableStepPerfMonitor.setText(BaseMessages.getString(PKG, (String)"TransDialog.StepPerformanceMonitoring.Label", (String[])new String[0]));
        this.props.setLook((Control)wlEnableStepPerfMonitor);
        FormData fdlSchemaName = new FormData();
        fdlSchemaName.left = new FormAttachment(0, 0);
        fdlSchemaName.right = new FormAttachment(this.middle, -this.margin);
        fdlSchemaName.top = new FormAttachment(0, 0);
        wlEnableStepPerfMonitor.setLayoutData((Object)fdlSchemaName);
        this.wEnableStepPerfMonitor = new Button(wMonitorComp, 32);
        this.props.setLook((Control)this.wEnableStepPerfMonitor);
        FormData fdEnableStepPerfMonitor = new FormData();
        fdEnableStepPerfMonitor.left = new FormAttachment(this.middle, 0);
        fdEnableStepPerfMonitor.right = new FormAttachment(100, 0);
        fdEnableStepPerfMonitor.top = new FormAttachment(0, 0);
        this.wEnableStepPerfMonitor.setLayoutData((Object)fdEnableStepPerfMonitor);
        this.wEnableStepPerfMonitor.addSelectionListener((SelectionListener)this.lsModSel);
        this.wEnableStepPerfMonitor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TransDialog.this.setFlags();
            }
        });
        Label wlStepPerfInterval = new Label(wMonitorComp, 16384);
        wlStepPerfInterval.setText(BaseMessages.getString(PKG, (String)"TransDialog.StepPerformanceInterval.Label", (String[])new String[0]));
        this.props.setLook((Control)wlStepPerfInterval);
        FormData fdlStepPerfInterval = new FormData();
        fdlStepPerfInterval.left = new FormAttachment(0, 0);
        fdlStepPerfInterval.right = new FormAttachment(this.middle, -this.margin);
        fdlStepPerfInterval.top = new FormAttachment((Control)this.wEnableStepPerfMonitor, this.margin);
        wlStepPerfInterval.setLayoutData((Object)fdlStepPerfInterval);
        this.wStepPerfInterval = new Text(wMonitorComp, 18436);
        this.props.setLook((Control)this.wStepPerfInterval);
        FormData fdStepPerfInterval = new FormData();
        fdStepPerfInterval.left = new FormAttachment(this.middle, 0);
        fdStepPerfInterval.right = new FormAttachment(100, 0);
        fdStepPerfInterval.top = new FormAttachment((Control)this.wEnableStepPerfMonitor, this.margin);
        this.wStepPerfInterval.setLayoutData((Object)fdStepPerfInterval);
        this.wStepPerfInterval.addModifyListener(this.lsMod);
        Label wlStepPerfMaxSize = new Label(wMonitorComp, 16384);
        wlStepPerfMaxSize.setText(BaseMessages.getString(PKG, (String)"TransDialog.StepPerformanceMaxSize.Label", (String[])new String[0]));
        wlStepPerfMaxSize.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.StepPerformanceMaxSize.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wlStepPerfMaxSize);
        FormData fdlStepPerfMaxSize = new FormData();
        fdlStepPerfMaxSize.left = new FormAttachment(0, 0);
        fdlStepPerfMaxSize.right = new FormAttachment(this.middle, -this.margin);
        fdlStepPerfMaxSize.top = new FormAttachment((Control)this.wStepPerfInterval, this.margin);
        wlStepPerfMaxSize.setLayoutData((Object)fdlStepPerfMaxSize);
        this.wStepPerfMaxSize = new TextVar((VariableSpace)this.transMeta, wMonitorComp, 18436);
        this.wStepPerfMaxSize.setToolTipText(BaseMessages.getString(PKG, (String)"TransDialog.StepPerformanceMaxSize.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wStepPerfMaxSize);
        FormData fdStepPerfMaxSize = new FormData();
        fdStepPerfMaxSize.left = new FormAttachment(this.middle, 0);
        fdStepPerfMaxSize.right = new FormAttachment(100, 0);
        fdStepPerfMaxSize.top = new FormAttachment((Control)this.wStepPerfInterval, this.margin);
        this.wStepPerfMaxSize.setLayoutData(fdStepPerfMaxSize);
        this.wStepPerfMaxSize.addModifyListener(this.lsMod);
        FormData fdMonitorComp = new FormData();
        fdMonitorComp.left = new FormAttachment(0, 0);
        fdMonitorComp.top = new FormAttachment(0, 0);
        fdMonitorComp.right = new FormAttachment(100, 0);
        fdMonitorComp.bottom = new FormAttachment(100, 0);
        wMonitorComp.setLayoutData((Object)fdMonitorComp);
        wMonitorComp.layout();
        this.wMonitorTab.setControl((Control)wMonitorComp);
    }

    public void dispose() {
        this.shell.dispose();
    }

    public void getData() {
        this.wTransname.setText(Const.NVL((String)this.transMeta.getName(), (String)""));
        this.wTransFilename.setText(Const.NVL((String)this.transMeta.getFilename(), (String)""));
        this.wTransdescription.setText(Const.NVL((String)this.transMeta.getDescription(), (String)""));
        this.wExtendeddescription.setText(Const.NVL((String)this.transMeta.getExtendedDescription(), (String)""));
        this.wTransversion.setText(Const.NVL((String)this.transMeta.getTransversion(), (String)""));
        this.wTransstatus.select(this.transMeta.getTransstatus() - 1);
        if (this.transMeta.getCreatedUser() != null) {
            this.wCreateUser.setText(this.transMeta.getCreatedUser());
        }
        if (this.transMeta.getCreatedDate() != null) {
            this.wCreateDate.setText(this.transMeta.getCreatedDate().toString());
        }
        if (this.transMeta.getModifiedUser() != null) {
            this.wModUser.setText(this.transMeta.getModifiedUser());
        }
        if (this.transMeta.getModifiedDate() != null) {
            this.wModDate.setText(this.transMeta.getModifiedDate().toString());
        }
        if (this.transMeta.getMaxDateConnection() != null) {
            this.wMaxdateconnection.setText(this.transMeta.getMaxDateConnection().getName());
        }
        if (this.transMeta.getMaxDateTable() != null) {
            this.wMaxdatetable.setText(this.transMeta.getMaxDateTable());
        }
        if (this.transMeta.getMaxDateField() != null) {
            this.wMaxdatefield.setText(this.transMeta.getMaxDateField());
        }
        this.wMaxdateoffset.setText(Double.toString(this.transMeta.getMaxDateOffset()));
        this.wMaxdatediff.setText(Double.toString(this.transMeta.getMaxDateDifference()));
        for (int i = 0; i < this.transMeta.nrDependencies(); ++i) {
            TableItem item = this.wFields.table.getItem(i);
            TransDependency td = this.transMeta.getDependency(i);
            DatabaseMeta conn = td.getDatabase();
            String table = td.getTablename();
            String field = td.getFieldname();
            if (conn != null) {
                item.setText(1, conn.getName());
            }
            if (table != null) {
                item.setText(2, table);
            }
            if (field == null) continue;
            item.setText(3, field);
        }
        String[] parameters = this.transMeta.listParameters();
        for (int idx = 0; idx < parameters.length; ++idx) {
            String description;
            String defValue;
            TableItem item = this.wParamFields.table.getItem(idx);
            try {
                defValue = this.transMeta.getParameterDefault(parameters[idx]);
            }
            catch (UnknownParamException e) {
                defValue = "";
            }
            try {
                description = this.transMeta.getParameterDescription(parameters[idx]);
            }
            catch (UnknownParamException e) {
                description = "";
            }
            item.setText(1, parameters[idx]);
            item.setText(2, Const.NVL((String)defValue, (String)""));
            item.setText(3, Const.NVL((String)description, (String)""));
        }
        this.wSizeRowset.setText(Integer.toString(this.transMeta.getSizeRowset()));
        this.wUniqueConnections.setSelection(this.transMeta.isUsingUniqueConnections());
        this.wShowFeedback.setSelection(this.transMeta.isFeedbackShown());
        this.wFeedbackSize.setText(Integer.toString(this.transMeta.getFeedbackSize()));
        this.wSharedObjectsFile.setText(Const.NVL((String)this.transMeta.getSharedObjectsFile(), (String)""));
        this.wManageThreads.setSelection(this.transMeta.isUsingThreadPriorityManagment());
        this.wTransformationType.setText(this.transMeta.getTransformationType().getDescription());
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wParamFields.setRowNums();
        this.wParamFields.optWidth(true);
        if (this.transMeta.getRepositoryDirectory() != null && this.transMeta.getRepositoryDirectory().getPath() != null) {
            this.wDirectory.setText(this.transMeta.getRepositoryDirectory().getPath());
        }
        this.wEnableStepPerfMonitor.setSelection(this.transMeta.isCapturingStepPerformanceSnapShots());
        this.wStepPerfInterval.setText(Long.toString(this.transMeta.getStepPerformanceCapturingDelay()));
        this.wStepPerfMaxSize.setText(Const.NVL((String)this.transMeta.getStepPerformanceCapturingSizeLimit(), (String)""));
        this.wTransname.selectAll();
        this.wTransname.setFocus();
        for (TransDialogPluginInterface extraTab : this.extraTabs) {
            try {
                extraTab.getData(this.transMeta);
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error adding extra plugin tab", e);
            }
        }
        this.setFlags();
    }

    public void setFlags() {
        this.wbDirectory.setEnabled(this.rep != null);
        this.wlDirectory.setEnabled(this.rep != null);
    }

    private void cancel() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.transMeta = null;
        this.dispose();
    }

    private void ok() {
        TableItem item;
        int i;
        MessageBox mb;
        boolean OK = true;
        this.getLogInfo();
        this.transMeta.setTransLogTable(this.transLogTable);
        this.transMeta.setPerformanceLogTable(this.performanceLogTable);
        this.transMeta.setChannelLogTable(this.channelLogTable);
        this.transMeta.setStepLogTable(this.stepLogTable);
        this.transMeta.setMetricsLogTable(this.metricsLogTable);
        this.transMeta.setMaxDateConnection(this.transMeta.findDatabase(this.wMaxdateconnection.getText()));
        this.transMeta.setMaxDateTable(this.wMaxdatetable.getText());
        this.transMeta.setMaxDateField(this.wMaxdatefield.getText());
        this.transMeta.setName(this.wTransname.getText());
        this.transMeta.setDescription(this.wTransdescription.getText());
        this.transMeta.setExtendedDescription(this.wExtendeddescription.getText());
        this.transMeta.setTransversion(this.wTransversion.getText());
        if (this.wTransstatus.getSelectionIndex() != 2) {
            this.transMeta.setTransstatus(this.wTransstatus.getSelectionIndex() + 1);
        } else {
            this.transMeta.setTransstatus(-1);
        }
        try {
            this.transMeta.setMaxDateOffset(Double.parseDouble(this.wMaxdateoffset.getText()));
        }
        catch (Exception e) {
            mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"TransDialog.InvalidOffsetNumber.DialogTitle", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"TransDialog.InvalidOffsetNumber.DialogMessage", (String[])new String[0]));
            mb.open();
            this.wMaxdateoffset.setFocus();
            this.wMaxdateoffset.selectAll();
            OK = false;
        }
        try {
            this.transMeta.setMaxDateDifference(Double.parseDouble(this.wMaxdatediff.getText()));
        }
        catch (Exception e) {
            mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"TransDialog.InvalidDateDifferenceNumber.DialogTitle", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"TransDialog.InvalidDateDifferenceNumber.DialogMessage", (String[])new String[0]));
            mb.open();
            this.wMaxdatediff.setFocus();
            this.wMaxdatediff.selectAll();
            OK = false;
        }
        this.transMeta.removeAllDependencies();
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        for (i = 0; i < nrNonEmptyFields; ++i) {
            item = this.wFields.getNonEmpty(i);
            DatabaseMeta db = this.transMeta.findDatabase(item.getText(1));
            String tablename = item.getText(2);
            String fieldname = item.getText(3);
            TransDependency td = new TransDependency(db, tablename, fieldname);
            this.transMeta.addDependency(td);
        }
        this.transMeta.eraseParameters();
        nrNonEmptyFields = this.wParamFields.nrNonEmpty();
        for (i = 0; i < nrNonEmptyFields; ++i) {
            item = this.wParamFields.getNonEmpty(i);
            try {
                this.transMeta.addParameterDefinition(item.getText(1), item.getText(2), item.getText(3));
                continue;
            }
            catch (DuplicateParamException e) {
                // empty catch block
            }
        }
        this.transMeta.activateParameters();
        this.transMeta.setSizeRowset(Const.toInt((String)this.wSizeRowset.getText(), (int)10000));
        this.transMeta.setUsingUniqueConnections(this.wUniqueConnections.getSelection());
        this.transMeta.setFeedbackShown(this.wShowFeedback.getSelection());
        this.transMeta.setFeedbackSize(Const.toInt((String)this.wFeedbackSize.getText(), (int)50000));
        this.transMeta.setSharedObjectsFile(this.wSharedObjectsFile.getText());
        this.transMeta.setUsingThreadPriorityManagment(this.wManageThreads.getSelection());
        this.transMeta.setTransformationType(TransMeta.TransformationType.values()[Const.indexOfString((String)this.wTransformationType.getText(), (String[])TransMeta.TransformationType.getTransformationTypesDescriptions())]);
        if (this.directoryChangeAllowed && this.transMeta.getObjectId() != null) {
            if (this.newDirectory != null) {
                RepositoryDirectoryInterface dirFrom = this.transMeta.getRepositoryDirectory();
                try {
                    ObjectId newId = this.rep.renameTransformation(this.transMeta.getObjectId(), this.newDirectory, this.transMeta.getName());
                    this.transMeta.setObjectId(newId);
                    this.transMeta.setRepositoryDirectory(this.newDirectory);
                }
                catch (KettleException ke) {
                    this.transMeta.setRepositoryDirectory(dirFrom);
                    OK = false;
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransDialog.ErrorMovingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransDialog.ErrorMovingTransformation.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
                }
            }
        } else if (this.newDirectory != null) {
            this.transMeta.setRepositoryDirectory(this.newDirectory);
        }
        this.transMeta.setCapturingStepPerformanceSnapShots(this.wEnableStepPerfMonitor.getSelection());
        this.transMeta.setStepPerformanceCapturingSizeLimit(this.wStepPerfMaxSize.getText());
        try {
            long stepPerformanceCapturingDelay = Long.parseLong(this.wStepPerfInterval.getText());
            if (stepPerformanceCapturingDelay <= 0L && this.transMeta.isCapturingStepPerformanceSnapShots()) {
                throw new KettleException();
            }
            if (stepPerformanceCapturingDelay <= 0L) {
                stepPerformanceCapturingDelay = 1000L;
            }
            this.transMeta.setStepPerformanceCapturingDelay(stepPerformanceCapturingDelay);
        }
        catch (Exception e) {
            MessageBox mb2 = new MessageBox(this.shell, 33);
            mb2.setText(BaseMessages.getString(PKG, (String)"TransDialog.InvalidStepPerfIntervalNumber.DialogTitle", (String[])new String[0]));
            mb2.setMessage(BaseMessages.getString(PKG, (String)"TransDialog.InvalidStepPerfIntervalNumber.DialogMessage", (String[])new String[0]));
            mb2.open();
            this.wStepPerfInterval.setFocus();
            this.wStepPerfInterval.selectAll();
            OK = false;
        }
        for (TransDialogPluginInterface extraTab : this.extraTabs) {
            try {
                extraTab.ok(this.transMeta);
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error getting information from extra plugin tab", e);
            }
        }
        if (OK) {
            this.transMeta.setChanged(this.changed || this.transMeta.hasChanged());
            this.dispose();
        }
    }

    private void get() {
        Table table = this.wFields.table;
        for (int i = 0; i < this.transMeta.nrSteps(); ++i) {
            StepMeta stepMeta = this.transMeta.getStep(i);
            String con = null;
            String tab = null;
            TableItem item = null;
            StepMetaInterface sii = stepMeta.getStepMetaInterface();
            if (sii instanceof TableInputMeta) {
                TableInputMeta tii = (TableInputMeta)stepMeta.getStepMetaInterface();
                if (tii.getDatabaseMeta() == null) {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"TransDialog.DatabaseMetaNotSet.Text", (String[])new String[0]));
                    mb.open();
                    return;
                }
                con = tii.getDatabaseMeta().getName();
                tab = this.getTableFromSQL(tii.getSQL());
                if (tab == null) {
                    tab = stepMeta.getName();
                }
            }
            if (sii instanceof DatabaseLookupMeta) {
                DatabaseLookupMeta dvli = (DatabaseLookupMeta)stepMeta.getStepMetaInterface();
                con = dvli.getDatabaseMeta().getName();
                tab = dvli.getTablename();
                if (tab != null) break;
                tab = stepMeta.getName();
                break;
            }
            if (tab == null && con == null) continue;
            item = new TableItem(table, 0);
            if (con != null) {
                item.setText(1, con);
            }
            if (tab == null) continue;
            item.setText(2, tab);
        }
        this.wFields.setRowNums();
    }

    private String getTableFromSQL(String sql) {
        if (sql == null) {
            return null;
        }
        int idxfrom = sql.toUpperCase().indexOf("FROM");
        int idxto = sql.toUpperCase().indexOf("WHERE");
        if (idxfrom == -1) {
            return null;
        }
        if (idxto == -1) {
            idxto = sql.length();
        }
        return sql.substring(idxfrom + 5, idxto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sql() {
        this.getLogInfo();
        try {
            boolean allOK = true;
            for (LogTableInterface logTable : new LogTableInterface[]{this.transLogTable, this.performanceLogTable, this.channelLogTable, this.stepLogTable, this.metricsLogTable}) {
                if (logTable.getDatabaseMeta() == null || Const.isEmpty((String)logTable.getTableName())) continue;
                Database db = null;
                try {
                    db = new Database((LoggingObjectInterface)this.transMeta, logTable.getDatabaseMeta());
                    db.shareVariablesWith((VariableSpace)this.transMeta);
                    db.connect();
                    StringBuilder ddl = new StringBuilder();
                    RowMetaInterface fields = logTable.getLogRecord(LogStatus.START, null, null).getRowMeta();
                    String tableName = db.environmentSubstitute(logTable.getTableName());
                    String schemaTable = logTable.getDatabaseMeta().getQuotedSchemaTableCombination(db.environmentSubstitute(logTable.getSchemaName()), tableName);
                    String createTable = db.getDDL(schemaTable, fields);
                    if (!Const.isEmpty((String)createTable)) {
                        ddl.append("-- ").append(logTable.getLogTableType()).append(Const.CR);
                        ddl.append("--").append(Const.CR).append(Const.CR);
                        ddl.append(createTable).append(Const.CR);
                    }
                    List indexes = logTable.getRecommendedIndexes();
                    for (int i = 0; i < indexes.size(); ++i) {
                        String createIndex;
                        RowMetaInterface index = (RowMetaInterface)indexes.get(i);
                        if (index.isEmpty() || Const.isEmpty((String)(createIndex = db.getCreateIndexStatement(schemaTable, "IDX_" + tableName + "_" + (i + 1), index.getFieldNames(), false, false, false, true)))) continue;
                        ddl.append(createIndex);
                    }
                    if (ddl.length() <= 0) continue;
                    allOK = false;
                    SQLEditor sqledit = new SQLEditor((VariableSpace)this.transMeta, this.shell, 0, logTable.getDatabaseMeta(), this.transMeta.getDbCache(), ddl.toString());
                    sqledit.open();
                }
                finally {
                    if (db != null) {
                        db.disconnect();
                    }
                }
            }
            if (allOK) {
                MessageBox mb = new MessageBox(this.shell, 34);
                mb.setText(BaseMessages.getString(PKG, (String)"TransDialog.NoSqlNedds.DialogTitle", (String[])new String[0]));
                mb.setMessage(BaseMessages.getString(PKG, (String)"TransDialog.NoSqlNedds.DialogMessage", (String[])new String[0]));
                mb.open();
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransDialog.ErrorOccurred.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransDialog.ErrorOccurred.DialogMessage", (String[])new String[0]), e);
        }
    }

    private void getLogInfo() {
        this.getTransLogTableOptions();
        this.getPerformanceLogTableOptions();
        this.getChannelLogTableOptions();
        this.getStepLogTableOptions();
        this.getMetricsLogTableOptions();
    }

    public boolean isSharedObjectsFileChanged() {
        return this.sharedObjectsFileChanged;
    }

    public void setDirectoryChangeAllowed(boolean directoryChangeAllowed) {
        this.directoryChangeAllowed = directoryChangeAllowed;
    }

    private void setCurrentTab(Tabs currentTab) {
        switch (currentTab) {
            case PARAM_TAB: {
                this.wTabFolder.setSelection(this.wParamTab);
                break;
            }
            case MISC_TAB: {
                this.wTabFolder.setSelection(this.wMiscTab);
                break;
            }
            case DATE_TAB: {
                this.wTabFolder.setSelection(this.wDateTab);
                break;
            }
            case LOG_TAB: {
                this.wTabFolder.setSelection(this.wLogTab);
                break;
            }
            case DEP_TAB: {
                this.wTabFolder.setSelection(this.wDepTab);
                break;
            }
            case MONITOR_TAB: {
                this.wTabFolder.setSelection(this.wMonitorTab);
                break;
            }
            case EXTRA_TAB: {
                if (this.extraTabs.size() <= 0) break;
                this.wTabFolder.setSelection(this.extraTabs.get(0).getTab());
                break;
            }
            default: {
                this.wTabFolder.setSelection(this.wTransTab);
            }
        }
    }

    public static enum Tabs {
        TRANS_TAB,
        PARAM_TAB,
        LOG_TAB,
        DATE_TAB,
        DEP_TAB,
        MISC_TAB,
        MONITOR_TAB,
        EXTRA_TAB;

    }
}

