/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.dialog;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.ProgressMonitorAdapter;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.trans.dialog.TransDialog;

public class TransLoadProgressDialog {
    private static Class<?> PKG = TransDialog.class;
    private Shell shell;
    private Repository rep;
    private String transname;
    private RepositoryDirectoryInterface repdir;
    private TransMeta transInfo;
    private ObjectId objectId;
    private String versionLabel;

    public TransLoadProgressDialog(Shell shell, Repository rep, String transname, RepositoryDirectoryInterface repdir, String versionLabel) {
        this.shell = shell;
        this.rep = rep;
        this.transname = transname;
        this.repdir = repdir;
        this.versionLabel = versionLabel;
        this.transInfo = null;
    }

    public TransLoadProgressDialog(Shell shell, Repository rep, ObjectId objectId, String versionLabel) {
        this.shell = shell;
        this.rep = rep;
        this.objectId = objectId;
        this.versionLabel = versionLabel;
        this.transInfo = null;
    }

    public TransMeta open() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    if (TransLoadProgressDialog.this.objectId != null) {
                        TransLoadProgressDialog.this.transInfo = TransLoadProgressDialog.this.rep.loadTransformation(TransLoadProgressDialog.this.objectId, TransLoadProgressDialog.this.versionLabel);
                    } else {
                        TransLoadProgressDialog.this.transInfo = TransLoadProgressDialog.this.rep.loadTransformation(TransLoadProgressDialog.this.transname, TransLoadProgressDialog.this.repdir, (ProgressMonitorListener)new ProgressMonitorAdapter(monitor), true, TransLoadProgressDialog.this.versionLabel);
                    }
                }
                catch (KettleException e) {
                    throw new InvocationTargetException(e, BaseMessages.getString((Class)PKG, (String)"TransLoadProgressDialog.Exception.ErrorLoadingTransformation", (String[])new String[0]));
                }
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(false, false, op);
        }
        catch (InvocationTargetException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransLoadProgressDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLoadProgressDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), e);
            this.transInfo = null;
        }
        catch (InterruptedException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransLoadProgressDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLoadProgressDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), e);
            this.transInfo = null;
        }
        return this.transInfo;
    }
}

