/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.step;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.laf.BasePropertyHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.core.database.wizard.CreateDatabaseWizard;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.ShowBrowserDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;
import org.pentaho.metastore.api.IMetaStore;

public class BaseStepDialog
extends Dialog {
    private static Class<?> PKG = StepInterface.class;
    public static final LoggingObjectInterface loggingObject = new SimpleLoggingObject("Step dialog", LoggingObjectType.STEPDIALOG, null);
    protected static VariableSpace variables = new Variables();
    protected String stepname;
    protected Label wlStepname;
    protected Text wStepname;
    protected FormData fdlStepname;
    protected FormData fdStepname;
    protected Button wOK;
    protected Button wGet;
    protected Button wPreview;
    protected Button wSQL;
    protected Button wCreate;
    protected Button wCancel;
    protected FormData fdOK;
    protected FormData fdGet;
    protected FormData fdPreview;
    protected FormData fdSQL;
    protected FormData fdCreate;
    protected FormData fdCancel;
    protected Listener lsOK;
    protected Listener lsGet;
    protected Listener lsPreview;
    protected Listener lsSQL;
    protected Listener lsCreate;
    protected Listener lsCancel;
    protected TransMeta transMeta;
    protected Shell shell;
    protected SelectionAdapter lsDef;
    protected Listener lsResize;
    protected boolean changed;
    protected boolean backupChanged;
    protected StepMetaInterface baseStepMeta;
    protected PropsUI props;
    protected Repository repository;
    protected IMetaStore metaStore;
    protected StepMeta stepMeta;
    protected LogChannel log;
    protected static final int BUTTON_ALIGNMENT_CENTER = 0;
    protected static final int BUTTON_ALIGNMENT_LEFT = 1;
    protected static final int BUTTON_ALIGNMENT_RIGHT = 2;
    protected static int buttonAlignment = 0;
    protected DatabaseDialog databaseDialog;

    public BaseStepDialog(Shell parent, BaseStepMeta baseStepMeta, TransMeta transMeta, String stepname) {
        super(parent, 0);
        this.log = new LogChannel((Object)baseStepMeta);
        this.transMeta = transMeta;
        this.stepname = stepname;
        this.stepMeta = transMeta.findStep(stepname);
        this.baseStepMeta = (StepMetaInterface)baseStepMeta;
        this.backupChanged = baseStepMeta.hasChanged();
        this.props = PropsUI.getInstance();
    }

    public BaseStepDialog(Shell parent, StepMetaInterface baseStepMeta, TransMeta transMeta, String stepname) {
        super(parent, 0);
        this.log = new LogChannel((Object)baseStepMeta);
        this.transMeta = transMeta;
        this.stepname = stepname;
        this.stepMeta = transMeta.findStep(stepname);
        this.baseStepMeta = baseStepMeta;
        this.backupChanged = baseStepMeta.hasChanged();
        this.props = PropsUI.getInstance();
    }

    public BaseStepDialog(Shell parent, int nr, BaseStepMeta in, TransMeta tr) {
        this(parent, in, tr, null);
    }

    public void setShellImage(Shell shell, StepMetaInterface stepMetaInterface) {
        try {
            String id;
            PluginInterface plugin = PluginRegistry.getInstance().getPlugin(StepPluginType.class, (Object)this.stepMeta.getStepMetaInterface());
            if (!Const.isEmpty((String)plugin.getDocumentationUrl())) {
                this.createHelpButton(shell, this.stepMeta, plugin);
            }
            if ((id = plugin.getIds()[0]) != null) {
                shell.setImage(GUIResource.getInstance().getImagesSteps().get(id));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void setSize() {
        BaseStepDialog.setSize(this.shell);
    }

    protected void setButtonPositions(Button[] buttons, int margin, Control lastControl) {
        BaseStepDialog.positionBottomButtons((Composite)this.shell, buttons, margin, lastControl);
    }

    public static final void positionBottomButtons(Composite composite, Button[] buttons, int margin, Control lastControl) {
        Rectangle largest = null;
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].pack(true);
            Rectangle r = buttons[i].getBounds();
            if (largest == null || r.width > largest.width) {
                largest = r;
            }
            if (buttons[i].getToolTipText() != null) continue;
            buttons[i].setToolTipText(Const.replace((String)buttons[i].getText(), (String)"&", (String)""));
        }
        largest.width += 10;
        if (largest.width % 2 == 1) {
            ++largest.width;
        }
        switch (buttonAlignment) {
            case 0: {
                BaseStepDialog.centerButtons(buttons, largest.width, margin, lastControl);
                break;
            }
            case 1: {
                BaseStepDialog.leftAlignButtons(buttons, largest.width, margin, lastControl);
                break;
            }
            case 2: {
                BaseStepDialog.rightAlignButtons(buttons, largest.width, margin, lastControl);
                break;
            }
        }
        if (Const.isOSX()) {
            Shell parentShell = composite.getShell();
            final ArrayList<TableView> tableViews = new ArrayList<TableView>();
            BaseStepDialog.getTableViews((Control)parentShell, tableViews);
            for (Button button : buttons) {
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        for (TableView view : tableViews) {
                            view.applyOSXChanges();
                        }
                    }
                });
            }
        }
    }

    private static final void getTableViews(Control parentControl, List<TableView> tableViews) {
        block3: {
            Control[] children;
            block4: {
                Control[] children2;
                block2: {
                    if (!(parentControl instanceof TableView)) break block2;
                    tableViews.add((TableView)parentControl);
                    break block3;
                }
                if (!(parentControl instanceof Composite)) break block4;
                for (Control child : children2 = ((Composite)parentControl).getChildren()) {
                    BaseStepDialog.getTableViews(child, tableViews);
                }
                break block3;
            }
            if (!(parentControl instanceof Shell)) break block3;
            for (Control child : children = ((Shell)parentControl).getChildren()) {
                BaseStepDialog.getTableViews(child, tableViews);
            }
        }
    }

    protected static int getButtonAlignment() {
        String buttonAlign = BasePropertyHandler.getProperty((String)"Button_Position", (String)"center").toLowerCase();
        if ("center".equals(buttonAlign)) {
            return 0;
        }
        if ("left".equals(buttonAlign)) {
            return 1;
        }
        return 2;
    }

    private static FormData createDefaultFormData(Button button, int width, int margin, Control lastControl) {
        FormData formData = new FormData();
        if (lastControl != null) {
            formData.top = new FormAttachment(lastControl, margin * 3);
        } else {
            formData.bottom = new FormAttachment(100, 0);
        }
        formData.right = new FormAttachment((Control)button, width + margin);
        return formData;
    }

    protected static void leftAlignButtons(Button[] buttons, int width, int margin, Control lastControl) {
        for (int i = 0; i < buttons.length; ++i) {
            FormData formData = BaseStepDialog.createDefaultFormData(buttons[i], width, margin, lastControl);
            formData.left = i == 0 ? new FormAttachment(0, margin) : new FormAttachment((Control)buttons[i - 1], margin);
            buttons[i].setLayoutData((Object)formData);
        }
    }

    protected static void rightAlignButtons(Button[] buttons, int width, int margin, Control lastControl) {
        for (int i = buttons.length - 1; i >= 0; --i) {
            FormData formData = BaseStepDialog.createDefaultFormData(buttons[i], width, margin, lastControl);
            formData.left = i == buttons.length - 1 ? new FormAttachment(100, -(width + margin)) : new FormAttachment((Control)buttons[i + 1], -(2 * (width + margin)) - margin);
            buttons[i].setLayoutData((Object)formData);
        }
    }

    protected static void centerButtons(Button[] buttons, int width, int margin, Control lastControl) {
        int i;
        int middleButtonIndex = buttons.length / 2;
        FormData formData = BaseStepDialog.createDefaultFormData(buttons[middleButtonIndex], width, margin, lastControl);
        int leftOffset = 0;
        leftOffset = buttons.length % 2 == 0 ? margin : -(width + margin) / 2;
        formData.left = new FormAttachment(50, leftOffset);
        buttons[middleButtonIndex].setLayoutData((Object)formData);
        for (i = middleButtonIndex + 1; i < buttons.length; ++i) {
            formData = BaseStepDialog.createDefaultFormData(buttons[i], width, margin, lastControl);
            formData.left = new FormAttachment((Control)buttons[i - 1], margin);
            buttons[i].setLayoutData((Object)formData);
        }
        for (i = middleButtonIndex - 1; i >= 0; --i) {
            formData = BaseStepDialog.createDefaultFormData(buttons[i], width, margin, lastControl);
            formData.left = new FormAttachment((Control)buttons[i + 1], -(2 * (width + margin)) - margin);
            buttons[i].setLayoutData((Object)formData);
        }
    }

    public static final ModifyListener getModifyListenerTooltipText(final Text textField) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                textField.setToolTipText(variables.environmentSubstitute(textField.getText()));
            }
        };
    }

    public void addDatabases(CCombo wConnection) {
        this.addDatabases(wConnection, null);
    }

    public void addDatabases(CCombo wConnection, Class<? extends DatabaseInterface> databaseType) {
        for (int i = 0; i < this.transMeta.nrDatabases(); ++i) {
            DatabaseMeta ci = this.transMeta.getDatabase(i);
            if (databaseType != null && !ci.getDatabaseInterface().getClass().equals(databaseType)) continue;
            wConnection.add(ci.getName());
        }
    }

    public void selectDatabase(CCombo wConnection, String name) {
        int idx = wConnection.indexOf(name);
        if (idx >= 0) {
            wConnection.select(idx);
        }
    }

    public CCombo addConnectionLine(Composite parent, Control previous, int middle, int margin) {
        return this.addConnectionLine(parent, previous, middle, margin, null);
    }

    public CCombo addConnectionLine(Composite parent, Control previous, int middle, int margin, Class<? extends DatabaseInterface> databaseType) {
        return this.addConnectionLine(parent, previous, middle, margin, new Label(parent, 131072), new Button(parent, 8), new Button(parent, 8), new Button(parent, 8), databaseType);
    }

    public CCombo addConnectionLine(Composite parent, Control previous, int middle, int margin, Label wlConnection, Button wbwConnection, Button wbnConnection, Button wbeConnection) {
        return this.addConnectionLine(parent, previous, middle, margin, wlConnection, wbwConnection, wbnConnection, wbeConnection, null);
    }

    public CCombo addConnectionLine(Composite parent, Control previous, int middle, int margin, Label wlConnection, Button wbwConnection, Button wbnConnection, Button wbeConnection, final Class<? extends DatabaseInterface> databaseType) {
        final CCombo wConnection = new CCombo(parent, 2056);
        this.props.setLook((Control)wConnection);
        this.addDatabases(wConnection);
        wlConnection.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.Connection.Label", (String[])new String[0]));
        this.props.setLook((Control)wlConnection);
        FormData fdlConnection = new FormData();
        fdlConnection.left = new FormAttachment(0, 0);
        fdlConnection.right = new FormAttachment(middle, -margin);
        fdlConnection.top = previous != null ? new FormAttachment(previous, margin) : new FormAttachment(0, 0);
        wlConnection.setLayoutData((Object)fdlConnection);
        wbwConnection.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.WizardConnectionButton.Label", (String[])new String[0]));
        wbwConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateDatabaseWizard cdw = new CreateDatabaseWizard();
                DatabaseMeta newDBInfo = cdw.createAndRunDatabaseWizard(BaseStepDialog.this.shell, BaseStepDialog.this.props, BaseStepDialog.this.transMeta.getDatabases());
                if (newDBInfo != null) {
                    BaseStepDialog.this.transMeta.addDatabase(newDBInfo);
                    wConnection.removeAll();
                    BaseStepDialog.this.addDatabases(wConnection);
                    BaseStepDialog.this.selectDatabase(wConnection, newDBInfo.getName());
                }
            }
        });
        FormData fdbwConnection = new FormData();
        fdbwConnection.right = new FormAttachment(100, 0);
        fdbwConnection.top = previous != null ? new FormAttachment(previous, margin) : new FormAttachment(0, 0);
        wbwConnection.setLayoutData((Object)fdbwConnection);
        wbnConnection.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.NewConnectionButton.Label", (String[])new String[0]));
        wbnConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseMeta databaseMeta = new DatabaseMeta();
                databaseMeta.shareVariablesWith((VariableSpace)BaseStepDialog.this.transMeta);
                DatabaseDialog cid = BaseStepDialog.this.getDatabaseDialog(BaseStepDialog.this.shell);
                cid.setDatabaseMeta(databaseMeta);
                cid.setModalDialog(true);
                if (cid.open() != null) {
                    BaseStepDialog.this.transMeta.addDatabase(databaseMeta);
                    wConnection.removeAll();
                    BaseStepDialog.this.addDatabases(wConnection, databaseType);
                    BaseStepDialog.this.selectDatabase(wConnection, databaseMeta.getName());
                }
            }
        });
        FormData fdbConnection = new FormData();
        fdbConnection.right = new FormAttachment((Control)wbwConnection, -margin);
        fdbConnection.top = previous != null ? new FormAttachment(previous, margin) : new FormAttachment(0, 0);
        wbnConnection.setLayoutData((Object)fdbConnection);
        wbeConnection.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.EditConnectionButton.Label", (String[])new String[0]));
        wbeConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseMeta databaseMeta = BaseStepDialog.this.transMeta.findDatabase(wConnection.getText());
                if (databaseMeta != null) {
                    databaseMeta.shareVariablesWith((VariableSpace)BaseStepDialog.this.transMeta);
                    DatabaseDialog cid = BaseStepDialog.this.getDatabaseDialog(BaseStepDialog.this.shell);
                    cid.setDatabaseMeta(databaseMeta);
                    cid.setModalDialog(true);
                    if (cid.open() != null) {
                        wConnection.removeAll();
                        BaseStepDialog.this.addDatabases(wConnection);
                        BaseStepDialog.this.selectDatabase(wConnection, databaseMeta.getName());
                    }
                }
            }
        });
        FormData fdeConnection = new FormData();
        fdeConnection.right = new FormAttachment((Control)wbnConnection, -margin);
        fdeConnection.top = previous != null ? new FormAttachment(previous, margin) : new FormAttachment(0, 0);
        wbeConnection.setLayoutData((Object)fdeConnection);
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(middle, 0);
        fdConnection.top = previous != null ? new FormAttachment(previous, margin) : new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment((Control)wbeConnection, -margin);
        wConnection.setLayoutData((Object)fdConnection);
        return wConnection;
    }

    protected DatabaseDialog getDatabaseDialog(Shell shell) {
        if (this.databaseDialog == null) {
            this.databaseDialog = new DatabaseDialog(shell);
        }
        return this.databaseDialog;
    }

    public void storeScreenSize() {
        this.props.setScreen(new WindowProperty(this.shell));
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public static void setMinimalShellHeight(Shell shell, Control[] controls, int margin, int extra) {
        int height = 0;
        for (int i = 0; i < controls.length; ++i) {
            Rectangle bounds = controls[i].getBounds();
            height += bounds.height + margin;
        }
        shell.setSize(shell.getBounds().width, height += extra);
    }

    public static void setSize(Shell shell) {
        BaseStepDialog.setSize(shell, -1, -1, true);
    }

    public static void setSize(Shell shell, int minWidth, int minHeight, boolean packIt) {
        PropsUI props = PropsUI.getInstance();
        WindowProperty winprop = props.getScreen(shell.getText());
        if (winprop != null) {
            winprop.setShell(shell, minWidth, minHeight);
        } else {
            if (packIt) {
                shell.pack();
            } else {
                shell.layout();
            }
            winprop = new WindowProperty(shell);
            winprop.setShell(shell, minWidth, minHeight);
            Rectangle shellBounds = shell.getBounds();
            Monitor monitor = shell.getDisplay().getPrimaryMonitor();
            if (shell.getParent() != null) {
                monitor = shell.getParent().getMonitor();
            }
            Rectangle monitorClientArea = monitor.getClientArea();
            int middleX = monitorClientArea.x + (monitorClientArea.width - shellBounds.width) / 2;
            int middleY = monitorClientArea.y + (monitorClientArea.height - shellBounds.height) / 2;
            shell.setLocation(middleX, middleY);
        }
    }

    public static final void setTraverseOrder(final Control[] controls) {
        for (int i = 0; i < controls.length; ++i) {
            final int controlNr = i;
            if (i < controls.length - 1) {
                controls[i].addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent te) {
                        te.doit = false;
                        int thisOne = controlNr + 1;
                        while (!controls[thisOne].isEnabled()) {
                            if (++thisOne >= controls.length) {
                                thisOne = 0;
                            }
                            if (thisOne != controlNr) continue;
                            return;
                        }
                        controls[thisOne].setFocus();
                    }
                });
                continue;
            }
            controls[i].addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent te) {
                    te.doit = false;
                    int thisOne = 0;
                    while (!controls[thisOne].isEnabled()) {
                        if (++thisOne < controls.length) continue;
                        return;
                    }
                    controls[thisOne].setFocus();
                }
            });
        }
    }

    public static final void getFieldsFromPrevious(TransMeta transMeta, StepMeta stepMeta, TableView tableView, int keyColumn, int[] nameColumn, int[] dataTypeColumn, int lengthColumn, int precisionColumn, TableItemInsertListener listener) {
        try {
            RowMetaInterface row = transMeta.getPrevStepFields(stepMeta);
            if (row != null) {
                BaseStepDialog.getFieldsFromPrevious(row, tableView, keyColumn, nameColumn, dataTypeColumn, lengthColumn, precisionColumn, listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(tableView.getShell(), BaseMessages.getString(PKG, (String)"BaseStepDialog.FailedToGetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.FailedToGetFields.Message", (String[])new String[]{stepMeta.getName()}), (Exception)((Object)ke));
        }
    }

    public static final void getFieldsFromPrevious(RowMetaInterface row, TableView tableView, int keyColumn, int[] nameColumn, int[] dataTypeColumn, int lengthColumn, int precisionColumn, TableItemInsertListener listener) {
        if (row == null || row.size() == 0) {
            return;
        }
        Table table = tableView.table;
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < table.getItemCount(); ++i) {
            TableItem tableItem = table.getItem(i);
            String key = tableItem.getText(keyColumn);
            if (Const.isEmpty((String)key) || keys.indexOf(key) >= 0) continue;
            keys.add(key);
        }
        int choice = 0;
        if (keys.size() > 0) {
            MessageDialog md = new MessageDialog(tableView.getShell(), BaseMessages.getString(PKG, (String)"BaseStepDialog.GetFieldsChoice.Title", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"BaseStepDialog.GetFieldsChoice.Message", (String[])new String[]{"" + keys.size(), "" + row.size()}), 4, new String[]{BaseMessages.getString(PKG, (String)"BaseStepDialog.AddNew", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.Add", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.ClearAndAdd", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.Cancel", (String[])new String[0])}, 0);
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            int idx = md.open();
            choice = idx & 0xFF;
        }
        if (choice == 3 || choice == 255) {
            return;
        }
        if (choice == 2) {
            tableView.clearAll(false);
        }
        for (int i = 0; i < row.size(); ++i) {
            int c;
            ValueMetaInterface v = row.getValueMeta(i);
            boolean add = true;
            if (choice == 0 && keys.indexOf(v.getName()) >= 0) {
                add = false;
            }
            if (!add) continue;
            TableItem tableItem = new TableItem(table, 0);
            for (c = 0; c < nameColumn.length; ++c) {
                tableItem.setText(nameColumn[c], Const.NVL((String)v.getName(), (String)""));
            }
            if (dataTypeColumn != null) {
                for (c = 0; c < dataTypeColumn.length; ++c) {
                    tableItem.setText(dataTypeColumn[c], v.getTypeDesc());
                }
            }
            if (lengthColumn > 0 && v.getLength() >= 0) {
                tableItem.setText(lengthColumn, Integer.toString(v.getLength()));
            }
            if (precisionColumn > 0 && v.getPrecision() >= 0) {
                tableItem.setText(precisionColumn, Integer.toString(v.getPrecision()));
            }
            if (listener == null || listener.tableItemInserted(tableItem, v)) continue;
            tableItem.dispose();
        }
        tableView.removeEmptyRows();
        tableView.setRowNums();
        tableView.optWidth(true);
    }

    public static final void getFieldsFromPrevious(ComboVar comboVar, TransMeta transMeta, StepMeta stepMeta) {
        String selectedField = null;
        int indexField = -1;
        try {
            RowMetaInterface r = transMeta.getPrevStepFields(stepMeta);
            selectedField = comboVar.getText();
            comboVar.removeAll();
            if (r != null && !r.isEmpty()) {
                r.getFieldNames();
                comboVar.setItems(r.getFieldNames());
                indexField = r.indexOfValue(selectedField);
            }
            if (indexField > -1) {
                comboVar.select(indexField);
            } else if (selectedField != null) {
                comboVar.setText(selectedField);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(comboVar.getShell(), BaseMessages.getString(PKG, (String)"BaseStepDialog.FailedToGetFieldsPrevious.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.FailedToGetFieldsPrevious.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public static final void generateFieldMapping(Shell shell, RowMetaInterface sourceFields, RowMetaInterface targetFields, List<SourceToTargetMapping> fieldMapping) throws KettleException {
        String[] source = sourceFields.getFieldNames();
        int i = 0;
        while (i < source.length) {
            ValueMetaInterface v = sourceFields.getValueMeta(i);
            int n = i++;
            source[n] = source[n] + "            (" + v.getOrigin() + ")";
        }
        String[] target = targetFields.getFieldNames();
        EnterMappingDialog dialog = new EnterMappingDialog(shell, source, target, fieldMapping);
        List<SourceToTargetMapping> newMapping = dialog.open();
        if (newMapping != null) {
            fieldMapping.clear();
            fieldMapping.addAll(newMapping);
        }
    }

    public boolean isBasic() {
        return this.log.isBasic();
    }

    public boolean isDetailed() {
        return this.log.isDetailed();
    }

    public boolean isDebug() {
        return this.log.isDebug();
    }

    public boolean isRowLevel() {
        return this.log.isRowLevel();
    }

    public void logMinimal(String message) {
        this.log.logMinimal(message);
    }

    public void logMinimal(String message, Object ... arguments) {
        this.log.logMinimal(message, arguments);
    }

    public void logBasic(String message) {
        this.log.logBasic(message);
    }

    public void logBasic(String message, Object ... arguments) {
        this.log.logBasic(message, arguments);
    }

    public void logDetailed(String message) {
        this.log.logDetailed(message);
    }

    public void logDetailed(String message, Object ... arguments) {
        this.log.logDetailed(message, arguments);
    }

    public void logDebug(String message) {
        this.log.logDebug(message);
    }

    public void logDebug(String message, Object ... arguments) {
        this.log.logDebug(message, arguments);
    }

    public void logRowlevel(String message) {
        this.log.logRowlevel(message);
    }

    public void logRowlevel(String message, Object ... arguments) {
        this.log.logRowlevel(message, arguments);
    }

    public void logError(String message) {
        this.log.logError(message);
    }

    public void logError(String message, Throwable e) {
        this.log.logError(message, e);
    }

    public void logError(String message, Object ... arguments) {
        this.log.logError(message, arguments);
    }

    protected Button createHelpButton(Shell shell, StepMeta stepMeta, PluginInterface plugin) {
        return BaseStepDialog.createHelpButton((Composite)shell, "Step documentation for " + plugin.getName(), plugin);
    }

    public static Button createHelpButton(final Composite parent, final String title, final PluginInterface plugin) {
        Button button = new Button(parent, 8);
        button.setImage(GUIResource.getInstance().getImageHelpWeb());
        button.setText(BaseMessages.getString(PKG, (String)"System.Button.Help", (String[])new String[0]));
        button.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.Help", (String[])new String[0]));
        FormData fdButton = new FormData();
        fdButton.left = new FormAttachment(0, 0);
        fdButton.bottom = new FormAttachment(100, 0);
        button.setLayoutData((Object)fdButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                StringBuilder html = new StringBuilder();
                html.append("<HTML><TITLE>").append(plugin.getName()).append("</TITLE>");
                html.append("<HEAD>");
                html.append("<STYLE type=\"text/css\">");
                html.append("body {");
                html.append("  background-color:#a7c4e2;");
                html.append("  font-family:arial,helvetica,sans-serif;");
                html.append("  font-size:16px;");
                html.append("}");
                html.append("</STYLE>");
                html.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"docs/English/welcome/kettle.css\" />");
                html.append("</HEAD>");
                html.append("<BODY>");
                html.append("<b>Name</b>: ").append(plugin.getName()).append("<br>");
                html.append("<b>ID: ").append(plugin.getIds()[0]).append("<br>");
                if (!Const.isEmpty((String)plugin.getDescription())) {
                    html.append("<b>Description</b>: ").append(plugin.getDescription()).append("<br>");
                }
                if (!Const.isEmpty((String)plugin.getImageFile())) {
                    html.append("<b>Icon</b>: ").append(plugin.getImageFile()).append("<br>");
                }
                if (!Const.isEmpty((String)plugin.getDocumentationUrl())) {
                    html.append("<b>Documenation</b>: <a href=\"").append(plugin.getDocumentationUrl()).append("\">").append("Click here to view the documentation").append("</a><br>");
                }
                if (!Const.isEmpty((String)plugin.getCasesUrl())) {
                    html.append("<b>Cases</b>: <a href=\"").append(plugin.getCasesUrl()).append("\">").append("Click here to view related PDI cases").append("</a><br>");
                }
                if (!Const.isEmpty((String)plugin.getForumUrl())) {
                    html.append("<b>Forum</b>: <a href=\"").append(plugin.getForumUrl()).append("\">").append("Click here to go to the forum").append("</a><br>");
                }
                html.append("</BODY></HTML>");
                ShowBrowserDialog browserDialog = new ShowBrowserDialog(parent.getShell(), title, html.toString());
                browserDialog.open();
            }
        });
        return button;
    }

    public IMetaStore getMetaStore() {
        return this.metaStore;
    }

    public void setMetaStore(IMetaStore metaStore) {
        this.metaStore = metaStore;
    }

    static {
        buttonAlignment = BaseStepDialog.getButtonAlignment();
    }
}

