/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.step;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulLoader;
import org.pentaho.ui.xul.XulRunner;
import org.pentaho.ui.xul.XulSettingsManager;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.XulEventHandler;

public abstract class BaseStepGenericXulDialog
extends AbstractXulEventHandler
implements StepDialogInterface {
    public static final LoggingObjectInterface loggingObject = new SimpleLoggingObject("Step dialog", LoggingObjectType.STEPDIALOG, null);
    protected static VariableSpace variables = new Variables();
    protected String stepname;
    protected XulLabel wlStepname;
    protected XulTextbox wStepname;
    protected XulButton wOK;
    protected XulButton wGet;
    protected XulButton wPreview;
    protected XulButton wSQL;
    protected XulButton wCreate;
    protected XulButton wCancel;
    protected TransMeta transMeta;
    protected Object parent;
    protected BaseStepMeta baseStepMeta;
    protected Repository repository;
    protected IMetaStore metaStore;
    protected StepMeta stepMeta;
    protected LogChannel log;
    private String xulFile;
    private XulDomContainer container;
    private XulRunner runner;
    protected XulDialog xulDialog;
    protected BindingFactory bf;
    Object modalParent = null;

    public BaseStepGenericXulDialog(String xulFile, Object parent, BaseStepMeta baseStepMeta, TransMeta transMeta, String stepname) {
        this.log = new LogChannel((Object)baseStepMeta);
        this.transMeta = transMeta;
        this.stepname = stepname;
        if (transMeta != null) {
            this.stepMeta = transMeta.findStep(stepname);
        }
        this.baseStepMeta = baseStepMeta;
        this.xulFile = xulFile;
        this.parent = parent;
        try {
            this.initializeXul();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.logError("Error initializing (" + stepname + ") step dialog", (Throwable)e);
            throw new IllegalStateException("Cannot load dialog due to error in initialization", e);
        }
    }

    protected abstract void initializeXul() throws XulException;

    protected void initializeXul(XulLoader loader, BindingFactory bindingFactory, XulRunner runner, Object parent) throws XulException {
        this.bf = bindingFactory;
        this.runner = runner;
        loader.registerClassLoader((Object)((Object)((Object)this)).getClass().getClassLoader());
        loader.setSettingsManager(this.getSettingsManager());
        loader.setOuterContext(parent);
        this.container = loader.loadXul(this.xulFile, (Object)this.getResourceBundle());
        this.bf.setDocument(this.container.getDocumentRoot());
        for (XulEventHandler h : this.getEventHandlers()) {
            this.container.addEventHandler(h);
        }
        this.runner.addContainer(this.container);
        this.xulDialog = (XulDialog)this.container.getDocumentRoot().getRootElement();
        runner.initialize();
    }

    public abstract XulSettingsManager getSettingsManager();

    public abstract ResourceBundle getResourceBundle();

    public abstract void clear();

    protected BindingFactory getBindingFactory() {
        return this.bf;
    }

    protected List<XulEventHandler> getEventHandlers() {
        return Collections.singletonList(this);
    }

    public String getName() {
        return "handler";
    }

    public String open() {
        this.xulDialog.show();
        return this.stepname;
    }

    public void close() {
        this.xulDialog.hide();
    }

    public void setModalParent(Object p) {
        this.modalParent = p;
    }

    public void showMessage(String message, String title) {
        try {
            XulMessageBox msg = (XulMessageBox)this.document.createElement("messagebox");
            msg.setModalParent(this.modalParent);
            msg.setTitle(title);
            msg.setMessage(message);
            msg.open();
        }
        catch (XulException e) {
            this.log.logError("Error displaying message: {0}", new Object[]{message});
        }
    }

    public int showClearDataMessage() {
        String message = "There already is data entered.\nHow do you want to add the data that were found?";
        String title = "Question";
        Object[] buttons = new Object[]{"Add new", "Add all", "Clear and add all", "Cancel"};
        return this.showPromptMessage(message, title, buttons);
    }

    public int showPromptMessage(String message, String title) {
        return this.showPromptMessage(message, title, new Object[]{"OK", "Cancel"});
    }

    public int showPromptMessage(String message, String title, Object[] buttons) {
        try {
            XulMessageBox msg = (XulMessageBox)this.document.createElement("messagebox");
            msg.setModalParent(this.modalParent);
            msg.setTitle(title);
            msg.setMessage(message);
            msg.setButtons(buttons);
            return msg.open();
        }
        catch (XulException e) {
            this.log.logError("Error displaying message: {0}", new Object[]{message});
            return -1;
        }
    }

    public abstract void onAccept();

    public abstract void onCancel();

    protected abstract Class<?> getClassForMessages();

    public abstract void dispose();

    public abstract boolean validate();

    public void addDatabases(XulMenuList<?> wConnection) {
        this.addDatabases(wConnection, null);
    }

    public void addDatabases(XulMenuList wConnection, Class<? extends DatabaseInterface> databaseType) {
        ArrayList<String> databases = new ArrayList<String>();
        for (int i = 0; i < this.transMeta.nrDatabases(); ++i) {
            DatabaseMeta ci = this.transMeta.getDatabase(i);
            if (databaseType != null && !ci.getDatabaseInterface().getClass().equals(databaseType)) continue;
            databases.add(ci.getName());
        }
        wConnection.setElements(databases);
    }

    public void selectDatabase(XulMenuList wConnection, String name) {
        wConnection.setSelectedItem((Object)wConnection);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public boolean isBasic() {
        return this.log.isBasic();
    }

    public boolean isDetailed() {
        return this.log.isDetailed();
    }

    public boolean isDebug() {
        return this.log.isDebug();
    }

    public boolean isRowLevel() {
        return this.log.isRowLevel();
    }

    public void logMinimal(String message) {
        this.log.logMinimal(message);
    }

    public void logMinimal(String message, Object ... arguments) {
        this.log.logMinimal(message, arguments);
    }

    public void logBasic(String message) {
        this.log.logBasic(message);
    }

    public void logBasic(String message, Object ... arguments) {
        this.log.logBasic(message, arguments);
    }

    public void logDetailed(String message) {
        this.log.logDetailed(message);
    }

    public void logDetailed(String message, Object ... arguments) {
        this.log.logDetailed(message, arguments);
    }

    public void logDebug(String message) {
        this.log.logDebug(message);
    }

    public void logDebug(String message, Object ... arguments) {
        this.log.logDebug(message, arguments);
    }

    public void logRowlevel(String message) {
        this.log.logRowlevel(message);
    }

    public void logRowlevel(String message, Object ... arguments) {
        this.log.logRowlevel(message, arguments);
    }

    public void logError(String message) {
        this.log.logError(message);
    }

    public void logError(String message, Throwable e) {
        this.log.logError(message, e);
    }

    public void logError(String message, Object ... arguments) {
        this.log.logError(message, arguments);
    }

    public IMetaStore getMetaStore() {
        return this.metaStore;
    }

    public void setMetaStore(IMetaStore metaStore) {
        this.metaStore = metaStore;
    }
}

