/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.step;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.laf.BasePropertyHandler;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.spoon.XulSpoonResourceBundle;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.di.ui.trans.step.BaseStepGenericXulDialog;
import org.pentaho.di.ui.trans.step.StepTableDataObject;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;
import org.pentaho.di.ui.trans.step.TableItemInsertXulListener;
import org.pentaho.di.ui.xul.KettleXulLoader;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulLoader;
import org.pentaho.ui.xul.XulRunner;
import org.pentaho.ui.xul.XulSettingsManager;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulTreeRow;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.SwtBindingFactory;
import org.pentaho.ui.xul.swt.SwtXulRunner;

public abstract class BaseStepXulDialog
extends BaseStepGenericXulDialog {
    private static Class<?> PKG = StepInterface.class;
    protected Listener lsOK;
    protected Listener lsGet;
    protected Listener lsPreview;
    protected Listener lsSQL;
    protected Listener lsCreate;
    protected Listener lsCancel;
    protected Listener lsResize;
    protected boolean changed;
    protected boolean backupChanged;
    protected PropsUI props;
    protected static final int BUTTON_ALIGNMENT_CENTER = 0;
    protected static final int BUTTON_ALIGNMENT_LEFT = 1;
    protected static final int BUTTON_ALIGNMENT_RIGHT = 2;
    protected static int buttonAlignment = 0;
    protected DatabaseDialog databaseDialog;
    protected Shell dialogShell;

    @Override
    public XulSettingsManager getSettingsManager() {
        return XulSpoonSettingsManager.getInstance();
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return new XulSpoonResourceBundle(this.getClassForMessages());
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean validate() {
        return true;
    }

    public BaseStepXulDialog(String xulFile, Shell parent, BaseStepMeta baseStepMeta, TransMeta transMeta, String stepname) {
        super(xulFile, parent, baseStepMeta, transMeta, stepname);
        this.backupChanged = baseStepMeta.hasChanged();
        this.props = PropsUI.getInstance();
        try {
            this.initializeXul();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.logError("Error initializing (" + stepname + ") step dialog", (Throwable)e);
            throw new IllegalStateException("Cannot load dialog due to error in initialization", e);
        }
    }

    @Override
    protected void initializeXul() throws XulException {
        this.initializeXul((XulLoader)new KettleXulLoader(), (BindingFactory)new SwtBindingFactory(), (XulRunner)new SwtXulRunner(), this.parent);
        this.dialogShell = (Shell)this.xulDialog.getRootObject();
    }

    public void setShellImage(Shell shell, StepMetaInterface stepMetaInterface) {
        try {
            String id = PluginRegistry.getInstance().getPluginId(StepPluginType.class, (Object)stepMetaInterface);
            if (this.getShell() != null && id != null) {
                this.getShell().setImage(GUIResource.getInstance().getImagesSteps().get(id));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void dispose() {
        Shell shell = (Shell)this.xulDialog.getRootObject();
        if (!shell.isDisposed()) {
            WindowProperty winprop = new WindowProperty(shell);
            this.props.setScreen(winprop);
            ((Composite)this.xulDialog.getManagedObject()).dispose();
            shell.dispose();
        }
    }

    public Shell getShell() {
        return this.dialogShell;
    }

    public void setSize() {
        BaseStepXulDialog.setSize(this.dialogShell);
    }

    protected static int getButtonAlignment() {
        String buttonAlign = BasePropertyHandler.getProperty((String)"Button_Position", (String)"center").toLowerCase();
        if ("center".equals(buttonAlign)) {
            return 0;
        }
        if ("left".equals(buttonAlign)) {
            return 1;
        }
        return 2;
    }

    protected DatabaseDialog getDatabaseDialog(Shell shell) {
        if (this.databaseDialog == null) {
            this.databaseDialog = new DatabaseDialog(shell);
        }
        return this.databaseDialog;
    }

    public void storeScreenSize() {
        this.props.setScreen(new WindowProperty(this.dialogShell));
    }

    public static void setSize(Shell shell) {
        BaseStepXulDialog.setSize(shell, -1, -1, true);
    }

    public static void setSize(Shell shell, int minWidth, int minHeight, boolean packIt) {
        PropsUI props = PropsUI.getInstance();
        WindowProperty winprop = props.getScreen(shell.getText());
        if (winprop != null) {
            winprop.setShell(shell, minWidth, minHeight);
        } else {
            if (packIt) {
                shell.pack();
            } else {
                shell.layout();
            }
            winprop = new WindowProperty(shell);
            winprop.setShell(shell, minWidth, minHeight);
            Rectangle shellBounds = shell.getBounds();
            Monitor monitor = shell.getDisplay().getPrimaryMonitor();
            if (shell.getParent() != null) {
                monitor = shell.getParent().getMonitor();
            }
            Rectangle monitorClientArea = monitor.getClientArea();
            int middleX = monitorClientArea.x + (monitorClientArea.width - shellBounds.width) / 2;
            int middleY = monitorClientArea.y + (monitorClientArea.height - shellBounds.height) / 2;
            shell.setLocation(middleX, middleY);
        }
    }

    public static final void getFieldsFromPrevious(RowMetaInterface row, XulTree tableView, int keyColumn, int[] nameColumn, int[] dataTypeColumn, int lengthColumn, int precisionColumn, TableItemInsertListener listener) {
        if (row == null || row.size() == 0) {
            return;
        }
        Table table = ((TableViewer)tableView.getManagedObject()).getTable();
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < table.getItemCount(); ++i) {
            TableItem tableItem = table.getItem(i);
            String key = tableItem.getText(keyColumn);
            if (Const.isEmpty((String)key) || keys.indexOf(key) >= 0) continue;
            keys.add(key);
        }
        int choice = 0;
        if (keys.size() > 0) {
            Shell shell = ((TableViewer)tableView.getManagedObject()).getTable().getShell();
            MessageDialog md = new MessageDialog(shell, BaseMessages.getString(PKG, (String)"BaseStepDialog.GetFieldsChoice.Title", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"BaseStepDialog.GetFieldsChoice.Message", (String[])new String[]{"" + keys.size(), "" + row.size()}), 4, new String[]{BaseMessages.getString(PKG, (String)"BaseStepDialog.AddNew", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.Add", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.ClearAndAdd", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.Cancel", (String[])new String[0])}, 0);
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            int idx = md.open();
            choice = idx & 0xFF;
        }
        if (choice == 3 || choice == 255) {
            return;
        }
        if (choice == 2) {
            tableView.getRootChildren().removeAll();
        }
        for (int i = 0; i < row.size(); ++i) {
            int c;
            ValueMetaInterface v = row.getValueMeta(i);
            boolean add = true;
            if (choice == 0 && keys.indexOf(v.getName()) >= 0) {
                add = false;
            }
            if (!add) continue;
            XulTreeRow tRow = tableView.getRootChildren().addNewRow();
            for (c = 0; c < nameColumn.length; ++c) {
                tRow.addCellText(nameColumn[c], Const.NVL((String)v.getName(), (String)""));
            }
            if (dataTypeColumn != null) {
                for (c = 0; c < dataTypeColumn.length; ++c) {
                    tRow.addCellText(dataTypeColumn[c], v.getTypeDesc());
                }
            }
            if (lengthColumn > 0 && v.getLength() >= 0) {
                tRow.addCellText(lengthColumn, Integer.toString(v.getLength()));
            }
            if (precisionColumn > 0 && v.getPrecision() >= 0) {
                tRow.addCellText(precisionColumn, Integer.toString(v.getPrecision()));
            }
            if (listener == null || listener.tableItemInserted(table.getItem(tRow.getParent().getParent().getChildNodes().indexOf(tRow.getParent())), v)) continue;
            tRow.getParent().getParent().removeChild((Element)tRow.getParent());
        }
    }

    public static final void getFieldsFromPrevious(ComboVar comboVar, TransMeta transMeta, StepMeta stepMeta) {
        String selectedField = null;
        int indexField = -1;
        try {
            RowMetaInterface r = transMeta.getPrevStepFields(stepMeta);
            selectedField = comboVar.getText();
            comboVar.removeAll();
            if (r != null && !r.isEmpty()) {
                r.getFieldNames();
                comboVar.setItems(r.getFieldNames());
                indexField = r.indexOfValue(selectedField);
            }
            if (indexField > -1) {
                comboVar.select(indexField);
            } else if (selectedField != null) {
                comboVar.setText(selectedField);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(comboVar.getShell(), BaseMessages.getString(PKG, (String)"BaseStepDialog.FailedToGetFieldsPrevious.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.FailedToGetFieldsPrevious.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public static final void generateFieldMapping(Shell shell, RowMetaInterface sourceFields, RowMetaInterface targetFields, List<SourceToTargetMapping> fieldMapping) throws KettleException {
        String[] source = sourceFields.getFieldNames();
        int i = 0;
        while (i < source.length) {
            ValueMetaInterface v = sourceFields.getValueMeta(i);
            int n = i++;
            source[n] = source[n] + "            (" + v.getOrigin() + ")";
        }
        String[] target = targetFields.getFieldNames();
        EnterMappingDialog dialog = new EnterMappingDialog(shell, source, target, fieldMapping);
        List<SourceToTargetMapping> newMapping = dialog.open();
        if (newMapping != null) {
            fieldMapping.clear();
            fieldMapping.addAll(newMapping);
        }
    }

    public static void getFieldsFromPrevious(RowMetaInterface row, XulTree tableView, List<Object> fields, StepTableDataObject field, TableItemInsertXulListener listener) {
        if (row == null || row.size() == 0) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (Object entry : fields) {
            keys.add(((StepTableDataObject)entry).getName());
        }
        int choice = 0;
        if (keys.size() > 0) {
            Shell shell = ((TableViewer)tableView.getManagedObject()).getTable().getShell();
            MessageDialog md = new MessageDialog(shell, BaseMessages.getString(PKG, (String)"BaseStepDialog.GetFieldsChoice.Title", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"BaseStepDialog.GetFieldsChoice.Message", (String[])new String[]{"" + keys.size(), "" + row.size()}), 4, new String[]{BaseMessages.getString(PKG, (String)"BaseStepDialog.AddNew", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.Add", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.ClearAndAdd", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.Cancel", (String[])new String[0])}, 0);
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            int idx = md.open();
            choice = idx & 0xFF;
        }
        if (choice == 3 || choice == 255) {
            return;
        }
        if (choice == 2) {
            fields.clear();
        }
        for (int i = 0; i < row.size(); ++i) {
            ValueMetaInterface v = row.getValueMeta(i);
            if (choice == 0 && keys.indexOf(v.getName()) >= 0 || listener != null && !listener.tableItemInsertedFor(v)) continue;
            StepTableDataObject newField = field.createNew(v);
            fields.add(newField);
        }
    }

    static {
        buttonAlignment = BaseStepXulDialog.getButtonAlignment();
    }
}

