/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.combinationlookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.combinationlookup.CombinationLookupMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class CombinationLookupDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = CombinationLookupMeta.class;
    private CCombo wConnection;
    private Label wlSchema;
    private TextVar wSchema;
    private Button wbSchema;
    private FormData fdbSchema;
    private Label wlTable;
    private Button wbTable;
    private TextVar wTable;
    private Label wlCommit;
    private Text wCommit;
    private Label wlCachesize;
    private Text wCachesize;
    private Label wlTk;
    private Text wTk;
    private Group gTechGroup;
    private FormData fdTechGroup;
    private Label wlAutoinc;
    private Button wAutoinc;
    private Label wlTableMax;
    private Button wTableMax;
    private Label wlSeqButton;
    private Button wSeqButton;
    private Text wSeq;
    private Label wlReplace;
    private Button wReplace;
    private Label wlHashcode;
    private Button wHashcode;
    private Label wlKey;
    private TableView wKey;
    private Label wlHashfield;
    private Text wHashfield;
    private Label wlLastUpdateField;
    private Text wLastUpdateField;
    private Button wGet;
    private Button wCreate;
    private Listener lsGet;
    private Listener lsCreate;
    private ColumnInfo[] ciKey;
    private CombinationLookupMeta input;
    private DatabaseMeta ci;
    private Map<String, Integer> inputFields;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public CombinationLookupDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (CombinationLookupMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CombinationLookupDialog.this.input.setChanged();
            }
        };
        ModifyListener lsTableMod = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CombinationLookupDialog.this.input.setChanged();
                CombinationLookupDialog.this.setTableFieldCombo();
            }
        };
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CombinationLookupDialog.this.input.setChanged();
                CombinationLookupDialog.this.setTableFieldCombo();
            }
        };
        this.backupChanged = this.input.hasChanged();
        this.ci = this.input.getDatabaseMeta();
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wConnection.addSelectionListener((SelectionListener)lsSelection);
        this.wConnection.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CombinationLookupDialog.this.ci = CombinationLookupDialog.this.transMeta.findDatabase(CombinationLookupDialog.this.wConnection.getText());
                CombinationLookupDialog.this.setAutoincUse();
                CombinationLookupDialog.this.setSequence();
                CombinationLookupDialog.this.input.setChanged();
            }
        });
        this.wlSchema = new Label((Composite)this.shell, 131072);
        this.wlSchema.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment((Control)this.wConnection, margin);
        this.wlSchema.setLayoutData((Object)fdlSchema);
        this.wbSchema = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbSchema);
        this.wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbSchema = new FormData();
        this.fdbSchema.top = new FormAttachment((Control)this.wConnection, margin);
        this.fdbSchema.right = new FormAttachment(100, 0);
        this.wbSchema.setLayoutData((Object)this.fdbSchema);
        this.wSchema = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsTableMod);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment((Control)this.wConnection, margin);
        fdSchema.right = new FormAttachment((Control)this.wbSchema, -margin);
        this.wSchema.setLayoutData(fdSchema);
        this.wlTable = new Label((Composite)this.shell, 131072);
        this.wlTable.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Target.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)this.wbSchema, margin);
        this.wlTable.setLayoutData((Object)fdlTable);
        this.wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.BrowseTable.Button", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)this.wbSchema, margin);
        this.wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(lsTableMod);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.top = new FormAttachment((Control)this.wbSchema, margin);
        fdTable.right = new FormAttachment((Control)this.wbTable, -margin);
        this.wTable.setLayoutData(fdTable);
        this.wlCommit = new Label((Composite)this.shell, 131072);
        this.wlCommit.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Commitsize.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCommit);
        FormData fdlCommit = new FormData();
        fdlCommit.left = new FormAttachment(0, 0);
        fdlCommit.right = new FormAttachment(middle, -margin);
        fdlCommit.top = new FormAttachment((Control)this.wTable, margin);
        this.wlCommit.setLayoutData((Object)fdlCommit);
        this.wCommit = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wCommit);
        this.wCommit.addModifyListener(lsMod);
        FormData fdCommit = new FormData();
        fdCommit.top = new FormAttachment((Control)this.wTable, margin);
        fdCommit.left = new FormAttachment(middle, 0);
        fdCommit.right = new FormAttachment(middle + (100 - middle) / 3, -margin);
        this.wCommit.setLayoutData((Object)fdCommit);
        this.wlCachesize = new Label((Composite)this.shell, 131072);
        this.wlCachesize.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Cachesize.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCachesize);
        FormData fdlCachesize = new FormData();
        fdlCachesize.top = new FormAttachment((Control)this.wTable, margin);
        fdlCachesize.left = new FormAttachment((Control)this.wCommit, margin);
        fdlCachesize.right = new FormAttachment(middle + 2 * (100 - middle) / 3, -margin);
        this.wlCachesize.setLayoutData((Object)fdlCachesize);
        this.wCachesize = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wCachesize);
        this.wCachesize.addModifyListener(lsMod);
        FormData fdCachesize = new FormData();
        fdCachesize.top = new FormAttachment((Control)this.wTable, margin);
        fdCachesize.left = new FormAttachment((Control)this.wlCachesize, margin);
        fdCachesize.right = new FormAttachment(100, 0);
        this.wCachesize.setLayoutData((Object)fdCachesize);
        this.wCachesize.setToolTipText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Cachesize.ToolTip", (String[])new String[0]));
        this.wlKey = new Label((Composite)this.shell, 0);
        this.wlKey.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Keyfields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlKey);
        FormData fdlKey = new FormData();
        fdlKey.left = new FormAttachment(0, 0);
        fdlKey.top = new FormAttachment((Control)this.wCommit, margin);
        fdlKey.right = new FormAttachment(100, 0);
        this.wlKey.setLayoutData((Object)fdlKey);
        int nrKeyCols = 2;
        int nrKeyRows = this.input.getKeyField() != null ? this.input.getKeyField().length : 1;
        this.ciKey = new ColumnInfo[nrKeyCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.ColumnInfo.DimensionField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.ColumnInfo.FieldInStream", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciKey[0]);
        this.wKey = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, this.ciKey, nrKeyRows, lsMod, this.props);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.GetFields.Button", (String[])new String[0]));
        this.wCreate = new Button((Composite)this.shell, 8);
        this.wCreate.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.SQL.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel, this.wGet, this.wCreate}, margin, null);
        this.wlLastUpdateField = new Label((Composite)this.shell, 131072);
        this.wlLastUpdateField.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.LastUpdateField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLastUpdateField);
        FormData fdlLastUpdateField = new FormData();
        fdlLastUpdateField.left = new FormAttachment(0, 0);
        fdlLastUpdateField.right = new FormAttachment(middle, -margin);
        fdlLastUpdateField.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wlLastUpdateField.setLayoutData((Object)fdlLastUpdateField);
        this.wLastUpdateField = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wLastUpdateField);
        this.wLastUpdateField.addModifyListener(lsMod);
        FormData fdLastUpdateField = new FormData();
        fdLastUpdateField.left = new FormAttachment(middle, 0);
        fdLastUpdateField.right = new FormAttachment(100, 0);
        fdLastUpdateField.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wLastUpdateField.setLayoutData((Object)fdLastUpdateField);
        this.wlHashfield = new Label((Composite)this.shell, 131072);
        this.wlHashfield.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Hashfield.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlHashfield);
        FormData fdlHashfield = new FormData();
        fdlHashfield.left = new FormAttachment(0, 0);
        fdlHashfield.right = new FormAttachment(middle, -margin);
        fdlHashfield.bottom = new FormAttachment((Control)this.wLastUpdateField, -margin);
        this.wlHashfield.setLayoutData((Object)fdlHashfield);
        this.wHashfield = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wHashfield);
        this.wHashfield.addModifyListener(lsMod);
        FormData fdHashfield = new FormData();
        fdHashfield.left = new FormAttachment(middle, 0);
        fdHashfield.right = new FormAttachment(100, 0);
        fdHashfield.bottom = new FormAttachment((Control)this.wLastUpdateField, -margin);
        this.wHashfield.setLayoutData((Object)fdHashfield);
        this.wlHashcode = new Label((Composite)this.shell, 131072);
        this.wlHashcode.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Hashcode.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlHashcode);
        FormData fdlHashcode = new FormData();
        fdlHashcode.left = new FormAttachment(0, 0);
        fdlHashcode.right = new FormAttachment(middle, -margin);
        fdlHashcode.bottom = new FormAttachment((Control)this.wHashfield, -margin);
        this.wlHashcode.setLayoutData((Object)fdlHashcode);
        this.wHashcode = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wHashcode);
        FormData fdHashcode = new FormData();
        fdHashcode.left = new FormAttachment(middle, 0);
        fdHashcode.right = new FormAttachment(100, 0);
        fdHashcode.bottom = new FormAttachment((Control)this.wHashfield, -margin);
        this.wHashcode.setLayoutData((Object)fdHashcode);
        this.wHashcode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CombinationLookupDialog.this.enableFields();
            }
        });
        this.wlReplace = new Label((Composite)this.shell, 131072);
        this.wlReplace.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Replace.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReplace);
        FormData fdlReplace = new FormData();
        fdlReplace.left = new FormAttachment(0, 0);
        fdlReplace.right = new FormAttachment(middle, -margin);
        fdlReplace.bottom = new FormAttachment((Control)this.wHashcode, -margin);
        this.wlReplace.setLayoutData((Object)fdlReplace);
        this.wReplace = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wReplace);
        FormData fdReplace = new FormData();
        fdReplace.left = new FormAttachment(middle, 0);
        fdReplace.bottom = new FormAttachment((Control)this.wHashcode, -margin);
        fdReplace.right = new FormAttachment(100, 0);
        this.wReplace.setLayoutData((Object)fdReplace);
        this.wReplace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CombinationLookupDialog.this.enableFields();
            }
        });
        this.gTechGroup = new Group((Composite)this.shell, 16);
        this.gTechGroup.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.TechGroup.Label", (String[])new String[0]));
        GridLayout gridLayout = new GridLayout(3, false);
        this.gTechGroup.setLayout((Layout)gridLayout);
        this.fdTechGroup = new FormData();
        this.fdTechGroup.left = new FormAttachment(middle, 0);
        this.fdTechGroup.bottom = new FormAttachment((Control)this.wReplace, -margin);
        this.fdTechGroup.right = new FormAttachment(100, 0);
        this.gTechGroup.setBackground(this.shell.getBackground());
        this.gTechGroup.setLayoutData((Object)this.fdTechGroup);
        this.wTableMax = new Button((Composite)this.gTechGroup, 16);
        this.props.setLook((Control)this.wTableMax);
        this.wTableMax.setSelection(false);
        GridData gdTableMax = new GridData();
        this.wTableMax.setLayoutData((Object)gdTableMax);
        this.wTableMax.setToolTipText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.TableMaximum.Tooltip", (String[])new String[]{Const.CR}));
        this.wlTableMax = new Label((Composite)this.gTechGroup, 16384);
        this.wlTableMax.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.TableMaximum.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTableMax);
        GridData gdlTableMax = new GridData(1808);
        gdlTableMax.horizontalSpan = 2;
        gdlTableMax.verticalSpan = 1;
        this.wlTableMax.setLayoutData((Object)gdlTableMax);
        this.wSeqButton = new Button((Composite)this.gTechGroup, 16);
        this.props.setLook((Control)this.wSeqButton);
        this.wSeqButton.setSelection(false);
        GridData gdSeqButton = new GridData();
        this.wSeqButton.setLayoutData((Object)gdSeqButton);
        this.wSeqButton.setToolTipText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Sequence.Tooltip", (String[])new String[]{Const.CR}));
        this.wlSeqButton = new Label((Composite)this.gTechGroup, 16384);
        this.wlSeqButton.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Sequence.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSeqButton);
        GridData gdlSeqButton = new GridData();
        this.wlSeqButton.setLayoutData((Object)gdlSeqButton);
        this.wSeq = new Text((Composite)this.gTechGroup, 18436);
        this.props.setLook((Control)this.wSeq);
        this.wSeq.addModifyListener(lsMod);
        GridData gdSeq = new GridData(768);
        this.wSeq.setLayoutData((Object)gdSeq);
        this.wSeq.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                CombinationLookupDialog.this.input.setTechKeyCreation(CombinationLookupMeta.CREATION_METHOD_SEQUENCE);
                CombinationLookupDialog.this.wSeqButton.setSelection(true);
                CombinationLookupDialog.this.wAutoinc.setSelection(false);
                CombinationLookupDialog.this.wTableMax.setSelection(false);
            }

            public void focusLost(FocusEvent arg0) {
            }
        });
        this.wAutoinc = new Button((Composite)this.gTechGroup, 16);
        this.props.setLook((Control)this.wAutoinc);
        this.wAutoinc.setSelection(false);
        GridData gdAutoinc = new GridData();
        this.wAutoinc.setLayoutData((Object)gdAutoinc);
        this.wAutoinc.setToolTipText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.AutoincButton.Tooltip", (String[])new String[]{Const.CR}));
        this.wlAutoinc = new Label((Composite)this.gTechGroup, 16384);
        this.wlAutoinc.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Autoincrement.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAutoinc);
        GridData gdlAutoinc = new GridData();
        this.wlAutoinc.setLayoutData((Object)gdlAutoinc);
        this.setTableMax();
        this.setSequence();
        this.setAutoincUse();
        this.wlTk = new Label((Composite)this.shell, 131072);
        this.wlTk.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.TechnicalKey.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTk);
        FormData fdlTk = new FormData();
        fdlTk.left = new FormAttachment(0, 0);
        fdlTk.right = new FormAttachment(middle, -margin);
        fdlTk.bottom = new FormAttachment((Control)this.gTechGroup, -margin);
        this.wlTk.setLayoutData((Object)fdlTk);
        this.wTk = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTk);
        FormData fdTk = new FormData();
        fdTk.left = new FormAttachment(middle, 0);
        fdTk.bottom = new FormAttachment((Control)this.gTechGroup, -margin);
        fdTk.right = new FormAttachment(100, 0);
        this.wTk.setLayoutData((Object)fdTk);
        FormData fdKey = new FormData();
        fdKey.left = new FormAttachment(0, 0);
        fdKey.top = new FormAttachment((Control)this.wlKey, margin);
        fdKey.right = new FormAttachment(100, 0);
        fdKey.bottom = new FormAttachment((Control)this.wTk, -margin);
        this.wKey.setLayoutData(fdKey);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = CombinationLookupDialog.this.transMeta.findStep(CombinationLookupDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = CombinationLookupDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            CombinationLookupDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        CombinationLookupDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        CombinationLookupDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                CombinationLookupDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                CombinationLookupDialog.this.get();
            }
        };
        this.lsCreate = new Listener(){

            public void handleEvent(Event e) {
                CombinationLookupDialog.this.create();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                CombinationLookupDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wCreate.addListener(13, this.lsCreate);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CombinationLookupDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wSchema.addSelectionListener(this.lsDef);
        this.wTable.addSelectionListener(this.lsDef);
        this.wCommit.addSelectionListener((SelectionListener)this.lsDef);
        this.wSeq.addSelectionListener((SelectionListener)this.lsDef);
        this.wTk.addSelectionListener((SelectionListener)this.lsDef);
        this.wCachesize.addSelectionListener((SelectionListener)this.lsDef);
        this.wHashfield.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                CombinationLookupDialog.this.cancel();
            }
        });
        this.wbSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CombinationLookupDialog.this.getSchemaNames();
            }
        });
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CombinationLookupDialog.this.getTableName();
            }
        });
        this.setSize();
        this.getData();
        this.setTableFieldCombo();
        this.input.setChanged(this.backupChanged);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciKey[1].setComboValues(fieldNames);
    }

    public void enableFields() {
        this.wHashfield.setEnabled(this.wHashcode.getSelection());
        this.wHashfield.setVisible(this.wHashcode.getSelection());
        this.wlHashfield.setEnabled(this.wHashcode.getSelection());
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = new Runnable(){

            @Override
            public void run() {
                block6: {
                    DatabaseMeta ci;
                    for (int i = 0; i < CombinationLookupDialog.this.tableFieldColumns.size(); ++i) {
                        ColumnInfo colInfo = (ColumnInfo)CombinationLookupDialog.this.tableFieldColumns.get(i);
                        colInfo.setComboValues(new String[0]);
                    }
                    if (!CombinationLookupDialog.this.wTable.isDisposed() && !Const.isEmpty((String)CombinationLookupDialog.this.wTable.getText()) && (ci = CombinationLookupDialog.this.transMeta.findDatabase(CombinationLookupDialog.this.wConnection.getText())) != null) {
                        Database db = new Database(BaseStepDialog.loggingObject, ci);
                        try {
                            String[] fieldNames;
                            db.connect();
                            String schemaTable = ci.getQuotedSchemaTableCombination(CombinationLookupDialog.this.transMeta.environmentSubstitute(CombinationLookupDialog.this.wSchema.getText()), CombinationLookupDialog.this.transMeta.environmentSubstitute(CombinationLookupDialog.this.wTable.getText()));
                            RowMetaInterface r = db.getTableFields(schemaTable);
                            if (null == r || null == (fieldNames = r.getFieldNames())) break block6;
                            for (int i = 0; i < CombinationLookupDialog.this.tableFieldColumns.size(); ++i) {
                                ColumnInfo colInfo = (ColumnInfo)CombinationLookupDialog.this.tableFieldColumns.get(i);
                                colInfo.setComboValues(fieldNames);
                            }
                        }
                        catch (Exception e) {
                            for (int i = 0; i < CombinationLookupDialog.this.tableFieldColumns.size(); ++i) {
                                ColumnInfo colInfo = (ColumnInfo)CombinationLookupDialog.this.tableFieldColumns.get(i);
                                colInfo.setComboValues(new String[0]);
                            }
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    public void setAutoincUse() {
        boolean enable = this.ci == null || this.ci.supportsAutoinc();
        this.wlAutoinc.setEnabled(enable);
        this.wAutoinc.setEnabled(enable);
        if (!enable && this.wAutoinc.getSelection()) {
            this.wAutoinc.setSelection(false);
            this.wSeqButton.setSelection(false);
            this.wTableMax.setSelection(true);
        }
    }

    public void setTableMax() {
        this.wlTableMax.setEnabled(true);
        this.wTableMax.setEnabled(true);
    }

    public void setSequence() {
        boolean seq = this.ci == null || this.ci.supportsSequences();
        this.wSeq.setEnabled(seq);
        this.wlSeqButton.setEnabled(seq);
        this.wSeqButton.setEnabled(seq);
        if (!seq && this.wSeqButton.getSelection()) {
            this.wAutoinc.setSelection(false);
            this.wSeqButton.setSelection(false);
            this.wTableMax.setSelection(true);
        }
    }

    public void getData() {
        this.logDebug(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Log.GettingKeyInfo", (String[])new String[0]));
        if (this.input.getKeyField() != null) {
            for (int i = 0; i < this.input.getKeyField().length; ++i) {
                TableItem item = this.wKey.table.getItem(i);
                if (this.input.getKeyLookup()[i] != null) {
                    item.setText(1, this.input.getKeyLookup()[i]);
                }
                if (this.input.getKeyField()[i] == null) continue;
                item.setText(2, this.input.getKeyField()[i]);
            }
        }
        this.wReplace.setSelection(this.input.replaceFields());
        this.wHashcode.setSelection(this.input.useHash());
        this.wHashfield.setEnabled(this.input.useHash());
        this.wHashfield.setVisible(this.input.useHash());
        this.wlHashfield.setEnabled(this.input.useHash());
        String techKeyCreation = this.input.getTechKeyCreation();
        if (techKeyCreation == null) {
            DatabaseMeta database = this.input.getDatabaseMeta();
            if (database == null || !database.supportsAutoinc()) {
                this.input.setUseAutoinc(false);
            }
            this.wAutoinc.setSelection(this.input.isUseAutoinc());
            this.wSeqButton.setSelection(this.input.getSequenceFrom() != null && this.input.getSequenceFrom().length() > 0);
            if (!(this.input.isUseAutoinc() || this.input.getSequenceFrom() != null && this.input.getSequenceFrom().length() > 0)) {
                this.wTableMax.setSelection(true);
            }
            if (database != null && database.supportsSequences() && this.input.getSequenceFrom() != null) {
                this.wSeq.setText(this.input.getSequenceFrom());
                this.input.setUseAutoinc(false);
                this.wTableMax.setSelection(false);
            }
        } else {
            if (CombinationLookupMeta.CREATION_METHOD_AUTOINC.equals(techKeyCreation)) {
                this.wAutoinc.setSelection(true);
            } else if (CombinationLookupMeta.CREATION_METHOD_SEQUENCE.equals(techKeyCreation)) {
                this.wSeqButton.setSelection(true);
            } else {
                this.wTableMax.setSelection(true);
                this.input.setTechKeyCreation(CombinationLookupMeta.CREATION_METHOD_TABLEMAX);
            }
            if (this.input.getSequenceFrom() != null) {
                this.wSeq.setText(this.input.getSequenceFrom());
            }
        }
        this.setAutoincUse();
        this.setSequence();
        this.setTableMax();
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTablename() != null) {
            this.wTable.setText(this.input.getTablename());
        }
        if (this.input.getTechnicalKeyField() != null) {
            this.wTk.setText(this.input.getTechnicalKeyField());
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        if (this.input.getHashField() != null) {
            this.wHashfield.setText(this.input.getHashField());
        }
        this.wCommit.setText("" + this.input.getCommitSize());
        this.wCachesize.setText("" + this.input.getCacheSize());
        this.wLastUpdateField.setText(Const.NVL((String)this.input.getLastUpdateField(), (String)""));
        this.wKey.setRowNums();
        this.wKey.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        CombinationLookupMeta oldMetaState = (CombinationLookupMeta)this.input.clone();
        this.getInfo(this.input);
        this.stepname = this.wStepname.getText();
        if (this.transMeta.findDatabase(this.wConnection.getText()) == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.NoValidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.NoValidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        if (!this.input.equals((Object)oldMetaState)) {
            this.input.setChanged();
        }
        this.dispose();
    }

    private void getInfo(CombinationLookupMeta in) {
        int nrkeys = this.wKey.nrNonEmpty();
        in.allocate(nrkeys);
        this.logDebug(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Log.SomeKeysFound", (String[])new String[]{String.valueOf(nrkeys)}));
        for (int i = 0; i < nrkeys; ++i) {
            TableItem item = this.wKey.getNonEmpty(i);
            in.getKeyLookup()[i] = item.getText(1);
            in.getKeyField()[i] = item.getText(2);
        }
        in.setUseAutoinc(this.wAutoinc.getSelection() && this.wAutoinc.isEnabled());
        in.setReplaceFields(this.wReplace.getSelection());
        in.setUseHash(this.wHashcode.getSelection());
        in.setHashField(this.wHashfield.getText());
        in.setSchemaName(this.wSchema.getText());
        in.setTablename(this.wTable.getText());
        in.setTechnicalKeyField(this.wTk.getText());
        if (this.wAutoinc.getSelection()) {
            in.setTechKeyCreation(CombinationLookupMeta.CREATION_METHOD_AUTOINC);
            in.setUseAutoinc(true);
            in.setSequenceFrom(null);
        } else if (this.wSeqButton.getSelection()) {
            in.setTechKeyCreation(CombinationLookupMeta.CREATION_METHOD_SEQUENCE);
            in.setUseAutoinc(false);
            in.setSequenceFrom(this.wSeq.getText());
        } else {
            in.setTechKeyCreation(CombinationLookupMeta.CREATION_METHOD_TABLEMAX);
            in.setUseAutoinc(false);
            in.setSequenceFrom(null);
        }
        in.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        in.setCommitSize(Const.toInt((String)this.wCommit.getText(), (int)0));
        in.setCacheSize(Const.toInt((String)this.wCachesize.getText(), (int)0));
        in.setLastUpdateField(this.wLastUpdateField.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSchemaNames() {
        DatabaseMeta databaseMeta = this.transMeta.findDatabase(this.wConnection.getText());
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, databaseMeta);
            try {
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"CombinationLookupDialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"CombinationLookupDialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d.toString(), (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CombinationLookupDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
            finally {
                if (database != null) {
                    database.disconnect();
                    database = null;
                }
            }
        }
    }

    private void getTableName() {
        DatabaseMeta inf = null;
        int connr = this.wConnection.getSelectionIndex();
        if (connr >= 0) {
            inf = this.transMeta.getDatabase(connr);
        }
        if (inf != null) {
            this.logDebug(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Log.LookingAtConnection", (String[])new String[]{inf.toString()}));
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, inf, this.transMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
                this.setTableFieldCombo();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.ConnectionError2.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
        }
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                BaseStepDialog.getFieldsFromPrevious(r, this.wKey, 1, new int[]{1, 2}, new int[0], -1, -1, new TableItemInsertListener(){

                    @Override
                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        tableItem.setText(3, "N");
                        return true;
                    }
                });
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CombinationLookupDialog.UnableToGetFieldsError.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CombinationLookupDialog.UnableToGetFieldsError.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            CombinationLookupMeta info = new CombinationLookupMeta();
            this.getInfo(info);
            String name = this.stepname;
            StepMeta stepMeta = new StepMeta(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.StepMeta.Title", (String[])new String[0]), name, (StepMetaInterface)info);
            RowMetaInterface prev = this.transMeta.getPrevStepFields(this.stepname);
            SQLStatement sql = info.getSQLStatements(this.transMeta, stepMeta, prev, this.repository, this.metaStore);
            if (!sql.hasError()) {
                if (sql.hasSQL()) {
                    SQLEditor sqledit = new SQLEditor((VariableSpace)this.transMeta, this.shell, 0, info.getDatabaseMeta(), this.transMeta.getDbCache(), sql.getSQL());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.SQLError.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CombinationLookupDialog.UnableToCreateSQL.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CombinationLookupDialog.UnableToCreateSQL.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

