/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.denormaliser;

import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.denormaliser.DenormaliserMeta;
import org.pentaho.di.trans.steps.denormaliser.DenormaliserTargetField;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class DenormaliserDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = DenormaliserMeta.class;
    public static final String STRING_SORT_WARNING_PARAMETER = "PivotSortWarning";
    private Label wlGroup;
    private TableView wGroup;
    private FormData fdlGroup;
    private FormData fdGroup;
    private Label wlTarget;
    private TableView wTarget;
    private FormData fdlTarget;
    private FormData fdTarget;
    private Label wlKeyField;
    private CCombo wKeyField;
    private FormData fdlKeyField;
    private FormData fdKeyField;
    private Button wGet;
    private Button wGetAgg;
    private FormData fdGet;
    private FormData fdGetAgg;
    private Listener lsGet;
    private Listener lsGetAgg;
    private DenormaliserMeta input;
    private boolean gotPreviousFields = false;

    public DenormaliserDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (DenormaliserMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DenormaliserDialog.this.input.setChanged();
            }
        };
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DenormaliserDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"DenormaliserDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlKeyField = new Label((Composite)this.shell, 131072);
        this.wlKeyField.setText(BaseMessages.getString(PKG, (String)"DenormaliserDialog.KeyField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlKeyField);
        this.fdlKeyField = new FormData();
        this.fdlKeyField.left = new FormAttachment(0, 0);
        this.fdlKeyField.right = new FormAttachment(middle, -margin);
        this.fdlKeyField.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlKeyField.setLayoutData((Object)this.fdlKeyField);
        this.wKeyField = new CCombo((Composite)this.shell, 2056);
        this.props.setLook((Control)this.wKeyField);
        this.wKeyField.addModifyListener(lsMod);
        this.fdKeyField = new FormData();
        this.fdKeyField.left = new FormAttachment(middle, 0);
        this.fdKeyField.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdKeyField.right = new FormAttachment(100, 0);
        this.wKeyField.setLayoutData((Object)this.fdKeyField);
        this.wKeyField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)DenormaliserDialog.this.shell.getDisplay(), 1);
                DenormaliserDialog.this.shell.setCursor(busy);
                DenormaliserDialog.this.getPreviousFieldNames();
                DenormaliserDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlGroup = new Label((Composite)this.shell, 0);
        this.wlGroup.setText(BaseMessages.getString(PKG, (String)"DenormaliserDialog.Group.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlGroup);
        this.fdlGroup = new FormData();
        this.fdlGroup.left = new FormAttachment(0, 0);
        this.fdlGroup.top = new FormAttachment((Control)this.wKeyField, margin);
        this.wlGroup.setLayoutData((Object)this.fdlGroup);
        int nrKeyCols = 1;
        int nrKeyRows = this.input.getGroupField() != null ? this.input.getGroupField().length : 1;
        ColumnInfo[] ciKey = new ColumnInfo[nrKeyCols];
        ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.GroupField", (String[])new String[0]), 1, false);
        this.wGroup = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, ciKey, nrKeyRows, lsMod, this.props);
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"DenormaliserDialog.GetFields.Button", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.top = new FormAttachment((Control)this.wlGroup, margin);
        this.fdGet.right = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)this.fdGet);
        this.fdGroup = new FormData();
        this.fdGroup.left = new FormAttachment(0, 0);
        this.fdGroup.top = new FormAttachment((Control)this.wlGroup, margin);
        this.fdGroup.right = new FormAttachment((Control)this.wGet, -margin);
        this.fdGroup.bottom = new FormAttachment(30, 0);
        this.wGroup.setLayoutData(this.fdGroup);
        this.wlTarget = new Label((Composite)this.shell, 0);
        this.wlTarget.setText(BaseMessages.getString(PKG, (String)"DenormaliserDialog.Target.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTarget);
        this.fdlTarget = new FormData();
        this.fdlTarget.left = new FormAttachment(0, 0);
        this.fdlTarget.top = new FormAttachment((Control)this.wGroup, margin);
        this.wlTarget.setLayoutData((Object)this.fdlTarget);
        int UpInsRows = this.input.getDenormaliserTargetField() != null ? this.input.getDenormaliserTargetField().length : 1;
        ColumnInfo[] ciTarget = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.TargetFieldname", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.ValueFieldname", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Keyvalue", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMeta.getAllTypes(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Format", (String[])new String[0]), 5, 4), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Currency", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Decimal", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Group", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.NullIf", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DenormaliserDialog.ColumnInfo.Aggregation", (String[])new String[0]), 2, DenormaliserTargetField.typeAggrLongDesc, false)};
        ciTarget[ciTarget.length - 1].setToolTip(BaseMessages.getString(PKG, (String)"DenormaliserDialog.CiTarget.Title", (String[])new String[0]));
        ciTarget[2].setUsingVariables(true);
        this.wTarget = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, ciTarget, UpInsRows, lsMod, this.props);
        this.wGetAgg = new Button((Composite)this.shell, 8);
        this.wGetAgg.setText(BaseMessages.getString(PKG, (String)"DenormaliserDialog.GetLookupFields.Button", (String[])new String[0]));
        this.fdGetAgg = new FormData();
        this.fdGetAgg.top = new FormAttachment((Control)this.wlTarget, margin);
        this.fdGetAgg.right = new FormAttachment(100, 0);
        this.wGetAgg.setLayoutData((Object)this.fdGetAgg);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.fdTarget = new FormData();
        this.fdTarget.left = new FormAttachment(0, 0);
        this.fdTarget.top = new FormAttachment((Control)this.wlTarget, margin);
        this.fdTarget.right = new FormAttachment((Control)this.wGetAgg, -margin);
        this.fdTarget.bottom = new FormAttachment((Control)this.wOK, -margin);
        this.wTarget.setLayoutData(this.fdTarget);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                DenormaliserDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                DenormaliserDialog.this.get();
            }
        };
        this.lsGetAgg = new Listener(){

            public void handleEvent(Event e) {
                DenormaliserDialog.this.getAgg();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                DenormaliserDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wGetAgg.addListener(13, this.lsGetAgg);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DenormaliserDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                DenormaliserDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.backupChanged);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        int i;
        this.logDebug(BaseMessages.getString(PKG, (String)"DenormaliserDialog.Log.Getting.KeyInfo", (String[])new String[0]));
        if (this.input.getKeyField() != null) {
            this.wKeyField.setText(this.input.getKeyField());
        }
        if (this.input.getGroupField() != null) {
            for (i = 0; i < this.input.getGroupField().length; ++i) {
                TableItem item = this.wGroup.table.getItem(i);
                if (this.input.getGroupField()[i] == null) continue;
                item.setText(1, this.input.getGroupField()[i]);
            }
        }
        if (this.input.getDenormaliserTargetField() != null) {
            for (i = 0; i < this.input.getDenormaliserTargetField().length; ++i) {
                DenormaliserTargetField field = this.input.getDenormaliserTargetField()[i];
                TableItem item = this.wTarget.table.getItem(i);
                if (field.getTargetName() != null) {
                    item.setText(1, field.getTargetName());
                }
                if (field.getFieldName() != null) {
                    item.setText(2, field.getFieldName());
                }
                if (field.getKeyValue() != null) {
                    item.setText(3, field.getKeyValue());
                }
                if (field.getTargetTypeDesc() != null) {
                    item.setText(4, field.getTargetTypeDesc());
                }
                if (field.getTargetFormat() != null) {
                    item.setText(5, field.getTargetFormat());
                }
                if (field.getTargetLength() >= 0) {
                    item.setText(6, "" + field.getTargetLength());
                }
                if (field.getTargetPrecision() >= 0) {
                    item.setText(7, "" + field.getTargetPrecision());
                }
                if (field.getTargetCurrencySymbol() != null) {
                    item.setText(8, field.getTargetCurrencySymbol());
                }
                if (field.getTargetDecimalSymbol() != null) {
                    item.setText(9, field.getTargetDecimalSymbol());
                }
                if (field.getTargetGroupingSymbol() != null) {
                    item.setText(10, field.getTargetGroupingSymbol());
                }
                if (field.getTargetNullString() != null) {
                    item.setText(11, field.getTargetNullString());
                }
                if (field.getTargetAggregationType() < 0) continue;
                item.setText(12, field.getTargetAggregationTypeDescLong());
            }
        }
        this.wGroup.setRowNums();
        this.wGroup.optWidth(true);
        this.wTarget.setRowNums();
        this.wTarget.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.dispose();
    }

    private void ok() {
        int i;
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        int sizegroup = this.wGroup.nrNonEmpty();
        int nrfields = this.wTarget.nrNonEmpty();
        this.input.setKeyField(this.wKeyField.getText());
        this.input.allocate(sizegroup, nrfields);
        for (i = 0; i < sizegroup; ++i) {
            TableItem item = this.wGroup.getNonEmpty(i);
            this.input.getGroupField()[i] = item.getText(1);
        }
        for (i = 0; i < nrfields; ++i) {
            DenormaliserTargetField field = new DenormaliserTargetField();
            TableItem item = this.wTarget.getNonEmpty(i);
            field.setTargetName(item.getText(1));
            field.setFieldName(item.getText(2));
            field.setKeyValue(item.getText(3));
            field.setTargetType(item.getText(4));
            field.setTargetFormat(item.getText(5));
            field.setTargetLength(Const.toInt((String)item.getText(6), (int)-1));
            field.setTargetPrecision(Const.toInt((String)item.getText(7), (int)-1));
            field.setTargetCurrencySymbol(item.getText(8));
            field.setTargetDecimalSymbol(item.getText(9));
            field.setTargetGroupingSymbol(item.getText(10));
            field.setTargetNullString(item.getText(11));
            field.setTargetAggregationType(item.getText(12));
            this.input.getDenormaliserTargetField()[i] = field;
        }
        this.stepname = this.wStepname.getText();
        if ("Y".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"DenormaliserDialog.Unpivot.DialogTitle", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"DenormaliserDialog.Unpivot.DialogMessage", (String[])new String[]{Const.CR, Const.CR}), 4, new String[]{BaseMessages.getString(PKG, (String)"DenormaliserDialog.WarningMessage.Option.1", (String[])new String[0])}, 0, BaseMessages.getString(PKG, (String)"DenormaliserDialog.WarningMessage.Option.2", (String[])new String[0]), "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y")));
            MessageDialogWithToggle.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            md.open();
            this.props.setCustomParameter(STRING_SORT_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
            this.props.saveProps();
        }
        this.dispose();
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                BaseStepDialog.getFieldsFromPrevious(r, this.wGroup, 1, new int[]{1}, new int[0], -1, -1, null);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DenormaliserDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DenormaliserDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getAgg() {
        this.wGroup.removeEmptyRows();
        final String[] groupingFields = this.wGroup.getItems(0);
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                BaseStepDialog.getFieldsFromPrevious(r, this.wTarget, 2, new int[0], new int[0], -1, -1, new TableItemInsertListener(){

                    @Override
                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        if (Const.indexOfString((String)v.getName(), (String[])groupingFields) < 0 && !DenormaliserDialog.this.wKeyField.getText().equalsIgnoreCase(v.getName())) {
                            int nr = tableItem.getParent().indexOf(tableItem) + 1;
                            tableItem.setText(1, BaseMessages.getString((Class)PKG, (String)"DenormaliserDialog.TargetFieldname.Label", (String[])new String[0]) + nr);
                            tableItem.setText(2, v.getName());
                            tableItem.setText(4, v.getTypeDesc());
                            if (v.getLength() >= 0) {
                                tableItem.setText(6, "" + v.getLength());
                            }
                            if (v.getPrecision() >= 0) {
                                tableItem.setText(7, "" + v.getPrecision());
                            }
                        }
                        return true;
                    }
                });
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DenormaliserDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DenormaliserDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getPreviousFieldNames() {
        if (!this.gotPreviousFields) {
            try {
                String keyValue = this.wKeyField.getText();
                this.wKeyField.removeAll();
                RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
                if (r != null) {
                    r.getFieldNames();
                    for (int i = 0; i < r.getFieldNames().length; ++i) {
                        this.wKeyField.add(r.getFieldNames()[i]);
                    }
                }
                if (keyValue != null) {
                    this.wKeyField.setText(keyValue);
                }
                this.gotPreviousFields = true;
            }
            catch (KettleException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DenormaliserDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DenormaliserDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }
}

