/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.gpbulkloader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.gpbulkloader.GPBulkLoaderMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class GPBulkLoaderDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = GPBulkLoaderMeta.class;
    private CCombo wConnection;
    private Label wlSchema;
    private TextVar wSchema;
    private FormData fdlSchema;
    private FormData fdSchema;
    private Label wlTable;
    private Button wbTable;
    private TextVar wTable;
    private FormData fdlTable;
    private FormData fdbTable;
    private FormData fdTable;
    private Label wlPsqlPath;
    private Button wbPsqlPath;
    private TextVar wPsqlPath;
    private FormData fdlPsqlPath;
    private FormData fdbPsqlPath;
    private FormData fdPsqlPath;
    private Label wlLoadMethod;
    private CCombo wLoadMethod;
    private FormData fdlLoadMethod;
    private FormData fdLoadMethod;
    private Label wlLoadAction;
    private CCombo wLoadAction;
    private FormData fdlLoadAction;
    private FormData fdLoadAction;
    private Label wlMaxErrors;
    private TextVar wMaxErrors;
    private FormData fdlMaxErrors;
    private FormData fdMaxErrors;
    private Label wlReturn;
    private TableView wReturn;
    private FormData fdlReturn;
    private FormData fdReturn;
    private Label wlControlFile;
    private Button wbControlFile;
    private TextVar wControlFile;
    private FormData fdlControlFile;
    private FormData fdbControlFile;
    private FormData fdControlFile;
    private Label wlDataFile;
    private Button wbDataFile;
    private TextVar wDataFile;
    private FormData fdlDataFile;
    private FormData fdbDataFile;
    private FormData fdDataFile;
    private Label wlLogFile;
    private Button wbLogFile;
    private TextVar wLogFile;
    private FormData fdlLogFile;
    private FormData fdbLogFile;
    private FormData fdLogFile;
    private Label wlDbNameOverride;
    private TextVar wDbNameOverride;
    private FormData fdlDbNameOverride;
    private FormData fdDbNameOverride;
    private Label wlEncoding;
    private Combo wEncoding;
    private FormData fdlEncoding;
    private FormData fdEncoding;
    private Label wlEraseFiles;
    private Button wEraseFiles;
    private FormData fdlEraseFiles;
    private FormData fdEraseFiles;
    private Button wGetLU;
    private FormData fdGetLU;
    private Listener lsGetLU;
    private Button wDoMapping;
    private FormData fdDoMapping;
    private GPBulkLoaderMeta input;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();
    private ColumnInfo[] ciReturn;
    private static String[] encodings = new String[]{"", "US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16BE", "UTF-16LE", "UTF-16"};
    private static final String[] ALL_FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.Filetype.All", (String[])new String[0])};
    private Map<String, Integer> inputFields;

    public GPBulkLoaderDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (GPBulkLoaderMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GPBulkLoaderDialog.this.input.setChanged();
            }
        };
        FocusAdapter lsFocusLost = new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                GPBulkLoaderDialog.this.setTableFieldCombo();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wlSchema = new Label((Composite)this.shell, 131072);
        this.wlSchema.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSchema);
        this.fdlSchema = new FormData();
        this.fdlSchema.left = new FormAttachment(0, 0);
        this.fdlSchema.right = new FormAttachment(middle, -margin);
        this.fdlSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wlSchema.setLayoutData((Object)this.fdlSchema);
        this.wSchema = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        this.wSchema.addFocusListener((FocusListener)lsFocusLost);
        this.fdSchema = new FormData();
        this.fdSchema.left = new FormAttachment(middle, 0);
        this.fdSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.fdSchema.right = new FormAttachment(100, 0);
        this.wSchema.setLayoutData(this.fdSchema);
        this.wlTable = new Label((Composite)this.shell, 131072);
        this.wlTable.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTable);
        this.fdlTable = new FormData();
        this.fdlTable.left = new FormAttachment(0, 0);
        this.fdlTable.right = new FormAttachment(middle, -margin);
        this.fdlTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.wlTable.setLayoutData((Object)this.fdlTable);
        this.wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.Browse.Button", (String[])new String[0]));
        this.fdbTable = new FormData();
        this.fdbTable.right = new FormAttachment(100, 0);
        this.fdbTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.wbTable.setLayoutData((Object)this.fdbTable);
        this.wTable = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(lsMod);
        this.wTable.addFocusListener((FocusListener)lsFocusLost);
        this.fdTable = new FormData();
        this.fdTable.left = new FormAttachment(middle, 0);
        this.fdTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.fdTable.right = new FormAttachment((Control)this.wbTable, -margin);
        this.wTable.setLayoutData(this.fdTable);
        this.wlPsqlPath = new Label((Composite)this.shell, 131072);
        this.wlPsqlPath.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.PsqlPath.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPsqlPath);
        this.fdlPsqlPath = new FormData();
        this.fdlPsqlPath.left = new FormAttachment(0, 0);
        this.fdlPsqlPath.right = new FormAttachment(middle, -margin);
        this.fdlPsqlPath.top = new FormAttachment((Control)this.wTable, margin);
        this.wlPsqlPath.setLayoutData((Object)this.fdlPsqlPath);
        this.wbPsqlPath = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbPsqlPath);
        this.wbPsqlPath.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.Browse.Button", (String[])new String[0]));
        this.fdbPsqlPath = new FormData();
        this.fdbPsqlPath.right = new FormAttachment(100, 0);
        this.fdbPsqlPath.top = new FormAttachment((Control)this.wTable, margin);
        this.wbPsqlPath.setLayoutData((Object)this.fdbPsqlPath);
        this.wPsqlPath = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPsqlPath);
        this.wPsqlPath.addModifyListener(lsMod);
        this.fdPsqlPath = new FormData();
        this.fdPsqlPath.left = new FormAttachment(middle, 0);
        this.fdPsqlPath.top = new FormAttachment((Control)this.wTable, margin);
        this.fdPsqlPath.right = new FormAttachment((Control)this.wbPsqlPath, -margin);
        this.wPsqlPath.setLayoutData(this.fdPsqlPath);
        this.wlLoadMethod = new Label((Composite)this.shell, 131072);
        this.wlLoadMethod.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.LoadMethod.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLoadMethod);
        this.fdlLoadMethod = new FormData();
        this.fdlLoadMethod.left = new FormAttachment(0, 0);
        this.fdlLoadMethod.right = new FormAttachment(middle, -margin);
        this.fdlLoadMethod.top = new FormAttachment((Control)this.wPsqlPath, margin);
        this.wlLoadMethod.setLayoutData((Object)this.fdlLoadMethod);
        this.wLoadMethod = new CCombo((Composite)this.shell, 2060);
        this.wLoadMethod.add(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.AutoEndLoadMethod.Label", (String[])new String[0]));
        this.wLoadMethod.add(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.ManualLoadMethod.Label", (String[])new String[0]));
        this.wLoadMethod.select(0);
        this.wLoadMethod.addModifyListener(lsMod);
        this.props.setLook((Control)this.wLoadMethod);
        this.fdLoadMethod = new FormData();
        this.fdLoadMethod.left = new FormAttachment(middle, 0);
        this.fdLoadMethod.top = new FormAttachment((Control)this.wPsqlPath, margin);
        this.fdLoadMethod.right = new FormAttachment(100, 0);
        this.wLoadMethod.setLayoutData((Object)this.fdLoadMethod);
        this.fdLoadMethod = new FormData();
        this.fdLoadMethod.left = new FormAttachment(middle, 0);
        this.fdLoadMethod.top = new FormAttachment((Control)this.wPsqlPath, margin);
        this.fdLoadMethod.right = new FormAttachment(100, 0);
        this.wLoadMethod.setLayoutData((Object)this.fdLoadMethod);
        this.wlLoadAction = new Label((Composite)this.shell, 131072);
        this.wlLoadAction.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.LoadAction.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLoadAction);
        this.fdlLoadAction = new FormData();
        this.fdlLoadAction.left = new FormAttachment(0, 0);
        this.fdlLoadAction.right = new FormAttachment(middle, -margin);
        this.fdlLoadAction.top = new FormAttachment((Control)this.wLoadMethod, margin);
        this.wlLoadAction.setLayoutData((Object)this.fdlLoadAction);
        this.wLoadAction = new CCombo((Composite)this.shell, 2060);
        this.wLoadAction.add(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.InsertLoadAction.Label", (String[])new String[0]));
        this.wLoadAction.add(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.TruncateLoadAction.Label", (String[])new String[0]));
        this.wLoadAction.select(0);
        this.wLoadAction.addModifyListener(lsMod);
        this.props.setLook((Control)this.wLoadAction);
        this.fdLoadAction = new FormData();
        this.fdLoadAction.left = new FormAttachment(middle, 0);
        this.fdLoadAction.top = new FormAttachment((Control)this.wLoadMethod, margin);
        this.fdLoadAction.right = new FormAttachment(100, 0);
        this.wLoadAction.setLayoutData((Object)this.fdLoadAction);
        this.fdLoadAction = new FormData();
        this.fdLoadAction.left = new FormAttachment(middle, 0);
        this.fdLoadAction.top = new FormAttachment((Control)this.wLoadMethod, margin);
        this.fdLoadAction.right = new FormAttachment(100, 0);
        this.wLoadAction.setLayoutData((Object)this.fdLoadAction);
        this.wlMaxErrors = new Label((Composite)this.shell, 131072);
        this.wlMaxErrors.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.MaxErrors.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMaxErrors);
        this.fdlMaxErrors = new FormData();
        this.fdlMaxErrors.left = new FormAttachment(0, 0);
        this.fdlMaxErrors.top = new FormAttachment((Control)this.wLoadAction, margin);
        this.fdlMaxErrors.right = new FormAttachment(middle, -margin);
        this.wlMaxErrors.setLayoutData((Object)this.fdlMaxErrors);
        this.wMaxErrors = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wMaxErrors);
        this.wMaxErrors.addModifyListener(lsMod);
        this.fdMaxErrors = new FormData();
        this.fdMaxErrors.left = new FormAttachment(middle, 0);
        this.fdMaxErrors.top = new FormAttachment((Control)this.wLoadAction, margin);
        this.fdMaxErrors.right = new FormAttachment(100, 0);
        this.wMaxErrors.setLayoutData(this.fdMaxErrors);
        this.wlDbNameOverride = new Label((Composite)this.shell, 131072);
        this.wlDbNameOverride.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.DbNameOverride.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDbNameOverride);
        this.fdlDbNameOverride = new FormData();
        this.fdlDbNameOverride.left = new FormAttachment(0, 0);
        this.fdlDbNameOverride.top = new FormAttachment((Control)this.wMaxErrors, margin);
        this.fdlDbNameOverride.right = new FormAttachment(middle, -margin);
        this.wlDbNameOverride.setLayoutData((Object)this.fdlDbNameOverride);
        this.wDbNameOverride = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDbNameOverride);
        this.wDbNameOverride.addModifyListener(lsMod);
        this.fdDbNameOverride = new FormData();
        this.fdDbNameOverride.left = new FormAttachment(middle, 0);
        this.fdDbNameOverride.top = new FormAttachment((Control)this.wMaxErrors, margin);
        this.fdDbNameOverride.right = new FormAttachment(100, 0);
        this.wDbNameOverride.setLayoutData(this.fdDbNameOverride);
        this.wlControlFile = new Label((Composite)this.shell, 131072);
        this.wlControlFile.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.ControlFile.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlControlFile);
        this.fdlControlFile = new FormData();
        this.fdlControlFile.left = new FormAttachment(0, 0);
        this.fdlControlFile.top = new FormAttachment((Control)this.wDbNameOverride, margin);
        this.fdlControlFile.right = new FormAttachment(middle, -margin);
        this.wlControlFile.setLayoutData((Object)this.fdlControlFile);
        this.wbControlFile = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbControlFile);
        this.wbControlFile.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.Browse.Button", (String[])new String[0]));
        this.fdbControlFile = new FormData();
        this.fdbControlFile.right = new FormAttachment(100, 0);
        this.fdbControlFile.top = new FormAttachment((Control)this.wDbNameOverride, margin);
        this.wbControlFile.setLayoutData((Object)this.fdbControlFile);
        this.wControlFile = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wControlFile);
        this.wControlFile.addModifyListener(lsMod);
        this.fdControlFile = new FormData();
        this.fdControlFile.left = new FormAttachment(middle, 0);
        this.fdControlFile.top = new FormAttachment((Control)this.wDbNameOverride, margin);
        this.fdControlFile.right = new FormAttachment((Control)this.wbControlFile, -margin);
        this.wControlFile.setLayoutData(this.fdControlFile);
        this.wlDataFile = new Label((Composite)this.shell, 131072);
        this.wlDataFile.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.DataFile.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDataFile);
        this.fdlDataFile = new FormData();
        this.fdlDataFile.left = new FormAttachment(0, 0);
        this.fdlDataFile.top = new FormAttachment((Control)this.wControlFile, margin);
        this.fdlDataFile.right = new FormAttachment(middle, -margin);
        this.wlDataFile.setLayoutData((Object)this.fdlDataFile);
        this.wbDataFile = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbDataFile);
        this.wbDataFile.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.Browse.Button", (String[])new String[0]));
        this.fdbDataFile = new FormData();
        this.fdbDataFile.right = new FormAttachment(100, 0);
        this.fdbDataFile.top = new FormAttachment((Control)this.wControlFile, margin);
        this.wbDataFile.setLayoutData((Object)this.fdbDataFile);
        this.wDataFile = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDataFile);
        this.wDataFile.addModifyListener(lsMod);
        this.fdDataFile = new FormData();
        this.fdDataFile.left = new FormAttachment(middle, 0);
        this.fdDataFile.top = new FormAttachment((Control)this.wControlFile, margin);
        this.fdDataFile.right = new FormAttachment((Control)this.wbDataFile, -margin);
        this.wDataFile.setLayoutData(this.fdDataFile);
        this.wlLogFile = new Label((Composite)this.shell, 131072);
        this.wlLogFile.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.LogFile.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLogFile);
        this.fdlLogFile = new FormData();
        this.fdlLogFile.left = new FormAttachment(0, 0);
        this.fdlLogFile.top = new FormAttachment((Control)this.wDataFile, margin);
        this.fdlLogFile.right = new FormAttachment(middle, -margin);
        this.wlLogFile.setLayoutData((Object)this.fdlLogFile);
        this.wbLogFile = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbLogFile);
        this.wbLogFile.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.Browse.Button", (String[])new String[0]));
        this.fdbLogFile = new FormData();
        this.fdbLogFile.right = new FormAttachment(100, 0);
        this.fdbLogFile.top = new FormAttachment((Control)this.wDataFile, margin);
        this.wbLogFile.setLayoutData((Object)this.fdbLogFile);
        this.wLogFile = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wLogFile);
        this.wLogFile.addModifyListener(lsMod);
        this.fdLogFile = new FormData();
        this.fdLogFile.left = new FormAttachment(middle, 0);
        this.fdLogFile.top = new FormAttachment((Control)this.wDataFile, margin);
        this.fdLogFile.right = new FormAttachment((Control)this.wbLogFile, -margin);
        this.wLogFile.setLayoutData(this.fdLogFile);
        this.wlEncoding = new Label((Composite)this.shell, 131072);
        this.wlEncoding.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.Encoding.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlEncoding);
        this.fdlEncoding = new FormData();
        this.fdlEncoding.left = new FormAttachment(0, 0);
        this.fdlEncoding.top = new FormAttachment((Control)this.wLogFile, margin);
        this.fdlEncoding.right = new FormAttachment(middle, -margin);
        this.wlEncoding.setLayoutData((Object)this.fdlEncoding);
        this.wEncoding = new Combo((Composite)this.shell, 18436);
        this.wEncoding.setToolTipText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.Encoding.Tooltip", (String[])new String[0]));
        this.wEncoding.setItems(encodings);
        this.props.setLook((Control)this.wEncoding);
        this.fdEncoding = new FormData();
        this.fdEncoding.left = new FormAttachment(middle, 0);
        this.fdEncoding.top = new FormAttachment((Control)this.wlLogFile, margin);
        this.fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)this.fdEncoding);
        this.wEncoding.addModifyListener(lsMod);
        this.wlEraseFiles = new Label((Composite)this.shell, 131072);
        this.wlEraseFiles.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.EraseFiles.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlEraseFiles);
        this.fdlEraseFiles = new FormData();
        this.fdlEraseFiles.left = new FormAttachment(0, 0);
        this.fdlEraseFiles.top = new FormAttachment((Control)this.wEncoding, margin);
        this.fdlEraseFiles.right = new FormAttachment(middle, -margin);
        this.wlEraseFiles.setLayoutData((Object)this.fdlEraseFiles);
        this.wEraseFiles = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wEraseFiles);
        this.fdEraseFiles = new FormData();
        this.fdEraseFiles.left = new FormAttachment(middle, 0);
        this.fdEraseFiles.top = new FormAttachment((Control)this.wEncoding, margin);
        this.fdEraseFiles.right = new FormAttachment(100, 0);
        this.wEraseFiles.setLayoutData((Object)this.fdEraseFiles);
        this.wEraseFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GPBulkLoaderDialog.this.input.setChanged();
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wSQL = new Button((Composite)this.shell, 8);
        this.wSQL.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.SQL.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wSQL, this.wCancel}, margin, null);
        this.wlReturn = new Label((Composite)this.shell, 0);
        this.wlReturn.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReturn);
        this.fdlReturn = new FormData();
        this.fdlReturn.left = new FormAttachment(0, 0);
        this.fdlReturn.top = new FormAttachment((Control)this.wEraseFiles, margin);
        this.wlReturn.setLayoutData((Object)this.fdlReturn);
        int UpInsCols = 3;
        int UpInsRows = this.input.getFieldTable() != null ? this.input.getFieldTable().length : 1;
        this.ciReturn = new ColumnInfo[UpInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.ColumnInfo.DateMask", (String[])new String[0]), 2, new String[]{"", BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.DateMask.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.DateTimeMask.Label", (String[])new String[0])}, true);
        this.tableFieldColumns.add(this.ciReturn[0]);
        this.wReturn = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, this.ciReturn, UpInsRows, lsMod, this.props);
        this.wGetLU = new Button((Composite)this.shell, 8);
        this.wGetLU.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.GetFields.Label", (String[])new String[0]));
        this.fdGetLU = new FormData();
        this.fdGetLU.top = new FormAttachment((Control)this.wlReturn, margin);
        this.fdGetLU.right = new FormAttachment(100, 0);
        this.wGetLU.setLayoutData((Object)this.fdGetLU);
        this.wDoMapping = new Button((Composite)this.shell, 8);
        this.wDoMapping.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.EditMapping.Label", (String[])new String[0]));
        this.fdDoMapping = new FormData();
        this.fdDoMapping.top = new FormAttachment((Control)this.wGetLU, margin);
        this.fdDoMapping.right = new FormAttachment(100, 0);
        this.wDoMapping.setLayoutData((Object)this.fdDoMapping);
        this.wDoMapping.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                GPBulkLoaderDialog.this.generateMappings();
            }
        });
        this.fdReturn = new FormData();
        this.fdReturn.left = new FormAttachment(0, 0);
        this.fdReturn.top = new FormAttachment((Control)this.wlReturn, margin);
        this.fdReturn.right = new FormAttachment((Control)this.wGetLU, -margin);
        this.fdReturn.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wReturn.setLayoutData(this.fdReturn);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = GPBulkLoaderDialog.this.transMeta.findStep(GPBulkLoaderDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = GPBulkLoaderDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            GPBulkLoaderDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        GPBulkLoaderDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        GPBulkLoaderDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.wbPsqlPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(GPBulkLoaderDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*"});
                if (GPBulkLoaderDialog.this.wPsqlPath.getText() != null) {
                    dialog.setFileName(GPBulkLoaderDialog.this.wPsqlPath.getText());
                }
                dialog.setFilterNames(ALL_FILETYPES);
                if (dialog.open() != null) {
                    GPBulkLoaderDialog.this.wPsqlPath.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        this.wbControlFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(GPBulkLoaderDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*"});
                if (GPBulkLoaderDialog.this.wControlFile.getText() != null) {
                    dialog.setFileName(GPBulkLoaderDialog.this.wControlFile.getText());
                }
                dialog.setFilterNames(ALL_FILETYPES);
                if (dialog.open() != null) {
                    GPBulkLoaderDialog.this.wControlFile.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        this.wbDataFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(GPBulkLoaderDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*"});
                if (GPBulkLoaderDialog.this.wDataFile.getText() != null) {
                    dialog.setFileName(GPBulkLoaderDialog.this.wDataFile.getText());
                }
                dialog.setFilterNames(ALL_FILETYPES);
                if (dialog.open() != null) {
                    GPBulkLoaderDialog.this.wDataFile.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        this.wbLogFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(GPBulkLoaderDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*"});
                if (GPBulkLoaderDialog.this.wLogFile.getText() != null) {
                    dialog.setFileName(GPBulkLoaderDialog.this.wLogFile.getText());
                }
                dialog.setFilterNames(ALL_FILETYPES);
                if (dialog.open() != null) {
                    GPBulkLoaderDialog.this.wLogFile.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                GPBulkLoaderDialog.this.ok();
            }
        };
        this.lsGetLU = new Listener(){

            public void handleEvent(Event e) {
                GPBulkLoaderDialog.this.getUpdate();
            }
        };
        this.lsSQL = new Listener(){

            public void handleEvent(Event e) {
                GPBulkLoaderDialog.this.create();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                GPBulkLoaderDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGetLU.addListener(13, this.lsGetLU);
        this.wSQL.addListener(13, this.lsSQL);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                GPBulkLoaderDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wSchema.addSelectionListener(this.lsDef);
        this.wTable.addSelectionListener(this.lsDef);
        this.wMaxErrors.addSelectionListener(this.lsDef);
        this.wDbNameOverride.addSelectionListener(this.lsDef);
        this.wControlFile.addSelectionListener(this.lsDef);
        this.wDataFile.addSelectionListener(this.lsDef);
        this.wLogFile.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                GPBulkLoaderDialog.this.cancel();
            }
        });
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GPBulkLoaderDialog.this.getTableName();
            }
        });
        this.setSize();
        this.getData();
        this.setTableFieldCombo();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void generateMappings() {
        EnterMappingDialog d;
        RowMetaInterface targetFields;
        RowMetaInterface sourceFields;
        try {
            sourceFields = this.transMeta.getPrevStepFields(this.stepMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        this.input.setTableName(this.transMeta.environmentSubstitute(this.wTable.getText()));
        StepMetaInterface stepMetaInterface = this.stepMeta.getStepMetaInterface();
        try {
            targetFields = stepMetaInterface.getRequiredFields((VariableSpace)this.transMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            ValueMetaInterface value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName() + "            (" + value.getOrigin() + ")";
        }
        List<SourceToTargetMapping> mappings = new ArrayList<SourceToTargetMapping>();
        StringBuffer missingSourceFields = new StringBuffer();
        StringBuffer missingTargetFields = new StringBuffer();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wReturn.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            String message = "";
            if (missingSourceFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = message + Const.CR;
            message = message + BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            boolean goOn = MessageDialog.openConfirm((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message);
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wReturn.table.removeAll();
            this.wReturn.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = mappings.get(i);
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wReturn.setRowNums();
            this.wReturn.optWidth(true);
        }
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = new Runnable(){

            @Override
            public void run() {
                block6: {
                    DatabaseMeta ci;
                    for (int i = 0; i < GPBulkLoaderDialog.this.tableFieldColumns.size(); ++i) {
                        ColumnInfo colInfo = (ColumnInfo)GPBulkLoaderDialog.this.tableFieldColumns.get(i);
                        colInfo.setComboValues(new String[0]);
                    }
                    if (!Const.isEmpty((String)GPBulkLoaderDialog.this.wTable.getText()) && (ci = GPBulkLoaderDialog.this.transMeta.findDatabase(GPBulkLoaderDialog.this.wConnection.getText())) != null) {
                        Database db = new Database(BaseStepDialog.loggingObject, ci);
                        try {
                            String[] fieldNames;
                            db.connect();
                            String schemaTable = ci.getQuotedSchemaTableCombination(GPBulkLoaderDialog.this.transMeta.environmentSubstitute(GPBulkLoaderDialog.this.wSchema.getText()), GPBulkLoaderDialog.this.transMeta.environmentSubstitute(GPBulkLoaderDialog.this.wTable.getText()));
                            RowMetaInterface r = db.getTableFields(schemaTable);
                            if (null == r || null == (fieldNames = r.getFieldNames())) break block6;
                            for (int i = 0; i < GPBulkLoaderDialog.this.tableFieldColumns.size(); ++i) {
                                ColumnInfo colInfo = (ColumnInfo)GPBulkLoaderDialog.this.tableFieldColumns.get(i);
                                colInfo.setComboValues(fieldNames);
                            }
                        }
                        catch (Exception e) {
                            for (int i = 0; i < GPBulkLoaderDialog.this.tableFieldColumns.size(); ++i) {
                                ColumnInfo colInfo = (ColumnInfo)GPBulkLoaderDialog.this.tableFieldColumns.get(i);
                                colInfo.setComboValues(new String[0]);
                            }
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        this.wMaxErrors.setText("" + this.input.getMaxErrors());
        if (this.input.getFieldTable() != null) {
            for (int i = 0; i < this.input.getFieldTable().length; ++i) {
                String dateMask;
                TableItem item = this.wReturn.table.getItem(i);
                if (this.input.getFieldTable()[i] != null) {
                    item.setText(1, this.input.getFieldTable()[i]);
                }
                if (this.input.getFieldStream()[i] != null) {
                    item.setText(2, this.input.getFieldStream()[i]);
                }
                if ((dateMask = this.input.getDateMask()[i]) != null) {
                    if ("DATE".equals(dateMask)) {
                        item.setText(3, BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.DateMask.Label", (String[])new String[0]));
                        continue;
                    }
                    if ("DATETIME".equals(dateMask)) {
                        item.setText(3, BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.DateTimeMask.Label", (String[])new String[0]));
                        continue;
                    }
                    item.setText(3, "");
                    continue;
                }
                item.setText(3, "");
            }
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getPsqlpath() != null) {
            this.wPsqlPath.setText(this.input.getPsqlpath());
        }
        if (this.input.getControlFile() != null) {
            this.wControlFile.setText(this.input.getControlFile());
        }
        if (this.input.getDataFile() != null) {
            this.wDataFile.setText(this.input.getDataFile());
        }
        if (this.input.getLogFile() != null) {
            this.wLogFile.setText(this.input.getLogFile());
        }
        if (this.input.getEncoding() != null) {
            this.wEncoding.setText(this.input.getEncoding());
        }
        if (this.input.getDbNameOverride() != null) {
            this.wDbNameOverride.setText(this.input.getDbNameOverride());
        }
        this.wEraseFiles.setSelection(this.input.isEraseFiles());
        String method = this.input.getLoadMethod();
        if ("AUTO_END".equals(method)) {
            this.wLoadMethod.select(0);
        } else if ("MANUAL".equals(method)) {
            this.wLoadMethod.select(1);
        } else {
            if (this.log.isDebug()) {
                this.logDebug("Internal error: load_method set to default 'auto at end'");
            }
            this.wLoadMethod.select(0);
        }
        String action = this.input.getLoadAction();
        if ("APPEND".equals(action)) {
            this.wLoadAction.select(0);
        } else if ("INSERT".equals(action)) {
            this.wLoadAction.select(1);
        } else if ("REPLACE".equals(action)) {
            this.wLoadAction.select(2);
        } else if ("TRUNCATE".equals(action)) {
            this.wLoadAction.select(3);
        } else {
            if (this.log.isDebug()) {
                this.logDebug("Internal error: load_action set to default 'append'");
            }
            this.wLoadAction.select(0);
        }
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(GPBulkLoaderMeta inf) {
        int nrfields = this.wReturn.nrNonEmpty();
        inf.allocate(nrfields);
        inf.setMaxErrors(Const.toInt((String)this.wMaxErrors.getText(), (int)0));
        inf.setDbNameOverride(this.wDbNameOverride.getText());
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.Log.FoundFields", (String[])new String[]{"" + nrfields}));
        }
        for (int i = 0; i < nrfields; ++i) {
            TableItem item = this.wReturn.getNonEmpty(i);
            inf.getFieldTable()[i] = item.getText(1);
            inf.getFieldStream()[i] = item.getText(2);
            inf.getDateMask()[i] = BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.DateMask.Label", (String[])new String[0]).equals(item.getText(3)) ? "DATE" : (BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.DateTimeMask.Label", (String[])new String[0]).equals(item.getText(3)) ? "DATETIME" : "");
        }
        inf.setSchemaName(this.wSchema.getText());
        inf.setTableName(this.wTable.getText());
        inf.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        inf.setPsqlpath(this.wPsqlPath.getText());
        inf.setControlFile(this.wControlFile.getText());
        inf.setDataFile(this.wDataFile.getText());
        inf.setLogFile(this.wLogFile.getText());
        inf.setEncoding(this.wEncoding.getText());
        inf.setEraseFiles(this.wEraseFiles.getSelection());
        String method = this.wLoadMethod.getText();
        if (BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.AutoEndLoadMethod.Label", (String[])new String[0]).equals(method)) {
            inf.setLoadMethod("AUTO_END");
        } else if (BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.ManualLoadMethod.Label", (String[])new String[0]).equals(method)) {
            inf.setLoadMethod("MANUAL");
        } else {
            if (this.log.isDebug()) {
                this.logDebug("Internal error: load_method set to default 'auto concurrent', value found '" + method + "'.");
            }
            inf.setLoadMethod("AUTO_END");
        }
        String action = this.wLoadAction.getText();
        if (BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.AppendLoadAction.Label", (String[])new String[0]).equals(action)) {
            inf.setLoadAction("APPEND");
        } else if (BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.InsertLoadAction.Label", (String[])new String[0]).equals(action)) {
            inf.setLoadAction("INSERT");
        } else if (BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.ReplaceLoadAction.Label", (String[])new String[0]).equals(action)) {
            inf.setLoadAction("REPLACE");
        } else if (BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.TruncateLoadAction.Label", (String[])new String[0]).equals(action)) {
            inf.setLoadAction("TRUNCATE");
        } else {
            if (this.log.isDebug()) {
                this.logDebug("Internal error: load_action set to default 'append', value found '" + action + "'.");
            }
            inf.setLoadAction("APPEND");
        }
        this.stepname = this.wStepname.getText();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.getInfo(this.input);
        if (this.input.getDatabaseMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void getTableName() {
        DatabaseMeta inf = null;
        int connr = this.wConnection.getSelectionIndex();
        if (connr >= 0) {
            inf = this.transMeta.getDatabase(connr);
        }
        if (inf != null) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.Log.LookingAtConnection", (String[])new String[0]) + inf.toString());
            }
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, inf, this.transMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void getUpdate() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                TableItemInsertListener listener = new TableItemInsertListener(){

                    @Override
                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        if (v.getType() == 3) {
                            tableItem.setText(3, BaseMessages.getString((Class)PKG, (String)"GPBulkLoaderDialog.DateMask.Label", (String[])new String[0]));
                        } else {
                            tableItem.setText(3, "");
                        }
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious(r, this.wReturn, 1, new int[]{1, 2}, new int[0], -1, -1, listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            GPBulkLoaderMeta info = new GPBulkLoaderMeta();
            this.getInfo(info);
            String name = this.stepname;
            StepMeta stepMeta = new StepMeta(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.StepMeta.Title", (String[])new String[0]), name, (StepMetaInterface)info);
            RowMetaInterface prev = this.transMeta.getPrevStepFields(this.stepname);
            SQLStatement sql = info.getSQLStatements(this.transMeta, stepMeta, prev, this.repository, this.metaStore);
            if (!sql.hasError()) {
                if (sql.hasSQL()) {
                    SQLEditor sqledit = new SQLEditor((VariableSpace)this.transMeta, this.shell, 0, info.getDatabaseMeta(), this.transMeta.getDbCache(), sql.getSQL());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.SQLError.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.CouldNotBuildSQL.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GPBulkLoaderDialog.CouldNotBuildSQL.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

